!{\src2tex{textfont=tt}}
!!****f* ABINIT/assemblychi0_sym
!! NAME
!! assemblychi0_sym
!!
!! FUNCTION
!! Update the independent particle susceptibility for the contribution
!! of one pair of occupied-unoccupied band, for each frequencies
!! taking into account the symmetries of the little group of the external 
!! point q
!!
!! Compute chi0(G,G'',io)=chi0(G,G'',io)+\sum_S (rhotwg(G)*rhotwg*(G''))*den(io)
!! where S are the symmetries of the little group of the external q-point.
!!
!! COPYRIGHT
!! Copyright (C) 1999-2007 ABINIT group (MG, GMR, VO, LR, RWG)
!! This file is distributed under the terms of the
!! GNU General Public License, see ~abinit/COPYING
!! or http://www.gnu.org/copyleft/gpl.txt .
!! For the initials of contributors, see ~abinit/doc/developers/contributors.txt .
!!
!! INPUTS
!!  npwsigx=number of plane waves for sigma exchange or epsilon (input variable)
!!  npwvec=maximum number of G vectors
!!  nomega=number of frequencies
!!  rhotwg(npwsigx)=density of a pair of occupied-unoccupied states, in reciprocal space
!!  den(nomega)=denominator of the susceptibility expression
!!  nop=number of symmetry operations
!!  ninv=if 2, inversion is considered; if 1, inversion is not considered
!!  nkbz=number of kpoints in the full BZ
!!  wtksym(2,nop)= equal to 1 if the symmetry (with or without time reversal) for this kpoint must be considered
!!   in the calculation of \chi_o, 0 otherwise  
!!  grottbm1(npwvec,2,nop)= contains the index of (IR) G where I is the identity or the inversion 
!!   operation and G is one of the npwvec vectors in reciprocal space 
!!    
!! OUTPUT
!!  (see side effects)
!!
!! SIDE EFFECTS
!!  chi0(npwsigx,npwsigx,nomega)=independent-particle susceptibility matrix in reciprocal space
!!
!! PARENTS
!!   
!!
!! CHILDREN
!!   
!!
!! SOURCE

#if defined HAVE_CONFIG_H
#include "config.h"
#endif

subroutine assemblychi0_sym(npwvec,npwsigx,ninv,nop,nkbz,wtksym,grottbm1,nomega,chi0,rhotwg,den)

 use defs_basis

 implicit none

!Arguments ------------------------------------
!scalars
 integer,intent(in) :: ninv,nkbz,nomega,nop,npwsigx,npwvec
!arrays
 integer,intent(in) :: grottbm1(npwvec,2,nop),wtksym(2,nop)
 complex,intent(in) :: rhotwg(npwsigx)
 complex,target :: chi0(npwsigx,npwsigx,nomega)
!no_abirules
 complex (kind(0.0d0)),intent(in) :: den(nomega)

!Local variables-------------------------------
!scalars
 integer :: i,i2,ig,igp,iinv,io,iop,npwsigx2
 complex :: dd
 logical,parameter :: vectorialized=.false.
!arrays
 complex,allocatable :: rhotwg_sym(:),rhotwgs(:)

! *************************************************************************

#ifdef VMS
!DEC$ ATTRIBUTES ALIAS:'CGERC' :: cgerc
#endif

!MG FIXME  this part is not used and symmetries are not used 
 if(vectorialized) then
!  calculate rhotwg*(G)
   allocate(rhotwgs(npwsigx))
   rhotwgs(:)=conjg(rhotwg(:))
   npwsigx2=npwsigx*npwsigx
!  do i=0, npwsigx*npwsigx*nomega-1
!    io =i/npwsigx2+1
!    ig =(i-(i/npwsigx2)*npwsigx2)/npwsigx+1
!    igp=i-(i/npwsigx2)*npwsigx2-&
!&    ((i-(i/npwsigx2)*npwsigx2)/npwsigx)*npwsigx+1
!    chi0(ig,igp,io)=chi0(ig,igp,io)+&
!&                 rhotwg(ig)*rhotwgs(igp)*den(io)
!  end do
   do ig=1,npwsigx
     do igp=1,npwsigx
       do io=1,nomega
         chi0(ig,igp,io)=chi0(ig,igp,io)+&
&                          rhotwg(ig)*rhotwgs(igp)*den(io)
       end do
     end do
   end do
   deallocate(rhotwgs)
 else
!   m(:,:)=0.0
!   call cher('U',npwsigx,1.0,rhotwg,1,m,npwsigx)
!   do ig=1, npwsigx
!     do igp=1, ig-1
!       m(ig,igp)=conjg(m(igp,ig))
!     end do
!   end do
!   do io=1, nomega
!     chi0(:,:,io)=chi0(:,:,io)+den(io)*m(:,:)
!   end do

!MG Symmetrization stuff
! should use a pointer!
  allocate(rhotwg_sym(npwsigx))

  do iop=1,nop
   do iinv=1,ninv
    if (wtksym(iinv,iop)==1) then 
     !here we should add the phase 
     if (iinv==1) then 
      rhotwg_sym(1:npwsigx)=rhotwg(grottbm1(1:npwsigx,iinv,iop))
     else 
      rhotwg_sym(1:npwsigx)=conjg(rhotwg(grottbm1(1:npwsigx,iinv,iop)))
     end if 
     do io=1,nomega
      !dd is single precision needed for cgerc
      dd=den(io)
      call cgerc(npwsigx,npwsigx,dd,rhotwg_sym,1,rhotwg_sym,1,chi0(:,:,io),npwsigx)
     end do
    end if 
   end do 
  end do 

 end if
  
 deallocate(rhotwg_sym)

end subroutine assemblychi0_sym
!!***
