#!/bin/sh
set -o errexit

###
# Copyright © 2015-2021, Antoine Le Gonidec <vv221@dotslashplay.it>
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
# 1. Redistributions of source code must retain the above copyright notice,
# this list of conditions and the following disclaimer.
#
# 2. Redistributions in binary form must reproduce the above copyright notice,
# this list of conditions and the following disclaimer in the documentation
# and/or other materials provided with the distribution.
#
# This software is provided by the copyright holders and contributors "as is"
# and any express or implied warranties, including, but not limited to, the
# implied warranties of merchantability and fitness for a particular purpose
# are disclaimed. In no event shall the copyright holder or contributors be
# liable for any direct, indirect, incidental, special, exemplary, or
# consequential damages (including, but not limited to, procurement of
# substitute goods or services; loss of use, data, or profits; or business
# interruption) however caused and on any theory of liability, whether in
# contract, strict liability, or tort (including negligence or otherwise)
# arising in any way out of the use of this software, even if advised of the
# possibility of such damage.
###

###
# Tomb Raider 2
# build native packages from the original installers
# send your bug reports to contact@dotslashplay.it
###

script_version=20220109.3

# Set game-specific variables

GAME_ID='tomb-raider-2'
GAME_NAME='Tomb Raider Ⅱ'

ARCHIVE_BASE_EN_0='setup_tomb_raider_2_20180108_(17720).exe'
ARCHIVE_BASE_EN_0_MD5='858aa88bf7654a8fb7b7f8070cf1021b'
ARCHIVE_BASE_EN_0_TYPE='innosetup'
ARCHIVE_BASE_EN_0_VERSION='1.1-gog17720'
ARCHIVE_BASE_EN_0_SIZE='340000'
ARCHIVE_BASE_EN_0_URL='https://www.gog.com/game/tomb_raider_123'

ARCHIVE_BASE_FR_0='setup_tomb_raider_2_french_20180108_(17720).exe'
ARCHIVE_BASE_FR_0_MD5='12ebe01ec7b4366862af31b860097f14'
ARCHIVE_BASE_FR_0_TYPE='innosetup'
ARCHIVE_BASE_FR_0_VERSION='1.1-gog17720'
ARCHIVE_BASE_FR_0_SIZE='410000'
ARCHIVE_BASE_FR_0_URL='https://www.gog.com/game/tomb_raider_123'

CONTENT_PATH_DEFAULT='app'
ARCHIVE_DOC_L10N_FILES='
manual.pdf
readme.txt'
ARCHIVE_DOC_L10N_FILES_EN="
$ARCHIVE_DOC_L10N_FILES
tomb?raider?ii_pc?eula?english.docx"
ARCHIVE_DOC_L10N_FILES_FR="
$ARCHIVE_DOC_L10N_FILES
tomb?raider?ii_pc?eula?french.doc"
ARCHIVE_GAME_BIN_FILES='
*.dll
*.exe'
ARCHIVE_GAME_L10N_FILES='
audio
data/*.dat
data/*.pcx'
ARCHIVE_GAME_DATA_FILES='
fmv
music
tombpc.dat
data/*.sfx
data/*.tr2'

APP_MAIN_TYPE='wine'
APP_MAIN_EXE='tomb2.exe'
APP_MAIN_ICON='tomb2.exe'

APP_SETUP_ID="${GAME_ID}-setup"
APP_SETUP_NAME="${GAME_NAME} - setup"
APP_SETUP_CAT='Settings'
APP_SETUP_TYPE='wine'
APP_SETUP_EXE='tomb2.exe'
APP_SETUP_OPTIONS='-setup'
APP_SETUP_ICON='tomb2.exe'

PACKAGES_LIST='PKG_BIN PKG_L10N PKG_DATA'

PKG_L10N_ID="${GAME_ID}-l10n"
PKG_L10N_ID_EN="${PKG_L10N_ID}-en"
PKG_L10N_ID_FR="${PKG_L10N_ID}-fr"
PKG_L10N_PROVIDE="$PKG_L10N_ID"
PKG_L10N_DESCRIPTION_EN='English localization'
PKG_L10N_DESCRIPTION_FR='French localization'

PKG_DATA_ID="${GAME_ID}-data"
PKG_DATA_DESCRIPTION='data'

PKG_BIN_ARCH='32'
PKG_BIN_DEPS="$PKG_DATA_ID $PKG_L10N_ID wine"
PKG_BIN_DEPS_ARCH='lib32-gstreamer lib32-gst-plugins-base'
PKG_BIN_DEPS_DEB='gstreamer1.0-plugins-base, gstreamer1.0-plugins-good'
PKG_BIN_DEPS_GENTOO='media-libs/gst-plugins-base[abi_x86_32] media-libs/gst-plugins-good[abi_x86_32]'

# Use persistent storage for user data

DATA_FILES='./savegame.*'

# Load common functions

target_version='2.15'

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
. "$PLAYIT_LIB2"

# Extract game data

extract_data_from "$SOURCE_ARCHIVE"
prepare_package_layout

# Delete temporary files

rm --recursive "${PLAYIT_WORKDIR}/gamedata"

# Include game icons

PKG='PKG_BIN'
icons_get_from_package 'APP_MAIN' 'APP_SETUP'
icons_move_to 'PKG_DATA'

# Write launchers

PKG='PKG_BIN'
launchers_write 'APP_MAIN' 'APP_SETUP'

# Build package

write_metadata
build_pkg

# Clean up

rm --recursive "$PLAYIT_WORKDIR"

# Print instructions

print_instructions

exit 0
