/*###############################################################################
# Linux Management Providers (LMP), CPU provider package
# Copyright (C) 2007 Frederic Desmons, ETRI <desmons@etri.re.kr ,desmons_frederic@yahoo.fr>
# 
# This program is being developed under the "OpenDRIM" project.
# The "OpenDRIM" project web page: http://opendrim.sourceforge.net
# The "OpenDRIM" project mailing list: opendrim@googlegroups.com
# 
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#################################################################################

#################################################################################
# To contributors, please leave your contact information in this section
# AND comment your changes in the source code.
# 
# Modified by 2009 Rakhimov Rustam, TUIT <rusyasoft@gmail.com>
# Modified by 2009 Guillaume BOTTEX, ETRI <guillaumebottex@etri.re.kr>
###############################################################################*/

#ifndef OPENDRIM_PROCESSOR_H_
#define OPENDRIM_PROCESSOR_H_

#include <Instance.h>

const static char* OpenDRIM_Processor_classnames[] = {"OpenDRIM_Processor"};
static string OpenDRIM_Processor_NAMESPACE = _NAMESPACE;

class OpenDRIM_Processor {

public:
	
	string Caption;
	bool Caption_isNULL;
	
	string Description;
	bool Description_isNULL;
	
	string ElementName;
	bool ElementName_isNULL;
	
	string InstallDate;
	bool InstallDate_isNULL;
	
	string Name;
	bool Name_isNULL;
	
	vector<unsigned short> OperationalStatus;
	bool OperationalStatus_isNULL;
	
	vector<string> StatusDescriptions;
	bool StatusDescriptions_isNULL;
	
	string Status;
	bool Status_isNULL;
	
	unsigned short HealthState;
	bool HealthState_isNULL;
	
	unsigned short PrimaryStatus;
	bool PrimaryStatus_isNULL;
	
	unsigned short DetailedStatus;
	bool DetailedStatus_isNULL;
	
	unsigned short OperatingStatus;
	bool OperatingStatus_isNULL;
	
	unsigned short CommunicationStatus;
	bool CommunicationStatus_isNULL;
	
	unsigned short EnabledState;
	bool EnabledState_isNULL;
	
	string OtherEnabledState;
	bool OtherEnabledState_isNULL;
	
	unsigned short RequestedState;
	bool RequestedState_isNULL;
	
	unsigned short EnabledDefault;
	bool EnabledDefault_isNULL;
	
	string TimeOfLastStateChange;
	bool TimeOfLastStateChange_isNULL;
	
	vector<unsigned short> AvailableRequestedStates;
	bool AvailableRequestedStates_isNULL;
	
	unsigned short TransitioningToState;
	bool TransitioningToState_isNULL;
	
	string SystemCreationClassName;
	bool SystemCreationClassName_isNULL;
	
	string SystemName;
	bool SystemName_isNULL;
	
	string CreationClassName;
	bool CreationClassName_isNULL;
	
	string DeviceID;
	bool DeviceID_isNULL;
	
	bool PowerManagementSupported;
	bool PowerManagementSupported_isNULL;
	
	vector<unsigned short> PowerManagementCapabilities;
	bool PowerManagementCapabilities_isNULL;
	
	unsigned short Availability;
	bool Availability_isNULL;
	
	unsigned short StatusInfo;
	bool StatusInfo_isNULL;
	
	unsigned int LastErrorCode;
	bool LastErrorCode_isNULL;
	
	string ErrorDescription;
	bool ErrorDescription_isNULL;
	
	bool ErrorCleared;
	bool ErrorCleared_isNULL;
	
	vector<string> OtherIdentifyingInfo;
	bool OtherIdentifyingInfo_isNULL;
	
	unsigned long long PowerOnHours;
	bool PowerOnHours_isNULL;
	
	unsigned long long TotalPowerOnHours;
	bool TotalPowerOnHours_isNULL;
	
	vector<string> IdentifyingDescriptions;
	bool IdentifyingDescriptions_isNULL;
	
	vector<unsigned short> AdditionalAvailability;
	bool AdditionalAvailability_isNULL;
	
	unsigned long long MaxQuiesceTime;
	bool MaxQuiesceTime_isNULL;
	
	unsigned short LocationIndicator;
	bool LocationIndicator_isNULL;
	
	string Role;
	bool Role_isNULL;
	
	unsigned short Family;
	bool Family_isNULL;
	
	string OtherFamilyDescription;
	bool OtherFamilyDescription_isNULL;
	
	unsigned short UpgradeMethod;
	bool UpgradeMethod_isNULL;
	
	unsigned int MaxClockSpeed;
	bool MaxClockSpeed_isNULL;
	
	unsigned int CurrentClockSpeed;
	bool CurrentClockSpeed_isNULL;
	
	unsigned short DataWidth;
	bool DataWidth_isNULL;
	
	unsigned short AddressWidth;
	bool AddressWidth_isNULL;
	
	unsigned short LoadPercentage;
	bool LoadPercentage_isNULL;
	
	string Stepping;
	bool Stepping_isNULL;
	
	string UniqueID;
	bool UniqueID_isNULL;
	
	unsigned short CPUStatus;
	bool CPUStatus_isNULL;
	
	unsigned int ExternalBusClockSpeed;
	bool ExternalBusClockSpeed_isNULL;
	
	vector<unsigned short> Characteristics;
	bool Characteristics_isNULL;
	
	unsigned short NumberOfEnabledCores;
	bool NumberOfEnabledCores_isNULL;
	
	OpenDRIM_Processor() {
		Caption_isNULL = true;
		Description_isNULL = true;
		ElementName_isNULL = true;
		InstallDate_isNULL = true;
		Name_isNULL = true;
		OperationalStatus_isNULL = true;
		StatusDescriptions_isNULL = true;
		Status_isNULL = true;
		HealthState_isNULL = true;
		PrimaryStatus_isNULL = true;
		DetailedStatus_isNULL = true;
		OperatingStatus_isNULL = true;
		CommunicationStatus_isNULL = true;
		EnabledState_isNULL = true;
		OtherEnabledState_isNULL = true;
		RequestedState_isNULL = true;
		EnabledDefault_isNULL = true;
		TimeOfLastStateChange_isNULL = true;
		AvailableRequestedStates_isNULL = true;
		TransitioningToState_isNULL = true;
		SystemCreationClassName_isNULL = true;
		SystemName_isNULL = true;
		CreationClassName_isNULL = true;
		DeviceID_isNULL = true;
		PowerManagementSupported_isNULL = true;
		PowerManagementCapabilities_isNULL = true;
		Availability_isNULL = true;
		StatusInfo_isNULL = true;
		LastErrorCode_isNULL = true;
		ErrorDescription_isNULL = true;
		ErrorCleared_isNULL = true;
		OtherIdentifyingInfo_isNULL = true;
		PowerOnHours_isNULL = true;
		TotalPowerOnHours_isNULL = true;
		IdentifyingDescriptions_isNULL = true;
		AdditionalAvailability_isNULL = true;
		MaxQuiesceTime_isNULL = true;
		LocationIndicator_isNULL = true;
		Role_isNULL = true;
		Family_isNULL = true;
		OtherFamilyDescription_isNULL = true;
		UpgradeMethod_isNULL = true;
		MaxClockSpeed_isNULL = true;
		CurrentClockSpeed_isNULL = true;
		DataWidth_isNULL = true;
		AddressWidth_isNULL = true;
		LoadPercentage_isNULL = true;
		Stepping_isNULL = true;
		UniqueID_isNULL = true;
		CPUStatus_isNULL = true;
		ExternalBusClockSpeed_isNULL = true;
		Characteristics_isNULL = true;
		NumberOfEnabledCores_isNULL = true;
	}
	
	~OpenDRIM_Processor() {}
	
	string getKeys() const {
		return CF_toLowCase(".SystemCreationClassName=\"" + CF_quoteString(SystemCreationClassName) + "\""".SystemName=\"" + CF_quoteString(SystemName) + "\""".CreationClassName=\"" + CF_quoteString(CreationClassName) + "\""".DeviceID=\"" + CF_quoteString(DeviceID) + "\"");
	}

	int getCaption(string& value) const {
		if (Caption_isNULL==true)
			return NOT_FOUND;
		value = Caption;
		return OK;
	}
	
	int setCaption(const string& newValue) {
		Caption = newValue;
		Caption_isNULL = false;
		return OK;
	}

	int getDescription(string& value) const {
		if (Description_isNULL==true)
			return NOT_FOUND;
		value = Description;
		return OK;
	}
	
	int setDescription(const string& newValue) {
		Description = newValue;
		Description_isNULL = false;
		return OK;
	}

	int getElementName(string& value) const {
		if (ElementName_isNULL==true)
			return NOT_FOUND;
		value = ElementName;
		return OK;
	}
	
	int setElementName(const string& newValue) {
		ElementName = newValue;
		ElementName_isNULL = false;
		return OK;
	}

	int getInstallDate(string& value) const {
		if (InstallDate_isNULL==true)
			return NOT_FOUND;
		value = InstallDate;
		return OK;
	}
	
	int setInstallDate(const string& newValue) {
		InstallDate = newValue;
		InstallDate_isNULL = false;
		return OK;
	}

	int getName(string& value) const {
		if (Name_isNULL==true)
			return NOT_FOUND;
		value = Name;
		return OK;
	}
	
	int setName(const string& newValue) {
		Name = newValue;
		Name_isNULL = false;
		return OK;
	}

	int getOperationalStatus(vector<unsigned short>& value) const {
		if (OperationalStatus_isNULL==true)
			return NOT_FOUND;
		value = OperationalStatus;
		return OK;
	}
	
	int setOperationalStatus(const vector<unsigned short>& newValue) {
		OperationalStatus = newValue;
		OperationalStatus_isNULL = false;
		return OK;
	}

	int getStatusDescriptions(vector<string>& value) const {
		if (StatusDescriptions_isNULL==true)
			return NOT_FOUND;
		value = StatusDescriptions;
		return OK;
	}
	
	int setStatusDescriptions(const vector<string>& newValue) {
		StatusDescriptions = newValue;
		StatusDescriptions_isNULL = false;
		return OK;
	}

	int getStatus(string& value) const {
		if (Status_isNULL==true)
			return NOT_FOUND;
		value = Status;
		return OK;
	}
	
	int setStatus(const string& newValue) {
		Status = newValue;
		Status_isNULL = false;
		return OK;
	}

	int getHealthState(unsigned short& value) const {
		if (HealthState_isNULL==true)
			return NOT_FOUND;
		value = HealthState;
		return OK;
	}
	
	int setHealthState(const unsigned short& newValue) {
		HealthState = newValue;
		HealthState_isNULL = false;
		return OK;
	}

	int getPrimaryStatus(unsigned short& value) const {
		if (PrimaryStatus_isNULL==true)
			return NOT_FOUND;
		value = PrimaryStatus;
		return OK;
	}
	
	int setPrimaryStatus(const unsigned short& newValue) {
		PrimaryStatus = newValue;
		PrimaryStatus_isNULL = false;
		return OK;
	}

	int getDetailedStatus(unsigned short& value) const {
		if (DetailedStatus_isNULL==true)
			return NOT_FOUND;
		value = DetailedStatus;
		return OK;
	}
	
	int setDetailedStatus(const unsigned short& newValue) {
		DetailedStatus = newValue;
		DetailedStatus_isNULL = false;
		return OK;
	}

	int getOperatingStatus(unsigned short& value) const {
		if (OperatingStatus_isNULL==true)
			return NOT_FOUND;
		value = OperatingStatus;
		return OK;
	}
	
	int setOperatingStatus(const unsigned short& newValue) {
		OperatingStatus = newValue;
		OperatingStatus_isNULL = false;
		return OK;
	}

	int getCommunicationStatus(unsigned short& value) const {
		if (CommunicationStatus_isNULL==true)
			return NOT_FOUND;
		value = CommunicationStatus;
		return OK;
	}
	
	int setCommunicationStatus(const unsigned short& newValue) {
		CommunicationStatus = newValue;
		CommunicationStatus_isNULL = false;
		return OK;
	}

	int getEnabledState(unsigned short& value) const {
		if (EnabledState_isNULL==true)
			return NOT_FOUND;
		value = EnabledState;
		return OK;
	}
	
	int setEnabledState(const unsigned short& newValue) {
		EnabledState = newValue;
		EnabledState_isNULL = false;
		return OK;
	}

	int getOtherEnabledState(string& value) const {
		if (OtherEnabledState_isNULL==true)
			return NOT_FOUND;
		value = OtherEnabledState;
		return OK;
	}
	
	int setOtherEnabledState(const string& newValue) {
		OtherEnabledState = newValue;
		OtherEnabledState_isNULL = false;
		return OK;
	}

	int getRequestedState(unsigned short& value) const {
		if (RequestedState_isNULL==true)
			return NOT_FOUND;
		value = RequestedState;
		return OK;
	}
	
	int setRequestedState(const unsigned short& newValue) {
		RequestedState = newValue;
		RequestedState_isNULL = false;
		return OK;
	}

	int getEnabledDefault(unsigned short& value) const {
		if (EnabledDefault_isNULL==true)
			return NOT_FOUND;
		value = EnabledDefault;
		return OK;
	}
	
	int setEnabledDefault(const unsigned short& newValue) {
		EnabledDefault = newValue;
		EnabledDefault_isNULL = false;
		return OK;
	}

	int getTimeOfLastStateChange(string& value) const {
		if (TimeOfLastStateChange_isNULL==true)
			return NOT_FOUND;
		value = TimeOfLastStateChange;
		return OK;
	}
	
	int setTimeOfLastStateChange(const string& newValue) {
		TimeOfLastStateChange = newValue;
		TimeOfLastStateChange_isNULL = false;
		return OK;
	}

	int getAvailableRequestedStates(vector<unsigned short>& value) const {
		if (AvailableRequestedStates_isNULL==true)
			return NOT_FOUND;
		value = AvailableRequestedStates;
		return OK;
	}
	
	int setAvailableRequestedStates(const vector<unsigned short>& newValue) {
		AvailableRequestedStates = newValue;
		AvailableRequestedStates_isNULL = false;
		return OK;
	}

	int getTransitioningToState(unsigned short& value) const {
		if (TransitioningToState_isNULL==true)
			return NOT_FOUND;
		value = TransitioningToState;
		return OK;
	}
	
	int setTransitioningToState(const unsigned short& newValue) {
		TransitioningToState = newValue;
		TransitioningToState_isNULL = false;
		return OK;
	}

	int getSystemCreationClassName(string& value) const {
		if (SystemCreationClassName_isNULL==true)
			return NOT_FOUND;
		value = SystemCreationClassName;
		return OK;
	}
	
	int setSystemCreationClassName(const string& newValue) {
		SystemCreationClassName = newValue;
		SystemCreationClassName_isNULL = false;
		return OK;
	}

	int getSystemName(string& value) const {
		if (SystemName_isNULL==true)
			return NOT_FOUND;
		value = SystemName;
		return OK;
	}
	
	int setSystemName(const string& newValue) {
		SystemName = newValue;
		SystemName_isNULL = false;
		return OK;
	}

	int getCreationClassName(string& value) const {
		if (CreationClassName_isNULL==true)
			return NOT_FOUND;
		value = CreationClassName;
		return OK;
	}
	
	int setCreationClassName(const string& newValue) {
		CreationClassName = newValue;
		CreationClassName_isNULL = false;
		return OK;
	}

	int getDeviceID(string& value) const {
		if (DeviceID_isNULL==true)
			return NOT_FOUND;
		value = DeviceID;
		return OK;
	}
	
	int setDeviceID(const string& newValue) {
		DeviceID = newValue;
		DeviceID_isNULL = false;
		return OK;
	}

	int getPowerManagementSupported(bool& value) const {
		if (PowerManagementSupported_isNULL==true)
			return NOT_FOUND;
		value = PowerManagementSupported;
		return OK;
	}
	
	int setPowerManagementSupported(const bool& newValue) {
		PowerManagementSupported = newValue;
		PowerManagementSupported_isNULL = false;
		return OK;
	}

	int getPowerManagementCapabilities(vector<unsigned short>& value) const {
		if (PowerManagementCapabilities_isNULL==true)
			return NOT_FOUND;
		value = PowerManagementCapabilities;
		return OK;
	}
	
	int setPowerManagementCapabilities(const vector<unsigned short>& newValue) {
		PowerManagementCapabilities = newValue;
		PowerManagementCapabilities_isNULL = false;
		return OK;
	}

	int getAvailability(unsigned short& value) const {
		if (Availability_isNULL==true)
			return NOT_FOUND;
		value = Availability;
		return OK;
	}
	
	int setAvailability(const unsigned short& newValue) {
		Availability = newValue;
		Availability_isNULL = false;
		return OK;
	}

	int getStatusInfo(unsigned short& value) const {
		if (StatusInfo_isNULL==true)
			return NOT_FOUND;
		value = StatusInfo;
		return OK;
	}
	
	int setStatusInfo(const unsigned short& newValue) {
		StatusInfo = newValue;
		StatusInfo_isNULL = false;
		return OK;
	}

	int getLastErrorCode(unsigned int& value) const {
		if (LastErrorCode_isNULL==true)
			return NOT_FOUND;
		value = LastErrorCode;
		return OK;
	}
	
	int setLastErrorCode(const unsigned int& newValue) {
		LastErrorCode = newValue;
		LastErrorCode_isNULL = false;
		return OK;
	}

	int getErrorDescription(string& value) const {
		if (ErrorDescription_isNULL==true)
			return NOT_FOUND;
		value = ErrorDescription;
		return OK;
	}
	
	int setErrorDescription(const string& newValue) {
		ErrorDescription = newValue;
		ErrorDescription_isNULL = false;
		return OK;
	}

	int getErrorCleared(bool& value) const {
		if (ErrorCleared_isNULL==true)
			return NOT_FOUND;
		value = ErrorCleared;
		return OK;
	}
	
	int setErrorCleared(const bool& newValue) {
		ErrorCleared = newValue;
		ErrorCleared_isNULL = false;
		return OK;
	}

	int getOtherIdentifyingInfo(vector<string>& value) const {
		if (OtherIdentifyingInfo_isNULL==true)
			return NOT_FOUND;
		value = OtherIdentifyingInfo;
		return OK;
	}
	
	int setOtherIdentifyingInfo(const vector<string>& newValue) {
		OtherIdentifyingInfo = newValue;
		OtherIdentifyingInfo_isNULL = false;
		return OK;
	}

	int getPowerOnHours(unsigned long long& value) const {
		if (PowerOnHours_isNULL==true)
			return NOT_FOUND;
		value = PowerOnHours;
		return OK;
	}
	
	int setPowerOnHours(const unsigned long long& newValue) {
		PowerOnHours = newValue;
		PowerOnHours_isNULL = false;
		return OK;
	}

	int getTotalPowerOnHours(unsigned long long& value) const {
		if (TotalPowerOnHours_isNULL==true)
			return NOT_FOUND;
		value = TotalPowerOnHours;
		return OK;
	}
	
	int setTotalPowerOnHours(const unsigned long long& newValue) {
		TotalPowerOnHours = newValue;
		TotalPowerOnHours_isNULL = false;
		return OK;
	}

	int getIdentifyingDescriptions(vector<string>& value) const {
		if (IdentifyingDescriptions_isNULL==true)
			return NOT_FOUND;
		value = IdentifyingDescriptions;
		return OK;
	}
	
	int setIdentifyingDescriptions(const vector<string>& newValue) {
		IdentifyingDescriptions = newValue;
		IdentifyingDescriptions_isNULL = false;
		return OK;
	}

	int getAdditionalAvailability(vector<unsigned short>& value) const {
		if (AdditionalAvailability_isNULL==true)
			return NOT_FOUND;
		value = AdditionalAvailability;
		return OK;
	}
	
	int setAdditionalAvailability(const vector<unsigned short>& newValue) {
		AdditionalAvailability = newValue;
		AdditionalAvailability_isNULL = false;
		return OK;
	}

	int getMaxQuiesceTime(unsigned long long& value) const {
		if (MaxQuiesceTime_isNULL==true)
			return NOT_FOUND;
		value = MaxQuiesceTime;
		return OK;
	}
	
	int setMaxQuiesceTime(const unsigned long long& newValue) {
		MaxQuiesceTime = newValue;
		MaxQuiesceTime_isNULL = false;
		return OK;
	}

	int getLocationIndicator(unsigned short& value) const {
		if (LocationIndicator_isNULL==true)
			return NOT_FOUND;
		value = LocationIndicator;
		return OK;
	}
	
	int setLocationIndicator(const unsigned short& newValue) {
		LocationIndicator = newValue;
		LocationIndicator_isNULL = false;
		return OK;
	}

	int getRole(string& value) const {
		if (Role_isNULL==true)
			return NOT_FOUND;
		value = Role;
		return OK;
	}
	
	int setRole(const string& newValue) {
		Role = newValue;
		Role_isNULL = false;
		return OK;
	}

	int getFamily(unsigned short& value) const {
		if (Family_isNULL==true)
			return NOT_FOUND;
		value = Family;
		return OK;
	}
	
	int setFamily(const unsigned short& newValue) {
		Family = newValue;
		Family_isNULL = false;
		return OK;
	}

	int getOtherFamilyDescription(string& value) const {
		if (OtherFamilyDescription_isNULL==true)
			return NOT_FOUND;
		value = OtherFamilyDescription;
		return OK;
	}
	
	int setOtherFamilyDescription(const string& newValue) {
		OtherFamilyDescription = newValue;
		OtherFamilyDescription_isNULL = false;
		return OK;
	}

	int getUpgradeMethod(unsigned short& value) const {
		if (UpgradeMethod_isNULL==true)
			return NOT_FOUND;
		value = UpgradeMethod;
		return OK;
	}
	
	int setUpgradeMethod(const unsigned short& newValue) {
		UpgradeMethod = newValue;
		UpgradeMethod_isNULL = false;
		return OK;
	}

	int getMaxClockSpeed(unsigned int& value) const {
		if (MaxClockSpeed_isNULL==true)
			return NOT_FOUND;
		value = MaxClockSpeed;
		return OK;
	}
	
	int setMaxClockSpeed(const unsigned int& newValue) {
		MaxClockSpeed = newValue;
		MaxClockSpeed_isNULL = false;
		return OK;
	}

	int getCurrentClockSpeed(unsigned int& value) const {
		if (CurrentClockSpeed_isNULL==true)
			return NOT_FOUND;
		value = CurrentClockSpeed;
		return OK;
	}
	
	int setCurrentClockSpeed(const unsigned int& newValue) {
		CurrentClockSpeed = newValue;
		CurrentClockSpeed_isNULL = false;
		return OK;
	}

	int getDataWidth(unsigned short& value) const {
		if (DataWidth_isNULL==true)
			return NOT_FOUND;
		value = DataWidth;
		return OK;
	}
	
	int setDataWidth(const unsigned short& newValue) {
		DataWidth = newValue;
		DataWidth_isNULL = false;
		return OK;
	}

	int getAddressWidth(unsigned short& value) const {
		if (AddressWidth_isNULL==true)
			return NOT_FOUND;
		value = AddressWidth;
		return OK;
	}
	
	int setAddressWidth(const unsigned short& newValue) {
		AddressWidth = newValue;
		AddressWidth_isNULL = false;
		return OK;
	}

	int getLoadPercentage(unsigned short& value) const {
		if (LoadPercentage_isNULL==true)
			return NOT_FOUND;
		value = LoadPercentage;
		return OK;
	}
	
	int setLoadPercentage(const unsigned short& newValue) {
		LoadPercentage = newValue;
		LoadPercentage_isNULL = false;
		return OK;
	}

	int getStepping(string& value) const {
		if (Stepping_isNULL==true)
			return NOT_FOUND;
		value = Stepping;
		return OK;
	}
	
	int setStepping(const string& newValue) {
		Stepping = newValue;
		Stepping_isNULL = false;
		return OK;
	}

	int getUniqueID(string& value) const {
		if (UniqueID_isNULL==true)
			return NOT_FOUND;
		value = UniqueID;
		return OK;
	}
	
	int setUniqueID(const string& newValue) {
		UniqueID = newValue;
		UniqueID_isNULL = false;
		return OK;
	}

	int getCPUStatus(unsigned short& value) const {
		if (CPUStatus_isNULL==true)
			return NOT_FOUND;
		value = CPUStatus;
		return OK;
	}
	
	int setCPUStatus(const unsigned short& newValue) {
		CPUStatus = newValue;
		CPUStatus_isNULL = false;
		return OK;
	}

	int getExternalBusClockSpeed(unsigned int& value) const {
		if (ExternalBusClockSpeed_isNULL==true)
			return NOT_FOUND;
		value = ExternalBusClockSpeed;
		return OK;
	}
	
	int setExternalBusClockSpeed(const unsigned int& newValue) {
		ExternalBusClockSpeed = newValue;
		ExternalBusClockSpeed_isNULL = false;
		return OK;
	}

	int getCharacteristics(vector<unsigned short>& value) const {
		if (Characteristics_isNULL==true)
			return NOT_FOUND;
		value = Characteristics;
		return OK;
	}
	
	int setCharacteristics(const vector<unsigned short>& newValue) {
		Characteristics = newValue;
		Characteristics_isNULL = false;
		return OK;
	}

	int getNumberOfEnabledCores(unsigned short& value) const {
		if (NumberOfEnabledCores_isNULL==true)
			return NOT_FOUND;
		value = NumberOfEnabledCores;
		return OK;
	}
	
	int setNumberOfEnabledCores(const unsigned short& newValue) {
		NumberOfEnabledCores = newValue;
		NumberOfEnabledCores_isNULL = false;
		return OK;
	}

};

class OpenDRIM_Processor_RequestStateChange_In {

public:

	unsigned short RequestedState;
	bool RequestedState_isNULL;

	Objectpath Job;
	bool Job_isNULL;

	string TimeoutPeriod;
	bool TimeoutPeriod_isNULL;

	OpenDRIM_Processor_RequestStateChange_In() {
		RequestedState_isNULL = true;
		Job_isNULL = true;
		TimeoutPeriod_isNULL = true;
	}

	~OpenDRIM_Processor_RequestStateChange_In() {}

	int getRequestedState(unsigned short& value) const {
		if (RequestedState_isNULL == true)
			return NOT_FOUND;
		value = RequestedState;
		return OK;
	}
	int setRequestedState(const unsigned short&  newValue) {
		RequestedState = newValue;
		RequestedState_isNULL = false;
		return OK;
	}

	int getJob(Objectpath& value) const {
		if (Job_isNULL == true)
			return NOT_FOUND;
		value = Job;
		return OK;
	}
	int setJob(const Objectpath&  newValue) {
		Job = newValue;
		Job_isNULL = false;
		return OK;
	}

	int getTimeoutPeriod(string& value) const {
		if (TimeoutPeriod_isNULL == true)
			return NOT_FOUND;
		value = TimeoutPeriod;
		return OK;
	}
	int setTimeoutPeriod(const string&  newValue) {
		TimeoutPeriod = newValue;
		TimeoutPeriod_isNULL = false;
		return OK;
	}

};

class OpenDRIM_Processor_RequestStateChange_Out {

public:

	Objectpath Job;
	bool Job_isNULL;

	OpenDRIM_Processor_RequestStateChange_Out() {
		Job_isNULL = true;
	}

	~OpenDRIM_Processor_RequestStateChange_Out() {}

	int getJob(Objectpath& value) const {
		if (Job_isNULL == true)
			return NOT_FOUND;
		value = Job;
		return OK;
	}
	int setJob(const Objectpath&  newValue) {
		Job = newValue;
		Job_isNULL = false;
		return OK;
	}

};

class OpenDRIM_Processor_SetPowerState_In {

public:

	unsigned short PowerState;
	bool PowerState_isNULL;

	string Time;
	bool Time_isNULL;

	OpenDRIM_Processor_SetPowerState_In() {
		PowerState_isNULL = true;
		Time_isNULL = true;
	}

	~OpenDRIM_Processor_SetPowerState_In() {}

	int getPowerState(unsigned short& value) const {
		if (PowerState_isNULL == true)
			return NOT_FOUND;
		value = PowerState;
		return OK;
	}
	int setPowerState(const unsigned short&  newValue) {
		PowerState = newValue;
		PowerState_isNULL = false;
		return OK;
	}

	int getTime(string& value) const {
		if (Time_isNULL == true)
			return NOT_FOUND;
		value = Time;
		return OK;
	}
	int setTime(const string&  newValue) {
		Time = newValue;
		Time_isNULL = false;
		return OK;
	}

};

class OpenDRIM_Processor_EnableDevice_In {

public:

	bool Enabled;
	bool Enabled_isNULL;

	OpenDRIM_Processor_EnableDevice_In() {
		Enabled_isNULL = true;
	}

	~OpenDRIM_Processor_EnableDevice_In() {}

	int getEnabled(bool& value) const {
		if (Enabled_isNULL == true)
			return NOT_FOUND;
		value = Enabled;
		return OK;
	}
	int setEnabled(const bool&  newValue) {
		Enabled = newValue;
		Enabled_isNULL = false;
		return OK;
	}

};

class OpenDRIM_Processor_OnlineDevice_In {

public:

	bool Online;
	bool Online_isNULL;

	OpenDRIM_Processor_OnlineDevice_In() {
		Online_isNULL = true;
	}

	~OpenDRIM_Processor_OnlineDevice_In() {}

	int getOnline(bool& value) const {
		if (Online_isNULL == true)
			return NOT_FOUND;
		value = Online;
		return OK;
	}
	int setOnline(const bool&  newValue) {
		Online = newValue;
		Online_isNULL = false;
		return OK;
	}

};

class OpenDRIM_Processor_QuiesceDevice_In {

public:

	bool Quiesce;
	bool Quiesce_isNULL;

	OpenDRIM_Processor_QuiesceDevice_In() {
		Quiesce_isNULL = true;
	}

	~OpenDRIM_Processor_QuiesceDevice_In() {}

	int getQuiesce(bool& value) const {
		if (Quiesce_isNULL == true)
			return NOT_FOUND;
		value = Quiesce;
		return OK;
	}
	int setQuiesce(const bool&  newValue) {
		Quiesce = newValue;
		Quiesce_isNULL = false;
		return OK;
	}

};

#endif /*OPENDRIM_PROCESSOR_H_*/
