/*###############################################################################
# Linux Management Providers (LMP), Battery provider package
# Copyright (C) 2009 Shakhrom RUSTAMOV, TUIT <shahrombek@gmail.com>
#
# This program is being developed under the "OpenDRIM" project.
# The "OpenDRIM" project web page: http://opendrim.sourceforge.net
# The "OpenDRIM" project mailing list: opendrim@googlegroups.com
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#################################################################################

#################################################################################
# To contributors, please leave your contact information in this section
# AND comment your changes in the source code.
#
# Modified by 2009 Guillaume BOTTEX, ETRI <guillaumebottex@etri.re.kr>
###############################################################################*/

#ifndef OPENDRIM_REGISTEREDBATTERYPROFILEACCESS_H_
#define OPENDRIM_REGISTEREDBATTERYPROFILEACCESS_H_

#include "Battery_Common.h"

#include "OpenDRIM_RegisteredBatteryProfile.h"

int Battery_OpenDRIM_RegisteredBatteryProfile_load(const CMPIBroker* broker, string& errorMessage);

int Battery_OpenDRIM_RegisteredBatteryProfile_unload(string& errorMessage);

int Battery_OpenDRIM_RegisteredBatteryProfile_retrieve(const CMPIBroker* broker, const CMPIContext* ctx, vector<OpenDRIM_RegisteredBatteryProfile>& instances, const char** properties, string& errorMessage, const string& discriminant);

int Battery_OpenDRIM_RegisteredBatteryProfile_getInstance(const CMPIBroker* broker, const CMPIContext* ctx, OpenDRIM_RegisteredBatteryProfile& instance, const char** properties, string& errorMessage);

int Battery_OpenDRIM_RegisteredBatteryProfile_setInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_RegisteredBatteryProfile& newInstance, const OpenDRIM_RegisteredBatteryProfile& oldInstance, const char** properties, string& errorMessage);

int Battery_OpenDRIM_RegisteredBatteryProfile_createInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_RegisteredBatteryProfile& instance, string& errorMessage);

int Battery_OpenDRIM_RegisteredBatteryProfile_deleteInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_RegisteredBatteryProfile& instance, string& errorMessage);

int Battery_OpenDRIM_RegisteredBatteryProfile_populate(OpenDRIM_RegisteredBatteryProfile& instance, string& errorMessage);

#endif /*OPENDRIM_REGISTEREDBATTERYPROFILEACCESS_H_*/
