/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.core.sourcelookup;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.cdt.debug.core.CDebugCorePlugin;
import org.eclipse.cdt.debug.core.sourcelookup.IMappingSourceContainer;
import org.eclipse.cdt.debug.internal.core.sourcelookup.SourceUtils;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.sourcelookup.ISourceContainer;
import org.eclipse.debug.core.sourcelookup.ISourceContainerType;
import org.eclipse.debug.core.sourcelookup.containers.CompositeSourceContainer;

public class CompilationDirectorySourceContainer
extends CompositeSourceContainer
implements IMappingSourceContainer {
    public static final String TYPE_ID = String.valueOf(CDebugCorePlugin.getUniqueIdentifier()) + ".containerType.compilationDirectory";
    private File fDirectory;
    private boolean fSubfolders;

    public CompilationDirectorySourceContainer(IPath dirPath, boolean subfolders) {
        this(dirPath.toFile(), subfolders);
    }

    public CompilationDirectorySourceContainer(File dir, boolean subfolders) {
        this.fDirectory = dir;
        this.fSubfolders = subfolders;
    }

    public String getName() {
        return this.fDirectory.getAbsolutePath();
    }

    public File getDirectory() {
        return this.fDirectory;
    }

    public ISourceContainerType getType() {
        return this.getSourceContainerType(TYPE_ID);
    }

    public Object[] findSourceElements(String name) throws CoreException {
        File file = new File(name);
        if (!file.isAbsolute()) {
            file = new File(this.fDirectory, name);
        }
        ArrayList<Object> sources = new ArrayList<Object>();
        if (file.exists() && file.isFile()) {
            sources.addAll(Arrays.asList(SourceUtils.findSourceElements(file, this.getDirector())));
        } else {
            sources = new ArrayList();
        }
        if (this.fSubfolders && (this.isFindDuplicates() || sources.isEmpty())) {
            ISourceContainer[] iSourceContainerArray = this.getSourceContainers();
            int n = iSourceContainerArray.length;
            int n2 = 0;
            while (n2 < n) {
                ISourceContainer container = iSourceContainerArray[n2];
                Object[] elements = container.findSourceElements(name);
                if (elements != null && elements.length != 0) {
                    if (this.isFindDuplicates()) {
                        Object[] objectArray = elements;
                        int n3 = elements.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            Object element = objectArray[n4];
                            sources.add(element);
                            ++n4;
                        }
                    } else {
                        sources.add(elements[0]);
                        break;
                    }
                }
                ++n2;
            }
        }
        if (sources.isEmpty()) {
            return EMPTY;
        }
        return sources.toArray();
    }

    public boolean isComposite() {
        return this.fSubfolders;
    }

    public boolean equals(Object obj) {
        if (obj instanceof CompilationDirectorySourceContainer) {
            CompilationDirectorySourceContainer container = (CompilationDirectorySourceContainer)obj;
            return container.getDirectory().equals(this.getDirectory());
        }
        return false;
    }

    public int hashCode() {
        return this.getDirectory().hashCode();
    }

    protected ISourceContainer[] createSourceContainers() throws CoreException {
        String[] files;
        if (this.fSubfolders && (files = this.fDirectory.list()) != null) {
            ISourceContainer[] containers;
            ArrayList<CompilationDirectorySourceContainer> dirs = new ArrayList<CompilationDirectorySourceContainer>();
            String[] stringArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                String name = stringArray[n2];
                File file = new File(this.getDirectory(), name);
                if (file.exists() && file.isDirectory()) {
                    dirs.add(new CompilationDirectorySourceContainer(file, true));
                }
                ++n2;
            }
            ISourceContainer[] iSourceContainerArray = containers = dirs.toArray(new ISourceContainer[dirs.size()]);
            int n3 = containers.length;
            n = 0;
            while (n < n3) {
                ISourceContainer container = iSourceContainerArray[n];
                container.init(this.getDirector());
                ++n;
            }
            return containers;
        }
        return new ISourceContainer[0];
    }

    @Override
    public IPath getCompilationPath(String sourceName) {
        Path path = new Path(sourceName);
        Path base = new Path(this.fDirectory.getPath());
        if (base.isPrefixOf((IPath)path)) {
            if (this.fSubfolders) {
                base = path.removeLastSegments(1);
            }
            return path.makeRelativeTo((IPath)base);
        }
        return null;
    }
}

