/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.cuda.ide.debug.util;

import com.nvidia.common.util.CoreUtil;
import com.nvidia.cuda.ide.debug.core.Activator;
import com.nvidia.cuda.ide.debug.model.DeviceThread;
import com.nvidia.cuda.ide.debug.model.ElementType;
import com.nvidia.cuda.ide.debug.model.ICudaRuntimeObject;
import com.nvidia.cuda.ide.debug.model.Lane;
import com.nvidia.cuda.ide.debug.util.DebugUtil;
import java.util.Iterator;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.cdt.dsf.concurrent.ConfinedToDsfExecutor;
import org.eclipse.cdt.dsf.concurrent.CountingRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.DataRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.DsfRunnable;
import org.eclipse.cdt.dsf.concurrent.ImmediateExecutor;
import org.eclipse.cdt.dsf.concurrent.Query;
import org.eclipse.cdt.dsf.concurrent.RequestMonitor;
import org.eclipse.cdt.dsf.datamodel.DMContexts;
import org.eclipse.cdt.dsf.datamodel.IDMContext;
import org.eclipse.cdt.dsf.service.DsfSession;
import org.eclipse.core.expressions.PropertyTester;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;

public final class CudaPropertiesTester
extends PropertyTester {
    public boolean test(Object receiver, String property, Object[] args, Object expectedValue) {
        if ("isPinnable".equals(property)) {
            return CudaPropertiesTester.getThreadOrLane(receiver) != null;
        }
        if ("isPinned".equals(property)) {
            final ICudaRuntimeObject threadOrLane = CudaPropertiesTester.getThreadOrLane(receiver);
            if (threadOrLane == null) {
                return false;
            }
            if (threadOrLane.getType() == ElementType.thread) {
                return DebugUtil.isPinned((DeviceThread)threadOrLane);
            }
            if (threadOrLane.getType() == ElementType.lane) {
                Query<Boolean> query = new Query<Boolean>(){

                    protected void execute(final DataRequestMonitor<Boolean> rm) {
                        threadOrLane.toLogicalElement(new DataRequestMonitor<ICudaRuntimeObject>(ImmediateExecutor.getInstance(), rm){

                            @ConfinedToDsfExecutor(value="fExecutor")
                            protected void handleSuccess() {
                                boolean isPinned = this.getData() != null && ((ICudaRuntimeObject)this.getData()).getType() == ElementType.thread ? DebugUtil.isPinned((DeviceThread)this.getData()) : false;
                                rm.done((Object)isPinned);
                            }
                        });
                    }
                };
                DsfSession session = DsfSession.getSession((String)threadOrLane.getSessionId());
                if (session != null) {
                    session.getExecutor().execute((Runnable)query);
                    try {
                        return (Boolean)query.get();
                    }
                    catch (InterruptedException e) {
                        Activator.log(e);
                    }
                    catch (ExecutionException e) {
                        Activator.log(e);
                    }
                }
                return false;
            }
            throw new IllegalStateException(threadOrLane.getType().name());
        }
        return false;
    }

    public static void getPinnableObjects(ISelection sel, DataRequestMonitor<DeviceThread[]> drm) {
        if (sel instanceof IStructuredSelection && !sel.isEmpty()) {
            IStructuredSelection selection = (IStructuredSelection)sel;
            final DeviceThread[] elements = new DeviceThread[selection.size()];
            Iterator i = selection.iterator();
            int c = 0;
            int lanes = 0;
            final AtomicBoolean canceled = new AtomicBoolean(false);
            final CountingRequestMonitor crm = new CountingRequestMonitor(ImmediateExecutor.getInstance(), (RequestMonitor)drm, (DataRequestMonitor)drm, elements){
                private final /* synthetic */ DataRequestMonitor val$drm;
                private final /* synthetic */ DeviceThread[] val$elements;
                {
                    this.val$drm = dataRequestMonitor;
                    this.val$elements = deviceThreadArray;
                    super($anonymous0, $anonymous1);
                }

                protected void handleSuccess() {
                    if (!canceled.get()) {
                        this.val$drm.done((Object)((DeviceThread[])CoreUtil.removeGaps((Object[])this.val$elements)));
                    }
                }
            };
            while (i.hasNext() && !canceled.get()) {
                ICudaRuntimeObject pinnable = CudaPropertiesTester.getThreadOrLane(i.next());
                if (pinnable == null) {
                    drm.done(null);
                    canceled.set(true);
                    return;
                }
                if (pinnable.getType() == ElementType.thread) {
                    elements[c++] = (DeviceThread)pinnable;
                    continue;
                }
                ++lanes;
                final int a = c++;
                pinnable.toLogicalElement(new DataRequestMonitor<ICudaRuntimeObject>(ImmediateExecutor.getInstance(), (RequestMonitor)crm){

                    @ConfinedToDsfExecutor(value="fExecutor")
                    protected void handleSuccess() {
                        elements[a] = (DeviceThread)this.getData();
                        crm.done();
                    }
                });
            }
            crm.setDoneCount(lanes);
        } else {
            drm.done(null);
        }
    }

    public static ICudaRuntimeObject getThreadOrLane(Object receiver) {
        if (receiver instanceof IDMContext) {
            DeviceThread t = (DeviceThread)DMContexts.getAncestorOfType((IDMContext)((IDMContext)receiver), DeviceThread.class);
            if (t != null) {
                return t;
            }
            Lane lane = (Lane)DMContexts.getAncestorOfType((IDMContext)((IDMContext)receiver), Lane.class);
            if (lane != null) {
                return lane;
            }
            return null;
        }
        if (receiver instanceof IStructuredSelection) {
            IStructuredSelection selection = (IStructuredSelection)receiver;
            if (selection.size() == 1) {
                return CudaPropertiesTester.getThreadOrLane(selection.getFirstElement());
            }
            return null;
        }
        if (receiver instanceof IAdaptable) {
            IDMContext ctx = (IDMContext)((IAdaptable)receiver).getAdapter(IDMContext.class);
            if (ctx == null) {
                return null;
            }
            return CudaPropertiesTester.getThreadOrLane(ctx);
        }
        return null;
    }

    public static void getPinnableObject(Object receiver, final DataRequestMonitor<DeviceThread> drm) {
        final ICudaRuntimeObject object = CudaPropertiesTester.getThreadOrLane(receiver);
        if (object == null || object.getType() == ElementType.thread) {
            drm.done((Object)((DeviceThread)object));
        } else {
            DsfSession.getSession((String)object.getSessionId()).getExecutor().execute((Runnable)new DsfRunnable(){

                public void run() {
                    object.toLogicalElement(new DataRequestMonitor<ICudaRuntimeObject>(ImmediateExecutor.getInstance(), (RequestMonitor)drm){

                        @ConfinedToDsfExecutor(value="fExecutor")
                        protected void handleSuccess() {
                            drm.done((Object)((DeviceThread)this.getData()));
                        }
                    });
                }
            });
        }
    }
}

