/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.cuda.ide.debug.ui.viewmodel.vms;

import com.nvidia.common.util.CoreUtil;
import com.nvidia.cuda.ide.debug.core.Activator;
import com.nvidia.cuda.ide.debug.core.CudaDebugImages;
import com.nvidia.cuda.ide.debug.model.CudaFocusChangedEvent;
import com.nvidia.cuda.ide.debug.model.CudaRuntimeInformation;
import com.nvidia.cuda.ide.debug.model.CudaThreadState;
import com.nvidia.cuda.ide.debug.model.DeviceThread;
import com.nvidia.cuda.ide.debug.model.ICoordSorter;
import com.nvidia.cuda.ide.debug.model.Kernel;
import com.nvidia.cuda.ide.debug.model.KernelCallSite;
import com.nvidia.cuda.ide.debug.model.events.ElementPinnedStatusEvent;
import com.nvidia.cuda.ide.debug.service.IDebuggerUIState;
import com.nvidia.cuda.ide.debug.ui.viewmodel.IDataContextProvider;
import com.nvidia.cuda.ide.debug.ui.viewmodel.LayoutChangeEvent;
import com.nvidia.cuda.ide.debug.ui.viewmodel.LinkedSelectionChangedEvent;
import com.nvidia.cuda.ide.debug.ui.viewmodel.vms.MulticolumnCudaStackFramesVMNode;
import com.nvidia.cuda.ide.debug.util.ConditionalLabelColors;
import com.nvidia.cuda.ide.debug.util.DebugUtil;
import com.nvidia.cuda.ide.debug.util.DeviceThreadComparator;
import com.nvidia.cuda.ide.debug.util.IffAttribute;
import com.nvidia.cuda.ide.debug.util.ThreadImage;
import java.util.List;
import java.util.concurrent.Executor;
import org.eclipse.cdt.dsf.concurrent.ConfinedToDsfExecutor;
import org.eclipse.cdt.dsf.concurrent.DataRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.ImmediateExecutor;
import org.eclipse.cdt.dsf.concurrent.RequestMonitor;
import org.eclipse.cdt.dsf.datamodel.DMContexts;
import org.eclipse.cdt.dsf.datamodel.IDMContext;
import org.eclipse.cdt.dsf.datamodel.IDMEvent;
import org.eclipse.cdt.dsf.debug.service.IRunControl;
import org.eclipse.cdt.dsf.debug.ui.viewmodel.launch.AbstractExecutionContextVMNode;
import org.eclipse.cdt.dsf.debug.ui.viewmodel.launch.ExecutionContextLabelText;
import org.eclipse.cdt.dsf.debug.ui.viewmodel.launch.FullStackRefreshEvent;
import org.eclipse.cdt.dsf.debug.ui.viewmodel.launch.MessagesForLaunchVM;
import org.eclipse.cdt.dsf.service.DsfSession;
import org.eclipse.cdt.dsf.ui.concurrent.ViewerDataRequestMonitor;
import org.eclipse.cdt.dsf.ui.viewmodel.IVMContext;
import org.eclipse.cdt.dsf.ui.viewmodel.IVMNode;
import org.eclipse.cdt.dsf.ui.viewmodel.ModelProxyInstalledEvent;
import org.eclipse.cdt.dsf.ui.viewmodel.VMChildrenUpdate;
import org.eclipse.cdt.dsf.ui.viewmodel.VMDelta;
import org.eclipse.cdt.dsf.ui.viewmodel.datamodel.AbstractDMVMNode;
import org.eclipse.cdt.dsf.ui.viewmodel.datamodel.AbstractDMVMProvider;
import org.eclipse.cdt.dsf.ui.viewmodel.datamodel.IDMVMContext;
import org.eclipse.cdt.dsf.ui.viewmodel.properties.IElementPropertiesProvider;
import org.eclipse.cdt.dsf.ui.viewmodel.properties.IPropertiesUpdate;
import org.eclipse.cdt.dsf.ui.viewmodel.properties.LabelAttribute;
import org.eclipse.cdt.dsf.ui.viewmodel.properties.LabelColumnInfo;
import org.eclipse.cdt.dsf.ui.viewmodel.properties.LabelText;
import org.eclipse.cdt.dsf.ui.viewmodel.properties.PropertiesBasedLabelProvider;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IChildrenUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IElementLabelProvider;
import org.eclipse.debug.internal.ui.viewers.model.provisional.ILabelUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IModelDelta;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IViewerUpdate;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IWorkbenchPart;

public final class PinnedThreadVMNode
extends AbstractExecutionContextVMNode
implements IVMNode,
IElementLabelProvider,
IElementPropertiesProvider {
    private final IElementLabelProvider labelProvider = this.createLabelProvider();

    private static boolean isSubtree(IVMNode root, IVMNode vmNode) {
        IVMNode[] children;
        if (root == null) {
            return false;
        }
        if (root.equals(vmNode)) {
            return true;
        }
        IVMNode[] iVMNodeArray = children = root.getVMProvider().getChildVMNodes(root);
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            IVMNode child = iVMNodeArray[n2];
            if (PinnedThreadVMNode.isSubtree(child, vmNode)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public PinnedThreadVMNode(AbstractDMVMProvider provider, DsfSession session) {
        super(provider, session, IRunControl.IExecutionDMContext.class);
    }

    protected final void addAndSelectPinnedThread(VMDelta parent, DeviceThread element, int nodeOffset, DeviceThread[] threads) {
        int i = 0;
        DeviceThread[] deviceThreadArray = threads;
        int n = threads.length;
        int n2 = 0;
        while (n2 < n) {
            DeviceThread deviceThread = deviceThreadArray[n2];
            if (deviceThread.equals(element)) {
                parent.addNode((Object)this.createVMContext(deviceThread), i + nodeOffset, 0x200010);
                break;
            }
            ++i;
            ++n2;
        }
    }

    public void buildDelta(Object event, VMDelta parent, int nodeOffset, RequestMonitor requestMonitor) {
        boolean done = true;
        if (event instanceof ElementPinnedStatusEvent) {
            ElementPinnedStatusEvent pinnedEvent = (ElementPinnedStatusEvent)event;
            DeviceThread thread = pinnedEvent.getDMContext();
            if (DebugUtil.isParent(parent, thread)) {
                this.togglePin(parent, thread, nodeOffset, pinnedEvent.isPinned(), requestMonitor);
                done = false;
            }
        } else if (event instanceof FullStackRefreshEvent) {
            done = this.buildDeltaForSuspendedEvent(parent, nodeOffset, requestMonitor);
        } else if (event instanceof DoubleClickEvent) {
            DebugUtil.togglePinOnDoubleclick(((DoubleClickEvent)event).getSelection(), this, this.getServicesTracker());
        } else if (event instanceof ModelProxyInstalledEvent) {
            done = this.buildProxyInstalledDelta(nodeOffset, parent, requestMonitor);
        } else if (event instanceof LinkedSelectionChangedEvent || event instanceof LayoutChangeEvent) {
            done = this.buildLinkedSelectionDelta(((IDMEvent)event).getDMContext(), parent, requestMonitor);
        }
        if (done) {
            requestMonitor.done();
        }
    }

    private boolean buildLinkedSelectionDelta(IDMContext context, VMDelta parent, RequestMonitor requestMonitor) {
        if (context instanceof DeviceThread && this.fromKernel(context, parent)) {
            DeviceThread thread = (DeviceThread)context;
            if (DebugUtil.isPinnedOrRemembered(thread)) {
                return this.selectThread(thread, parent, false, requestMonitor);
            }
        } else {
            Object element;
            IDebuggerUIState service = (IDebuggerUIState)this.getServicesTracker().getService(IDebuggerUIState.class);
            if (service != null && service.getFocus() != null && (element = parent.getElement()) instanceof IDMVMContext && ((IDMVMContext)element).getDMContext() instanceof Kernel) {
                KernelCallSite site;
                Kernel callsiteKernel;
                Kernel focus = service.getFocus().getKernel();
                Kernel deltaKernel = (Kernel)DMContexts.getAncestorOfType((IDMContext)((IDMVMContext)element).getDMContext(), Kernel.class);
                if (deltaKernel.equals(focus) && (callsiteKernel = (Kernel)DMContexts.getAncestorOfType((IDMContext)context, Kernel.class)) != null && (site = focus.getCallSite(callsiteKernel.getId())) != null) {
                    DebugUtil.select(service.getFocus(), parent, false, false, this.getVMProvider(), requestMonitor);
                    return false;
                }
            }
        }
        return true;
    }

    private boolean fromKernel(IDMContext context, VMDelta parent) {
        Object element = parent.getElement();
        if (element instanceof IDMVMContext) {
            IDMContext kernel = ((IDMVMContext)element).getDMContext();
            return kernel instanceof Kernel && DMContexts.isAncestorOf((IDMContext)context, (IDMContext)kernel);
        }
        return false;
    }

    private boolean buildProxyInstalledDelta(int nodeOffset, VMDelta parent, RequestMonitor requestMonitor) {
        IDebuggerUIState service = (IDebuggerUIState)this.getServicesTracker().getService(IDebuggerUIState.class);
        if (service != null && service.getFocus() != null) {
            DeviceThread focus = service.getFocus();
            return this.selectThread(focus, parent, true, requestMonitor);
        }
        return true;
    }

    private boolean selectThread(DeviceThread focus, VMDelta parent, boolean collapseOthers, RequestMonitor requestMonitor) {
        VMDelta delta = DebugUtil.getAncestorDelta((IModelDelta)parent, focus);
        if (delta != null) {
            parent.setFlags(parent.getFlags() | 0x100000);
            DebugUtil.select(focus, delta, true, collapseOthers, this.getVMProvider(), requestMonitor);
            return false;
        }
        return true;
    }

    private boolean buildDeltaForSuspendedEvent(VMDelta parent, int nodeOffset, final RequestMonitor requestMonitor) {
        DeviceThread focus;
        IDebuggerUIState stateService = (IDebuggerUIState)this.getServicesTracker().getService(IDebuggerUIState.class);
        if (stateService != null && (focus = stateService.getFocus()) != null) {
            Kernel focusedKernel = focus.getKernel();
            final VMDelta ancestorDelta = DebugUtil.getAncestorDelta((IModelDelta)parent, focusedKernel);
            if (ancestorDelta != null) {
                ancestorDelta.setFlags(ancestorDelta.getFlags() | 0x100000);
                this.getVMProvider().update(new IChildrenUpdate[]{new VMChildrenUpdate((IModelDelta)ancestorDelta, this.getVMProvider().getPresentationContext(), 0, -1, (DataRequestMonitor)new DataRequestMonitor<List<Object>>(ImmediateExecutor.getInstance(), requestMonitor){

                    @ConfinedToDsfExecutor(value="fExecutor")
                    protected void handleSuccess() {
                        ancestorDelta.setChildCount(((List)this.getData()).size());
                        int i = 0;
                        for (Object object : (List)this.getData()) {
                            if (object instanceof IDMVMContext && focus.equals(((IDMVMContext)object).getDMContext())) {
                                ancestorDelta.addNode(object, i, 0x200000);
                                break;
                            }
                            ++i;
                        }
                        requestMonitor.done();
                    }
                })});
                return false;
            }
            return true;
        }
        return true;
    }

    protected IElementLabelProvider createLabelProvider() {
        PropertiesBasedLabelProvider provider = new PropertiesBasedLabelProvider();
        ThreadImage pinnedThreadImage = new ThreadImage(CudaDebugImages.PINNED_THREAD, CudaDebugImages.PINNED_THREAD_DIVERGED, CudaDebugImages.PINNED_THREAD_INACTIVE);
        ThreadImage focusImage = new ThreadImage(CudaDebugImages.FOCUS, CudaDebugImages.FOCUS_DIVERGED, CudaDebugImages.FOCUS_INACTIVE);
        provider.setColumnInfo("ID_COLUMN_NO_COLUMNS", new LabelColumnInfo(new LabelAttribute[]{new IffAttribute("cuda_object_pinned", pinnedThreadImage, focusImage), new ExecutionContextLabelText("CUDA Thread {0} Block {1} {2}", new String[]{"id", "block_id", "cuda_state_label"}){}, new ConditionalLabelColors(DebugUtil.getRGBColor(33), "cuda_object_active", false), new LabelText(MessagesForLaunchVM.AbstractThreadVMNode_No_columns__Error__label, new String[0])}));
        return provider;
    }

    protected IDMVMContext createVMContext(IDMContext dmc) {
        return new AbstractDMVMNode.DMVMContext((AbstractDMVMNode)this, dmc){

            public Object getAdapter(Class adapter) {
                if (IDataContextProvider.class.equals((Object)adapter)) {
                    return new TopStackFrameProvider();
                }
                return super.getAdapter(adapter);
            }
        };
    }

    protected void fillDelta(VMDelta parent, IDMContext[] threads) {
        IVMContext[] iVMContextArray = this.dmcs2vmcs(threads);
        int n = iVMContextArray.length;
        int n2 = 0;
        while (n2 < n) {
            IVMContext vmc = iVMContextArray[n2];
            parent.addNode((Object)vmc, 1024);
            ++n2;
        }
    }

    private void fillThreadState(DeviceThread cudaThread, final IPropertiesUpdate update) {
        cudaThread.getState((DataRequestMonitor<CudaRuntimeInformation>)new ViewerDataRequestMonitor<CudaRuntimeInformation>((Executor)this.getSession().getExecutor(), (IViewerUpdate)update){

            protected void handleCompleted() {
                if (this.isSuccess()) {
                    update.setProperty("diverged", (Object)(((CudaRuntimeInformation)this.getData()).getState() == CudaThreadState.DIVERGENT ? 1 : 0));
                    update.setProperty("cuda_object_active", (Object)((CudaRuntimeInformation)this.getData()).getState().isActive());
                    update.setProperty("cuda_state_label", (Object)Activator.getDefault().getFormatter().format(((CudaRuntimeInformation)this.getData()).getState()));
                    update.done();
                } else {
                    PinnedThreadVMNode.this.handleFailedUpdate((IViewerUpdate)update);
                }
            }
        });
    }

    protected IDMContext getDebuggerFocus() {
        Object element;
        ISelection selection = DebugUITools.getDebugContextForPart((IWorkbenchPart)this.getVMProvider().getPresentationContext().getPart());
        if (selection instanceof IStructuredSelection && ((IStructuredSelection)selection).size() == 1 && (element = ((IStructuredSelection)selection).getFirstElement()) instanceof IAdaptable) {
            return (IDMContext)((IAdaptable)element).getAdapter(IDMContext.class);
        }
        return null;
    }

    public int getDeltaFlags(Object event) {
        if (event instanceof CudaFocusChangedEvent) {
            return 1024;
        }
        if (event instanceof ElementPinnedStatusEvent) {
            return 2100242;
        }
        if (event instanceof FullStackRefreshEvent) {
            return 0x200400;
        }
        if (event instanceof DoubleClickEvent) {
            return 2048;
        }
        if (event instanceof ModelProxyInstalledEvent) {
            return 0x300000;
        }
        if (event instanceof LayoutChangeEvent) {
            return 0x300400;
        }
        if (event instanceof LinkedSelectionChangedEvent) {
            return 0x300400;
        }
        return 0;
    }

    private void getThreads(Kernel threadsContainer, DataRequestMonitor<DeviceThread[]> dmc) {
        IDebuggerUIState service = (IDebuggerUIState)this.getServicesTracker().getService(IDebuggerUIState.class);
        if (service != null) {
            service.getThreads(threadsContainer, 5, dmc);
        } else {
            dmc.done((IStatus)new Status(4, "com.nvidia.cuda.ide.debug", String.valueOf(IDebuggerUIState.class.getName()) + " in not available"));
        }
    }

    protected boolean isFocusThread(DeviceThread context) {
        IDebuggerUIState service = (IDebuggerUIState)this.getServicesTracker().getService(IDebuggerUIState.class);
        if (service != null) {
            return CoreUtil.equals((Object)service.getFocus(), (Object)context);
        }
        return false;
    }

    private boolean isSelection(DeviceThread context) {
        IVMContext vmc;
        IAdaptable debugContext;
        IDMContext selection = this.getDebuggerFocus();
        if (selection != null && (context.equals(selection) || DMContexts.isAncestorOf((IDMContext)selection, (IDMContext)context)) && (debugContext = DebugUITools.getDebugContext()) != null && (vmc = (IVMContext)debugContext.getAdapter(IVMContext.class)) != null) {
            return vmc.getVMNode() != null && PinnedThreadVMNode.isSubtree(this, vmc.getVMNode());
        }
        return false;
    }

    protected boolean isVisibleThread(DeviceThread context) {
        IDebuggerUIState service = (IDebuggerUIState)this.getServicesTracker().getService(IDebuggerUIState.class);
        if (service != null) {
            return service.isRemembered(context);
        }
        return false;
    }

    private void togglePin(final VMDelta parent, final DeviceThread context, final int nodeOffset, final boolean pin, final RequestMonitor rm) {
        Kernel container = (Kernel)DMContexts.getAncestorOfType((IDMContext)context, Kernel.class);
        parent.setFlags(parent.getFlags() | 0x400);
        this.getThreads(container, new DataRequestMonitor<DeviceThread[]>(ImmediateExecutor.getInstance(), rm){

            @ConfinedToDsfExecutor(value="fExecutor")
            protected void handleSuccess() {
                if (PinnedThreadVMNode.this.isFocusThread(context) || pin && PinnedThreadVMNode.this.isVisibleThread(context)) {
                    parent.addNode((Object)PinnedThreadVMNode.this.createVMContext(context), 2048);
                } else if (DebugUtil.isPinned(context)) {
                    PinnedThreadVMNode.this.addAndSelectPinnedThread(parent, context, nodeOffset, (DeviceThread[])this.getData());
                } else {
                    PinnedThreadVMNode.this.unpinThread(parent, context, nodeOffset, (DeviceThread[])this.getData());
                }
                rm.done();
            }
        });
    }

    protected void unpinThread(VMDelta parent, DeviceThread context, int nodeOffset, DeviceThread[] allPinned) {
        int ind = 0;
        DeviceThreadComparator comparator = new DeviceThreadComparator(ICoordSorter.CUDA);
        DeviceThread[] deviceThreadArray = allPinned;
        int n = allPinned.length;
        int n2 = 0;
        while (n2 < n) {
            DeviceThread pinned = deviceThreadArray[n2];
            if (comparator.compare(pinned, context) > 0) break;
            ++ind;
            ++n2;
        }
        parent.addNode((Object)this.createVMContext(context), ind + nodeOffset, 2);
        if (this.isSelection(context) && allPinned.length > 0) {
            DeviceThread sel = ind >= allPinned.length ? allPinned[allPinned.length - 1] : allPinned[ind];
            parent.addNode((Object)this.createVMContext(sel), 0x200000);
        }
    }

    public void update(ILabelUpdate[] updates) {
        this.labelProvider.update(updates);
    }

    public void update(IPropertiesUpdate[] updates) {
        IPropertiesUpdate[] iPropertiesUpdateArray = updates;
        int n = updates.length;
        int n2 = 0;
        while (n2 < n) {
            IPropertiesUpdate update = iPropertiesUpdateArray[n2];
            Object element = update.getElement();
            IDMContext dmContext = ((IDMVMContext)element).getDMContext();
            if (!(dmContext instanceof DeviceThread)) {
                this.handleFailedUpdate((IViewerUpdate)update);
            } else {
                DeviceThread cudaThread = (DeviceThread)dmContext;
                update.setProperty("block_id", (Object)cudaThread.getBlockIdx().toString());
                update.setProperty("id", (Object)cudaThread.getThreadIdx().toString());
                update.setProperty("is_suspended", (Object)true);
                update.setProperty("cuda_object_pinned", (Object)DebugUtil.isPinned(cudaThread));
                if (update.getProperties().contains("cuda_object_active") || update.getProperties().contains("cuda_state_label") || update.getProperties().contains("diverged")) {
                    this.fillThreadState(cudaThread, update);
                } else {
                    update.done();
                }
            }
            ++n2;
        }
    }

    protected void updateElementsInSessionThread(final IChildrenUpdate update) {
        ViewerDataRequestMonitor<DeviceThread[]> dmc = new ViewerDataRequestMonitor<DeviceThread[]>(this.getExecutor(), (IViewerUpdate)update){

            public void handleCompleted() {
                if (!this.isSuccess()) {
                    PinnedThreadVMNode.this.handleFailedUpdate((IViewerUpdate)update);
                    return;
                }
                IDMContext[] data = (IDMContext[])this.getData();
                if (data != null) {
                    PinnedThreadVMNode.this.fillUpdateWithVMCs(update, data);
                }
                update.done();
            }
        };
        IDMContext dmContext = ((IDMVMContext)update.getElement()).getDMContext();
        Kernel threadsContainer = (Kernel)DMContexts.getAncestorOfType((IDMContext)dmContext, Kernel.class);
        if (threadsContainer == null) {
            this.handleFailedUpdate((IViewerUpdate)update);
        } else {
            this.getThreads(threadsContainer, (DataRequestMonitor<DeviceThread[]>)dmc);
        }
    }

    public void getContextsForEvent(VMDelta parentDelta, Object event, DataRequestMonitor<IVMContext[]> rm) {
        if (event instanceof LinkedSelectionChangedEvent || event instanceof LayoutChangeEvent) {
            IDMContext context = ((IDMEvent)event).getDMContext();
            IVMContext[] ctxs = null;
            ctxs = this.getThreadContext(parentDelta, context);
            if (ctxs == null) {
                IDebuggerUIState service = (IDebuggerUIState)this.getServicesTracker().getService(IDebuggerUIState.class);
                if (context != null && service != null && service.getFocus() != null) {
                    Kernel kernel = (Kernel)DMContexts.getAncestorOfType((IDMContext)context, Kernel.class);
                    Kernel focusKernel = service.getFocus().getKernel();
                    if (focusKernel.getCallSite(kernel.getId()) != null) {
                        ctxs = new IVMContext[]{this.createVMContext(service.getFocus())};
                    }
                }
            }
            if (ctxs == null) {
                ctxs = new IVMContext[]{};
            }
            rm.done((Object)ctxs);
        } else {
            super.getContextsForEvent(parentDelta, event, rm);
        }
    }

    private IVMContext[] getThreadContext(VMDelta parentDelta, IDMContext context) {
        IDMContext dmContext;
        Object element;
        if (context instanceof DeviceThread && (element = parentDelta.getElement()) instanceof IDMVMContext && DMContexts.isAncestorOf((IDMContext)context, (IDMContext)(dmContext = ((IDMVMContext)element).getDMContext()))) {
            return new IVMContext[]{this.createVMContext(context)};
        }
        return null;
    }

    public class TopStackFrameProvider
    implements IDataContextProvider {
        @Override
        public void getDataContext(Object element, DataRequestMonitor<IDMVMContext> rm) {
            IRunControl.IExecutionDMContext thread;
            IDMContext dmc;
            IVMNode[] nodes = PinnedThreadVMNode.this.getVMProvider().getChildVMNodes((IVMNode)PinnedThreadVMNode.this);
            MulticolumnCudaStackFramesVMNode stackNode = null;
            IVMNode[] iVMNodeArray = nodes;
            int n = nodes.length;
            int n2 = 0;
            while (n2 < n) {
                IVMNode node = iVMNodeArray[n2];
                if (node instanceof MulticolumnCudaStackFramesVMNode) {
                    stackNode = (MulticolumnCudaStackFramesVMNode)node;
                    break;
                }
                ++n2;
            }
            if (stackNode != null && (dmc = (IDMContext)((IAdaptable)element).getAdapter(IDMContext.class)) != null && (thread = (IRunControl.IExecutionDMContext)DMContexts.getAncestorOfType((IDMContext)dmc, IRunControl.IExecutionDMContext.class)) != null) {
                stackNode.getTopFrame(thread, rm);
                return;
            }
            rm.done();
        }
    }
}

