/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui.wizards;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.internal.ccvs.core.ICVSFolder;
import org.eclipse.team.internal.ccvs.core.ICVSRepositoryLocation;
import org.eclipse.team.internal.ccvs.core.connection.CVSRepositoryLocation;
import org.eclipse.team.internal.ccvs.core.resources.CVSWorkspaceRoot;
import org.eclipse.team.internal.ccvs.core.syncinfo.FolderSyncInfo;
import org.eclipse.team.internal.ccvs.ui.CVSUIMessages;
import org.eclipse.team.internal.ccvs.ui.CVSUIPlugin;
import org.eclipse.team.internal.ccvs.ui.wizards.CVSWizardPage;
import org.eclipse.ui.PlatformUI;

public class ConfigurationWizardAutoconnectPage
extends CVSWizardPage {
    private boolean validate = true;
    private FolderSyncInfo info;
    ICVSRepositoryLocation location;

    public ConfigurationWizardAutoconnectPage(String pageName, String title, ImageDescriptor titleImage) {
        super(pageName, title, titleImage);
    }

    public void createControl(Composite parent) {
        Composite composite = this.createComposite(parent, 2, false);
        this.setControl((Control)composite);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, "org.eclipse.team.cvs.ui.sharing_autoconnect_page_context");
        Label description = new Label(composite, 64);
        GridData data = new GridData();
        data.horizontalSpan = 2;
        data.widthHint = 350;
        description.setLayoutData((Object)data);
        description.setText(CVSUIMessages.ConfigurationWizardAutoconnectPage_description);
        if (this.location == null) {
            return;
        }
        ConfigurationWizardAutoconnectPage.createLabel(composite, "");
        ConfigurationWizardAutoconnectPage.createLabel(composite, "");
        ConfigurationWizardAutoconnectPage.createLabel(composite, CVSUIMessages.ConfigurationWizardAutoconnectPage_user);
        ConfigurationWizardAutoconnectPage.createLabel(composite, this.location.getUsername());
        ConfigurationWizardAutoconnectPage.createLabel(composite, CVSUIMessages.ConfigurationWizardAutoconnectPage_host);
        ConfigurationWizardAutoconnectPage.createLabel(composite, this.location.getHost());
        ConfigurationWizardAutoconnectPage.createLabel(composite, CVSUIMessages.ConfigurationWizardAutoconnectPage_port);
        int port = this.location.getPort();
        if (port == 0) {
            ConfigurationWizardAutoconnectPage.createLabel(composite, CVSUIMessages.ConfigurationWizardAutoconnectPage_default);
        } else {
            ConfigurationWizardAutoconnectPage.createLabel(composite, "" + port);
        }
        ConfigurationWizardAutoconnectPage.createLabel(composite, CVSUIMessages.ConfigurationWizardAutoconnectPage_connectionType);
        ConfigurationWizardAutoconnectPage.createLabel(composite, this.location.getMethod().getName());
        ConfigurationWizardAutoconnectPage.createLabel(composite, CVSUIMessages.ConfigurationWizardAutoconnectPage_repositoryPath);
        ConfigurationWizardAutoconnectPage.createLabel(composite, this.location.getRootDirectory());
        ConfigurationWizardAutoconnectPage.createLabel(composite, CVSUIMessages.ConfigurationWizardAutoconnectPage_module);
        ConfigurationWizardAutoconnectPage.createLabel(composite, this.info.getRepository());
        ConfigurationWizardAutoconnectPage.createLabel(composite, "");
        ConfigurationWizardAutoconnectPage.createLabel(composite, "");
        final Button check = new Button(composite, 32);
        data = new GridData();
        data.horizontalSpan = 2;
        check.setText(CVSUIMessages.ConfigurationWizardAutoconnectPage_validate);
        check.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                ConfigurationWizardAutoconnectPage.this.validate = check.getSelection();
            }
        });
        check.setSelection(true);
        Dialog.applyDialogFont((Control)parent);
    }

    public FolderSyncInfo getFolderSyncInfo() {
        return this.info;
    }

    public boolean getValidate() {
        return this.validate;
    }

    public boolean setProject(IProject project) {
        block3: {
            try {
                ICVSFolder folder = (ICVSFolder)CVSWorkspaceRoot.getCVSResourceFor((IResource)project);
                this.info = folder.getFolderSyncInfo();
                if (this.info != null) break block3;
                CVSUIPlugin.openError(null, CVSUIMessages.ConfigurationWizardAutoconnectPage_noSyncInfo, CVSUIMessages.ConfigurationWizardAutoconnectPage_noCVSDirectory, null);
                return false;
            }
            catch (TeamException e) {
                CVSUIPlugin.openError(null, null, null, e);
                return false;
            }
        }
        this.location = CVSRepositoryLocation.fromString((String)this.info.getRoot());
        return true;
    }

    public ICVSRepositoryLocation getLocation() {
        return this.location;
    }
}

