/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.subsystems.processes.shell.linux;

import org.eclipse.rse.core.model.IHost;
import org.eclipse.rse.core.subsystems.IConnectorService;
import org.eclipse.rse.core.subsystems.ISubSystem;
import org.eclipse.rse.internal.subsystems.processes.shell.linux.Activator;
import org.eclipse.rse.internal.subsystems.processes.shell.linux.DelegatingShellProcessConnectorService;
import org.eclipse.rse.internal.subsystems.processes.shell.linux.LinuxShellProcessService;
import org.eclipse.rse.internal.subsystems.processes.shell.linux.ShellProcessAdapter;
import org.eclipse.rse.services.processes.IProcessService;
import org.eclipse.rse.services.shells.IShellService;
import org.eclipse.rse.subsystems.processes.core.subsystem.IHostProcessToRemoteProcessAdapter;
import org.eclipse.rse.subsystems.processes.servicesubsystem.ProcessServiceSubSystem;
import org.eclipse.rse.subsystems.processes.servicesubsystem.ProcessServiceSubSystemConfiguration;

public class ShellProcessSubSystemConfiguration
extends ProcessServiceSubSystemConfiguration {
    protected IHostProcessToRemoteProcessAdapter hostProcessAdapter;

    public ISubSystem createSubSystemInternal(IHost conn) {
        IConnectorService connectorService = this.getConnectorService(conn);
        ProcessServiceSubSystem subsys = new ProcessServiceSubSystem(conn, connectorService, this.getProcessService(conn), this.getHostProcessAdapter());
        return subsys;
    }

    public IHostProcessToRemoteProcessAdapter getHostProcessAdapter() {
        if (this.hostProcessAdapter == null) {
            this.hostProcessAdapter = new ShellProcessAdapter();
        }
        return this.hostProcessAdapter;
    }

    public IConnectorService getConnectorService(IHost host) {
        ISubSystem ss = Activator.getSuitableSubSystem(host);
        if (ss != null) {
            return ss.getConnectorService();
        }
        return new DelegatingShellProcessConnectorService(host);
    }

    public Class getServiceImplType() {
        return IShellService.class;
    }

    public void setConnectorService(IHost host, IConnectorService connectorService) {
    }

    public IProcessService createProcessService(IHost host) {
        return new LinuxShellProcessService(host);
    }
}

