/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.cuda.ide.build.ui;

import com.nvidia.cuda.ide.build.core.Activator;
import com.nvidia.cuda.ide.build.core.Architecture;
import com.nvidia.cuda.ide.build.project.AbstractMultiModule;
import com.nvidia.cuda.ide.build.project.BuildUtils;
import com.nvidia.cuda.ide.build.project.ICudaProjectConfiguration;
import com.nvidia.cuda.ide.build.project.MultiConfiguration;
import com.nvidia.cuda.ide.build.project.MultiCubin;
import com.nvidia.cuda.ide.build.ui.BasicModuleView;
import com.nvidia.cuda.ide.build.ui.MultiModuleView;
import com.nvidia.cuda.ide.build.ui.SourceEditingArchitectureFieldEditor;
import com.nvidia.cuda.ide.util.UiUtil;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.core.settings.model.ICResourceDescription;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.ui.newui.AbstractCPropertyTab;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.statushandlers.StatusManager;

public class CudaArchitecturesTab
extends AbstractCPropertyTab
implements ICudaProjectConfiguration.IModuleListener {
    private static final String PREF_DEFAULT_MODE = "projectProperty.advanced";
    private MultiModuleView advancedView;
    private BasicModuleView basicView;
    private MultiConfiguration configuration;
    private Link link;
    private SourceEditingArchitectureFieldEditor sourceArch;

    private static int allArchitectures(AbstractMultiModule module) {
        return module.getVirtualArchitecturesForAllConfigurations() | module.getPhysicalArchitecturesForAllConfigurations();
    }

    public static void showControl(Control control, boolean advancedMode, int fill, int heightHint) {
        GridData data = new GridData(fill);
        data.exclude = !advancedMode;
        data.heightHint = heightHint;
        data.widthHint = 300;
        data.horizontalSpan = 2;
        control.setVisible(advancedMode);
        control.setLayoutData((Object)data);
        control.getParent().layout();
    }

    public boolean canBeVisible() {
        ICResourceDescription resDesc = this.getResDesc();
        ICConfigurationDescription description = resDesc.getConfiguration();
        IConfiguration c = ManagedBuildManager.getConfigurationForDescription((ICConfigurationDescription)description);
        return c.isManagedBuildOn() && BuildUtils.isCudaToolkit(c.getToolChain());
    }

    @Override
    public void configurationReloaded() {
        this.updateSourceTarget();
    }

    public MultiModuleView createAdvancedMode(Composite book) {
        return new MultiModuleView(book, 0, this.configuration);
    }

    private BasicModuleView createBasicPane(Composite book) {
        return new BasicModuleView(book, this.configuration, false);
    }

    protected void createControls(Composite parent) {
        super.createControls(parent);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "com.nvidia.cuda.ide.build.cuda-property-page");
        try {
            this.configuration = new MultiConfiguration();
            this.configuration.load(this.getResDesc().getConfiguration());
        }
        catch (CoreException e) {
            StatusManager.getManager().handle((IStatus)new Status(4, "com.nvidia.cuda.ide.build", "Unable to read module configuration from project metadata", (Throwable)e), 3);
        }
        IResource resource = (IResource)this.page.getElement();
        this.usercomp.setLayout((Layout)new GridLayout(2, false));
        this.configuration.addModuleListener(this);
        this.basicView = this.createBasicPane(this.usercomp);
        this.advancedView = this.createAdvancedMode(this.usercomp);
        UiUtil.createDevicesInformationLabel(this.usercomp);
        if (resource.getType() != 1) {
            new Label(this.usercomp, 0).setLayoutData((Object)new GridData(1, 1, false, false, 2, 1));
            this.sourceArch = new PreferenceTabSourceArchEditor(this.usercomp);
        }
        this.link = this.createLink(this.usercomp, 2);
        this.updateActiveMode();
    }

    private Link createLink(Composite pane, int columns) {
        final Link link = new Link(pane, 0);
        GridData data = new GridData(136);
        data.horizontalSpan = columns;
        data.grabExcessHorizontalSpace = true;
        link.setLayoutData((Object)data);
        link.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CudaArchitecturesTab.this.switchMode((Boolean)link.getData() == false);
            }
        });
        return link;
    }

    public int getArchitectures() {
        int archs = CudaArchitecturesTab.allArchitectures(this.configuration.getExecutable());
        MultiCubin[] multiCubinArray = this.configuration.getModules();
        int n = multiCubinArray.length;
        int n2 = 0;
        while (n2 < n) {
            MultiCubin module = multiCubinArray[n2];
            if (module.isInAllConfigurations()) {
                archs |= CudaArchitecturesTab.allArchitectures(module);
            }
            ++n2;
        }
        return archs;
    }

    @Override
    public void moduleAdded() {
        this.updateSourceTarget();
    }

    @Override
    public void modulePropertyChanged() {
        if (!this.usercomp.isDisposed()) {
            this.updateSourceTarget();
        }
    }

    @Override
    public void moduleRemoved() {
        this.updateSourceTarget();
    }

    protected void performApply(ICResourceDescription src, ICResourceDescription dst) {
    }

    protected void performDefaults() {
        this.advancedView.performDefaults();
        this.resetArchToDefault();
    }

    private void resetArchToDefault() {
        this.updateSourceTarget();
    }

    private void switchMode(boolean advancedMode) {
        if (advancedMode) {
            this.link.setText("<a>Switch to basic mode >></a>");
        } else {
            this.link.setText("<a>Switch to advanced mode >></a>");
        }
        this.link.setLayoutData((Object)new GridData(0x1000008, 0x1000008, true, !advancedMode, 2, 1));
        if (this.link.isVisible()) {
            Activator.getDefault().getPreferenceStore().setValue(PREF_DEFAULT_MODE, advancedMode);
        }
        this.link.setData((Object)advancedMode);
        CudaArchitecturesTab.showControl((Control)this.advancedView, advancedMode, 1808, 320);
        CudaArchitecturesTab.showControl((Control)this.basicView, !advancedMode, 768, -1);
        this.usercomp.layout(true);
    }

    private void updateActiveMode() {
        MultiCubin[] modules = this.configuration.getModules();
        if (this.link != null) {
            this.link.setVisible(modules.length == 0);
        }
        this.switchMode(modules.length > 0 || Activator.getDefault().getPreferenceStore().getBoolean(PREF_DEFAULT_MODE));
    }

    protected void updateButtons() {
    }

    protected void updateData(ICResourceDescription cfg) {
        try {
            this.configuration.load(cfg.getConfiguration());
            this.updateActiveMode();
            this.updateSourceTarget();
        }
        catch (CoreException e) {
            StatusManager.getManager().handle((IStatus)new Status(4, "com.nvidia.cuda.ide.build", "Unable to load project configuration", (Throwable)e), 3);
        }
    }

    private void updateSourceTarget() {
        if (this.sourceArch != null) {
            this.sourceArch.updateSourceTarget();
        }
    }

    private final class PreferenceTabSourceArchEditor
    extends SourceEditingArchitectureFieldEditor {
        private PreferenceTabSourceArchEditor(Composite usercomp) {
            super(usercomp);
        }

        @Override
        protected Architecture getArchitecture() {
            return CudaArchitecturesTab.this.configuration.getEditorArchitecture();
        }

        @Override
        protected int getAvailableArchitectures() {
            return CudaArchitecturesTab.this.configuration.getSupportedArchitectures();
        }

        @Override
        protected void setArchitecture(Architecture arch) {
            CudaArchitecturesTab.this.configuration.setEditorArchitecture(arch);
        }
    }
}

