/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.cuda.ide.build.project;

import com.nvidia.cuda.ide.build.project.AbstractMultiModule;
import com.nvidia.cuda.ide.build.project.CudaExecutable;
import com.nvidia.cuda.ide.build.project.CudaProjectConfigurationImpl;
import com.nvidia.cuda.ide.build.project.ICudaModule;
import com.nvidia.cuda.ide.build.project.MultiConfiguration;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.resources.IFile;

public class MultiExecutable
extends AbstractMultiModule {
    public MultiExecutable(MultiConfiguration multiConfiguration) {
        super(multiConfiguration);
    }

    public Collection<IFile> getExcludedFromAllConfigurations() {
        HashSet<IFile> files = null;
        Collection<CudaExecutable> modules = this.getModules();
        for (CudaExecutable cudaExecutable : modules) {
            List<IFile> configurationFiles = Arrays.asList(cudaExecutable.getExcludedFiles());
            if (files == null) {
                files = new HashSet<IFile>(configurationFiles);
                continue;
            }
            files.retainAll(configurationFiles);
        }
        return files;
    }

    public Collection<IFile> getExcludedFromSomeConfigurations() {
        HashSet<IFile> presentInAllModules = null;
        HashSet<IFile> presentInAnyModule = null;
        Collection<CudaExecutable> modules = this.getModules();
        for (CudaExecutable cudaExecutable : modules) {
            List<IFile> configurationFiles = Arrays.asList(cudaExecutable.getExcludedFiles());
            if (presentInAllModules == null) {
                presentInAllModules = new HashSet<IFile>(configurationFiles);
                presentInAnyModule = new HashSet<IFile>(configurationFiles);
                continue;
            }
            presentInAllModules.retainAll(configurationFiles);
            presentInAnyModule.addAll(configurationFiles);
        }
        presentInAnyModule.remove(presentInAllModules);
        return presentInAnyModule;
    }

    protected Collection<CudaExecutable> getModules() {
        CudaProjectConfigurationImpl[] configurations = this.multiConfiguration.getNestedConfigurations();
        CudaExecutable[] executables = new CudaExecutable[configurations.length];
        int i = 0;
        while (i < configurations.length) {
            executables[i] = configurations[i].getExecutable();
            ++i;
        }
        return Collections.unmodifiableCollection(Arrays.asList(executables));
    }

    @Override
    public Collection<ICudaModule.Type> getTypesFromConfigurations() {
        return Collections.singleton(ICudaModule.Type.executable);
    }
}

