/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.viper.actions;

import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPageListener;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.actions.PartEventAction;

public class ActiveEditorAction
extends PartEventAction
implements IPageListener {
    private IWorkbenchWindow window;
    private IWorkbenchPage activePage;
    private IEditorPart activeEditor;

    public ActiveEditorAction(String label, IWorkbenchWindow window) {
        super(label);
        this.window = window;
        this.activePage = window.getActivePage();
        this.window.addPageListener((IPageListener)this);
        this.window.getPartService().addPartListener((IPartListener)this);
        this.updateState();
    }

    public IEditorPart getActiveEditor() {
        return this.activeEditor;
    }

    public void setActiveEditor(IEditorPart activeEditor) {
        this.activeEditor = activeEditor;
    }

    public void pageActivated(IWorkbenchPage page) {
        this.activePage = page;
        this.updateActiveEditor();
        this.updateState();
    }

    public void pageClosed(IWorkbenchPage page) {
        if (page == this.activePage) {
            this.activePage = null;
        }
        this.updateActiveEditor();
        this.updateState();
    }

    public void pageOpened(IWorkbenchPage page) {
    }

    public void partActivated(IWorkbenchPart part) {
        super.partActivated(part);
        if (part instanceof IEditorPart) {
            this.updateActiveEditor();
            this.updateState();
        }
    }

    public void partClosed(IWorkbenchPart part) {
        super.partClosed(part);
        if (part instanceof IEditorPart) {
            this.updateActiveEditor();
            this.updateState();
        }
    }

    public void partDeactivated(IWorkbenchPart part) {
        super.partDeactivated(part);
        if (part instanceof IEditorPart) {
            this.updateActiveEditor();
            this.updateState();
        }
    }

    private void updateActiveEditor() {
        if (this.activePage == null) {
            this.setActiveEditor(null);
        } else {
            this.setActiveEditor(this.activePage.getActiveEditor());
        }
    }

    protected void updateState() {
        this.setEnabled(this.getActiveEditor() != null);
    }
}

