/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.viper;

import com.nvidia.viper.ViperException;
import com.nvidia.viper.ViperExceptionHandler;
import com.nvidia.viper.ViperMessages;
import com.nvidia.viper.jni.CuptiEvent;
import com.nvidia.viper.jni.NativeCupti;
import com.nvidia.viper.model.Event;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class EventManager {
    private static Map<EventDomainIdPair, Event> events = new HashMap<EventDomainIdPair, Event>();
    private static Map<String, Set<Event>> eventNameMap = new HashMap<String, Set<Event>>();

    static {
        try {
            ArrayList<CuptiEvent> cuptiEvents = NativeCupti.cuptiGetEvents();
            for (CuptiEvent e : cuptiEvents) {
                if (EventManager.getEvent(e.domain, e.id) != null) continue;
                EventManager.createEvent(e.domain, e.id, e.name, e.shortDesc, e.longDesc);
            }
        }
        catch (Exception e2) {
            ViperException e2;
            if (!(e2 instanceof ViperException)) {
                e2 = new ViperException(e2);
            }
            ViperExceptionHandler.handle(ViperMessages.EventManager_Fail_Title, ViperMessages.EventManager_Fail_Message, e2);
        }
    }

    private static Event createEvent(int domain, int id, String name, String shortDesc, String longDesc) {
        EventDomainIdPair idPair = new EventDomainIdPair(domain, id);
        Event event = events.get(idPair);
        if (event == null) {
            event = new Event(domain, id, name, shortDesc, longDesc);
            events.put(idPair, event);
            if (name != null && !name.isEmpty()) {
                Set<Event> eventSet = eventNameMap.get(name);
                if (eventSet == null) {
                    eventSet = new HashSet<Event>();
                    eventNameMap.put(name, eventSet);
                }
                eventSet.add(event);
            }
        }
        return event;
    }

    public static Event getEvent(int domain, int id) {
        EventDomainIdPair idPair = new EventDomainIdPair(domain, id);
        return events.get(idPair);
    }

    public static Set<Event> getEvents(String eventName) {
        Set<Event> eventSet = eventNameMap.get(eventName);
        if (eventSet == null) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet(eventSet);
    }

    public static Collection<Event> getEvents() {
        return Collections.unmodifiableCollection(events.values());
    }

    private static class EventDomainIdPair {
        int domain;
        int id;

        private EventDomainIdPair(int domain, int id) {
            this.domain = domain;
            this.id = id;
        }

        private EventDomainIdPair(Event event) {
            this(event.getDomain(), event.getId());
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof EventDomainIdPair)) {
                return false;
            }
            EventDomainIdPair other = (EventDomainIdPair)obj;
            return this.domain == other.domain && this.id == other.id;
        }

        public int hashCode() {
            return this.domain + this.id;
        }
    }
}

