/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.ui.concurrent;

import java.lang.reflect.Field;
import java.util.concurrent.Executor;
import org.eclipse.cdt.dsf.concurrent.DataRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.DsfExecutable;
import org.eclipse.cdt.dsf.concurrent.RequestMonitor;
import org.eclipse.cdt.dsf.internal.DsfPlugin;
import org.eclipse.cdt.dsf.ui.viewmodel.VMViewerUpdate;
import org.eclipse.core.runtime.Platform;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IViewerUpdate;

public class ViewerDataRequestMonitor<V>
extends DataRequestMonitor<V> {
    private static boolean DEBUG_MONITORS = DsfPlugin.DEBUG && "true".equals(Platform.getDebugOption((String)"org.eclipse.cdt.dsf/debug/monitors"));
    private final IViewerUpdate fUpdate;

    public ViewerDataRequestMonitor(Executor executor, IViewerUpdate update) {
        super(executor, null);
        this.fUpdate = update;
        if (DEBUG_MONITORS) {
            this.createMonitorBacktrace();
        }
    }

    public synchronized boolean isCanceled() {
        return this.fUpdate.isCanceled() || super.isCanceled();
    }

    protected void handleSuccess() {
        this.fUpdate.done();
    }

    protected void handleErrorOrWarning() {
        this.fUpdate.setStatus(this.getStatus());
        this.fUpdate.done();
    }

    protected void handleCancel() {
        this.fUpdate.setStatus(this.getStatus());
        this.fUpdate.done();
    }

    private void createMonitorBacktrace() {
        StringBuilder str = new StringBuilder();
        ViewerDataRequestMonitor nextrm = this;
        VMViewerUpdate nextupdate = null;
        String type = null;
        while (true) {
            StackTraceElement topFrame = null;
            if (nextupdate != null) {
                type = "update ";
                topFrame = ViewerDataRequestMonitor.getCreatedAtTopFrame(nextupdate);
                nextrm = ViewerDataRequestMonitor.getMonitor(nextupdate);
                nextupdate = null;
            } else {
                if (nextrm == null) break;
                type = "monitor";
                topFrame = ViewerDataRequestMonitor.getCreatedAtTopFrame(nextrm);
                if (nextrm instanceof ViewerDataRequestMonitor) {
                    ViewerDataRequestMonitor vdrm = nextrm;
                    nextupdate = vdrm.fUpdate instanceof VMViewerUpdate ? (VMViewerUpdate)vdrm.fUpdate : null;
                    nextrm = null;
                } else {
                    nextrm = ViewerDataRequestMonitor.getParentMonitor((RequestMonitor)nextrm);
                    nextupdate = null;
                }
            }
            if (topFrame != null) {
                str.append("[" + type + "] " + topFrame + "\n");
                continue;
            }
            str.append("<unknown>\n");
        }
        try {
            Field field = RequestMonitor.class.getDeclaredField("fMonitorBacktrace");
            field.setAccessible(true);
            field.set((Object)this, str.toString());
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (SecurityException securityException) {
        }
        catch (NoSuchFieldException noSuchFieldException) {}
    }

    private static RequestMonitor getMonitor(VMViewerUpdate update) {
        try {
            Field field = VMViewerUpdate.class.getDeclaredField("fRequestMonitor");
            field.setAccessible(true);
            return (RequestMonitor)field.get((Object)update);
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (SecurityException securityException) {
        }
        catch (NoSuchFieldException noSuchFieldException) {
        }
        catch (ClassCastException classCastException) {}
        return null;
    }

    private static RequestMonitor getParentMonitor(RequestMonitor rm) {
        try {
            Field field = RequestMonitor.class.getDeclaredField("fParentRequestMonitor");
            field.setAccessible(true);
            return (RequestMonitor)field.get(rm);
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (NoSuchFieldException noSuchFieldException) {}
        return null;
    }

    private static <T extends DsfExecutable> StackTraceElement getCreatedAtTopFrame(T dsfExecutable) {
        try {
            Field field_fCreatedAt = DsfExecutable.class.getDeclaredField("fCreatedAt");
            field_fCreatedAt.setAccessible(true);
            Object obj_fCreatedAt = field_fCreatedAt.get(dsfExecutable);
            Class<?> class_StackTraceElement = Class.forName("org.eclipse.cdt.dsf.concurrent.StackTraceWrapper");
            Field field_fStackTraceElements = class_StackTraceElement.getDeclaredField("fStackTraceElements");
            field_fStackTraceElements.setAccessible(true);
            StackTraceElement[] frames = (StackTraceElement[])field_fStackTraceElements.get(obj_fCreatedAt);
            if (frames != null && frames.length > 0) {
                return frames[0];
            }
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (NoSuchFieldException noSuchFieldException) {
        }
        catch (ClassNotFoundException classNotFoundException) {}
        return null;
    }
}

