/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.cuda.ide.remote.internal.source;

import com.nvidia.cuda.ide.remote.internal.source.RemoteSystemSourceContainer;
import org.eclipse.cdt.debug.internal.core.sourcelookup.CSourcePathComputerDelegate;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.sourcelookup.ISourceContainer;

public class RemoteDebugSourcePathComputer
extends CSourcePathComputerDelegate {
    public ISourceContainer[] computeSourceContainers(ILaunchConfiguration configuration, IProgressMonitor monitor) throws CoreException {
        ISourceContainer[] containers = super.computeSourceContainers(configuration, monitor);
        boolean useRemoteContainer = RemoteSystemSourceContainer.shouldUseRemoteContainer(configuration);
        if (useRemoteContainer) {
            boolean found = false;
            ISourceContainer[] iSourceContainerArray = containers;
            int n = containers.length;
            int n2 = 0;
            while (n2 < n) {
                ISourceContainer container = iSourceContainerArray[n2];
                if (container.getType().getId().equals("com.nvidia.cuda.ide.remote.remoteFiles")) {
                    found = true;
                    break;
                }
                ++n2;
            }
            if (!found) {
                ISourceContainer[] newContainers = new ISourceContainer[containers.length + 1];
                newContainers[0] = new RemoteSystemSourceContainer();
                System.arraycopy(containers, 0, newContainers, 1, containers.length);
                return newContainers;
            }
        }
        return containers;
    }
}

