/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.cuda.ide.remote.internal.commands;

import com.nvidia.common.util.CoreUtil;
import com.nvidia.cuda.ide.build.core.Activator;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.ptp.internal.rdt.sync.git.core.JGitRepo;
import org.eclipse.ptp.rdt.sync.core.SyncConfig;
import org.eclipse.ptp.rdt.sync.core.SyncConfigManager;
import org.eclipse.ptp.rdt.sync.core.SyncManager;
import org.eclipse.ptp.rdt.sync.core.exceptions.MissingConnectionException;
import org.eclipse.ptp.rdt.sync.core.services.ISynchronizeService;
import org.eclipse.remote.core.IRemoteConnection;
import org.eclipse.remote.core.IRemoteFileManager;
import org.eclipse.remote.core.exception.RemoteConnectionException;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;

public class SyncResetOperation
extends AbstractHandler {
    private static final String GIT_SYNC_SERVICE_ID = "org.eclipse.ptp.rdt.sync.git.core.synchronizeService";

    public static IProject getProjectFromSelection(ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            Object[] objectArray = ((IStructuredSelection)selection).toArray();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                ICProject cprj;
                Object o = objectArray[n2];
                if (o instanceof IProject) {
                    return (IProject)o;
                }
                if (o instanceof IResource) {
                    return ((IResource)o).getProject();
                }
                if (o instanceof ICElement && (cprj = ((ICElement)o).getCProject()) != null) {
                    return cprj.getProject();
                }
                ++n2;
            }
        }
        return null;
    }

    public IRemoteConnection getRemoteConnectionSafe(SyncConfig config) {
        try {
            return !SyncConfigManager.isLocal((SyncConfig)config) ? config.getRemoteConnection() : null;
        }
        catch (MissingConnectionException missingConnectionException) {
            return null;
        }
    }

    public static String getActiveSyncServiceId(IProject prj) {
        SyncConfig active = prj != null ? SyncConfigManager.getActive((IProject)prj) : null;
        return active != null ? active.getSyncProviderId() : null;
    }

    /*
     * Loose catch block
     */
    public static void deleteLocalGitRepo(IProject project, IProgressMonitor monitor) {
        monitor.beginTask("Reinitializing local git repository", 99);
        try {
            try {
                IFolder gitDir = project.getFolder(".ptp-sync");
                if (gitDir.exists()) {
                    gitDir.delete(true, (IProgressMonitor)new SubProgressMonitor(monitor, 33));
                }
                JGitRepo repo = new JGitRepo(project.getLocation(), (IProgressMonitor)new SubProgressMonitor(monitor, 33));
                repo.close();
                project.refreshLocal(2, (IProgressMonitor)new SubProgressMonitor(monitor, 33));
            }
            catch (GitAPIException e) {
                Activator.log((Exception)((Object)e));
                monitor.done();
            }
            catch (CoreException e) {
                Activator.log((Exception)((Object)e));
                monitor.done();
            }
            catch (IOException e) {
                Activator.log((Exception)e);
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
                monitor.done();
            }
        }
        finally {
            monitor.done();
        }
    }

    public static void closeSyncProject(IProject project) {
        String serviceId = SyncResetOperation.getActiveSyncServiceId(project);
        ISynchronizeService service = SyncManager.getSyncService((String)serviceId);
        try {
            service.close(project);
        }
        catch (CoreException e) {
            Activator.log((Exception)((Object)e));
        }
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        IProject project = SyncResetOperation.getProjectFromSelection(selection);
        if (!CoreUtil.equals((Object)SyncResetOperation.getActiveSyncServiceId(project), (Object)GIT_SYNC_SERVICE_ID)) {
            return null;
        }
        Shell shell = HandlerUtil.getActiveShell((ExecutionEvent)event);
        String message = "Synchronization state for the project " + project.getName() + " is about to be deleted.\n" + "Are you sure you want to continue?\n" + "Nsight will be restarted to complete the operation!";
        String title = "Deleting sync state of " + project.getName();
        MessageDialog areYouSure = new MessageDialog(shell, title, null, message, 3, new String[]{"Yes", "No"}, 0);
        if (areYouSure.open() != 0) {
            return null;
        }
        SyncResetOperationRunnable op = new SyncResetOperationRunnable(project);
        ProgressMonitorDialog dialog = new ProgressMonitorDialog(shell);
        try {
            dialog.run(true, true, (IRunnableWithProgress)op);
        }
        catch (InvocationTargetException e) {
            Activator.log((Exception)e, (String)"Failed to reset synchronized project state", (Object[])new Object[0]);
        }
        catch (InterruptedException interruptedException) {
            return null;
        }
        PlatformUI.getWorkbench().restart();
        return null;
    }

    class SyncResetOperationRunnable
    implements IRunnableWithProgress {
        private final IProject project;

        SyncResetOperationRunnable(IProject p) {
            this.project = p;
        }

        boolean tryOpenConnection(IRemoteConnection conn, IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
            monitor.beginTask("Opening connection to " + conn.getName(), 100);
            try {
                if (conn.isOpen()) {
                    return true;
                }
                conn.open((IProgressMonitor)new SubProgressMonitor(monitor, 100));
                boolean bl = conn.isOpen();
                return bl;
            }
            catch (RemoteConnectionException e) {
                if (e.getCause() instanceof InterruptedException) {
                    throw (InterruptedException)e.getCause();
                }
                throw new InvocationTargetException(e, "Can not open the connection");
            }
            finally {
                monitor.done();
            }
        }

        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
            Object[] configs = SyncConfigManager.getConfigs((IProject)this.project);
            if (CoreUtil.isNullOrEmpty((Object[])configs)) {
                throw new InvocationTargetException(null, "Project does not have any synchronized configs");
            }
            monitor.beginTask("Deleting synchronized project " + this.project.getName() + " git repositories", 30 + (configs.length - 1) * 50);
            SyncResetOperation.deleteLocalGitRepo(this.project, (IProgressMonitor)new SubProgressMonitor(monitor, 30));
            Object[] objectArray = configs;
            int n = configs.length;
            int n2 = 0;
            while (n2 < n) {
                Object config = objectArray[n2];
                IRemoteConnection conn = SyncResetOperation.this.getRemoteConnectionSafe((SyncConfig)config);
                if (conn != null) {
                    if (!this.tryOpenConnection(conn, (IProgressMonitor)new SubProgressMonitor(monitor, 10))) {
                        monitor.worked(40);
                    } else {
                        String remoteLocation = config.getLocation();
                        try {
                            IRemoteFileManager fs = conn.getFileManager();
                            IFileStore dir = fs.getResource(remoteLocation);
                            dir.delete(0, (IProgressMonitor)new SubProgressMonitor(monitor, 10));
                        }
                        catch (CoreException e) {
                            e.printStackTrace();
                        }
                    }
                }
                ++n2;
            }
            monitor.done();
        }
    }
}

