/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.toolbox.plugins;

import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.BaseFont;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfGState;
import com.lowagie.text.pdf.PdfReader;
import com.lowagie.text.pdf.PdfStamper;
import com.lowagie.toolbox.AbstractTool;
import com.lowagie.toolbox.arguments.AbstractArgument;
import com.lowagie.toolbox.arguments.FileArgument;
import com.lowagie.toolbox.arguments.FloatArgument;
import com.lowagie.toolbox.arguments.IntegerArgument;
import com.lowagie.toolbox.arguments.StringArgument;
import com.lowagie.toolbox.arguments.filters.PdfFilter;
import java.io.File;
import java.io.FileOutputStream;
import javax.swing.JInternalFrame;
import javax.swing.JOptionPane;

public class Watermarker
extends AbstractTool {
    FileArgument destfile = null;

    public Watermarker() {
        FileArgument fileArgument = new FileArgument(this, "srcfile", "The file you want to watermark", false, new PdfFilter());
        this.arguments.add(fileArgument);
        this.arguments.add(new StringArgument(this, "watermark", "The text that can be used as watermark"));
        this.arguments.add(new IntegerArgument(this, "fontsize", "The fontsize of the watermark text"));
        this.arguments.add(new FloatArgument(this, "opacity", "The opacity of the watermark text"));
        this.destfile = new FileArgument(this, "destfile", "The file to which the watermarked PDF has to be written", true, new PdfFilter());
        this.arguments.add(this.destfile);
        fileArgument.addPropertyChangeListener(this.destfile);
    }

    protected void createFrame() {
        this.internalFrame = new JInternalFrame("Watermark", true, false, true);
        this.internalFrame.setSize(300, 80);
        this.internalFrame.setJMenuBar(this.getMenubar());
        System.out.println("=== Watermark OPENED ===");
    }

    public void execute() {
        try {
            if (this.getValue("srcfile") == null) {
                throw new InstantiationException("You need to choose a sourcefile");
            }
            if (this.getValue("destfile") == null) {
                throw new InstantiationException("You need to choose a destination file");
            }
            if (this.getValue("watermark") == null) {
                throw new InstantiationException("You need to add a text for the watermark");
            }
            int n = Integer.parseInt((String)this.getValue("fontsize"));
            float f = Float.parseFloat((String)this.getValue("opacity"));
            BaseFont baseFont = BaseFont.createFont("Helvetica", "Cp1252", false);
            PdfReader pdfReader = new PdfReader(((File)this.getValue("srcfile")).getAbsolutePath());
            int n2 = pdfReader.getNumberOfPages();
            PdfGState pdfGState = new PdfGState();
            pdfGState.setFillOpacity(f);
            String string = (String)this.getValue("watermark");
            PdfStamper pdfStamper = new PdfStamper(pdfReader, new FileOutputStream((File)this.getValue("destfile")));
            float f2 = baseFont.getWidthPoint(string, (float)n);
            for (int i = 1; i <= n2; ++i) {
                PdfContentByte pdfContentByte = pdfStamper.getOverContent(i);
                Rectangle rectangle = pdfReader.getCropBox(i);
                float f3 = (float)Math.atan(rectangle.getHeight() / rectangle.getWidth());
                float f4 = (float)Math.cos(f3);
                float f5 = (float)(-Math.sin(f3));
                float f6 = (float)Math.sin(f3);
                float f7 = (float)Math.cos(f3);
                float f8 = (float)(-Math.cos(f3) * (double)f2 / 2.0 - Math.sin(f3) * (double)n / 2.0);
                float f9 = (float)(Math.sin(f3) * (double)f2 / 2.0 - Math.cos(f3) * (double)n / 2.0);
                pdfContentByte.saveState();
                pdfContentByte.setGState(pdfGState);
                pdfContentByte.beginText();
                pdfContentByte.setFontAndSize(baseFont, n);
                pdfContentByte.setTextMatrix(f4, f5, f6, f7, f8 + rectangle.getWidth() / 2.0f, f9 + rectangle.getHeight() / 2.0f);
                pdfContentByte.showText(string);
                pdfContentByte.endText();
                pdfContentByte.restoreState();
            }
            pdfStamper.close();
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(this.internalFrame, exception.getMessage(), exception.getClass().getName(), 0);
            System.err.println(exception.getMessage());
        }
    }

    protected File getDestPathPDF() throws InstantiationException {
        return (File)this.getValue("destfile");
    }

    public void valueHasChanged(AbstractArgument abstractArgument) {
        if (this.internalFrame == null) {
            return;
        }
        if (this.destfile.getValue() == null && abstractArgument.getName().equalsIgnoreCase("srcfile")) {
            String string = abstractArgument.getValue().toString();
            String string2 = string.substring(0, string.indexOf(".", string.length() - 4)) + "_out.pdf";
            this.destfile.setValue(string2);
        }
    }

    public static void main(String[] stringArray) {
        Watermarker watermarker = new Watermarker();
        if (stringArray.length != 5) {
            System.err.println(watermarker.getUsage());
        }
        watermarker.setMainArguments(stringArray);
        watermarker.execute();
    }

    static {
        Watermarker.addVersion("$Id: Watermarker.java 3271 2008-04-18 20:39:42Z xlv $");
    }
}

