/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.viper.parts;

import com.nvidia.viper.TimeFormatter;
import com.nvidia.viper.model.IModel;
import com.nvidia.viper.model.ISessionPropertyChangeListener;
import com.nvidia.viper.model.RegionOfInterest;
import com.nvidia.viper.model.Session;
import com.nvidia.viper.model.TimelineRuler;
import com.nvidia.viper.parts.RegionOfInterestDragTracker;
import com.nvidia.viper.parts.RegionOfInterestResizeDragTracker;
import com.nvidia.viper.parts.TimelineRulerSelectTracker;
import com.nvidia.viper.ui.RegionOfInterestFigure;
import com.nvidia.viper.ui.TimelineRulerFigure;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.draw2d.Cursors;
import org.eclipse.draw2d.FigureUtilities;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.MouseEvent;
import org.eclipse.draw2d.MouseMotionListener;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.gef.DragTracker;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.Request;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;
import org.eclipse.gef.editparts.LayerManager;
import org.eclipse.gef.tools.AbstractTool;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Font;

public class TimelineRulerEditPart
extends AbstractGraphicalEditPart
implements ISessionPropertyChangeListener {
    protected static final int DEFAULT_VIEWER_WIDTH = 1000;
    public static final int REGION_RESIZE_MARGIN = 5;
    private static final Point UNKNOWN_MOUSE_LOCATION = new Point(-1, -1);
    private Point mouseLocation = new Point(UNKNOWN_MOUSE_LOCATION);
    private List<RegionOfInterest> hoverRois = null;
    private RegionOfInterest resizeRoi = null;
    private boolean resizeRoiStart;
    private RegionOfInterestFigure roiDragFeedbackFigure = null;

    protected TimelineRuler getCastedModel() {
        return (TimelineRuler)this.getModel();
    }

    protected IFigure getDiagramGuideLayer() {
        GraphicalViewer diagramViewer = (GraphicalViewer)this.getViewer().getProperty(GraphicalViewer.class.toString());
        LayerManager lm = (LayerManager)diagramViewer.getEditPartRegistry().get(LayerManager.ID);
        if (lm != null) {
            IFigure layer = lm.getLayer((Object)"Guide Layer");
            if (layer != null) {
                layer.setEnabled(false);
            }
            return layer;
        }
        return null;
    }

    protected IFigure createFigure() {
        TimelineRulerFigure f = new TimelineRulerFigure();
        f.setPreferredSize(this.getFigureSize());
        this.setFigureScaling(f);
        this.setFigureMajorInterval(f);
        this.setFigureRegionsOfInterest(f, this.getCastedModel().getSession());
        f.addMouseMotionListener((MouseMotionListener)new MouseMotionListener.Stub(){

            public void mouseMoved(MouseEvent me) {
                TimelineRulerEditPart.this.mouseLocation.setLocation(me.x, me.y);
                TimelineRulerEditPart.this.updateDrag();
            }

            public void mouseExited(MouseEvent me) {
                TimelineRulerEditPart.this.mouseLocation.setLocation(UNKNOWN_MOUSE_LOCATION);
                TimelineRulerEditPart.this.updateDrag();
            }
        });
        return f;
    }

    protected Dimension getFigureSize() {
        return new Dimension((int)((double)this.getCastedModel().getSession().getVisibleDuration() * this.getCastedModel().getSession().getHorizontalScale()), -1);
    }

    protected void setFigureRegionsOfInterest(TimelineRulerFigure figure, Session session) {
        IFigure layer = this.getDiagramGuideLayer();
        if (layer != null) {
            ArrayList chs = new ArrayList(layer.getChildren());
            for (Object ch : chs) {
                layer.remove((IFigure)ch);
            }
        }
        this.roiDragFeedbackFigure = null;
        figure.clearRegionsOfInterest();
        List<RegionOfInterest> regionsOfInterest = this.getCastedModel().getRegionsOfInterest();
        if (!regionsOfInterest.isEmpty()) {
            double hScale = session.getHorizontalScale();
            for (RegionOfInterest region : regionsOfInterest) {
                String text = new TimeFormatter().format(region.getDuration());
                int startX = (int)((double)region.getStart() * hScale);
                int endX = (int)((double)region.getEnd() * hScale);
                figure.addRegionOfInterest(region.getUid(), region.isSelected(), startX, endX + 1, text);
                if (!region.isSelected()) continue;
                this.addRegionOfInterestFigure(region.isSelected(), startX, endX);
            }
        }
    }

    protected RegionOfInterest addRegionOfInterest(int start, int end) {
        double hScale = this.getCastedModel().getSession().getHorizontalScale();
        long startns = (long)((double)start / hScale);
        long endns = (long)((double)end / hScale);
        this.getCastedModel().deselectRegionsOfInterest(this.getCastedModel().getRegionsOfInterest());
        RegionOfInterest roi = this.getCastedModel().addRegionOfInterest(true, startns, endns);
        return roi;
    }

    protected void moveRegionOfInterest(RegionOfInterest regionOfInterest, int start, int end) {
        double hScale = this.getCastedModel().getSession().getHorizontalScale();
        long startns = start == -1 ? -1L : (long)((double)start / hScale);
        long endns = end == -1 ? -1L : (long)((double)end / hScale);
        this.getCastedModel().moveRegionOfInterest(regionOfInterest, startns, endns);
    }

    protected void clearRegionOfInterestDrag() {
        if (this.roiDragFeedbackFigure != null) {
            IFigure layer = this.getDiagramGuideLayer();
            if (layer != null) {
                layer.remove((IFigure)this.roiDragFeedbackFigure);
            }
            this.roiDragFeedbackFigure = null;
        }
    }

    protected void showRegionOfInterestDrag(int start, int end) {
        this.clearRegionOfInterestDrag();
        double hScale = this.getCastedModel().getSession().getHorizontalScale();
        long startns = (long)((double)start / hScale);
        long endns = (long)((double)end / hScale);
        String text = new TimeFormatter().format(Math.abs(startns - endns));
        this.getTimelineRulerFigure().addDragRegionOfInterest(start, end, text);
        this.roiDragFeedbackFigure = this.addRegionOfInterestFigure(true, start, end);
        this.refreshVisuals();
    }

    protected RegionOfInterestFigure addRegionOfInterestFigure(boolean selected, int start, int end) {
        RegionOfInterestFigure roif = null;
        IFigure layer = this.getDiagramGuideLayer();
        if (layer != null) {
            roif = new RegionOfInterestFigure(start, end, selected);
            layer.add((IFigure)roif, null, 0);
        }
        return roif;
    }

    protected void updateDrag() {
        this.hoverRois = this.getRoisAt(this.mouseLocation);
        double hScale = this.getCastedModel().getSession().getHorizontalScale();
        this.resizeRoi = null;
        for (RegionOfInterest roi : this.hoverRois) {
            if (!roi.isSelected()) continue;
            boolean rev = roi.getStart() > roi.getEnd();
            long start = (long)((double)Math.min(roi.getStart(), roi.getEnd()) * hScale);
            long end = (long)((double)Math.max(roi.getStart(), roi.getEnd()) * hScale);
            if ((long)this.mouseLocation.x < start || (long)this.mouseLocation.x > end) continue;
            if ((long)this.mouseLocation.x - start < 5L && (long)this.mouseLocation.x - start <= end - (long)this.mouseLocation.x) {
                this.resizeRoi = roi;
                this.resizeRoiStart = !rev;
                break;
            }
            if (end - (long)this.mouseLocation.x >= 5L) continue;
            this.resizeRoi = roi;
            this.resizeRoiStart = rev;
            break;
        }
        this.getTimelineRulerFigure().setCursor(this.resizeRoi != null ? Cursors.SIZEWE : Cursors.ARROW);
    }

    protected List<RegionOfInterest> getRoisAt(Point location) {
        List<RegionOfInterest> rois = Collections.emptyList();
        TimelineRulerFigure figure = this.getTimelineRulerFigure();
        if (location.y >= figure.getSize().height - 3 - 4) {
            double hScale = this.getCastedModel().getSession().getHorizontalScale();
            long ns = (long)((double)location.x / hScale);
            int slop = (int)(2.0 / hScale);
            rois = this.getCastedModel().getContainingRegionsOfInterest(ns, slop);
        }
        return rois;
    }

    public void setRegionOfInterestSelected(AbstractTool.Input input) {
        if (this.hoverRois != null && !this.hoverRois.isEmpty()) {
            RegionOfInterest hoverRoi = this.hoverRois.get(0);
            boolean appendSelection = input.isModKeyDown(SWT.MOD1);
            if (!hoverRoi.isSelected()) {
                this.getCastedModel().prioritizeRegionOfInterest(hoverRoi.getUid(), -1, appendSelection);
            } else if (this.hoverRois.size() == 1) {
                this.getCastedModel().deselectRegionsOfInterest(this.hoverRois);
            } else {
                this.getCastedModel().prioritizeRegionOfInterest(this.hoverRois.get(1).getUid(), hoverRoi.getUid(), appendSelection);
            }
            this.hoverRois = this.getRoisAt(this.mouseLocation);
        } else {
            this.getCastedModel().deselectRegionsOfInterest(this.getCastedModel().getRegionsOfInterest());
        }
    }

    protected void setFigureScaling(TimelineRulerFigure figure) {
        figure.setXScale(this.getCastedModel().getSession().getHorizontalScale());
    }

    protected void setFigureMajorInterval(TimelineRulerFigure figure) {
        double scale = this.getCastedModel().getSession().getHorizontalScale();
        int width = this.getViewer().getControl().getSize().x;
        if (width == 0) {
            width = 1000;
        }
        double timespan = (double)width / scale;
        Font font = figure.getFont();
        if (font == null) {
            font = this.getViewer().getControl().getFont();
        }
        Dimension markSpacing = FigureUtilities.getStringExtents((String)"000000000xs    ", (Font)font);
        int maxMarks = Math.max(1, width / markSpacing.width);
        double markTimespan = 1000.0;
        while (timespan / markTimespan > (double)maxMarks) {
            markTimespan *= 10.0;
        }
        if (timespan / (markTimespan / 2.0) <= (double)maxMarks && timespan / ((markTimespan /= 2.0) / 2.0) <= (double)maxMarks) {
            markTimespan /= 2.0;
        }
        figure.setMajorInterval((long)markTimespan);
    }

    protected TimelineRulerFigure getTimelineRulerFigure() {
        return (TimelineRulerFigure)this.getFigure();
    }

    protected void createEditPolicies() {
    }

    protected void refreshVisuals() {
        this.getFigure().repaint();
    }

    public DragTracker getDragTracker(Request request) {
        if (!request.getType().equals("selection")) {
            return null;
        }
        if (this.hoverRois == null || this.hoverRois.isEmpty()) {
            this.getCastedModel().deselectRegionsOfInterest(this.getCastedModel().getRegionsOfInterest());
            return new RegionOfInterestDragTracker(this);
        }
        if (this.resizeRoi != null) {
            return new RegionOfInterestResizeDragTracker(this, this.resizeRoi, this.resizeRoiStart);
        }
        return new TimelineRulerSelectTracker(this);
    }

    public void activate() {
        super.activate();
        this.getCastedModel().addPropertyChangeListener(this);
        this.getCastedModel().getSession().addPropertyChangeListener(this);
    }

    public void deactivate() {
        super.deactivate();
        this.getCastedModel().removePropertyChangeListener(this);
        this.getCastedModel().getSession().removePropertyChangeListener(this);
    }

    @Override
    public void propertyChange(IModel model, String propertyName) {
        if ("session:hScale".equals(propertyName)) {
            this.setFigureScaling(this.getTimelineRulerFigure());
            this.setFigureMajorInterval(this.getTimelineRulerFigure());
            this.getFigure().setPreferredSize(this.getFigureSize());
            this.setFigureRegionsOfInterest(this.getTimelineRulerFigure(), this.getCastedModel().getSession());
            this.refreshVisuals();
        } else if ("hruler:roi".equals(propertyName)) {
            this.setFigureRegionsOfInterest(this.getTimelineRulerFigure(), this.getCastedModel().getSession());
            this.refreshVisuals();
        }
    }
}

