/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.viper.model;

import com.nvidia.viper.EventManager;
import com.nvidia.viper.MetricManager;
import com.nvidia.viper.ViperColors;
import com.nvidia.viper.ViperException;
import com.nvidia.viper.activity.CuptiActivityEvent;
import com.nvidia.viper.activity.CuptiActivityKernel;
import com.nvidia.viper.activity.CuptiActivityKind;
import com.nvidia.viper.activity.CuptiActivityMetric;
import com.nvidia.viper.activity.CuptiActivityPCSamplingRecordInfo;
import com.nvidia.viper.activity.ICuptiActivitySourceLevelResult;
import com.nvidia.viper.jni.CuCacheConfig;
import com.nvidia.viper.model.Event;
import com.nvidia.viper.model.IModel;
import com.nvidia.viper.model.ITimelineInterval;
import com.nvidia.viper.model.Metric;
import com.nvidia.viper.model.ProfileDataModel;
import com.nvidia.viper.model.Session;
import com.nvidia.viper.model.TimelineColorMode;
import com.nvidia.viper.model.TimelineDevice;
import com.nvidia.viper.model.TimelineIntervalHierarchy;
import com.nvidia.viper.model.TimelineIntervalKind;
import com.nvidia.viper.model.TimelineKind;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class TimelineIntervalKernel
extends TimelineIntervalHierarchy
implements IModel,
ITimelineInterval {
    protected CuptiActivityKernel activity;
    protected Set<Integer> correlationIds = new HashSet<Integer>();
    private long minCompleted;
    private boolean analysisLoaded = false;

    public TimelineIntervalKernel(CuptiActivityKernel activity) {
        super(TimelineIntervalKind.KERNEL, 0L, 0L, 0L);
        if (activity != null) {
            this.start = activity.start;
            this.end = activity.end;
            this.id = activity.getID();
            this.correlationIds.add(activity.correlationId);
        }
        this.activity = activity;
        this.minCompleted = 0L;
    }

    public boolean isHostLaunched() {
        return !this.activity.getKind().equals((Object)CuptiActivityKind.CUPTI_ACTIVITY_KIND_CDP_KERNEL);
    }

    @Override
    public String getName() {
        return this.activity.name;
    }

    @Override
    public String getDisplayName() {
        return this.primaryTimeline == null ? this.getName() : this.primaryTimeline.getDisplayName(false);
    }

    @Override
    public Set<Integer> getCorrelationIds() {
        return this.correlationIds;
    }

    @Override
    public int getPrimaryCorrelationId() {
        return this.activity.correlationId;
    }

    public int getRuntimeCorrelationId() {
        return this.activity.runtimeCorrelationId;
    }

    @Override
    public long getGridId() {
        return this.activity.gridId;
    }

    @Override
    public long getParentGridId() {
        return this.activity.parentGridId;
    }

    public int getStreamId() {
        return this.activity.streamId;
    }

    public String getStreamName() {
        return this.getStreamName(this.getStreamId());
    }

    @Override
    public ViperColors.GradientColors getColor(ViperColors.GradientColors colors) {
        Session session = this.primaryTimeline.getSession();
        TimelineColorMode colorMode = session.getColorMode();
        if (colorMode.equals((Object)TimelineColorMode.KERNEL)) {
            return session.kernelNameToColorMap.get(this.getName());
        }
        if (colorMode.equals((Object)TimelineColorMode.STREAM)) {
            return session.streamIdToColorMap.get(this.getStreamId());
        }
        if (colorMode.equals((Object)TimelineColorMode.PROCESS)) {
            if (session.processIdToColorMap.size() == 1) {
                return (ViperColors.GradientColors)session.processIdToColorMap.values().toArray()[0];
            }
            return session.processIdToColorMap.get(session.getProcessId(this));
        }
        return null;
    }

    public Integer[] getGrid() {
        Integer[] grid = new Integer[]{this.activity.gridX == -1 ? null : Integer.valueOf(this.activity.gridX), this.activity.gridY == -1 ? null : Integer.valueOf(this.activity.gridY), this.activity.gridZ == -1 ? null : Integer.valueOf(this.activity.gridZ)};
        return grid;
    }

    public long getBlocksPerGrid() {
        Integer[] gridDim = this.getGrid();
        long total = 1L;
        Integer[] integerArray = gridDim;
        int n = gridDim.length;
        int n2 = 0;
        while (n2 < n) {
            Integer dim = integerArray[n2];
            if (dim != null && dim > 0) {
                total *= (long)dim.intValue();
            }
            ++n2;
        }
        return total;
    }

    public Integer[] getBlock() {
        Integer[] block = new Integer[]{this.activity.blockX == -1 ? null : Integer.valueOf(this.activity.blockX), this.activity.blockY == -1 ? null : Integer.valueOf(this.activity.blockY), this.activity.blockZ == -1 ? null : Integer.valueOf(this.activity.blockZ)};
        return block;
    }

    public int getThreadsPerBlock() {
        Integer[] blockDim = this.getBlock();
        int total = 1;
        Integer[] integerArray = blockDim;
        int n = blockDim.length;
        int n2 = 0;
        while (n2 < n) {
            Integer dim = integerArray[n2];
            if (dim != null && dim > 0) {
                total *= dim.intValue();
            }
            ++n2;
        }
        return total;
    }

    public Integer getRegistersPerThread() {
        return this.activity.regPerThread == -1 ? null : Integer.valueOf(this.activity.regPerThread);
    }

    public Integer getStaticSharedMemory() {
        return this.activity.statSharedMem == -1 ? null : Integer.valueOf(this.activity.statSharedMem);
    }

    public Integer getDynamicSharedMemory() {
        return this.activity.dynaSharedMem == -1 ? null : Integer.valueOf(this.activity.dynaSharedMem);
    }

    public CuCacheConfig getCacheConfigRequested() {
        return CuCacheConfig.valueOf(this.activity.cacheConfigRequested);
    }

    public CuCacheConfig getCacheConfigExecuted() {
        return CuCacheConfig.valueOf(this.activity.cacheConfigExecuted);
    }

    public Integer getSharedMemoryBankSize() {
        int bytes = CuptiActivityKernel.decodeSharedMemoryConfig(this.activity.sharedMemoryConfig);
        return bytes == -1 ? null : Integer.valueOf(bytes);
    }

    public Integer getCudaOccPartitionedGCConfig() {
        return CuptiActivityKernel.decodePartitionedGlobalCacheConfig(this.activity.partitionedGlobalCacheRequested);
    }

    public Integer getPartitionedGlobalCacheConfigRequested() {
        return this.activity.partitionedGlobalCacheRequested;
    }

    public Integer getPartitionedGlobalCacheConfigExecuted() {
        return this.activity.partitionedGlobalCacheExecuted;
    }

    public Integer getIsSharedMemoryCarveoutRequested() {
        return this.activity.isSharedMemoryCarveoutRequested;
    }

    public Long getSharedMemoryCarveoutSizeRequested(Long maxSharedMemory) {
        Long sharedMemoryRequested = (long)this.activity.sharedMemoryCarveoutRequested * maxSharedMemory / 100L;
        if (sharedMemoryRequested == 0L) {
            return 0L;
        }
        if (sharedMemoryRequested <= 8192L) {
            return 8192L;
        }
        if (sharedMemoryRequested <= 16384L) {
            return 16384L;
        }
        if (sharedMemoryRequested <= 32768L) {
            return 32768L;
        }
        if (sharedMemoryRequested <= 65536L) {
            return 65536L;
        }
        return 98304L;
    }

    public Integer getCudaOccSharedMemoryCarveoutSize() {
        return CuptiActivityKernel.decodeSharedMemoryCarveoutConfig(this.activity.isSharedMemoryCarveoutRequested, this.activity.sharedMemoryCarveoutRequested);
    }

    public long getSharedMemoryExecuted() {
        return this.activity.sharedMemoryExecuted;
    }

    public Integer[] getParentBlock() {
        Integer[] block = new Integer[]{this.activity.parentBlockX == -1 ? null : Integer.valueOf(this.activity.parentBlockX), this.activity.parentBlockY == -1 ? null : Integer.valueOf(this.activity.parentBlockY), this.activity.parentBlockZ == -1 ? null : Integer.valueOf(this.activity.parentBlockZ)};
        return block;
    }

    @Override
    public long getExtendedEnd() {
        Long completed = this.getCompleted(true);
        if (completed == null) {
            return this.getEnd();
        }
        return completed;
    }

    @Override
    public long getExtendedDuration() {
        return this.getExtendedEnd() - this.getStart();
    }

    public long getMinimumCompletion() {
        return this.minCompleted;
    }

    public void setMinimumCompletion(long time) {
        this.minCompleted = time;
    }

    public Long getCompleted(boolean useMin) {
        if (useMin) {
            if (this.minCompleted != 0L) {
                return this.minCompleted - this.getNormalizedTime();
            }
        } else if (this.activity.completed != 0L) {
            return this.activity.completed - this.getNormalizedTime();
        }
        return null;
    }

    public Long getSubmitted() {
        long submitted = this.activity.submitted;
        if (submitted == 0L) {
            return null;
        }
        return submitted - this.getNormalizedTime();
    }

    public Long getQueued() {
        long queued = this.activity.queued;
        if (queued == 0L) {
            return null;
        }
        return queued - this.getNormalizedTime();
    }

    @Override
    public Set<Event> getEvents() {
        return this.activity.getEvents();
    }

    @Override
    public Long getEventValue(Event event) {
        return this.activity.getEventValue(event);
    }

    @Override
    public Long getEventsTotalValue(Collection<Event> events) {
        long total = 0L;
        for (Event event : events) {
            Long val = this.getEventValue(event);
            if (val == null) {
                return null;
            }
            total += val.longValue();
        }
        return total;
    }

    @Override
    public void setEventValue(Event event, Long value) {
        this.activity.setEventValue(event, value);
    }

    @Override
    public Set<Metric> getAggregateMetrics() {
        return this.activity.getAggregateMetrics();
    }

    @Override
    public CuptiActivityMetric getAggregateMetricActivity(Metric metric) {
        return this.activity.getAggregateMetricActivity(metric);
    }

    @Override
    public Number getAggregateMetricValue(Metric metric) {
        CuptiActivityMetric metricActivity = this.activity.getAggregateMetricActivity(metric);
        if (metricActivity != null && !metricActivity.isOverflow() && !metricActivity.isInvalid()) {
            return metricActivity.getValue();
        }
        return null;
    }

    @Override
    public boolean isAggregateMetricOverflow(Metric metric) {
        CuptiActivityMetric metricActivity = this.activity.getAggregateMetricActivity(metric);
        return metricActivity != null && metricActivity.isOverflow();
    }

    @Override
    public boolean isAggregateMetricInvalid(Metric metric) {
        CuptiActivityMetric metricActivity = this.activity.getAggregateMetricActivity(metric);
        return metricActivity != null && metricActivity.isInvalid();
    }

    @Override
    public void setAggregateMetricActivity(Metric metric, CuptiActivityMetric metricActivity) {
        this.activity.setAggregateMetricActivity(metric, metricActivity);
    }

    @Override
    public Set<Metric> getInstanceMetrics() {
        return this.activity.getInstanceMetrics();
    }

    @Override
    public CuptiActivityMetric getInstanceMetricActivity(Metric metric, int instance) {
        return this.activity.getInstanceMetricActivity(metric, instance);
    }

    @Override
    public List<CuptiActivityMetric> getInstanceMetricActivities(Metric metric) {
        return this.activity.getInstanceMetricActivities(metric);
    }

    @Override
    public Number getInstanceMetricValue(Metric metric, int instance) {
        CuptiActivityMetric metricActivity = this.activity.getInstanceMetricActivity(metric, instance);
        if (metricActivity != null && !metricActivity.isOverflow() && !metricActivity.isInvalid()) {
            return metricActivity.getValue();
        }
        return null;
    }

    @Override
    public boolean isInstanceMetricOverflow(Metric metric, int instance) {
        CuptiActivityMetric metricActivity = this.activity.getInstanceMetricActivity(metric, instance);
        return metricActivity != null && metricActivity.isOverflow();
    }

    @Override
    public boolean isInstanceMetricInvalid(Metric metric, int instance) {
        CuptiActivityMetric metricActivity = this.activity.getInstanceMetricActivity(metric, instance);
        return metricActivity != null && metricActivity.isInvalid();
    }

    @Override
    public void setInstanceMetricActivity(Metric metric, int instance, CuptiActivityMetric metricActivity) {
        this.activity.setInstanceMetricActivity(metric, instance, metricActivity);
    }

    @Override
    public Collection<ICuptiActivitySourceLevelResult> getSourceLevelResults() {
        return this.activity.getSourceLevelResults();
    }

    @Override
    public boolean addSourceLevelResult(ICuptiActivitySourceLevelResult result) {
        return this.activity.addSourceLevelResult(result);
    }

    @Override
    public void addPCSamplingRecordInfo(CuptiActivityPCSamplingRecordInfo recordInfo) {
        this.activity.setPCSamplingRecordInfo(recordInfo);
    }

    @Override
    public CuptiActivityPCSamplingRecordInfo getPCSamplingRecordInfo() {
        return this.activity.getPCSamplingRecordInfo();
    }

    @Override
    public boolean removeSourceLevelResult(ICuptiActivitySourceLevelResult result) {
        return this.activity.removeSourceLevelResult(result);
    }

    @Override
    public void clearSourceLevelResults() {
        this.activity.clearSourceLevelResults();
        this.setAnalysisLoaded(false);
    }

    @Override
    public void appendToPDM(ProfileDataModel pdm) throws ViperException {
        try {
            this.activity.appendToPDM(pdm.getNativeHandle());
        }
        catch (Exception e) {
            if (e instanceof ViperException) {
                throw (ViperException)e;
            }
            throw new ViperException(e);
        }
    }

    @Override
    public boolean addEvent(CuptiActivityEvent eventActivity) throws Exception {
        Event event = EventManager.getEvent(eventActivity.domain, eventActivity.id);
        if (event == null) {
            return false;
        }
        this.setEventValue(event, eventActivity.value);
        return true;
    }

    @Override
    public boolean addMetric(CuptiActivityMetric metricActivity) throws Exception {
        Metric metric = MetricManager.getMetric(metricActivity.id);
        if (metric == null) {
            return false;
        }
        metricActivity.valueKindCode = metric.getValueKind().getCode();
        if (metricActivity.getInstance() == -1) {
            this.setAggregateMetricActivity(metric, metricActivity);
        } else {
            this.setInstanceMetricActivity(metric, metricActivity.getInstance(), metricActivity);
        }
        return true;
    }

    @Override
    public boolean isAllAnalysisDataLoaded() {
        return this.analysisLoaded;
    }

    @Override
    public void setAnalysisLoaded(boolean loaded) {
        this.analysisLoaded = loaded;
    }

    public int getMajorComputeCapability() {
        TimelineDevice device = (TimelineDevice)this.primaryTimeline.getAncestor(TimelineKind.DEVICE);
        return device.getComputeCapabilityMajor();
    }

    public int getMinorComputeCapability() {
        TimelineDevice device = (TimelineDevice)this.primaryTimeline.getAncestor(TimelineKind.DEVICE);
        return device.getComputeCapabilityMinor();
    }

    public int getLaunchType() {
        return this.activity.launchType;
    }

    public void clearAllAnalysis() {
        this.activity.clearAllAnalysis();
        this.analysisLoaded = false;
    }
}

