/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.viper.editor;

import com.nvidia.viper.analysis.AnalysisResultSourceLevelKind;
import com.nvidia.viper.analysis.AnalysisStage;
import com.nvidia.viper.editor.IViewerColumnsManager;
import com.nvidia.viper.editor.RulerColumnBase;
import com.nvidia.viper.editor.SourceSassEditor;
import com.nvidia.viper.editor.ViewerControl;
import com.nvidia.viper.model.Analysis;
import com.nvidia.viper.model.SourceSassModel;
import com.nvidia.viper.ui.CudaViewer;
import com.nvidia.viper.ui.ViperViewerBase;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.text.source.CompositeRuler;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.IVerticalRulerColumn;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class SourceSassColumnControl {
    private ViewerControl parent;
    private AnalysisResultSourceLevelKind currentAnalysisType;
    private boolean widgetsCreated = false;
    private int numColumns = 0;

    public SourceSassColumnControl(ViewerControl parent) {
        this.parent = parent;
    }

    public void setCurrentAnalysis(AnalysisResultSourceLevelKind cudaSassControlType) {
        this.currentAnalysisType = cudaSassControlType;
    }

    public boolean addColumn(IVerticalRulerColumn column) {
        if (!this.existsColumn(column.getClass())) {
            CompositeRuler viewRuler = this.parent.getViewRuler();
            if (column instanceof RulerColumnBase) {
                Iterator iter = viewRuler.getDecoratorIterator();
                int columnIndex = ((RulerColumnBase)column).getColumnIndex();
                int currentIndex = 0;
                while (iter.hasNext()) {
                    int rulerColumnIndex;
                    Object rulerColumn = iter.next();
                    if (rulerColumn instanceof RulerColumnBase && (rulerColumnIndex = ((RulerColumnBase)((Object)rulerColumn)).getColumnIndex()) > columnIndex) {
                        viewRuler.addDecorator(currentIndex, column);
                        break;
                    }
                    ++currentIndex;
                }
                if (!iter.hasNext()) {
                    this.parent.getViewRuler().addDecorator(columnIndex, column);
                }
            } else {
                this.parent.getViewRuler().addDecorator(99, column);
            }
            return true;
        }
        return false;
    }

    public void removeColumn(IVerticalRulerColumn column) {
        if (column != null && this.existsColumn(column.getClass())) {
            CompositeRuler viewRuler = this.parent.getViewRuler();
            viewRuler.removeDecorator(column);
        }
    }

    public boolean existsColumn(Class<?> class1) {
        CompositeRuler ruler = this.parent.getViewRuler();
        Iterator iter = ruler.getDecoratorIterator();
        while (iter.hasNext()) {
            if (!iter.next().getClass().equals(class1)) continue;
            return true;
        }
        return false;
    }

    public GridLayout getLayout() {
        GridData viewerLayoutData;
        GridLayout gridLayout;
        Layout layout = this.parent.getLayout();
        int numLayoutColumns = this.getNumLayoutColumns();
        if (layout != null && layout instanceof GridLayout) {
            gridLayout = (GridLayout)layout;
            gridLayout.numColumns = numLayoutColumns;
        } else {
            gridLayout = new GridLayout(numLayoutColumns, false);
            this.parent.setLayout((Layout)gridLayout);
        }
        ViperViewerBase viewer = this.parent.getViewer();
        if (viewer != null && (viewerLayoutData = (GridData)viewer.getControl().getLayoutData()) == null) {
            viewerLayoutData = new GridData(4, 4, true, true);
            viewer.getControl().setLayoutData((Object)viewerLayoutData);
        }
        this.parent.layout();
        return gridLayout;
    }

    private int getNumLayoutColumns() {
        return this.parent.getChildren().length;
    }

    public Label addLabel(String text, String tooltipText, GridData data) {
        Label label = new Label((Composite)this.parent, 0);
        label.setLayoutData((Object)data);
        label.setText(text);
        label.setToolTipText(tooltipText);
        return label;
    }

    public Label getLabel(String text) {
        Control[] children;
        Control[] controlArray = children = this.parent.getChildren();
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            Control child = controlArray[n2];
            if (child instanceof Label && ((Label)child).getText().equals(text)) {
                return (Label)child;
            }
            ++n2;
        }
        return null;
    }

    private int getMajorComputeCapability() {
        SourceSassModel model = this.parent.getEditor().getSourceSassModel();
        return model.getAnalysisResultSourceLevel().getKernel().getMajorComputeCapability();
    }

    private void addColumnsForAllAnalysis() {
        if (!this.widgetsCreated) {
            List<AnalysisResultSourceLevelKind> sourceLevelResultsKind = AnalysisResultSourceLevelKind.getOrderedResults(this.getMajorComputeCapability());
            for (AnalysisResultSourceLevelKind sourceLevelResultKind : sourceLevelResultsKind) {
                IViewerColumnsManager uiControl = sourceLevelResultKind.getColumnsManager(this.parent.getViewerControlType());
                if (uiControl == null) continue;
                uiControl.addAnalysisColumns(this);
                ++this.numColumns;
            }
            this.widgetsCreated = true;
        }
    }

    public SourceSassEditor.AnnotationType[] getAnnotationTypes() {
        return new SourceSassEditor.AnnotationType[]{SourceSassEditor.AnnotationType.HOTSPOT_HIGH, SourceSassEditor.AnnotationType.HOTSPOT_MED};
    }

    public void selectAnalysisStage(Analysis analysis) {
        AnalysisStage stage = this.currentAnalysisType.getAnalysisStage();
        if (stage != null) {
            analysis.setSelectedStage(stage);
        }
    }

    public int createViewerColumns() {
        this.addColumnsForAllAnalysis();
        this.getLayout();
        return this.numColumns;
    }

    public void showViewerColumns() {
        this.currentAnalysisType.getColumnsManager(this.parent.getViewerControlType()).setEnableColumns(this, true);
        this.getLayout();
    }

    public void updateViewerColumns(Analysis analysis, IAnnotationModel annotationModel) {
        this.addColumnsForAllAnalysis();
        ViperViewerBase viewer = this.parent.getViewer();
        IViewerColumnsManager uiControl = this.currentAnalysisType.getColumnsManager(this.parent.getViewerControlType());
        uiControl.createAnnotations(viewer, annotationModel);
        if (viewer instanceof CudaViewer) {
            uiControl.selectDefaultSourceLine((CudaViewer)viewer);
        }
        this.showViewerColumns();
        this.selectAnalysisStage(analysis);
    }

    public ViewerControl getControl() {
        return this.parent;
    }
}

