/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.viper.device;

import com.nvidia.common.device.ICudaDevice;
import com.nvidia.common.device.ICudaDeviceManager;
import com.nvidia.common.util.CoreUtil;
import com.nvidia.viper.DeviceManager;
import com.nvidia.viper.device.DeviceAdapter;
import com.nvidia.viper.model.Device;
import java.util.Collection;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.eclipse.core.runtime.CoreException;

public final class ViperDeviceManager
implements ICudaDeviceManager {
    private ICudaDevice[] devices;
    private Future<ICudaDevice[]> query;

    private static ICudaDevice wrap(Device device) {
        return new DeviceAdapter(device);
    }

    public synchronized ICudaDevice[] getDevices(long timeout) throws TimeoutException, CoreException {
        if (this.devices == null) {
            if (this.query == null) {
                this.query = Executors.newSingleThreadExecutor().submit(new DevicesQuery());
            }
            try {
                this.devices = this.query.get(timeout, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                throw new CoreException(CoreUtil.errorStatus((Throwable)e, (String)"Timed out reading devices list", (Object[])new Object[0]));
            }
            catch (ExecutionException e) {
                throw new CoreException(CoreUtil.errorStatus((Throwable)e.getCause(), (String)"Unexpected exception reading devices list", (Object[])new Object[0]));
            }
        }
        return this.devices;
    }

    private static final class DevicesQuery
    implements Callable<ICudaDevice[]> {
        private DevicesQuery() {
        }

        @Override
        public ICudaDevice[] call() throws Exception {
            Collection<Device> detected = DeviceManager.getDevices();
            ICudaDevice[] devices = new ICudaDevice[detected.size()];
            int i = 0;
            for (Device device : detected) {
                devices[i++] = ViperDeviceManager.wrap(device);
            }
            return devices;
        }
    }
}

