/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.viper.analysis;

import com.nvidia.viper.ViperHelp;
import com.nvidia.viper.analysis.AnalysisDescriptor;
import com.nvidia.viper.analysis.AnalysisResultTimeline;
import com.nvidia.viper.analysis.AnalysisTimeData;
import com.nvidia.viper.analysis.ResultOutput;
import com.nvidia.viper.model.Timeline;
import com.nvidia.viper.value.IValue;
import com.nvidia.viper.value.ValueNs;
import com.nvidia.viper.value.ValueNumber;
import org.eclipse.jface.action.Action;

public class AnalysisResultGPUComputeEfficiency
extends AnalysisResultTimeline<AnalysisTimeData> {
    public AnalysisResultGPUComputeEfficiency(AnalysisDescriptor desc) {
        super(desc);
    }

    @Override
    public String getDetails(ResultOutput otpt) {
        ValueNumber avgUtil = AnalysisTimeData.getAvgRatioValue(this.timelines.values());
        ValueNs avgTime = AnalysisTimeData.getAvgTimeValue(this.timelines.values());
        ValueNs avgTotalTime = AnalysisTimeData.getAvgTotalTimeValue(this.timelines.values());
        return String.valueOf(avgTime.toString()) + " / " + avgTotalTime.toString() + " = " + avgUtil.toString() + (this.getTimelineCount() > 1 ? " avg" : "");
    }

    @Override
    public IValue getValue(Timeline timeline) {
        Double p = ((AnalysisTimeData)this.getData(timeline)).getRatio();
        if (p == null) {
            return null;
        }
        return new ValueNumber(p);
    }

    @Override
    public String getValueDescription(Timeline timeline) {
        return "Ratio of compute time to memory copy time";
    }

    @Override
    public Action getMoreAction() {
        return new Action(){

            public void run() {
                ViperHelp.displayHelp(ViperHelp.DATA_XFER_HTOD);
            }
        };
    }
}

