/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.viper.actions;

import com.nvidia.viper.Activator;
import java.util.Iterator;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.text.source.CompositeRuler;
import org.eclipse.jface.text.source.IVerticalRulerColumn;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;

public abstract class RulerColumnAction
extends Action {
    protected Composite viewerControl;
    protected CompositeRuler viewRuler;
    protected GridData gridDataHeader;
    protected Label labelHeader;
    protected String pref;
    protected int index;

    public RulerColumnAction(Composite viewerControl, CompositeRuler viewRuler, GridData gridDataHeader, Label labelHeader, String pref, int index, String name) {
        super(name, 2);
        this.viewerControl = viewerControl;
        this.viewRuler = viewRuler;
        this.gridDataHeader = gridDataHeader;
        this.labelHeader = labelHeader;
        this.pref = pref;
        this.index = index;
        boolean show = Activator.getDefault().getPreferenceStore().getBoolean(pref);
        this.setChecked(show);
    }

    public void run() {
        super.run();
        IVerticalRulerColumn column = this.getRulerColumn();
        if (this.isChecked() && column == null) {
            IVerticalRulerColumn rulerColumn = this.createRulerColumn();
            this.viewRuler.addDecorator(this.index, rulerColumn);
            this.updateColumnWidth(rulerColumn);
        } else if (!this.isChecked() && column != null) {
            this.viewRuler.removeDecorator(column);
        }
        this.labelHeader.setVisible(this.isChecked());
        this.gridDataHeader.exclude = !this.isChecked();
        this.viewerControl.layout();
        Activator.getDefault().getPreferenceStore().setValue(this.pref, this.isChecked());
    }

    protected void updateColumnWidth(IVerticalRulerColumn rulerColumn) {
    }

    protected abstract IVerticalRulerColumn createRulerColumn();

    protected abstract boolean isActionForColumn(IVerticalRulerColumn var1);

    protected IVerticalRulerColumn getRulerColumn() {
        Iterator it = this.viewRuler.getDecoratorIterator();
        while (it.hasNext()) {
            IVerticalRulerColumn column = (IVerticalRulerColumn)it.next();
            if (!this.isActionForColumn(column)) continue;
            return column;
        }
        return null;
    }
}

