/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove.module.pdf;

import edu.harvard.hul.ois.jhove.module.pdf.ArrayEnd;
import edu.harvard.hul.ois.jhove.module.pdf.ArrayStart;
import edu.harvard.hul.ois.jhove.module.pdf.Comment;
import edu.harvard.hul.ois.jhove.module.pdf.DictionaryEnd;
import edu.harvard.hul.ois.jhove.module.pdf.DictionaryStart;
import edu.harvard.hul.ois.jhove.module.pdf.Keyword;
import edu.harvard.hul.ois.jhove.module.pdf.Name;
import edu.harvard.hul.ois.jhove.module.pdf.Numeric;
import edu.harvard.hul.ois.jhove.module.pdf.PdfArray;
import edu.harvard.hul.ois.jhove.module.pdf.PdfDictionary;
import edu.harvard.hul.ois.jhove.module.pdf.PdfException;
import edu.harvard.hul.ois.jhove.module.pdf.PdfIndirectObj;
import edu.harvard.hul.ois.jhove.module.pdf.PdfInvalidException;
import edu.harvard.hul.ois.jhove.module.pdf.PdfMalformedException;
import edu.harvard.hul.ois.jhove.module.pdf.PdfObject;
import edu.harvard.hul.ois.jhove.module.pdf.PdfSimpleObject;
import edu.harvard.hul.ois.jhove.module.pdf.PdfStream;
import edu.harvard.hul.ois.jhove.module.pdf.Stream;
import edu.harvard.hul.ois.jhove.module.pdf.Token;
import edu.harvard.hul.ois.jhove.module.pdf.Tokenizer;
import java.io.IOException;
import java.util.Map;
import java.util.Set;
import java.util.Vector;

public class Parser {
    private Tokenizer _tokenizer;
    private int _dictDepth;
    private int _arrayDepth;
    private Map _objectMap;
    private boolean _encrypted;
    private boolean _pdfACompliant;

    public Parser(Tokenizer tokenizer) {
        this._tokenizer = tokenizer;
        this._pdfACompliant = true;
        this.reset();
    }

    public void setObjectMap(Map map) {
        this._objectMap = map;
    }

    public void reset() {
        this._dictDepth = 0;
        this._arrayDepth = 0;
    }

    public void resetLoose() {
        this._dictDepth = 1000000;
        this._arrayDepth = 1000000;
    }

    public Token getNext() throws IOException, PdfException {
        return this.getNext(0L);
    }

    public Token getNext(long l) throws IOException, PdfException {
        Token token = this._tokenizer.getNext(l);
        if (token instanceof DictionaryStart) {
            ++this._dictDepth;
        } else if (token instanceof DictionaryEnd) {
            --this._dictDepth;
            if (this._dictDepth < 0) {
                throw new PdfMalformedException("Improperly nested dictionary delimiters");
            }
        }
        if (token instanceof ArrayStart) {
            ++this._arrayDepth;
        } else if (token instanceof ArrayEnd) {
            --this._arrayDepth;
            if (this._arrayDepth < 0) {
                throw new PdfMalformedException("Improperly nested array delimiters");
            }
        }
        return token;
    }

    public Token getNext(Class clazz, String string) throws IOException, PdfException {
        Token token = this.getNext();
        if (!clazz.isInstance(token)) {
            throw new PdfInvalidException(string);
        }
        if (!token.isPdfACompliant()) {
            this._pdfACompliant = false;
        }
        return token;
    }

    public int getDictDepth() {
        return this._dictDepth;
    }

    public void setEncrypted(boolean bl) {
        this._encrypted = bl;
        this._tokenizer.setEncrypted(bl);
    }

    public int getArrayDepth() {
        return this._arrayDepth;
    }

    public String getWSString() {
        return this._tokenizer.getWSString();
    }

    public Set getLanguageCodes() {
        return this._tokenizer.getLanguageCodes();
    }

    public boolean getPDFACompliant() {
        if (!this._tokenizer.getPDFACompliant()) {
            this._pdfACompliant = false;
        }
        return this._pdfACompliant;
    }

    public void setPDFACompliant(boolean bl) {
        this._pdfACompliant = bl;
        if (bl) {
            this._tokenizer.setPDFACompliant(true);
        }
    }

    public PdfObject readObjectDef() throws IOException, PdfException {
        Numeric numeric = (Numeric)this.getNext(Numeric.class, "Invalid object definition");
        return this.readObjectDef(numeric);
    }

    public PdfObject readObjectDef(Numeric numeric) throws IOException, PdfException {
        PdfObject pdfObject;
        String string = "Invalid object definition";
        this.reset();
        Numeric numeric2 = (Numeric)this.getNext(Numeric.class, string);
        Keyword keyword = (Keyword)this.getNext(Keyword.class, string);
        if (!"obj".equals(keyword.getValue())) {
            throw new PdfMalformedException(string);
        }
        if (this._tokenizer.getWSString().length() > 1) {
            this._pdfACompliant = false;
        }
        if ((pdfObject = this.readObject()) instanceof PdfDictionary) {
            Stream stream = null;
            try {
                stream = (Stream)this.getNext(Stream.class, "");
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (stream != null) {
                PdfStream pdfStream = new PdfStream((PdfDictionary)pdfObject, stream);
                if (!pdfStream.isPdfaCompliant()) {
                    this._pdfACompliant = false;
                }
                pdfObject = pdfStream;
            }
        }
        pdfObject.setObjNumber(numeric.getIntegerValue());
        pdfObject.setGenNumber(numeric2.getIntegerValue());
        return pdfObject;
    }

    public PdfObject readObject() throws IOException, PdfException {
        Token token = this.getNext();
        if (token instanceof ArrayStart) {
            return this.readArray();
        }
        if (token instanceof DictionaryStart) {
            return this.readDictionary();
        }
        if (token.isSimpleToken()) {
            return new PdfSimpleObject(token);
        }
        throw new PdfMalformedException("Cannot parse object", this.getOffset(), token);
    }

    public PdfArray readArray() throws IOException, PdfException {
        PdfArray pdfArray = new PdfArray();
        while (true) {
            PdfObject pdfObject = null;
            try {
                pdfObject = this.readObject();
                pdfArray.add(pdfObject);
            }
            catch (PdfException pdfException) {
                Token token = pdfException.getToken();
                if (token instanceof ArrayEnd) {
                    this.collapseObjectVector(pdfArray.getContent());
                    if (!pdfArray.isPdfACompliant()) {
                        this._pdfACompliant = false;
                    }
                    return pdfArray;
                }
                throw pdfException;
            }
        }
    }

    public PdfDictionary readDictionary() throws IOException, PdfException {
        PdfDictionary pdfDictionary = new PdfDictionary();
        Vector<PdfObject> vector = new Vector<PdfObject>();
        while (true) {
            PdfObject pdfObject = null;
            try {
                pdfObject = this.readObject();
                if (pdfObject instanceof PdfSimpleObject && ((PdfSimpleObject)pdfObject).getToken() instanceof Comment) continue;
                vector.add(pdfObject);
            }
            catch (PdfException pdfException) {
                Token token = pdfException.getToken();
                if (token instanceof DictionaryEnd) {
                    this.collapseObjectVector(vector);
                    String string = "Malformed dictionary";
                    int n = vector.size();
                    if (n % 2 != 0) {
                        throw new PdfMalformedException(string + ": Vector must contain an even number of objects, but has " + n, this.getOffset());
                    }
                    for (int i = 0; i < n; i += 2) {
                        try {
                            Name name = (Name)((PdfSimpleObject)vector.elementAt(i)).getToken();
                            PdfObject pdfObject2 = (PdfObject)vector.elementAt(i + 1);
                            pdfDictionary.add(name.getValue(), pdfObject2);
                            continue;
                        }
                        catch (Exception exception) {
                            throw new PdfMalformedException(string, this.getOffset());
                        }
                    }
                    if (!pdfDictionary.isPdfACompliant()) {
                        this._pdfACompliant = false;
                    }
                    return pdfDictionary;
                }
                throw pdfException;
            }
        }
    }

    public long getOffset() {
        return this._tokenizer.getOffset();
    }

    public void seek(long l) throws IOException, PdfException {
        this._tokenizer.seek(l);
        this.reset();
    }

    private void collapseObjectVector(Vector vector) throws PdfException {
        for (int i = vector.size() - 1; i >= 2; --i) {
            Token token;
            PdfObject pdfObject = (PdfObject)vector.elementAt(i);
            if (!(pdfObject instanceof PdfSimpleObject) || !((token = ((PdfSimpleObject)pdfObject).getToken()) instanceof Keyword) || !"R".equals(((Keyword)token).getValue())) continue;
            try {
                PdfSimpleObject pdfSimpleObject = (PdfSimpleObject)vector.elementAt(i - 2);
                Numeric numeric = (Numeric)pdfSimpleObject.getToken();
                int n = numeric.getIntegerValue();
                pdfSimpleObject = (PdfSimpleObject)vector.elementAt(i - 1);
                numeric = (Numeric)pdfSimpleObject.getToken();
                int n2 = numeric.getIntegerValue();
                vector.set(i - 2, new PdfIndirectObj(n, n2, this._objectMap));
                vector.removeElementAt(i);
                vector.removeElementAt(i - 1);
                i -= 2;
                continue;
            }
            catch (Exception exception) {
                throw new PdfMalformedException("Malformed indirect object reference");
            }
        }
    }

    public void scanMode(boolean bl) {
        this._tokenizer.scanMode(bl);
    }
}

