/*
 * Decompiled with CFR 0.152.
 */
package com.sun.medialib.codec.jpeg;

import com.sun.medialib.codec.jiio.Util;
import com.sun.medialib.codec.jiio.mediaLibImage;
import com.sun.medialib.codec.jpeg.Constants;
import java.io.IOException;
import java.io.InputStream;
import javax.imageio.stream.ImageInputStream;

public final class Decoder
implements Constants {
    private long decoder = 0L;
    private ImageInputStream iistream = null;
    private InputStream istream = null;
    private long iioffset = 0L;
    private static String errorMessage = "";

    public Decoder(InputStream inputStream) throws IOException {
        if (inputStream instanceof ImageInputStream) {
            this.iistream = (ImageInputStream)((Object)inputStream);
            this.iioffset = this.iistream.getStreamPosition();
        } else {
            this.istream = inputStream;
            this.istream.mark(0x100000);
        }
        this.decoder = this.njpeg_decode_init(inputStream);
    }

    public Decoder(ImageInputStream imageInputStream) throws IOException {
        this.iistream = imageInputStream;
        this.iioffset = this.iistream.getStreamPosition();
        this.decoder = this.njpeg_decode_init(imageInputStream);
    }

    public mediaLibImage decode(mediaLibImage mediaLibImage2) throws IOException {
        Object[] objectArray;
        int[] nArray = new int[9];
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        this.njpeg_decode(this.decoder, nArray);
        if (nArray[1] == -1) {
            return null;
        }
        if (this.iistream != null) {
            this.iistream.seek(this.iioffset + (long)this.getLength());
        } else if (this.istream.markSupported()) {
            this.istream.reset();
            this.istream.skip(this.getLength());
        }
        n2 = nArray[3];
        n = nArray[4];
        if (nArray[8] == 0) {
            n2 = nArray[7] == 2 ? nArray[3] + 7 & 0xFFFFFFF8 : nArray[3] + 15 & 0xFFFFFFF0;
        }
        n3 = n2 * n;
        if (nArray[0] == 1) {
            objectArray = new byte[n3];
        } else if (nArray[0] == 2) {
            n /= 2;
            objectArray = new short[n3 / 2];
        } else {
            return null;
        }
        if (mediaLibImage2 == null) {
            mediaLibImage2 = new mediaLibImage(nArray[0], nArray[1], nArray[2], nArray[3], n, 0, nArray[7], (Object)objectArray);
        }
        if (0 != this.nSetData(mediaLibImage2, n3, this.decoder)) {
            return null;
        }
        if (nArray[7] != -1) {
            mediaLibImage2.setFormat(nArray[7]);
        }
        return mediaLibImage2;
    }

    public mediaLibImage getSize() {
        int[] nArray = new int[9];
        int n = 0;
        boolean bl = false;
        boolean bl2 = false;
        this.nGetSize(this.decoder, nArray);
        if (nArray[1] == -1) {
            return null;
        }
        n = nArray[4];
        if (nArray[0] == 2) {
            n >>= 1;
        }
        mediaLibImage mediaLibImage2 = new mediaLibImage(nArray[0], nArray[1], nArray[2], nArray[3], n, 0, nArray[7], null);
        return mediaLibImage2;
    }

    public byte[] getEmbeddedICCProfile() {
        byte[] byArray = this.nGetEmbeddedICCProfile(this.decoder);
        return byArray;
    }

    public void setFormat(int n) {
        this.nSetFormat(this.decoder, n);
    }

    public void setFilter(int n) {
        this.nSetFilter(this.decoder, n);
    }

    public int getDepth() {
        return this.nGetDepth(this.decoder);
    }

    public int getType() {
        return this.nGetType(this.decoder);
    }

    public int getMode() {
        return this.nGetMode(this.decoder);
    }

    public int getRate() {
        return this.nGetRate(this.decoder);
    }

    public int getLength() {
        return this.nGetLength(this.decoder);
    }

    protected void finalize() throws Throwable {
        if (this.decoder != 0L) {
            this.njpeg_decode_free(this.decoder);
            this.decoder = 0L;
        }
    }

    public void dispose() {
        if (this.decoder != 0L) {
            this.njpeg_decode_free(this.decoder);
            this.decoder = 0L;
        }
    }

    private native long njpeg_decode_init(Object var1);

    private native void njpeg_decode(long var1, int[] var3);

    private native int nSetData(Object var1, int var2, long var3);

    private native void nSetFormat(long var1, int var3);

    private native void nSetFilter(long var1, int var3);

    private native void nGetSize(long var1, int[] var3);

    private native byte[] nGetEmbeddedICCProfile(long var1);

    private native int nGetDepth(long var1);

    private native int nGetType(long var1);

    private native int nGetMode(long var1);

    private native int nGetRate(long var1);

    private native int nGetLength(long var1);

    private native void njpeg_decode_free(long var1);

    public static String getErrorMessage() {
        return errorMessage;
    }

    public static native String getVersion();

    static {
        Util.isCodecLibAvailable();
    }
}

