/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.gatk.utils.pairhmm;

import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.SortedSet;
import java.util.TreeSet;

public class PairHMMReadyHaplotypes
implements Iterable<Entry> {
    private Map<Entry, Map<Entry, Integer>> commonPrefixLength;
    private SortedSet<Entry> entries;
    private int capacity;
    private final Comparator<Entry> comparator = new Comparator<Entry>(){

        @Override
        public int compare(Entry o1, Entry o2) {
            int i;
            HashMap<Entry, Integer> b2map;
            byte[] b1 = o1.bases;
            byte[] b2 = o2.bases;
            HashMap<Entry, Integer> b1map = (HashMap<Entry, Integer>)PairHMMReadyHaplotypes.this.commonPrefixLength.get(o1);
            if (b1map == null) {
                b1map = new HashMap<Entry, Integer>(PairHMMReadyHaplotypes.this.capacity);
                PairHMMReadyHaplotypes.this.commonPrefixLength.put(o1, b1map);
            }
            if ((b2map = (HashMap<Entry, Integer>)PairHMMReadyHaplotypes.this.commonPrefixLength.get(o2)) == null) {
                b2map = new HashMap<Entry, Integer>(PairHMMReadyHaplotypes.this.capacity);
                PairHMMReadyHaplotypes.this.commonPrefixLength.put(o2, b2map);
            }
            Integer previousI = b1map.get(o2) == null ? null : (Integer)b1map.get(o2);
            int iLimit = Math.min(b1.length, b2.length);
            if (previousI == null) {
                for (i = 0; i < iLimit && b1[i] == b2[i]; ++i) {
                }
                b1map.put(o2, i);
                b2map.put(o1, i);
            } else {
                i = previousI;
            }
            int result = i < iLimit ? Byte.compare(b1[i], b2[i]) : (b1.length == b2.length ? 0 : (b1.length < b2.length ? -1 : 1));
            return result;
        }
    };

    public PairHMMReadyHaplotypes(int capacity) {
        this.commonPrefixLength = new HashMap<Entry, Map<Entry, Integer>>(capacity);
        this.entries = new TreeSet<Entry>(this.comparator);
    }

    public void add(byte[] bases) {
        Entry entry = new Entry(bases);
        this.entries.add(entry);
    }

    public int size() {
        return this.entries.size();
    }

    public Iterator iterator() {
        return new Iterator();
    }

    public class Iterator
    implements java.util.Iterator<Entry> {
        private java.util.Iterator<Entry> actualIterator;
        private Entry previousEntry;
        private Entry currentEntry;
        private int startIndex;
        private int cmp;

        private Iterator() {
            this.actualIterator = PairHMMReadyHaplotypes.this.entries.iterator();
        }

        @Override
        public boolean hasNext() {
            return this.actualIterator.hasNext();
        }

        @Override
        public Entry next() {
            this.previousEntry = this.currentEntry;
            Entry result = this.currentEntry = this.actualIterator.next();
            this.startIndex = -1;
            return result;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        public byte[] bases() {
            if (this.currentEntry == null) {
                throw new NoSuchElementException();
            }
            return this.currentEntry.bases;
        }

        public int startIndex() {
            if (this.startIndex >= 0) {
                return this.startIndex;
            }
            if (this.previousEntry == null) {
                this.startIndex = 0;
                return 0;
            }
            this.cmp = PairHMMReadyHaplotypes.this.comparator.compare(this.previousEntry, this.currentEntry);
            this.startIndex = (Integer)((Map)PairHMMReadyHaplotypes.this.commonPrefixLength.get(this.previousEntry)).get(this.currentEntry);
            return this.startIndex;
        }

        public String toString() {
            return super.toString() + " cmp = " + this.cmp;
        }

        public void setLikelihood(double likelihood) {
            if (this.currentEntry == null) {
                throw new NoSuchElementException();
            }
            this.currentEntry.setLikelihood(likelihood);
        }
    }

    public class Entry {
        private final byte[] bases;
        private double likelihood = Double.NaN;

        protected Entry(byte[] bases) {
            this.bases = bases;
        }

        protected byte[] getBases() {
            return this.bases;
        }

        public void setLikelihood(double lk) {
            this.likelihood = lk;
        }

        public double getLikelihood() {
            return this.likelihood;
        }
    }
}

