/*
 *    for new GOGO-no-coda (1999/09)
 *      modified by shigeo
 *      renewed by sakai (2000/02)
 */

extern const int *scalefac_long;
extern const int *scalefac_short;

#include <stdio.h>
#include <stdlib.h>
#include <assert.h>
#include "l3bs.h"		/* the public interface */
#include "l3psy.h"
#include "mdct.h"
#include "loop.h"
#include "huffman.h"
#include "bitstrem.h"		/* for putbits() */

/* globals */
/* export to putbits.nas */
int BitCount = 0;
int BitsRemaining = 0;
void write_main_data_with_side_info(unsigned int val, unsigned int nbits);

static int ThisFrameSize = 0;
static int elements, forwardFrameLength, forwardSILength;

typedef struct side_info_link {
	struct side_info_link	*next;
	int			frameLength;
	int			SILength;
	III_side_info_t		l3_side;
} side_info_link;

static struct side_info_link *side_queue_head = NULL;
static struct side_info_link *side_queue_free = NULL;

/* forward declarations */
static void store_side_info(III_side_info_t *si, int bitsPerFrame);
static void free_side_queues(void);
static side_info_link *get_side_info(void);
static void encodeMainData(int l3_enc[2][2][576], III_side_info_t *si, III_scalefac_t *scalefac);
static void Huffmancodebits(int *ix, gr_info *gi );
static void drain_into_ancillary_data( int lengthInBits );

void
InitFormatBitStream(void)
{
	BitCount = 0;
	ThisFrameSize = 0;
	BitsRemaining = 0;
	elements = 0;
	forwardFrameLength = 0;
	forwardSILength = 0;
	side_queue_head = NULL;
	side_queue_free = NULL;
}

void
III_format_bitstream(int bitsPerFrame, int l3_enc[2][2][576], III_side_info_t *l3_side, III_scalefac_t *scalefac)
{
	/*
	   BitStreamFrame is the public interface to the bitstream
	   formatting package. It writes one frame of main data per call.

	   Assumptions:
	   - The back pointer is zero on the first call
	   - An integral number of bytes is written each frame

	   You should be able to change the frame length, side info
	   length, #channels, #granules on a frame-by-frame basis.
	 */
	/* save SI and compute its length */
	store_side_info(l3_side, bitsPerFrame);

	/* encode & write the main data, inserting SI to maintain framing */
	encodeMainData(l3_enc, l3_side, scalefac);

	if (l3_side->resvDrain){
		drain_into_ancillary_data(l3_side->resvDrain);
	}

	/*
	   Caller must ensure that back SI and main data are
	   an integral number of bytes, since the back pointer
	   can only point to a byte boundary and this code
	   does not add stuffing bits
	 */

	/* we set this here -- it will be tested in the next loops iteration */
	l3_side->main_data_begin = (BitsRemaining >> 3) + (forwardFrameLength >> 3) - (forwardSILength >> 3);
}

/* WriteMainDataBits()͂̂񐔌Ă΂̂ŃCCWJ */
/* nbits != 0 ł邱ƁB */
/* static void WriteMainDataBits( unsigned val, unsigned nbits ); */
#define WriteMainDataBits(_val,_nbits)					\
{									\
	unsigned val=(_val), nbits=(_nbits);				\
	assert( ( 0 < nbits) && (nbits <= 32) );			\
	if( nbits > BitsRemaining ){					\
		write_main_data_with_side_info(val, nbits);		\
	}else{								\
		putbits( val, nbits );					\
		BitCount += nbits;					\
		BitsRemaining -= nbits;					\
	}								\
	assert( BitCount <= ThisFrameSize );				\
	assert( BitsRemaining >= 0 );					\
	assert( (BitCount + BitsRemaining) == ThisFrameSize );		\
}

#define WriteMainDataBits24(_val,_nbits)				\
{									\
	unsigned val=(_val), nbits=(_nbits);				\
	assert( ( 0 < nbits) && (nbits <= 32) );			\
	if( nbits > BitsRemaining ){					\
		write_main_data_with_side_info(val, nbits);		\
	}else{								\
		putbits24( val, nbits );				\
		BitCount += nbits;					\
		BitsRemaining -= nbits;					\
	}								\
	assert( BitCount <= ThisFrameSize );				\
	assert( BitsRemaining >= 0 );					\
	assert( (BitCount + BitsRemaining) == ThisFrameSize );		\
}

static unsigned slen1_tab[16] =
{0, 0, 0, 0, 3, 1, 1, 1, 2, 2, 2, 3, 3, 3, 4, 4};
static unsigned slen2_tab[16] =
{0, 1, 2, 3, 0, 1, 2, 3, 1, 2, 3, 1, 2, 3, 2, 3};

static void
encodeMainData(int l3_enc[2][2][576], III_side_info_t *si, III_scalefac_t *scalefac)
{
	int i, gr, ch, sfb, window;
	int *facl, (*facs)[3];
	int tmp;

	if (gl.version == 1) {
		/* MPEG 1 */
		for (gr = 0; gr < 2; gr++) {
			for (ch = 0; ch < gl.stereo; ch++) {
				gr_info *gi = &(si->gr[gr].ch[ch].tt);
				unsigned slen1 = slen1_tab[gi->scalefac_compress];
				unsigned slen2 = slen2_tab[gi->scalefac_compress];
				int *ix = &l3_enc[gr][ch][0];
				facl = scalefac->l[gr][ch];
				facs = scalefac->s[gr][ch];

				if (gi->block_type == SHORT_TYPE) {
					if (slen1) {
						tmp  = facs[0][0]; tmp <<= slen1;
						tmp |= facs[0][1]; tmp <<= slen1;
						tmp |= facs[0][2]; tmp <<= slen1;
						tmp |= facs[1][0]; tmp <<= slen1;
						tmp |= facs[1][1]; tmp <<= slen1;
						tmp |= facs[1][2];
						WriteMainDataBits24(tmp, slen1 * 6); // max = 4*3*2
						tmp  = facs[2][0]; tmp <<= slen1;
						tmp |= facs[2][1]; tmp <<= slen1;
						tmp |= facs[2][2]; tmp <<= slen1;
						tmp |= facs[3][0]; tmp <<= slen1;
						tmp |= facs[3][1]; tmp <<= slen1;
						tmp |= facs[3][2];
						WriteMainDataBits24(tmp, slen1 * 6); // max = 4*3*2
						tmp  = facs[4][0]; tmp <<= slen1;
						tmp |= facs[4][1]; tmp <<= slen1;
						tmp |= facs[4][2]; tmp <<= slen1;
						tmp |= facs[5][0]; tmp <<= slen1;
						tmp |= facs[5][1]; tmp <<= slen1;
						tmp |= facs[5][2];
						WriteMainDataBits24(tmp, slen1 * 6); // max = 4*3*2
					}
					if (slen2) {
						tmp  = facs[ 6][0]; tmp <<= slen2;
						tmp |= facs[ 6][1]; tmp <<= slen2;
						tmp |= facs[ 6][2]; tmp <<= slen2;
						tmp |= facs[ 7][0]; tmp <<= slen2;
						tmp |= facs[ 7][1]; tmp <<= slen2;
						tmp |= facs[ 7][2]; tmp <<= slen2;
						tmp |= facs[ 8][0]; tmp <<= slen2;
						tmp |= facs[ 8][1];
						WriteMainDataBits24(tmp, slen2 * 8); // max(slen2)=3
						tmp  = facs[ 8][2]; tmp <<= slen2;
						tmp |= facs[ 9][0]; tmp <<= slen2;
						tmp |= facs[ 9][1]; tmp <<= slen2;
						tmp |= facs[ 9][2]; tmp <<= slen2;
						tmp |= facs[10][0]; tmp <<= slen2;
						tmp |= facs[10][1]; tmp <<= slen2;
						tmp |= facs[10][2]; tmp <<= slen2;
						tmp |= facs[11][0]; tmp <<= slen2;
						tmp |= facs[11][1]; tmp <<= slen2;
						tmp |= facs[11][2];
						WriteMainDataBits(tmp, slen2 * 10); // max(slen2)=3
					}
				} else {
					if (slen1) {
						tmp = 0; /* max = 4*6 */
						for (sfb = 0; sfb < 6; sfb++) {
							tmp = facl[sfb] | (tmp<<slen1);
						}
						WriteMainDataBits24(tmp, slen1*6);
						tmp = 0; /* max = 4*5 */
						for (sfb = 6; sfb < 11; sfb++) {
							tmp = facl[sfb] | (tmp<<slen1);
						}
						WriteMainDataBits24(tmp, slen1*5);
					}
					if (slen2) {
						tmp = 0; /* max = 3*10 */
						for (sfb = 11; sfb < 21; sfb++){
							tmp = facl[sfb] | (tmp<<slen2);
						}
						WriteMainDataBits(tmp, slen2*10);
					}
				}
				Huffmancodebits(ix, gi);

			}	/* for ch */
		}		/* for gr */
	} else {
		/* MPEG 2 */
		gr = 0;
		for (ch = 0; ch < gl.stereo; ch++) {
			gr_info *gi = &(si->gr[gr].ch[ch].tt);
			int *ix = &l3_enc[gr][ch][0];
			int sfb_partition;
			assert(gi->sfbTblSub);

			facl = scalefac->l[gr][ch];
			facs = scalefac->s[gr][ch];

			if (gi->block_type == SHORT_TYPE) {
				{
					for (sfb = 0, sfb_partition = 0; sfb_partition < 4; sfb_partition++) {
						int sfbs = gi->sfbTblSub[sfb_partition] / 3;
						int slen = gi->slen[sfb_partition];
						if (slen){
							for (i = 0; i < sfbs; i++, sfb++){
								for (window = 0; window < 3; window++){
									WriteMainDataBits(facs[sfb][window], slen);
								}
							}
						}
					}
				}
			} else {
				for (sfb = 0, sfb_partition = 0; sfb_partition < 4; sfb_partition++) {
					int sfbs = gi->sfbTblSub[sfb_partition];
					int slen = gi->slen[sfb_partition];
					if (slen){
						for (i = 0; i < sfbs; i++, sfb++){
							WriteMainDataBits(facl[sfb], slen);
						}
					}
				}
			}
			Huffmancodebits(ix, gi);
		}	/* for ch */
	}
} /* end of encodeMainData */


/* 153clk -> 96clk by shigeo 00/02/07 */
/* absolute of v, w, x, y <=1 always */
static int
L3_huffman_coder_count1(struct huffcodetab *h, int *ix, int count)
{
	int huffbits, len, p;
	int ret = 0;
	while( count ){
		huffbits = len = p = 0;
		if (ix[0]) {
			if (ix[0] < 0) huffbits++;
			p = 8;
			len++;
		}
		if (ix[1]) {
			huffbits <<= 1;
			if (ix[1] < 0) huffbits++;
			p |= 4;
			len++;
		}
		if (ix[2]) {
			huffbits <<= 1;
			if (ix[2] < 0) huffbits++;
			p |= 2;
			len++;
		}
		if (ix[3]) {
			huffbits <<= 1;
			if (ix[3] < 0) huffbits++;
			p |= 1;
			len++;
		}
		huffbits += h->table[p] << len;
		/* max of len = 19 + 4 */
		len += h->hlen[p];
		if( len ) WriteMainDataBits24(huffbits, len);
		ret += len;
		ix += 4;
		count--;
	}
	return ret;
}

/* defined in putbits.nas */
int HuffmanCodePutBits(int table_select, int x,int y);

static void
Huffmancodebits(int *ix, gr_info * gi)
{
	int region1Start;
	int region2Start;
	int bigvalues;
	int i, x, y, bits, stuffingBits;
	struct huffcodetab *h;
	int bitsWritten = 0;

	/* 1: Write the bigvalues */
	bigvalues = gi->big_values * 2;
	if (bigvalues) {
		if (gi->block_type == SHORT_TYPE) {
			int sfb, window, line, start, end;
			I192_3 *ix_s;

			ix_s = (I192_3 *) ix;
			region1Start = 12;
			region2Start = 576;

			for (sfb = 0; sfb < 13; sfb++) {
				unsigned tableindex;
				start = scalefac_short[sfb];
				end = scalefac_short[sfb + 1];

				if (start < region1Start)
					tableindex = gi->table_select[0];
				else
					tableindex = gi->table_select[1];
				if (tableindex) {
					for (window = 0; window < 3; window++) {
						for (line = start; line < end; line += 2) {
							x = (*ix_s)[line][window];
							y = (*ix_s)[line + 1][window];
							bits = HuffmanCodePutBits(tableindex, x, y);
							bitsWritten += bits;
						}
					}
				}
			}
		} else {
			/* Long blocks */
			unsigned scalefac_index;
			unsigned tableindex;

			scalefac_index = gi->region0_count + 1;
			assert(scalefac_index < 23);
			region1Start = scalefac_long[scalefac_index];
			scalefac_index += gi->region1_count + 1;
			assert(scalefac_index < 23);
			region2Start = scalefac_long[scalefac_index];

			if(region1Start > bigvalues) region1Start = bigvalues;
			/* get table pointer */
			tableindex = gi->table_select[0];
			if (tableindex) {
				for (i = 0; i < region1Start; i += 2) {
					/* get huffman code */
					x = ix[i];
					y = ix[i + 1];
					bits = HuffmanCodePutBits(tableindex, x, y);
					bitsWritten += bits;
				}
			}
			if(region2Start > bigvalues) region2Start = bigvalues;
			/* get table pointer */
			tableindex = gi->table_select[1];
			if (tableindex) {
				for (i = region1Start; i < region2Start; i += 2) {
					/* get huffman code */
					x = ix[i];
					y = ix[i + 1];
					bits = HuffmanCodePutBits(tableindex, x, y);
					bitsWritten += bits;
				}
			}
			/* get table pointer */
			tableindex = gi->table_select[2];
			if (tableindex) {
				for (i = region2Start; i < bigvalues; i += 2) {
					/* get huffman code */
					x = ix[i];
					y = ix[i + 1];
					bits = HuffmanCodePutBits(tableindex, x, y);
					bitsWritten += bits;
				}
			}
		}
	}
	/* 2: Write count1 area */
	assert((gi->count1table_select < 2));
	h = &ht[gi->count1table_select + 32];
	bitsWritten += L3_huffman_coder_count1(h, &ix[bigvalues], gi->count1 );
	stuffingBits = gi->part2_3_length - gi->part2_length - bitsWritten;
	if (stuffingBits) {
		int stuffingWords = stuffingBits >> 5;
		int remainingBits = stuffingBits & 31;
		assert(stuffingBits > 0);
		while (stuffingWords--) {
			WriteMainDataBits(~0, 32);
		}
		if (remainingBits) {
			WriteMainDataBits(~0, remainingBits);
		}
		bitsWritten += stuffingBits;
	}
	assert(bitsWritten == gi->part2_3_length - gi->part2_length);
}

void
III_FlushBitstream(void)
{
	if (elements) {
		int bitsRemaining = forwardFrameLength - forwardSILength;
		int wordsRemaining = bitsRemaining >> 5;
		while (wordsRemaining--) {
			WriteMainDataBits(0, 32);
		}
		bitsRemaining &= 31;
		if( bitsRemaining )		// <- assert΍ 2000.03.11 T.Narita
			WriteMainDataBits(0, bitsRemaining & 31);
	}

	/* reclaim queue space */
	free_side_queues();

	/* reinitialize globals */
	BitCount = 0;
	ThisFrameSize = 0;
	BitsRemaining = 0;

	return;
}

static void
drain_into_ancillary_data(int lengthInBits)
{
	int wordsToSend = lengthInBits >> 5;	// / 32;
	int remainingBits = lengthInBits & 31;	//% 32;
	int i;

	for (i = 0; i < wordsToSend; i++)
		WriteMainDataBits(0, 32);
	if (remainingBits)
		WriteMainDataBits(0, remainingBits);
}

void
write_main_data_with_side_info(unsigned int val, unsigned int nbits)
{
	int gr, ch, region, window;
	side_info_link	*l;
	III_side_info_t	*si;
	int tmp;

	l = get_side_info();
	si = &l->l3_side;

	if(BitsRemaining){
		unsigned extra = val >> (nbits - BitsRemaining);
		nbits -= BitsRemaining;
		putbits( extra, BitsRemaining );
	}

	/* write header */
	/* write header */
	tmp = (0xFFF<<4) | (gl.version<<3) | (1<<1) | 1;
	putbits24(tmp, 16);
	tmp = (si->rate_idx<<12) | (gl.freq_idx<<10) | (si->padding<<9) | (gl.extension<<8) | (gl.mode<<6)
		| (si->mode_ext<<4) | (0 /* gl.copyright */<<3) | (1 /* gl.original */ <<2) | (gl.emphasis);
	putbits24(tmp, 16);

	if (gl.version == 1) {
		/* MPEG1 */
		/* write frame info */
		putbits24(si->main_data_begin, 9);

		if (gl.stereo == 2) {
			putbits24(0, 3 + 8);
		} else {
			putbits24(0, 5 + 4);
		}

		/* write spectrum info */
		for (gr = 0; gr < 2; gr++) {
			for (ch = 0; ch < gl.stereo; ch++) {
				gr_info *gi = &(si->gr[gr].ch[ch].tt);

				putbits24(gi->part2_3_length, 12);
				tmp = (gi->big_values<<13) | (gi->global_gain<<5) | (gi->scalefac_compress<<1) | gi->window_switching_flag;
				putbits24(tmp, 9 + 8 + 4 + 1);
				if (gi->window_switching_flag) {
					tmp = (gi->block_type<<20) | (0<<19) | (gi->table_select[0]<<14) | (gi->table_select[1]<<9);
					putbits24(tmp,22);
				} else {
					assert(gi->block_type == 0);
					tmp = (gi->table_select[0]<<17) | (gi->table_select[1]<<12) | (gi->table_select[2]<<7) | (gi->region0_count<<3) | gi->region1_count;
					putbits24(tmp, 22);
				}

				tmp = (gi->preflag<<2) | (gi->scalefac_scale<<1) | gi->count1table_select;
				putbits24(tmp, 3);
			}
		}
	} else {
		/* MPEG2 */
		/* write frame info */
		putbits24(si->main_data_begin, 8);
		if (gl.stereo == 2) {
			putbits24(0, 2);
		} else {
			putbits24(0, 1);
		}

		/* write spectrum info */
		gr = 0;
		for (ch = 0; ch < gl.stereo; ch++) {
			gr_info *gi = &(si->gr[gr].ch[ch].tt);

			putbits24(gi->part2_3_length, 12);
			putbits24(gi->big_values, 9);
			putbits24(gi->global_gain, 8);
			putbits24(gi->scalefac_compress, 9);
			putbits24(gi->window_switching_flag, 1);

			if (gi->window_switching_flag) {
				putbits24(gi->block_type, 2);
				putbits24(0, 1);

				for (region = 0; region < 2; region++)
					putbits24(gi->table_select[region], 5);
				for (window = 0; window < 3; window++) {
					putbits24(0, 3);
				}
			} else {
				for (region = 0; region < 3; region++)
					putbits24(gi->table_select[region], 5);

				putbits24(gi->region0_count, 4);
				putbits24(gi->region1_count, 3);
			}

			putbits24(gi->scalefac_scale, 1);
			putbits24(gi->count1table_select, 1);
		}
	}
	ThisFrameSize = l->frameLength;
	BitCount = l->SILength;
	BitsRemaining = ThisFrameSize - BitCount;

	if( nbits ){
		putbits( val, nbits );
		BitCount += nbits;
		BitsRemaining -= nbits;
	}
}

static void
store_side_info(III_side_info_t *si, int bitsPerFrame)
{
	side_info_link *l;
	side_info_link *f = side_queue_free;
	int bits = 32;

	/* calculate the number of bits in SI */
	if (gl.version == 1) {
		/* MPEG1 */
		if (gl.stereo == 2)
			bits += 256;
		else
			bits += 136;
	} else {
		/* MPEG2 */
		if (gl.stereo == 2)
			bits += 136;
		else
			bits += 72;
	}

	if (f == NULL) {
		/* must allocate another */
		l = (side_info_link *) mem_alloc(sizeof(side_info_link), "side_info_link");
	} else {
		/* remove from the free list */
		side_queue_free = f->next;
		l = f;
	}
	/* copy data */
	l->next = NULL;
	l->frameLength = bitsPerFrame;
	l->SILength = bits;
	l->l3_side = *si;

	elements++;
	forwardFrameLength += bitsPerFrame;
	forwardSILength += bits;

	/* place at end of queue */
	f = side_queue_head;
	if (f == NULL) {
		/* empty queue */
		side_queue_head = l;
	} else {
		/* find last element */
		while (f->next)
			f = f->next;
		f->next = l;
	}
}

static side_info_link *
get_side_info(void)
{
	side_info_link *f = side_queue_free;
	side_info_link *l = side_queue_head;

	/*
	   If we stop here it means you didn't provide enough
	   headers to support the amount of main data that was
	   written.
	 */
#if		1		/* by PEN 99/11/8 */
	if (!l)
		return f;
#else
	assert(l);
#endif

	/* update queue head */
	side_queue_head = l->next;

	side_queue_free = l;
	l->next = f;
	elements--;
	forwardFrameLength -= l->frameLength;
	forwardSILength -= l->SILength;
	return l;
}

static void
free_side_queues(void)
{
	side_info_link *l, *next;

	for (l = side_queue_head; l; l = next) {
		next = l->next;
		mem_free((void **) &l);
	}
	side_queue_head = NULL;

	for (l = side_queue_free; l; l = next) {
		next = l->next;
		mem_free((void **) &l);
	}
	side_queue_free = NULL;
}

