/******************************************************************************
 *									      *
 *	                           N O T I C E				      *
 *									      *
 *	              Copyright Abandoned, 1987, Fred Fish		      *
 *									      *
 *									      *
 *	This previously copyrighted work has been placed into the  public     *
 *	domain  by  the  author  and  may be freely used for any purpose,     *
 *	private or commercial.						      *
 *									      *
 *	Because of the number of inquiries I was receiving about the  use     *
 *	of this product in commercially developed works I have decided to     *
 *	simply make it public domain to further its unrestricted use.   I     *
 *	specifically  would  be  most happy to see this material become a     *
 *	part of the standard Unix distributions by AT&T and the  Berkeley     *
 *	Computer  Science  Research Group, and a standard part of the GNU     *
 *	system from the Free Software Foundation.			      *
 *									      *
 *	I would appreciate it, as a courtesy, if this notice is  left  in     *
 *	all copies and derivative works.  Thank you.			      *
 *									      *
 *	The author makes no warranty of any kind  with  respect  to  this     *
 *	product  and  explicitly disclaims any implied warranties of mer-     *
 *	chantability or fitness for any particular purpose.		      *
 *									      *
 ******************************************************************************
 */

/*
 *  FILE
 *
 *	dbug.h    user include file for programs using the dbug package
 *
 *  SYNOPSIS
 *
 *	#include <local/dbug.h>
 *
 *  SCCS ID
 *
 *	@(#)dbug.h	1.11 9/5/87
 *
 *  DESCRIPTION
 *
 *	Programs which use the dbug package must include this file.
 *	It contains the appropriate macros to call support routines
 *	in the dbug runtime library.
 *
 *	To disable compilation of the macro expansions define the
 *	preprocessor symbol "DBUG_OFF".  This will result in null
 *	macros expansions so that the resulting code will be smaller
 *	and faster.  (The difference may be smaller than you think
 *	so this step is recommended only when absolutely necessary).
 *	In general, tradeoffs between space and efficiency are
 *	decided in favor of efficiency since space is seldom a
 *	problem on the new machines).
 *
 *	All externally visible symbol names follow the pattern
 *	"_db_xxx..xx_" to minimize the possibility of a dbug package
 *	symbol colliding with a user defined symbol.
 *	
 *	The DBUG_<N> style macros are obsolete and should not be used
 *	in new code.  Macros to map them to instances of DBUG_PRINT
 *	are provided for compatibility with older code.  They may go
 *	away completely in subsequent releases.
 *
 *  AUTHOR
 *
 *	Fred Fish
 *	(Currently employed by Motorola Computer Division, Tempe, Az.)
 *	hao!noao!mcdsun!fnf
 *	(602) 438-3614
 *
 * Changed by Steffen Kaiser to fit to ANSI C, to use NDEBUG as trigger, &
 *	splitted DB_ENTER().
 */

/*
 *	Internally used dbug variables which must be global.
 */

//#define NO_DEBUG

#ifdef _MICROC_
#define NO_DEBUG
#endif
#ifdef NDEBUG
#define NO_DEBUG
#endif

#ifndef NO_DEBUG
#include <stdio.h>
    extern int _db_on_;			/* TRUE if debug currently enabled */
    extern FILE *_db_fp_;		/* Current debug output stream */
    extern char *_db_process_;		/* Name of current process */
    extern int _db_keyword_ (char *keyword);		/* Accept/reject keyword */
    extern void _db_push_ (char *control);		/* Push state, set up new state */
    extern void _db_pop_ (void);		/* Pop previous debug state */
    extern void _db_enter_ (char*,char*,int,char**,char**,int*);		/* New user function entered */
    extern void _db_return_ (int,char**,char**,int*);		/* User function return */
    extern void _db_pargs_ (int,char*);		/* Remember args for line */
    extern void _db_doprnt_ (char*,...);		/* Print debug output */
    extern void _db_setjmp_ (void);		/* Save debugger environment */
    extern void _db_longjmp_ (void);	/* Restore debugger environment */
#endif

/*
 *	These macros provide a user interface into functions in the
 *	dbug runtime support library.  They isolate users from changes
 *	in the MACROS and/or runtime support.
 *
 *	The symbols "__LINE__" and "__FILE__" are expanded by the
 *	preprocessor to the current source file line number and file
 *	name respectively.
 *
 *	WARNING ---  Because the DBUG_ENTER macro allocates space on
 *	the user function's stack, it must precede any executable
 *	statements in the user function.
 *
 */

#ifdef NO_DEBUG
#define DB_ENTER(a1)
#define DB_MALLOC(a1)
#define DB_RETURN(a1) return(a1)
#define DB_EXIT return;
#define DB_EXECUTE(keyword,a1)
#define DB_PRINT(keyword,arglist)
#define DB_2(keyword,format)		/* Obsolete */
#define DB_3(keyword,format,a1)		/* Obsolete */
#define DB_4(keyword,format,a1,a2)	/* Obsolete */
#define DB_5(keyword,format,a1,a2,a3)	/* Obsolete */
#define DB_PUSH(a1)
#define DB_POP()
#define DB_PROCESS(a1)
#define DB_FILE (stderr)
#define DB_SETJMP setjmp
#define DB_LONGJMP longjmp
#else
#	define DB_ENTER_INIT()	\
	auto char *_db_func_, *_db_file_; \
	int _db_level_
#	define DB_ENTER_DO(a) \
	_db_enter_ (a,__FILE__,__LINE__,&_db_func_,&_db_file_,&_db_level_)
#    define DB_ENTER(a) DB_ENTER_INIT(); DB_ENTER_DO(a)
#    define DB_MALLOC(a) \
	auto char *_db_func_, *_db_file_; \
	int _db_level_; \
	malloc_init();\
	_db_enter_ (a,__FILE__,__LINE__,&_db_func_,&_db_file_,&_db_level_)
#    define DB_LEAVE \
	(_db_return_ (__LINE__, &_db_func_, &_db_file_, &_db_level_))
#    define DB_RETURN(a1) return (DB_LEAVE, (a1))
/*   define DB_RETURN(a1) {DB_LEAVE; return(a1);}  Alternate form */
#    define DB_EXIT { DB_LEAVE; return; }
#    define DB_EXECUTE(keyword,a1) \
	{if (_db_on_) {if (_db_keyword_ (keyword)) { a1 }}}
#    define DB_PRINT(keyword,arglist) \
	{if (_db_on_) {_db_pargs_(__LINE__,keyword); _db_doprnt_ arglist;}}
#    define DB_2(keyword,format) \
	DB_PRINT(keyword,(format))		/* Obsolete */
#    define DB_3(keyword,format,a1) \
	DB_PRINT(keyword,(format,a1))		/* Obsolete */
#    define DB_4(keyword,format,a1,a2) \
	DB_PRINT(keyword,(format,a1,a2))	/* Obsolete */
#    define DB_5(keyword,format,a1,a2,a3) \
	DB_PRINT(keyword,(format,a1,a2,a3))	/* Obsolete */
#    define DB_PUSH(a1) _db_push_ (a1)
#    define DB_POP() _db_pop_ ()
#    define DB_PROCESS(a1) (_db_process_ = a1)
#    define DB_FILE (_db_fp_)
#    define DB_SETJMP(a1) (_db_setjmp_ (), setjmp (a1))
#    define DB_LONGJMP(a1,a2) (_db_longjmp_ (), longjmp (a1, a2))
#endif

