/*
 * Decompiled with CFR 0.152.
 */
package org.mvel2.debug;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.mvel2.ast.ASTNode;
import org.mvel2.ast.BinaryOperation;
import org.mvel2.ast.NestedStatement;
import org.mvel2.ast.Substatement;
import org.mvel2.compiler.CompiledExpression;
import org.mvel2.compiler.ExecutableAccessor;
import org.mvel2.compiler.ExecutableLiteral;
import org.mvel2.integration.VariableResolver;
import org.mvel2.integration.VariableResolverFactory;
import org.mvel2.util.ASTLinkedList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DebugTools {
    public static String decompile(Serializable expr) {
        if (expr instanceof CompiledExpression) {
            return DebugTools.decompile((CompiledExpression)expr);
        }
        if (expr instanceof ExecutableAccessor) {
            return "CANNOT DECOMPILE OPTIMIZED STATEMENT (Run with -Dmvel.optimizer=false)";
        }
        if (expr instanceof ExecutableLiteral) {
            return "LITERAL: " + ((ExecutableLiteral)expr).getValue(null, null);
        }
        return "NOT A KNOWN PAYLOAD: " + expr.getClass().getName();
    }

    public static String decompile(CompiledExpression cExp) {
        return DebugTools.decompile(cExp, false, new DecompileContext());
    }

    private static String decompile(CompiledExpression cExp, boolean nest, DecompileContext context) {
        ASTLinkedList iter = new ASTLinkedList(cExp.getFirstNode());
        StringBuffer sbuf = new StringBuffer();
        if (!nest) {
            sbuf.append("Expression Decompile\n-------------\n");
        }
        while (iter.hasMoreNodes()) {
            sbuf.append("(").append(context.node++).append(") ");
            ASTNode tk = iter.nextNode();
            if (tk instanceof NestedStatement && ((NestedStatement)((Object)tk)).getNestedStatement() instanceof CompiledExpression) {
                sbuf.append("NEST [" + tk.getClass().getSimpleName() + "]: { " + tk.getName() + " }\n");
                sbuf.append(DebugTools.decompile((CompiledExpression)((NestedStatement)((Object)tk)).getNestedStatement(), true, context));
            }
            if (tk instanceof Substatement && ((Substatement)tk).getStatement() instanceof CompiledExpression) {
                sbuf.append("NEST [" + tk.getClass().getSimpleName() + "]: { " + tk.getName() + " }\n");
                sbuf.append(DebugTools.decompile((CompiledExpression)((Substatement)tk).getStatement(), true, context));
            } else if (tk.isDebuggingSymbol()) {
                sbuf.append("DEBUG_SYMBOL :: " + tk.toString());
            } else if (tk.isLiteral()) {
                sbuf.append("LITERAL :: ").append(tk.getLiteralValue()).append("'");
            } else if (tk.isOperator()) {
                sbuf.append("OPERATOR [").append(DebugTools.getOperatorName(tk.getOperator())).append("]: ").append(tk.getName());
                if (tk.isOperator(37)) {
                    sbuf.append("\n");
                }
            } else if (tk.isIdentifier()) {
                sbuf.append("REFERENCE :: ").append(tk.getClass().getSimpleName()).append(":").append(tk.getName());
            } else if (tk instanceof BinaryOperation) {
                BinaryOperation bo = (BinaryOperation)tk;
                sbuf.append("OPERATION [" + DebugTools.getOperatorName(bo.getOperation()) + "] {").append(bo.getLeft().getName()).append("} {").append(bo.getRight().getName()).append("}");
            } else {
                sbuf.append("NODE [" + tk.getClass().getSimpleName() + "] :: " + tk.getName());
            }
            sbuf.append("\n");
        }
        sbuf.append("==END==");
        return sbuf.toString();
    }

    public static String getOperatorSymbol(int operator) {
        switch (operator) {
            case 0: {
                return "+";
            }
            case 1: {
                return "-";
            }
            case 31: {
                return "=";
            }
            case 52: {
                return "=+";
            }
            case 54: {
                return "=+";
            }
            case 53: {
                return "=";
            }
            case 6: {
                return "&";
            }
            case 7: {
                return "|";
            }
            case 10: {
                return "<<";
            }
            case 9: {
                return ">>";
            }
            case 12: {
                return "<<<";
            }
            case 11: {
                return ">>>";
            }
            case 8: {
                return "^";
            }
            case 26: {
                return "contains";
            }
            case 36: {
                return "convertable_to";
            }
            case 51: {
                return "--";
            }
            case 33: {
                return "++";
            }
            case 3: {
                return "/";
            }
            case 45: {
                return "do";
            }
            case 40: {
                return "else";
            }
            case 37: {
                return ";";
            }
            case 18: {
                return "==";
            }
            case 43: {
                return "for";
            }
            case 38: {
                return "foreach";
            }
            case 100: {
                return "function";
            }
            case 17: {
                return ">=";
            }
            case 15: {
                return ">";
            }
            case 39: {
                return "if";
            }
            case 50: {
                return "++";
            }
            case 32: {
                return "++";
            }
            case 25: {
                return "instanceof";
            }
            case 16: {
                return "<=";
            }
            case 14: {
                return "<";
            }
            case 4: {
                return "%";
            }
            case 2: {
                return "*";
            }
            case 19: {
                return "!=";
            }
            case 34: {
                return "new";
            }
            case 21: {
                return "&&";
            }
            case 22: {
                return "||";
            }
            case 5: {
                return "**";
            }
            case 35: {
                return "PROJECT";
            }
            case 24: {
                return "REGEX";
            }
            case 99: {
                return "RETURN";
            }
            case 28: {
                return "SIMILARITY";
            }
            case 27: {
                return "SOUNDEX";
            }
            case 20: {
                return "+";
            }
            case 44: {
                return "SWITCH";
            }
            case 29: {
                return "TERNARY_IF";
            }
            case 30: {
                return "TERNARY_ELSE";
            }
            case 41: {
                return "while";
            }
            case 23: {
                return "or";
            }
        }
        return "UNKNOWN_OPERATOR";
    }

    public static String getOperatorName(int operator) {
        switch (operator) {
            case 0: {
                return "ADD";
            }
            case 1: {
                return "SUBTRACT";
            }
            case 31: {
                return "ASSIGN";
            }
            case 52: {
                return "ASSIGN_ADD";
            }
            case 54: {
                return "ASSIGN_STR_APPEND";
            }
            case 53: {
                return "ASSIGN_SUB";
            }
            case 6: {
                return "BIT_AND";
            }
            case 7: {
                return "BIT_OR";
            }
            case 10: {
                return "BIT_SHIFT_LEFT";
            }
            case 9: {
                return "BIT_SHIFT_RIGHT";
            }
            case 12: {
                return "BIT_UNSIGNED_SHIFT_LEFT";
            }
            case 11: {
                return "BIT_UNSIGNED_SHIFT_RIGHT";
            }
            case 8: {
                return "BIT_XOR";
            }
            case 26: {
                return "CONTAINS";
            }
            case 36: {
                return "CONVERTABLE_TO";
            }
            case 51: {
                return "DECREMENT";
            }
            case 33: {
                return "DECREMENT_ASSIGN";
            }
            case 3: {
                return "DIVIDE";
            }
            case 45: {
                return "DO";
            }
            case 40: {
                return "ELSE";
            }
            case 37: {
                return "END_OF_STATEMENT";
            }
            case 18: {
                return "EQUAL";
            }
            case 43: {
                return "FOR";
            }
            case 38: {
                return "FOREACH";
            }
            case 100: {
                return "FUNCTION";
            }
            case 17: {
                return "GREATER_THAN_OR_EQUAL";
            }
            case 15: {
                return "GREATHER_THAN";
            }
            case 39: {
                return "IF";
            }
            case 50: {
                return "INCREMENT";
            }
            case 32: {
                return "INCREMENT_ASSIGN";
            }
            case 25: {
                return "INSTANCEOF";
            }
            case 16: {
                return "LESS_THAN_OR_EQUAL";
            }
            case 14: {
                return "LESS_THAN";
            }
            case 4: {
                return "MODULUS";
            }
            case 2: {
                return "MULTIPLY";
            }
            case 19: {
                return "NOT_EQUAL";
            }
            case 34: {
                return "NEW_OBJECT";
            }
            case 21: {
                return "AND";
            }
            case 22: {
                return "OR";
            }
            case 5: {
                return "POWER_OF";
            }
            case 35: {
                return "PROJECT";
            }
            case 24: {
                return "REGEX";
            }
            case 99: {
                return "RETURN";
            }
            case 28: {
                return "SIMILARITY";
            }
            case 27: {
                return "SOUNDEX";
            }
            case 20: {
                return "STR_APPEND";
            }
            case 44: {
                return "SWITCH";
            }
            case 29: {
                return "TERNARY_IF";
            }
            case 30: {
                return "TERNARY_ELSE";
            }
            case 41: {
                return "WHILE";
            }
            case 23: {
                return "CHAINED_OR";
            }
        }
        return "UNKNOWN_OPERATOR";
    }

    public static Class determineType(String name, CompiledExpression compiledExpression) {
        ASTLinkedList iter = new ASTLinkedList(compiledExpression.getFirstNode());
        while (iter.hasMoreNodes()) {
            ASTNode node = iter.nextNode();
            if (!name.equals(node.getName()) || !node.isAssignment()) continue;
            return node.getEgressType();
        }
        return null;
    }

    public static Map<String, VariableResolver> getAllVariableResolvers(VariableResolverFactory rootFactory) {
        HashMap<String, VariableResolver> allVariableResolvers = new HashMap<String, VariableResolver>();
        VariableResolverFactory vrf = rootFactory;
        do {
            for (String var : vrf.getKnownVariables()) {
                allVariableResolvers.put(var, vrf.getVariableResolver(var));
            }
        } while ((vrf = vrf.getNextFactory()) != null);
        return allVariableResolvers;
    }

    private static final class DecompileContext {
        public int node = 0;

        private DecompileContext() {
        }
    }
}

