# PySNMP SMI module. Autogenerated from smidump -f python LMP-MIB
# by libsmi2pysnmp-0.1.3 at Mon Apr  2 20:39:16 2012,
# Python version sys.version_info(major=2, minor=7, micro=2, releaselevel='final', serial=0)

# Imports

( Integer, ObjectIdentifier, OctetString, ) = mibBuilder.importSymbols("ASN1", "Integer", "ObjectIdentifier", "OctetString")
( NamedValues, ) = mibBuilder.importSymbols("ASN1-ENUMERATION", "NamedValues")
( ConstraintsIntersection, ConstraintsUnion, SingleValueConstraint, ValueRangeConstraint, ValueSizeConstraint, ) = mibBuilder.importSymbols("ASN1-REFINEMENT", "ConstraintsIntersection", "ConstraintsUnion", "SingleValueConstraint", "ValueRangeConstraint", "ValueSizeConstraint")
( InterfaceIndexOrZero, ifIndex, ) = mibBuilder.importSymbols("IF-MIB", "InterfaceIndexOrZero", "ifIndex")
( InetAddress, InetAddressType, ) = mibBuilder.importSymbols("INET-ADDRESS-MIB", "InetAddress", "InetAddressType")
( ModuleCompliance, NotificationGroup, ObjectGroup, ) = mibBuilder.importSymbols("SNMPv2-CONF", "ModuleCompliance", "NotificationGroup", "ObjectGroup")
( Bits, Counter32, Integer32, ModuleIdentity, MibIdentifier, NotificationType, MibScalar, MibTable, MibTableRow, MibTableColumn, TimeTicks, TimeTicks, Unsigned32, transmission, ) = mibBuilder.importSymbols("SNMPv2-SMI", "Bits", "Counter32", "Integer32", "ModuleIdentity", "MibIdentifier", "NotificationType", "MibScalar", "MibTable", "MibTableRow", "MibTableColumn", "TimeTicks", "TimeTicks", "Unsigned32", "transmission")
( RowStatus, StorageType, TextualConvention, TimeStamp, TruthValue, ) = mibBuilder.importSymbols("SNMPv2-TC", "RowStatus", "StorageType", "TextualConvention", "TimeStamp", "TruthValue")
( TeLinkEncodingType, teLinkIncomingIfId, teLinkRemoteIpAddr, ) = mibBuilder.importSymbols("TE-LINK-STD-MIB", "TeLinkEncodingType", "teLinkIncomingIfId", "teLinkRemoteIpAddr")

# Types

class LmpInterval(TextualConvention, Unsigned32):
    displayHint = "d"
    subtypeSpec = Unsigned32.subtypeSpec+ValueRangeConstraint(1,65535)
    
class LmpNodeId(TextualConvention, OctetString):
    displayHint = "1d.1d.1d.1d"
    subtypeSpec = OctetString.subtypeSpec+ValueSizeConstraint(4,4)
    fixedLength = 4
    
class LmpRetransmitInterval(TextualConvention, Unsigned32):
    displayHint = "d"
    subtypeSpec = Unsigned32.subtypeSpec+ValueRangeConstraint(1,4294967295)
    

# Objects

lmpMIB = ModuleIdentity((1, 3, 6, 1, 2, 1, 10, 227)).setRevisions(("2006-08-14 00:00","2006-01-11 00:00",))
if mibBuilder.loadTexts: lmpMIB.setOrganization("Common Control and Measurement Protocols (CCAMP)\nWorking Group")
if mibBuilder.loadTexts: lmpMIB.setContactInfo("        Martin Dubuc\nEmail:  dubuc.consulting@sympatico.ca\n\n        Thomas D. Nadeau\nEmail:  tnadeau@cisco.com\n\n        Jonathan P. Lang\nEmail:  jplang@ieee.org\n\n        Evan McGinnis\nEmail:  emcginnis@hammerheadsystems.com\n\n        Adrian Farrel\nEmail:  adrian@olddog.co.uk")
if mibBuilder.loadTexts: lmpMIB.setDescription("Copyright (C) 2006 The Internet Society.  This version of\nthe MIB module is part of RFC 4631; see the RFC itself\nfor full legal notices.\n\nThis MIB module contains managed object definitions for\nthe Link Management Protocol (LMP) as\ndefined in 'Link Management Protocol'.")
lmpNotifications = MibIdentifier((1, 3, 6, 1, 2, 1, 10, 227, 0))
lmpObjects = MibIdentifier((1, 3, 6, 1, 2, 1, 10, 227, 1))
lmpAdminStatus = MibScalar((1, 3, 6, 1, 2, 1, 10, 227, 1, 1), Integer().subtype(subtypeSpec=SingleValueConstraint(2,1,)).subtype(namedValues=NamedValues(("up", 1), ("down", 2), )).clone(1)).setMaxAccess("readwrite")
if mibBuilder.loadTexts: lmpAdminStatus.setDescription("The desired operational status of LMP on the node.\n\n\n\nImplementations should save the value of this object in\npersistent memory so that it survives restarts or reboot.")
lmpOperStatus = MibScalar((1, 3, 6, 1, 2, 1, 10, 227, 1, 2), Integer().subtype(subtypeSpec=SingleValueConstraint(2,1,)).subtype(namedValues=NamedValues(("up", 1), ("down", 2), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: lmpOperStatus.setDescription("The actual operational status of LMP on the node.")
lmpNbrTable = MibTable((1, 3, 6, 1, 2, 1, 10, 227, 1, 3))
if mibBuilder.loadTexts: lmpNbrTable.setDescription("This table specifies the neighbor node(s) to which control\nchannels may be established.")
lmpNbrEntry = MibTableRow((1, 3, 6, 1, 2, 1, 10, 227, 1, 3, 1)).setIndexNames((0, "LMP-MIB", "lmpNbrNodeId"))
if mibBuilder.loadTexts: lmpNbrEntry.setDescription("An entry in this table is created by a LMP-enabled device for\nevery pair of nodes that can establish control channels.")
lmpNbrNodeId = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 227, 1, 3, 1, 1), LmpNodeId()).setMaxAccess("noaccess")
if mibBuilder.loadTexts: lmpNbrNodeId.setDescription("This is a unique index for an entry in the LmpNbrTable.\nThis value represents the remote Node ID.")
lmpNbrRetransmitInterval = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 227, 1, 3, 1, 2), LmpRetransmitInterval().clone('500')).setMaxAccess("readcreate")
if mibBuilder.loadTexts: lmpNbrRetransmitInterval.setDescription("This object specifies the initial retransmission interval that\nis used for the retransmission of messages that require\nacknowledgement.  This object, along with lmpNbrRetryLimit,\nis used to implement the congestion-handling mechanism defined\nin Section 10 of the Link Management Protocol specification,\nwhich is based on RFC 2914.")
lmpNbrRetryLimit = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 227, 1, 3, 1, 3), Unsigned32().clone(3)).setMaxAccess("readcreate")
if mibBuilder.loadTexts: lmpNbrRetryLimit.setDescription("This object specifies the maximum number of times a message\nis transmitted without being acknowledged.  A value of 0 is used\nto indicate that a node should never stop retransmission.\nThis object, along with lmpNbrRetransmitInterval, is\nused to implement the congestion-handling mechanism as defined\nin Section 10 of the Link Management Protocol specification,\nwhich is based on RFC 2914.")
lmpNbrRetransmitDelta = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 227, 1, 3, 1, 4), Unsigned32().clone(1)).setMaxAccess("readcreate")
if mibBuilder.loadTexts: lmpNbrRetransmitDelta.setDescription("This object governs the speed with which the sender increases\nthe retransmission interval, as explained in Section 10 of the\nLink Management Protocol specification, which is based on\nRFC 2914.  This value is a power used to express the\nexponential backoff.  The ratio of two successive retransmission\nintervals is (1 + Delta).")
lmpNbrAdminStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 227, 1, 3, 1, 5), Integer().subtype(subtypeSpec=SingleValueConstraint(2,1,)).subtype(namedValues=NamedValues(("up", 1), ("down", 2), ))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: lmpNbrAdminStatus.setDescription("The desired operational status of LMP to this remote node.")
lmpNbrOperStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 227, 1, 3, 1, 6), Integer().subtype(subtypeSpec=SingleValueConstraint(2,1,)).subtype(namedValues=NamedValues(("up", 1), ("down", 2), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: lmpNbrOperStatus.setDescription("The actual operational status of LMP to this remote node.")
lmpNbrRowStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 227, 1, 3, 1, 7), RowStatus()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: lmpNbrRowStatus.setDescription("This variable is used to create, modify, and/or\ndelete a row in this table.  None of the writable objects\nin a row can be changed if the status is active(1).\nAll read-create objects must have valid and consistent\nvalues before the row can be activated.")
lmpNbrStorageType = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 227, 1, 3, 1, 8), StorageType().clone('nonVolatile')).setMaxAccess("readcreate")
if mibBuilder.loadTexts: lmpNbrStorageType.setDescription("The storage type for this conceptual row in the\nlmpNbrTable.  Conceptual rows having the value\n'permanent' need not allow write-access to any\n\n\n\ncolumnar object in the row.")
lmpCcHelloIntervalDefault = MibScalar((1, 3, 6, 1, 2, 1, 10, 227, 1, 4), LmpInterval()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: lmpCcHelloIntervalDefault.setDescription("This object specifies the default value for the HelloInterval\nparameter used in the Hello protocol keep-alive phase.  It\nindicates how frequently LMP Hello messages will be sent.  It\nis used as the default value for lmpCcHelloInterval.\nImplementations should save the value of this object in\npersistent memory so that it survives restarts or reboot.")
lmpCcHelloIntervalDefaultMin = MibScalar((1, 3, 6, 1, 2, 1, 10, 227, 1, 5), LmpInterval()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: lmpCcHelloIntervalDefaultMin.setDescription("This object specifies the default minimum value for the\nHelloInterval parameter.  It is used as a default value\nfor lmpCcHelloIntervalMin.  Implementations should save the\nvalue of this object in persistent memory so that it survives\nrestarts or reboot.")
lmpCcHelloIntervalDefaultMax = MibScalar((1, 3, 6, 1, 2, 1, 10, 227, 1, 6), LmpInterval()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: lmpCcHelloIntervalDefaultMax.setDescription("This object specifies the default maximum value for the\nHelloInterval parameter.  It is used as a default value\nfor lmpCcHelloIntervalMax.  Implementations should save the\nvalue of this object in persistent memory so that it survives\nrestarts or reboot.")
lmpCcHelloDeadIntervalDefault = MibScalar((1, 3, 6, 1, 2, 1, 10, 227, 1, 7), LmpInterval()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: lmpCcHelloDeadIntervalDefault.setDescription("This object specifies the default HelloDeadInterval parameter\nto use in the Hello protocol keep-alive phase.  It indicates\nhow long a device should wait before declaring the control\nchannel dead.  The HelloDeadInterval parameter should be at\nleast three times the value of HelloInterval.  It is used as\na default value for lmpCcHelloDeadInterval.  Implementations\nshould save the value of this object in persistent memory so\nthat it survives restarts or reboot.")
lmpCcHelloDeadIntervalDefaultMin = MibScalar((1, 3, 6, 1, 2, 1, 10, 227, 1, 8), LmpInterval()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: lmpCcHelloDeadIntervalDefaultMin.setDescription("This object specifies the default minimum value for the\nHelloDeadInterval parameter.  It is used as a default value\nfor lmpCcHelloDeadIntervalMin.  Implementations should save\nthe value of this object in persistent memory so that it\nsurvives restarts or reboot.")
lmpCcHelloDeadIntervalDefaultMax = MibScalar((1, 3, 6, 1, 2, 1, 10, 227, 1, 9), LmpInterval()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: lmpCcHelloDeadIntervalDefaultMax.setDescription("This object specifies the default maximum value for the\nHelloDeadInterval parameter.  It is used as a default value\nfor lmpCcHelloDeadIntervalMax.  Implementations should save the\nvalue of this object in persistent memory so that it survives\nrestarts or reboot.")
lmpControlChannelTable = MibTable((1, 3, 6, 1, 2, 1, 10, 227, 1, 10))
if mibBuilder.loadTexts: lmpControlChannelTable.setDescription("This table specifies LMP control channel information.")
lmpControlChannelEntry = MibTableRow((1, 3, 6, 1, 2, 1, 10, 227, 1, 10, 1)).setIndexNames((0, "LMP-MIB", "lmpCcId"))
if mibBuilder.loadTexts: lmpControlChannelEntry.setDescription("An entry in this table is created by an LMP-enabled device for\nevery control channel.  Whenever a new entry is created with\nlmpCcIsIf set to true(1), a corresponding entry is\ncreated in ifTable as well (see RFC 2863).")
lmpCcId = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 227, 1, 10, 1, 1), Unsigned32().subtype(subtypeSpec=ValueRangeConstraint(1, 4294967295))).setMaxAccess("noaccess")
if mibBuilder.loadTexts: lmpCcId.setDescription("This value represents the local control channel identifier.\nThe control channel identifier is a non-zero 32-bit number.")
lmpCcUnderlyingIfIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 227, 1, 10, 1, 2), InterfaceIndexOrZero()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: lmpCcUnderlyingIfIndex.setDescription("If lmpCcIsIf is set to true(1), this object carries the\nindex into the ifTable of the entry that represents the\nLMP interface over which LMP will transmit its traffic.\nIf this object is set to zero but lmpCcIsIf is set to\ntrue(1), the control channel is not currently associated\nwith any underlying interface, and the control channel's\noperational status must not be up(1); nor should the\ncontrol channel forward or receive traffic.\nIf lmpCcIsIf is set to false(2), this object should be set\nto zero and ignored.")
lmpCcIsIf = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 227, 1, 10, 1, 3), TruthValue()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: lmpCcIsIf.setDescription("In implementations where the control channels are modeled\nas interfaces, the value of this object is true(1), and\nthis control channel is represented by an interface in\nthe interfaces group table as indicated by the value of\nlmpCcUnderlyingIfIndex.  If control channels are not\nmodeled as interfaces, the value of this object is\nfalse(2), and there is no corresponding interface for\nthis control channel in the interfaces group table;\nthe value of lmpCcUnderlyingIfIndex should be\nignored.")
lmpCcNbrNodeId = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 227, 1, 10, 1, 4), LmpNodeId()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: lmpCcNbrNodeId.setDescription("This is the Node ID of the control channel remote node.\nThis value either is configured or gets created by the node\nwhen a Config message is received or when an outgoing Config\nmessage is acknowledged by the remote node.")
lmpCcRemoteId = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 227, 1, 10, 1, 5), Unsigned32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: lmpCcRemoteId.setDescription("This value represents the remote control channel identifier\n(32-bit number).  It is determined during the negotiation\nphase.  A value of zero means that the remote control channel\nidentifier has not yet been learned.")
lmpCcRemoteAddressType = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 227, 1, 10, 1, 6), InetAddressType()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: lmpCcRemoteAddressType.setDescription("This value represents the remote control channel IP address\ntype.  In point-to-point configuration, this value can be set\nto unknown(0).")
lmpCcRemoteIpAddr = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 227, 1, 10, 1, 7), InetAddress()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: lmpCcRemoteIpAddr.setDescription("This value represents the remote control channel Internet\naddress for numbered control channel.  The type of this\naddress is determined by lmpCcRemoteAddressType.\nThe control channel must be numbered on non-point-to-point\nconfiguration.  For point-to-point configuration, the\nremote control channel address can be of type unknown,\nin which case this object must be a zero-length string.  The\nlmpCcRemoteId object then identifies the unnumbered\naddress.")
lmpCcSetupRole = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 227, 1, 10, 1, 8), Integer().subtype(subtypeSpec=SingleValueConstraint(1,2,)).subtype(namedValues=NamedValues(("active", 1), ("passive", 2), )).clone(1)).setMaxAccess("readcreate")
if mibBuilder.loadTexts: lmpCcSetupRole.setDescription("The role that this node should take during establishment\nof this control channel.  An active node will initiate\nestablishment.  A passive node will wait for the remote node\nto initiate.  A pair of nodes that both take the passive role\nwill never establish communications.")
lmpCcAuthentication = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 227, 1, 10, 1, 9), TruthValue()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: lmpCcAuthentication.setDescription("This object indicates whether the control channel must use\nauthentication.")
lmpCcHelloInterval = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 227, 1, 10, 1, 10), LmpInterval()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: lmpCcHelloInterval.setDescription("This object specifies the value of the HelloInterval\nparameter.  The default value for this object should be\nset to lmpCcHelloIntervalDefault.")
lmpCcHelloIntervalMin = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 227, 1, 10, 1, 11), LmpInterval()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: lmpCcHelloIntervalMin.setDescription("This object specifies the minimum value for the\nHelloInterval parameter.  The default value for this\nobject should be set to lmpCcHelloIntervalMinDefault.")
lmpCcHelloIntervalMax = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 227, 1, 10, 1, 12), LmpInterval()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: lmpCcHelloIntervalMax.setDescription("This object specifies the maximum value for the\nHelloInterval parameter.  The default value for this\nobject should be set to lmpCcHelloIntervalMaxDefault.")
lmpCcHelloIntervalNegotiated = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 227, 1, 10, 1, 13), LmpInterval()).setMaxAccess("readonly")
if mibBuilder.loadTexts: lmpCcHelloIntervalNegotiated.setDescription("Once the control channel is active, this object represents\nthe negotiated HelloInterval value.")
lmpCcHelloDeadInterval = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 227, 1, 10, 1, 14), LmpInterval()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: lmpCcHelloDeadInterval.setDescription("This object specifies the value of the HelloDeadInterval\nparameter.  The default value for this object should be\nset to lmpCcHelloDeadIntervalDefault.")
lmpCcHelloDeadIntervalMin = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 227, 1, 10, 1, 15), LmpInterval()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: lmpCcHelloDeadIntervalMin.setDescription("This object specifies the minimum value for the\nHelloDeadInterval parameter.  The default value for this\nobject should be set to lmpCcHelloDeadIntervalMinDefault.")
lmpCcHelloDeadIntervalMax = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 227, 1, 10, 1, 16), LmpInterval()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: lmpCcHelloDeadIntervalMax.setDescription("This object specifies the maximum value for the\nHelloDeadInterval parameter.  The default value for this\nobject should be set to lmpCcHelloIntervalMaxDefault.")
lmpCcHelloDeadIntervalNegotiated = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 227, 1, 10, 1, 17), LmpInterval()).setMaxAccess("readonly")
if mibBuilder.loadTexts: lmpCcHelloDeadIntervalNegotiated.setDescription("Once the control channel is active, this object represents\nthe negotiated HelloDeadInterval value.")
lmpCcLastChange = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 227, 1, 10, 1, 18), TimeTicks()).setMaxAccess("readonly")
if mibBuilder.loadTexts: lmpCcLastChange.setDescription("The value of sysUpTime at the time the control channel entered\nits current operational state.  If the current state was\nentered prior to the last re-initialization of the local\nnetwork management subsystem, then this object contains a\nzero value.")
lmpCcAdminStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 227, 1, 10, 1, 19), Integer().subtype(subtypeSpec=SingleValueConstraint(2,1,)).subtype(namedValues=NamedValues(("up", 1), ("down", 2), ))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: lmpCcAdminStatus.setDescription("The desired operational status of this control channel.")
lmpCcOperStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 227, 1, 10, 1, 20), Integer().subtype(subtypeSpec=SingleValueConstraint(3,6,1,2,5,4,)).subtype(namedValues=NamedValues(("up", 1), ("down", 2), ("configSnd", 3), ("configRcv", 4), ("active", 5), ("goingDown", 6), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: lmpCcOperStatus.setDescription("The actual operational status of this control channel.")
lmpCcRowStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 227, 1, 10, 1, 21), RowStatus()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: lmpCcRowStatus.setDescription("This variable is used to create, modify, and/or\ndelete a row in this table.  None of the writable objects\nin a row can be changed if the status is active(1).\nAll read-create objects must have valid and consistent\nvalues before the row can be activated.")
lmpCcStorageType = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 227, 1, 10, 1, 22), StorageType().clone('nonVolatile')).setMaxAccess("readcreate")
if mibBuilder.loadTexts: lmpCcStorageType.setDescription("The storage type for this conceptual row in the\nlmpControlChannelTable.  Conceptual rows having the value\n'permanent' need not allow write-access to any\ncolumnar object in the row.")
lmpControlChannelPerfTable = MibTable((1, 3, 6, 1, 2, 1, 10, 227, 1, 11))
if mibBuilder.loadTexts: lmpControlChannelPerfTable.setDescription("This table specifies LMP control channel performance\ncounters.")
lmpControlChannelPerfEntry = MibTableRow((1, 3, 6, 1, 2, 1, 10, 227, 1, 11, 1)).setIndexNames((0, "LMP-MIB", "lmpCcId"))
if mibBuilder.loadTexts: lmpControlChannelPerfEntry.setDescription("An entry in this table is created by a LMP-enabled device for\nevery control channel.  lmpCcCounterDiscontinuityTime is used\nto indicate potential discontinuity for all counter objects\nin this table.")
lmpCcInOctets = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 227, 1, 11, 1, 1), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: lmpCcInOctets.setDescription("The total number of LMP message octets received on the\ncontrol channel.")
lmpCcInDiscards = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 227, 1, 11, 1, 2), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: lmpCcInDiscards.setDescription("The number of inbound packets that were chosen to be\ndiscarded even though no errors had been detected.  One\npossible reason for discarding such a packet could be to\nfree up buffer space.")
lmpCcInErrors = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 227, 1, 11, 1, 3), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: lmpCcInErrors.setDescription("The number of inbound packets that contained errors\npreventing them from being processed by LMP.")
lmpCcOutOctets = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 227, 1, 11, 1, 4), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: lmpCcOutOctets.setDescription("The total number of LMP message octets transmitted out of\nthe control channel.")
lmpCcOutDiscards = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 227, 1, 11, 1, 5), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: lmpCcOutDiscards.setDescription("The number of outbound packets that were chosen to be\ndiscarded even though no errors had been detected to\nprevent their being transmitted.  One possible reason\nfor discarding such a packet could be to free up buffer\nspace.")
lmpCcOutErrors = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 227, 1, 11, 1, 6), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: lmpCcOutErrors.setDescription("The number of outbound packets that could not be\ntransmitted because of errors.")
lmpCcConfigReceived = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 227, 1, 11, 1, 7), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: lmpCcConfigReceived.setDescription("This object counts the number of Config messages that have\nbeen received on this control channel.")
lmpCcConfigSent = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 227, 1, 11, 1, 8), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: lmpCcConfigSent.setDescription("This object counts the number of Config messages that have\nbeen sent on this control channel.")
lmpCcConfigRetransmit = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 227, 1, 11, 1, 9), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: lmpCcConfigRetransmit.setDescription("This object counts the number of Config messages that\nhave been retransmitted over this control channel.")
lmpCcConfigAckReceived = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 227, 1, 11, 1, 10), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: lmpCcConfigAckReceived.setDescription("This object counts the number of ConfigAck messages that have\nbeen received on this control channel.")
lmpCcConfigAckSent = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 227, 1, 11, 1, 11), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: lmpCcConfigAckSent.setDescription("This object counts the number of ConfigAck messages that have\nbeen sent on this control channel.")
lmpCcConfigNackReceived = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 227, 1, 11, 1, 12), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: lmpCcConfigNackReceived.setDescription("This object counts the number of ConfigNack messages that have\nbeen received on this control channel.")
lmpCcConfigNackSent = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 227, 1, 11, 1, 13), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: lmpCcConfigNackSent.setDescription("This object counts the number of ConfigNack messages that have\nbeen sent on this control channel.")
lmpCcHelloReceived = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 227, 1, 11, 1, 14), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: lmpCcHelloReceived.setDescription("This object counts the number of Hello messages that have\nbeen received on this control channel.")
lmpCcHelloSent = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 227, 1, 11, 1, 15), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: lmpCcHelloSent.setDescription("This object counts the number of Hello messages that have\nbeen sent on this control channel.")
lmpCcBeginVerifyReceived = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 227, 1, 11, 1, 16), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: lmpCcBeginVerifyReceived.setDescription("This object counts the number of BeginVerify messages that have\nbeen received on this control channel.")
lmpCcBeginVerifySent = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 227, 1, 11, 1, 17), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: lmpCcBeginVerifySent.setDescription("This object counts the number of BeginVerify messages that have\nbeen sent on this control channel.")
lmpCcBeginVerifyRetransmit = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 227, 1, 11, 1, 18), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: lmpCcBeginVerifyRetransmit.setDescription("This object counts the number of BeginVerify messages that\nhave been retransmitted over this control channel.")
lmpCcBeginVerifyAckReceived = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 227, 1, 11, 1, 19), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: lmpCcBeginVerifyAckReceived.setDescription("This object counts the number of BeginVerifyAck messages that\nhave been received on this control channel.")
lmpCcBeginVerifyAckSent = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 227, 1, 11, 1, 20), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: lmpCcBeginVerifyAckSent.setDescription("This object counts the number of BeginVerifyAck messages that\nhave been sent on this control channel.")
lmpCcBeginVerifyNackReceived = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 227, 1, 11, 1, 21), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: lmpCcBeginVerifyNackReceived.setDescription("This object counts the number of BeginVerifyNack messages that\nhave been received on this control channel.")
lmpCcBeginVerifyNackSent = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 227, 1, 11, 1, 22), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: lmpCcBeginVerifyNackSent.setDescription("This object counts the number of BeginVerifyNack messages that\nhave been sent on this control channel.")
lmpCcEndVerifyReceived = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 227, 1, 11, 1, 23), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: lmpCcEndVerifyReceived.setDescription("This object counts the number of EndVerify messages that have\nbeen received on this control channel.")
lmpCcEndVerifySent = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 227, 1, 11, 1, 24), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: lmpCcEndVerifySent.setDescription("This object counts the number of EndVerify messages that have\nbeen sent on this control channel.")
lmpCcEndVerifyRetransmit = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 227, 1, 11, 1, 25), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: lmpCcEndVerifyRetransmit.setDescription("This object counts the number of EndVerify messages that\nhave been retransmitted over this control channel.")
lmpCcEndVerifyAckReceived = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 227, 1, 11, 1, 26), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: lmpCcEndVerifyAckReceived.setDescription("This object counts the number of EndVerifyAck messages that\nhave been received on this control channel.")
lmpCcEndVerifyAckSent = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 227, 1, 11, 1, 27), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: lmpCcEndVerifyAckSent.setDescription("This object counts the number of EndVerifyAck messages that\nhave been sent on this control channel.")
lmpCcTestStatusSuccessReceived = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 227, 1, 11, 1, 28), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: lmpCcTestStatusSuccessReceived.setDescription("This object counts the number of TestStatusSuccess messages\nthat have been received on this control channel.")
lmpCcTestStatusSuccessSent = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 227, 1, 11, 1, 29), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: lmpCcTestStatusSuccessSent.setDescription("This object counts the number of TestStatusSuccess messages\nthat have been sent on this control channel.")
lmpCcTestStatusSuccessRetransmit = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 227, 1, 11, 1, 30), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: lmpCcTestStatusSuccessRetransmit.setDescription("This object counts the number of TestStatusSuccess messages\nthat have been retransmitted over this control channel.")
lmpCcTestStatusFailureReceived = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 227, 1, 11, 1, 31), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: lmpCcTestStatusFailureReceived.setDescription("This object counts the number of TestStatusFailure messages\nthat have been received on this control channel.")
lmpCcTestStatusFailureSent = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 227, 1, 11, 1, 32), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: lmpCcTestStatusFailureSent.setDescription("This object counts the number of TestStatusFailure messages\nthat have been sent on this control channel.")
lmpCcTestStatusFailureRetransmit = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 227, 1, 11, 1, 33), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: lmpCcTestStatusFailureRetransmit.setDescription("This object counts the number of TestStatusFailure messages\nthat have been retransmitted over this control channel.")
lmpCcTestStatusAckReceived = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 227, 1, 11, 1, 34), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: lmpCcTestStatusAckReceived.setDescription("This object counts the number of TestStatusAck messages\nthat have been received on this control channel.")
lmpCcTestStatusAckSent = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 227, 1, 11, 1, 35), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: lmpCcTestStatusAckSent.setDescription("This object counts the number of TestStatusAck messages\nthat have been sent on this control channel.")
lmpCcLinkSummaryReceived = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 227, 1, 11, 1, 36), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: lmpCcLinkSummaryReceived.setDescription("This object counts the number of LinkSummary messages\nthat have been received on this control channel.")
lmpCcLinkSummarySent = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 227, 1, 11, 1, 37), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: lmpCcLinkSummarySent.setDescription("This object counts the number of LinkSummary messages\nthat have been sent on this control channel.")
lmpCcLinkSummaryRetransmit = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 227, 1, 11, 1, 38), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: lmpCcLinkSummaryRetransmit.setDescription("This object counts the number of LinkSummary messages that\nhave been retransmitted over this control channel.")
lmpCcLinkSummaryAckReceived = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 227, 1, 11, 1, 39), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: lmpCcLinkSummaryAckReceived.setDescription("This object counts the number of LinkSummaryAck messages\nthat have been received on this control channel.")
lmpCcLinkSummaryAckSent = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 227, 1, 11, 1, 40), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: lmpCcLinkSummaryAckSent.setDescription("This object counts the number of LinkSummaryAck messages\nthat have been sent on this control channel.")
lmpCcLinkSummaryNackReceived = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 227, 1, 11, 1, 41), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: lmpCcLinkSummaryNackReceived.setDescription("This object counts the number of LinkSummaryNack messages\nthat have been received on this control channel.")
lmpCcLinkSummaryNackSent = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 227, 1, 11, 1, 42), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: lmpCcLinkSummaryNackSent.setDescription("This object counts the number of LinkSummaryNack messages\nthat have been sent on this control channel.")
lmpCcChannelStatusReceived = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 227, 1, 11, 1, 43), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: lmpCcChannelStatusReceived.setDescription("This object counts the number of ChannelStatus messages\nthat have been received on this control channel.")
lmpCcChannelStatusSent = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 227, 1, 11, 1, 44), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: lmpCcChannelStatusSent.setDescription("This object counts the number of ChannelStatus messages\nthat have been sent on this control channel.")
lmpCcChannelStatusRetransmit = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 227, 1, 11, 1, 45), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: lmpCcChannelStatusRetransmit.setDescription("This object counts the number of ChannelStatus messages\nthat have been retransmitted on this control channel.")
lmpCcChannelStatusAckReceived = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 227, 1, 11, 1, 46), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: lmpCcChannelStatusAckReceived.setDescription("This object counts the number of ChannelStatusAck messages\nthat have been received on this control channel.")
lmpCcChannelStatusAckSent = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 227, 1, 11, 1, 47), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: lmpCcChannelStatusAckSent.setDescription("This object counts the number of ChannelStatus messages\nthat have been sent on this control channel.")
lmpCcChannelStatusReqReceived = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 227, 1, 11, 1, 48), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: lmpCcChannelStatusReqReceived.setDescription("This object counts the number of ChannelStatusRequest messages\nthat have been received on this control channel.")
lmpCcChannelStatusReqSent = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 227, 1, 11, 1, 49), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: lmpCcChannelStatusReqSent.setDescription("This object counts the number of ChannelStatusRequest messages\nthat have been sent on this control channel.")
lmpCcChannelStatusReqRetransmit = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 227, 1, 11, 1, 50), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: lmpCcChannelStatusReqRetransmit.setDescription("This object counts the number of ChannelStatusRequest messages\nthat have been retransmitted on this control channel.")
lmpCcChannelStatusRspReceived = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 227, 1, 11, 1, 51), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: lmpCcChannelStatusRspReceived.setDescription("This object counts the number of ChannelStatusResponse messages\nthat have been received on this control channel.")
lmpCcChannelStatusRspSent = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 227, 1, 11, 1, 52), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: lmpCcChannelStatusRspSent.setDescription("This object counts the number of ChannelStatusResponse messages\nthat have been sent on this control channel.")
lmpCcCounterDiscontinuityTime = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 227, 1, 11, 1, 53), TimeStamp()).setMaxAccess("readonly")
if mibBuilder.loadTexts: lmpCcCounterDiscontinuityTime.setDescription("The value of sysUpTime on the most recent occasion at which\none or more of this control channel's counters suffered a\ndiscontinuity.  The relevant counters are the specific\ninstances associated with this control channel of any\nCounter32 object contained in the lmpControlChannelPerfTable.\nIf no such discontinuities have occurred since the last re-\ninitialization of the local management subsystem, then this\nobject contains a zero value.")
lmpTeLinkTable = MibTable((1, 3, 6, 1, 2, 1, 10, 227, 1, 12))
if mibBuilder.loadTexts: lmpTeLinkTable.setDescription("This table specifies the LMP-specific TE link information.\nOverall TE link information is kept in three separate tables:\nifTable for interface-specific information, lmpTeLinkTable\nfor LMP specific information, and teLinkTable for generic\nTE link information.  ifIndex is the common index to all\ntables.")
lmpTeLinkEntry = MibTableRow((1, 3, 6, 1, 2, 1, 10, 227, 1, 12, 1)).setIndexNames((0, "IF-MIB", "ifIndex"))
if mibBuilder.loadTexts: lmpTeLinkEntry.setDescription("An entry in this table exists for each ifEntry with an\nifType of teLink(200) that is managed by LMP.  An ifEntry with\nan ifIndex must exist before the corresponding lmpTeLinkEntry is\ncreated.  If a TE link entry in the ifTable is destroyed, then\nso is the corresponding entry in the lmpTeLinkTable.  The\nadministrative status value is controlled from the ifEntry.\nSetting the administrative status to testing prompts LMP to\nstart link verification on the TE link.  Information about the\nTE link that is not LMP specific is contained in the\nteLinkTable of the TE-LINK-STD-MIB MIB module.")
lmpTeLinkNbrRemoteNodeId = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 227, 1, 12, 1, 1), LmpNodeId()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: lmpTeLinkNbrRemoteNodeId.setDescription("This is the Node ID of the TE link remote node.  This value\nmay be learned during the control channel parameter negotiation\n\n\n\nphase (in the Config message).  Node ID is an address whose\ntype must be IPv4.")
lmpTeLinkVerification = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 227, 1, 12, 1, 2), TruthValue()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: lmpTeLinkVerification.setDescription("This object indicates whether the LMP link verification\nprocedure is enabled for this TE link.")
lmpTeLinkFaultManagement = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 227, 1, 12, 1, 3), TruthValue()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: lmpTeLinkFaultManagement.setDescription("This object indicates whether the LMP fault management procedure\nis enabled on this TE link.")
lmpTeLinkDwdm = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 227, 1, 12, 1, 4), TruthValue()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: lmpTeLinkDwdm.setDescription("This object indicates whether the LMP DWDM procedure is enabled\non this TE link.")
lmpTeLinkOperStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 227, 1, 12, 1, 5), Integer().subtype(subtypeSpec=SingleValueConstraint(3,1,2,4,5,)).subtype(namedValues=NamedValues(("up", 1), ("down", 2), ("testing", 3), ("init", 4), ("degraded", 5), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: lmpTeLinkOperStatus.setDescription("The actual operational status of this TE link.  The status\nis set to testing when the TE link is performing link\nverification.  A degraded state indicates that there is\n\n\n\nno active control channel between the pair of nodes that\nform the endpoints of the TE link, but that at least one\ndata-bearing link on the TE link is allocated.")
lmpTeLinkRowStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 227, 1, 12, 1, 6), RowStatus()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: lmpTeLinkRowStatus.setDescription("This variable is used to create, modify, and/or\ndelete a row in this table.  None of the writable objects\nin a row can be changed if the status is active(1).\nAll read-create objects must have valid and consistent\nvalues before the row can be activated.")
lmpTeLinkStorageType = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 227, 1, 12, 1, 7), StorageType().clone('nonVolatile')).setMaxAccess("readcreate")
if mibBuilder.loadTexts: lmpTeLinkStorageType.setDescription("The storage type for this conceptual row in the\nlmpTeLinkTable.  Conceptual rows having the value\n'permanent' need not allow write-access to any\ncolumnar object in the row.")
lmpGlobalLinkVerificationInterval = MibScalar((1, 3, 6, 1, 2, 1, 10, 227, 1, 13), Unsigned32()).setMaxAccess("readwrite").setUnits("milliseconds")
if mibBuilder.loadTexts: lmpGlobalLinkVerificationInterval.setDescription("This object indicates how often the link verification\nprocedure is executed.  The interval is in milliseconds.\nA value of 0 is used to indicate that the link\nverification procedure should not be executed.  The\ninterval specified in this object should be large enough\nto allow the verification procedure to be completed\nbefore the start of the next interval.\nImplementations should save the value of this object in\npersistent memory so that it survives restarts or reboot.")
lmpLinkVerificationTable = MibTable((1, 3, 6, 1, 2, 1, 10, 227, 1, 14))
if mibBuilder.loadTexts: lmpLinkVerificationTable.setDescription("This table specifies TE link information associated with the\nLMP verification procedure.")
lmpLinkVerificationEntry = MibTableRow((1, 3, 6, 1, 2, 1, 10, 227, 1, 14, 1)).setIndexNames((0, "IF-MIB", "ifIndex"))
if mibBuilder.loadTexts: lmpLinkVerificationEntry.setDescription("An entry in this table is created by an LMP-enabled device for\nevery TE link that supports the LMP verification\nprocedure.")
lmpLinkVerifyInterval = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 227, 1, 14, 1, 1), LmpInterval()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: lmpLinkVerifyInterval.setDescription("This object specifies the VerifyInterval parameter used\nin the LMP link verification process.  It indicates the\ninterval at which the Test messages are sent.")
lmpLinkVerifyDeadInterval = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 227, 1, 14, 1, 2), LmpInterval()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: lmpLinkVerifyDeadInterval.setDescription("This object specifies the VerifyDeadInterval parameter used\nin the verification of the physical connectivity of data-\nbearing links.  It specifies the observation period used to\ndetect a Test message at the remote node.")
lmpLinkVerifyTransportMechanism = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 227, 1, 14, 1, 3), Bits().subtype(namedValues=NamedValues(("payload", 0), ("dccSectionOverheadBytes", 1), ("dccLineOverheadBytes", 2), ("j0Trace", 3), ("j1Trace", 4), ("j2Trace", 5), ))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: lmpLinkVerifyTransportMechanism.setDescription("This defines the transport mechanism for the Test messages.  The\nscope of this bit mask is restricted to each link encoding\ntype.  The local node will set the bits corresponding to the\nvarious mechanisms it can support for transmitting LMP Test\nmessages.  The receiver chooses the appropriate mechanism in the\nBeginVerifyAck message.")
lmpLinkVerifyAllLinks = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 227, 1, 14, 1, 4), TruthValue()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: lmpLinkVerifyAllLinks.setDescription("A value of true(1) for this object indicates that the\nverification process checks all unallocated links; otherwise,\nonly the new ports or component links that have been added to\nthis TE link are verified.")
lmpLinkVerifyTransmissionRate = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 227, 1, 14, 1, 5), Unsigned32()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: lmpLinkVerifyTransmissionRate.setDescription("This is the transmission rate of the data link over which\nthe Test messages will be transmitted and is expressed in\nbytes per second.")
lmpLinkVerifyWavelength = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 227, 1, 14, 1, 6), Unsigned32()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: lmpLinkVerifyWavelength.setDescription("This value corresponds to the wavelength at\nwhich the Test messages will be transmitted and is\nmeasured in nanometers (nm).  If each data-bearing link\ncorresponds to a separate wavelength, then this value should\nbe set to 0.")
lmpLinkVerifyRowStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 227, 1, 14, 1, 7), RowStatus()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: lmpLinkVerifyRowStatus.setDescription("This variable is used to create, modify, and/or\ndelete a row in this table.  None of the writable objects\nin a row can be changed if the status is active(1).\nAll read-create objects must have valid and consistent\nvalues before the row can be activated.")
lmpLinkVerifyStorageType = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 227, 1, 14, 1, 8), StorageType().clone('nonVolatile')).setMaxAccess("readcreate")
if mibBuilder.loadTexts: lmpLinkVerifyStorageType.setDescription("The storage type for this conceptual row in the\nlmpLinkVerificationTable.  Conceptual rows having the value\n'permanent' need not allow write-access to any\n\n\n\ncolumnar object in the row.")
lmpTeLinkPerfTable = MibTable((1, 3, 6, 1, 2, 1, 10, 227, 1, 15))
if mibBuilder.loadTexts: lmpTeLinkPerfTable.setDescription("This table specifies LMP TE link performance counters.")
lmpTeLinkPerfEntry = MibTableRow((1, 3, 6, 1, 2, 1, 10, 227, 1, 15, 1)).setIndexNames((0, "IF-MIB", "ifIndex"))
if mibBuilder.loadTexts: lmpTeLinkPerfEntry.setDescription("An entry in this table is created by an LMP-enabled device for\nevery TE link.  lmpTeCounterDiscontinuityTime is used\nto indicate potential discontinuity for all counter objects\nin this table.")
lmpTeInOctets = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 227, 1, 15, 1, 1), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: lmpTeInOctets.setDescription("The total number of LMP message octets received for\nthis TE link.")
lmpTeOutOctets = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 227, 1, 15, 1, 2), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: lmpTeOutOctets.setDescription("The total number of LMP message octets transmitted out\nfor this TE link.")
lmpTeBeginVerifyReceived = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 227, 1, 15, 1, 3), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: lmpTeBeginVerifyReceived.setDescription("This object counts the number of BeginVerify messages that have\n\n\n\nbeen received for this TE link.")
lmpTeBeginVerifySent = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 227, 1, 15, 1, 4), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: lmpTeBeginVerifySent.setDescription("This object counts the number of BeginVerify messages that have\nbeen sent for this TE link.")
lmpTeBeginVerifyRetransmit = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 227, 1, 15, 1, 5), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: lmpTeBeginVerifyRetransmit.setDescription("This object counts the number of BeginVerify messages that\nhave been retransmitted for this TE link.")
lmpTeBeginVerifyAckReceived = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 227, 1, 15, 1, 6), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: lmpTeBeginVerifyAckReceived.setDescription("This object counts the number of BeginVerifyAck messages that\nhave been received for this TE link.")
lmpTeBeginVerifyAckSent = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 227, 1, 15, 1, 7), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: lmpTeBeginVerifyAckSent.setDescription("This object counts the number of BeginVerifyAck messages that\nhave been sent for this TE link.")
lmpTeBeginVerifyNackReceived = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 227, 1, 15, 1, 8), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: lmpTeBeginVerifyNackReceived.setDescription("This object counts the number of BeginVerifyNack messages that\nhave been received for this TE link.")
lmpTeBeginVerifyNackSent = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 227, 1, 15, 1, 9), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: lmpTeBeginVerifyNackSent.setDescription("This object counts the number of BeginVerifyNack messages that\nhave been sent for this TE link.")
lmpTeEndVerifyReceived = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 227, 1, 15, 1, 10), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: lmpTeEndVerifyReceived.setDescription("This object counts the number of EndVerify messages that have\nbeen received for this TE link.")
lmpTeEndVerifySent = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 227, 1, 15, 1, 11), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: lmpTeEndVerifySent.setDescription("This object counts the number of EndVerify messages that have\nbeen sent for this TE link.")
lmpTeEndVerifyRetransmit = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 227, 1, 15, 1, 12), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: lmpTeEndVerifyRetransmit.setDescription("This object counts the number of EndVerify messages that\nhave been retransmitted over this control channel.")
lmpTeEndVerifyAckReceived = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 227, 1, 15, 1, 13), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: lmpTeEndVerifyAckReceived.setDescription("This object counts the number of EndVerifyAck messages that\nhave been received for this TE link.")
lmpTeEndVerifyAckSent = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 227, 1, 15, 1, 14), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: lmpTeEndVerifyAckSent.setDescription("This object counts the number of EndVerifyAck messages that\nhave been sent for this TE link.")
lmpTeTestStatusSuccessReceived = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 227, 1, 15, 1, 15), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: lmpTeTestStatusSuccessReceived.setDescription("This object counts the number of TestStatusSuccess messages\nthat have been received for this TE link.")
lmpTeTestStatusSuccessSent = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 227, 1, 15, 1, 16), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: lmpTeTestStatusSuccessSent.setDescription("This object counts the number of TestStatusSuccess messages\nthat have been sent for this TE link.")
lmpTeTestStatusSuccessRetransmit = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 227, 1, 15, 1, 17), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: lmpTeTestStatusSuccessRetransmit.setDescription("This object counts the number of TestStatusSuccess messages\nthat have been retransmitted for this TE link.")
lmpTeTestStatusFailureReceived = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 227, 1, 15, 1, 18), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: lmpTeTestStatusFailureReceived.setDescription("This object counts the number of TestStatusFailure messages\nthat have been received for this TE link.")
lmpTeTestStatusFailureSent = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 227, 1, 15, 1, 19), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: lmpTeTestStatusFailureSent.setDescription("This object counts the number of TestStatusFailure messages\n\n\n\nthat have been sent for this TE link.")
lmpTeTestStatusFailureRetransmit = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 227, 1, 15, 1, 20), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: lmpTeTestStatusFailureRetransmit.setDescription("This object counts the number of TestStatusFailure messages\nthat have been retransmitted on this TE link.")
lmpTeTestStatusAckReceived = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 227, 1, 15, 1, 21), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: lmpTeTestStatusAckReceived.setDescription("This object counts the number of TestStatusAck messages that\nhave been received for this TE link.")
lmpTeTestStatusAckSent = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 227, 1, 15, 1, 22), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: lmpTeTestStatusAckSent.setDescription("This object counts the number of TestStatusAck messages that\nhave been sent for this TE link.")
lmpTeLinkSummaryReceived = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 227, 1, 15, 1, 23), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: lmpTeLinkSummaryReceived.setDescription("This object counts the number of LinkSummary messages that\nhave been received for this TE link.")
lmpTeLinkSummarySent = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 227, 1, 15, 1, 24), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: lmpTeLinkSummarySent.setDescription("This object counts the number of LinkSummary messages that\nhave been sent for this TE link.")
lmpTeLinkSummaryRetransmit = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 227, 1, 15, 1, 25), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: lmpTeLinkSummaryRetransmit.setDescription("This object counts the number of LinkSummary messages that\nhave been retransmitted over this control channel.")
lmpTeLinkSummaryAckReceived = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 227, 1, 15, 1, 26), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: lmpTeLinkSummaryAckReceived.setDescription("This object counts the number of LinkSummaryAck messages that\nhave been received for this TE link.")
lmpTeLinkSummaryAckSent = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 227, 1, 15, 1, 27), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: lmpTeLinkSummaryAckSent.setDescription("This object counts the number of LinkSummaryAck messages that\nhave been sent for this TE link.")
lmpTeLinkSummaryNackReceived = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 227, 1, 15, 1, 28), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: lmpTeLinkSummaryNackReceived.setDescription("This object counts the number of LinkSummaryNack messages that\nhave been received for this TE link.")
lmpTeLinkSummaryNackSent = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 227, 1, 15, 1, 29), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: lmpTeLinkSummaryNackSent.setDescription("This object counts the number of LinkSummaryNack messages that\nhave been sent for this TE link.")
lmpTeChannelStatusReceived = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 227, 1, 15, 1, 30), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: lmpTeChannelStatusReceived.setDescription("This object counts the number of ChannelStatus messages that\nhave been received for this TE link.")
lmpTeChannelStatusSent = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 227, 1, 15, 1, 31), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: lmpTeChannelStatusSent.setDescription("This object counts the number of ChannelStatus messages that\nhave been sent for this TE link.")
lmpTeChannelStatusRetransmit = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 227, 1, 15, 1, 32), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: lmpTeChannelStatusRetransmit.setDescription("This object counts the number of ChannelStatus messages that\nhave been retransmitted for this TE link.")
lmpTeChannelStatusAckReceived = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 227, 1, 15, 1, 33), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: lmpTeChannelStatusAckReceived.setDescription("This object counts the number of ChannelStatusAck messages\nthat have been received for this TE link.")
lmpTeChannelStatusAckSent = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 227, 1, 15, 1, 34), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: lmpTeChannelStatusAckSent.setDescription("This object counts the number of ChannelStatus messages\nthat have been sent for this TE link.")
lmpTeChannelStatusReqReceived = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 227, 1, 15, 1, 35), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: lmpTeChannelStatusReqReceived.setDescription("This object counts the number of ChannelStatusRequest messages\n\n\n\nthat have been received for this TE link.")
lmpTeChannelStatusReqSent = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 227, 1, 15, 1, 36), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: lmpTeChannelStatusReqSent.setDescription("This object counts the number of ChannelStatusRequest messages\nthat have been sent for this TE link.")
lmpTeChannelStatusReqRetransmit = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 227, 1, 15, 1, 37), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: lmpTeChannelStatusReqRetransmit.setDescription("This object counts the number of ChannelStatusRequest messages\nthat have been retransmitted for this TE link.")
lmpTeChannelStatusRspReceived = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 227, 1, 15, 1, 38), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: lmpTeChannelStatusRspReceived.setDescription("This object counts the number of ChannelStatusResponse messages\nthat have been received for this TE link.")
lmpTeChannelStatusRspSent = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 227, 1, 15, 1, 39), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: lmpTeChannelStatusRspSent.setDescription("This object counts the number of ChannelStatusResponse messages\nthat have been sent for this TE link.")
lmpTeCounterDiscontinuityTime = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 227, 1, 15, 1, 40), TimeStamp()).setMaxAccess("readonly")
if mibBuilder.loadTexts: lmpTeCounterDiscontinuityTime.setDescription("The value of sysUpTime on the most recent occasion at which\none or more of this TE link's counters suffered a\ndiscontinuity.  The relevant counters are the specific\ninstances associated with this TE link of any Counter32\n\n\n\nobject contained in the lmpTeLinkPerfTable.  If\nno such discontinuities have occurred since the last re-\ninitialization of the local management subsystem, then this\nobject contains a zero value.")
lmpDataLinkTable = MibTable((1, 3, 6, 1, 2, 1, 10, 227, 1, 16))
if mibBuilder.loadTexts: lmpDataLinkTable.setDescription("This table specifies the data-bearing links managed by the\nLMP.")
lmpDataLinkEntry = MibTableRow((1, 3, 6, 1, 2, 1, 10, 227, 1, 16, 1)).setIndexNames((0, "IF-MIB", "ifIndex"))
if mibBuilder.loadTexts: lmpDataLinkEntry.setDescription("An entry in this table exists for each ifEntry that represents\na data-bearing link.  An ifEntry with an ifIndex must exist\nbefore the corresponding lmpDataLinkEntry is created.\nIf an entry representing the data-bearing link is destroyed in\nthe ifTable, then so is the corresponding entry in the\nlmpDataLinkTable.  The administrative status value is\ncontrolled from the ifEntry.  The index to this table is also\nused to get information in the componentLinkTable\nof the TE-LINK-STD-MIB MIB module.")
lmpDataLinkType = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 227, 1, 16, 1, 1), Integer().subtype(subtypeSpec=SingleValueConstraint(2,1,)).subtype(namedValues=NamedValues(("port", 1), ("componentLink", 2), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: lmpDataLinkType.setDescription("This attribute specifies whether this data-bearing link is\na port or a component link.  Component links are multiplex\ncapable, whereas ports are not multiplex capable.")
lmpDataLinkAddressType = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 227, 1, 16, 1, 2), InetAddressType()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: lmpDataLinkAddressType.setDescription("This attribute specifies the data-bearing link IP address\ntype.  If the data-bearing link is unnumbered, the address\ntype must be set to unknown(0).")
lmpDataLinkIpAddr = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 227, 1, 16, 1, 3), InetAddress()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: lmpDataLinkIpAddr.setDescription("The local Internet address for numbered links.  The type\nof this address is determined by the value of\nlmpDataLinkAddressType object.\n\nFor IPv4 and IPv6 numbered links, this object represents\nthe local IP address associated with the data-bearing\nlink.  For an unnumbered link, the local address is\nof type unknown, and this object is set to the zero-length\nstring; the ifIndex object then identifies the\nunnumbered address.")
lmpDataLinkRemoteIpAddress = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 227, 1, 16, 1, 4), InetAddress()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: lmpDataLinkRemoteIpAddress.setDescription("The remote Internet address for numbered data-bearing links.\nThe type of this address is determined by the\nlmpDataLinkAddressType object.\n\nFor IPv4 and IPv6 numbered links, this object represents the\nremote IP address associated with the data-bearing link.  For\nan unnumbered link, the remote address is of type unknown,\nand this object is set to the zero-length string; the\nlmpDataLinkRemoteIfId object then identifies the unnumbered\naddress.\n\nThis information is either configured manually or\ncommunicated by the remote node during the link verification\nprocedure.")
lmpDataLinkRemoteIfId = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 227, 1, 16, 1, 5), InterfaceIndexOrZero()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: lmpDataLinkRemoteIfId.setDescription("Interface identifier of the remote end point.  This\ninformation is either configured manually or\ncommunicated by the remote node during the link verification\nprocedure.")
lmpDataLinkEncodingType = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 227, 1, 16, 1, 6), TeLinkEncodingType()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: lmpDataLinkEncodingType.setDescription("The encoding type of the data-bearing link.")
lmpDataLinkActiveOperStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 227, 1, 16, 1, 7), Integer().subtype(subtypeSpec=SingleValueConstraint(3,2,4,1,)).subtype(namedValues=NamedValues(("upAlloc", 1), ("upFree", 2), ("down", 3), ("testing", 4), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: lmpDataLinkActiveOperStatus.setDescription("The actual operational status of this data-bearing link\n\n\n\n(active FSM).")
lmpDataLinkPassiveOperStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 227, 1, 16, 1, 8), Integer().subtype(subtypeSpec=SingleValueConstraint(3,4,2,1,)).subtype(namedValues=NamedValues(("upAlloc", 1), ("upFree", 2), ("down", 3), ("psvTst", 4), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: lmpDataLinkPassiveOperStatus.setDescription("The actual operational status of this data-bearing link\n(passive FSM).")
lmpDataLinkRowStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 227, 1, 16, 1, 9), RowStatus()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: lmpDataLinkRowStatus.setDescription("This variable is used to create, modify, and/or\ndelete a row in this table.  None of the writable objects\nin a row can be changed if the status is active(1).\nAll read-create objects must have valid and consistent\nvalues before the row can be activated.")
lmpDataLinkStorageType = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 227, 1, 16, 1, 10), StorageType().clone('nonVolatile')).setMaxAccess("readcreate")
if mibBuilder.loadTexts: lmpDataLinkStorageType.setDescription("The storage type for this conceptual row in the\nlmpDataLinkTable.  Conceptual rows having the value\n'permanent' need not allow write-access to any\ncolumnar object in the row.")
lmpDataLinkPerfTable = MibTable((1, 3, 6, 1, 2, 1, 10, 227, 1, 17))
if mibBuilder.loadTexts: lmpDataLinkPerfTable.setDescription("This table specifies the data-bearing links LMP performance\ncounters.")
lmpDataLinkPerfEntry = MibTableRow((1, 3, 6, 1, 2, 1, 10, 227, 1, 17, 1)).setIndexNames((0, "IF-MIB", "ifIndex"))
if mibBuilder.loadTexts: lmpDataLinkPerfEntry.setDescription("An entry in this table contains information about\nthe LMP performance counters for the data-bearing links.\nlmpDataLinkDiscontinuityTime is used to indicate potential\ndiscontinuity for all counter objects in this table.")
lmpDataLinkTestReceived = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 227, 1, 17, 1, 1), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: lmpDataLinkTestReceived.setDescription("This object counts the number of Test messages that have\nbeen received on this data-bearing link.")
lmpDataLinkTestSent = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 227, 1, 17, 1, 2), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: lmpDataLinkTestSent.setDescription("This object counts the number of Test messages that have\nbeen sent on this data-bearing link.")
lmpDataLinkActiveTestSuccess = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 227, 1, 17, 1, 3), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: lmpDataLinkActiveTestSuccess.setDescription("This object counts the number of data-bearing link tests\nthat were successful on the active side of this data-\nbearing link.")
lmpDataLinkActiveTestFailure = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 227, 1, 17, 1, 4), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: lmpDataLinkActiveTestFailure.setDescription("This object counts the number of data-bearing link tests\nthat failed on the active side of this data-bearing link.")
lmpDataLinkPassiveTestSuccess = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 227, 1, 17, 1, 5), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: lmpDataLinkPassiveTestSuccess.setDescription("This object counts the number of data-bearing link tests\nthat were successful on the passive side of this data-\nbearing link.")
lmpDataLinkPassiveTestFailure = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 227, 1, 17, 1, 6), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: lmpDataLinkPassiveTestFailure.setDescription("This object counts the number of data-bearing link tests\nthat failed on the passive side of this data-bearing link.")
lmpDataLinkDiscontinuityTime = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 227, 1, 17, 1, 7), TimeStamp()).setMaxAccess("readonly")
if mibBuilder.loadTexts: lmpDataLinkDiscontinuityTime.setDescription("The value of sysUpTime on the most recent occasion at which\none or more of this data-bearing link's counters suffered\na discontinuity.  The relevant counters are the specific\ninstances associated with this data-bearing link of any\nCounter32 object contained in the lmpDataLinkPerfTable.  If\n\n\n\nno such discontinuities have occurred since the last re-\ninitialization of the local management subsystem, then this\nobject contains a zero value.")
lmpNotificationMaxRate = MibScalar((1, 3, 6, 1, 2, 1, 10, 227, 1, 18), Unsigned32()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: lmpNotificationMaxRate.setDescription("The LMP notification rate depends on the size of the network,\nthe type of links, the network configuration, the\nreliability of the network, etc.\n\nWhen this MIB was designed, care was taken to minimize the\namount of notifications generated for LMP purposes.  Wherever\npossible, notifications are state driven, meaning that the\nnotifications are sent only when the system changes state.\nThe only notifications that are repeated and that could cause a\nproblem as far as congestion is concerned are the ones\nassociated with data link verification.\nWithout any considerations to handling of these\nnotifications, a problem may arise if the number of data\nlinks is high.  Since the data link verification notifications\ncan happen only once per data link per link verification\ninterval, the notification rate should be sustainable if one\nchooses an appropriate link verification interval for a given\nnetwork configuration.  For instance, a network of 100 nodes\nwith 5 links of 128 wavelengths each and a link verification\nof 1 minute, where no more than 10% of the links failed at any\ngiven time, would have 1 notification per second sent from\neach node, or 100 notifications per second for the whole\nnetwork.  The rest of the notifications are negligible\ncompared to this number.\n\nTo alleviate the congestion problem, the\nlmpNotificationMaxRate object can be used to implement a\nthrottling mechanism.  It is also possible to enable/disable\ncertain type of notifications.\n\nThis variable indicates the maximum number of\nnotifications issued per minute.  If events occur\nmore rapidly, the implementation may simply fail to\n\n\n\nemit these notifications during that period or may\nqueue them until an appropriate time.  A value of 0\nmeans that no throttling is applied and events may be\nnotified at the rate at which they occur.\nImplementations should save the value of this object in\npersistent memory so that it survives restarts or reboot.")
lmpLinkPropertyNotificationsEnabled = MibScalar((1, 3, 6, 1, 2, 1, 10, 227, 1, 19), TruthValue().clone('false')).setMaxAccess("readwrite")
if mibBuilder.loadTexts: lmpLinkPropertyNotificationsEnabled.setDescription("If this object is true(1), then it enables the\ngeneration of lmpTeLinkPropertyMismatch\nand lmpDataLinkPropertyMismatch notifications;\notherwise, these notifications are not emitted.\nImplementations should save the value of this object in\npersistent memory so that it survives restarts or reboot.")
lmpUnprotectedNotificationsEnabled = MibScalar((1, 3, 6, 1, 2, 1, 10, 227, 1, 20), TruthValue().clone('false')).setMaxAccess("readwrite")
if mibBuilder.loadTexts: lmpUnprotectedNotificationsEnabled.setDescription("If this object is true(1), then it enables the\ngeneration of lmpUnprotected notifications;\notherwise, these notifications are not emitted.\nImplementations should save the value of this object in\npersistent memory so that it survives restarts or reboot.")
lmpCcUpDownNotificationsEnabled = MibScalar((1, 3, 6, 1, 2, 1, 10, 227, 1, 21), TruthValue().clone('false')).setMaxAccess("readwrite")
if mibBuilder.loadTexts: lmpCcUpDownNotificationsEnabled.setDescription("If this object is true(1), then it enables the generation of\nlmpControlChannelUp and lmpControlChannelDown notifications;\notherwise, these notifications are not emitted.\nImplementations should save the value of this object in\npersistent memory so that it survives restarts or reboot.")
lmpTeLinkNotificationsEnabled = MibScalar((1, 3, 6, 1, 2, 1, 10, 227, 1, 22), TruthValue().clone('false')).setMaxAccess("readwrite")
if mibBuilder.loadTexts: lmpTeLinkNotificationsEnabled.setDescription("If this object is true(1), then it enables the\ngeneration of lmpTeLinkDegraded and lmpTeLinkNotDegraded\nnotifications; otherwise, these notifications are not emitted.\nImplementations should save the value of this object in\npersistent memory so that it survives restarts or reboot.")
lmpDataLinkNotificationsEnabled = MibScalar((1, 3, 6, 1, 2, 1, 10, 227, 1, 23), TruthValue().clone('false')).setMaxAccess("readwrite")
if mibBuilder.loadTexts: lmpDataLinkNotificationsEnabled.setDescription("If this object is true(1), then it enables the\ngeneration of lmpDataLinkVerificationFailure\nnotification; otherwise, these notifications are not emitted.\nImplementations should save the value of this object in\npersistent memory so that it survives restarts or reboot.")
lmpConformance = MibIdentifier((1, 3, 6, 1, 2, 1, 10, 227, 2))
lmpCompliances = MibIdentifier((1, 3, 6, 1, 2, 1, 10, 227, 2, 1))
lmpGroups = MibIdentifier((1, 3, 6, 1, 2, 1, 10, 227, 2, 2))

# Augmentions

# Notifications

lmpTeLinkPropertyMismatch = NotificationType((1, 3, 6, 1, 2, 1, 10, 227, 0, 1)).setObjects(*(("TE-LINK-STD-MIB", "teLinkIncomingIfId"), ("TE-LINK-STD-MIB", "teLinkRemoteIpAddr"), ) )
if mibBuilder.loadTexts: lmpTeLinkPropertyMismatch.setDescription("This notification is generated when a TE link property\nmismatch is detected on the node.  The received remote TE link\nID of the misconfigured TE link is represented by either\nteLinkRemoteIpAddr or teLinkIncomingIfId, depending on whether\nthe TE link is numbered or unnumbered.  This notification\nshould not be sent unless lmpLinkPropertyNotificationsEnabled\nis true(1).  It is recommended that this notification be\nreported only the first time a mismatch is detected.\nOtherwise, for a given TE link, this notification can occur\nno more than once per verification interval\n(lmpGlobalLinkVerificationInterval).")
lmpDataLinkPropertyMismatch = NotificationType((1, 3, 6, 1, 2, 1, 10, 227, 0, 2)).setObjects(*(("LMP-MIB", "lmpDataLinkType"), ("LMP-MIB", "lmpDataLinkRemoteIfId"), ) )
if mibBuilder.loadTexts: lmpDataLinkPropertyMismatch.setDescription("This notification is generated when a data-bearing link\nproperty mismatch is detected on the node.  lmpDataLinkType\nis used to identify the local identifiers associated with\nthe data link.  (The data link interface index can be used\nto determine the TE link interface index, as this\nrelationship is captured in the interface stack table.)\nThe remote entity interface ID is the remote entity\ninterface ID received in the LinkSummary message.\nThis notification should not be sent unless\nlmpLinkPropertyNotificationsEnabled is true(1).  It is\nrecommended that this notification be reported only the\nfirst time a mismatch is detected.  Otherwise, for a given\ndata link, this notification can occur no more than once\nper verification interval (lmpGlobalLinkVerificationInterval).")
lmpUnprotected = NotificationType((1, 3, 6, 1, 2, 1, 10, 227, 0, 3)).setObjects(*(("LMP-MIB", "lmpCcNbrNodeId"), ) )
if mibBuilder.loadTexts: lmpUnprotected.setDescription("This notification is generated when there is more than one\ncontrol channel between LMP neighbors and the last redundant\ncontrol channel has failed.  If the remaining operational\ncontrol channel fails, then there will be no more control\nchannels between the pair of nodes and all the TE links\nbetween the pair of nodes, will go to degraded state.  This\nnotification should not be sent unless\nlmpUnprotectedNotificationsEnabled is set to true(1).")
lmpControlChannelUp = NotificationType((1, 3, 6, 1, 2, 1, 10, 227, 0, 4)).setObjects(*(("LMP-MIB", "lmpCcAdminStatus"), ("LMP-MIB", "lmpCcOperStatus"), ) )
if mibBuilder.loadTexts: lmpControlChannelUp.setDescription("This notification is generated when a control\nchannel transitions to the up operational state.  This\nnotification should not be sent unless\nlmpCcUpDownNotificationsEnabled is true(1).")
lmpControlChannelDown = NotificationType((1, 3, 6, 1, 2, 1, 10, 227, 0, 5)).setObjects(*(("LMP-MIB", "lmpCcAdminStatus"), ("LMP-MIB", "lmpCcOperStatus"), ) )
if mibBuilder.loadTexts: lmpControlChannelDown.setDescription("This notification is generated when a control channel\ntransitions out of the up operational state.  This\nnotification should not be sent unless\nlmpCcUpDownNotificationsEnabled is true(1).")
lmpTeLinkDegraded = NotificationType((1, 3, 6, 1, 2, 1, 10, 227, 0, 6)).setObjects(*(("LMP-MIB", "lmpTeLinkOperStatus"), ) )
if mibBuilder.loadTexts: lmpTeLinkDegraded.setDescription("This notification is generated when a lmpTeLinkOperStatus\nobject for a TE link enters the degraded state.  This\nnotification should not be sent unless\nlmpTeLinkNotificationsEnabled is true(1).")
lmpTeLinkNotDegraded = NotificationType((1, 3, 6, 1, 2, 1, 10, 227, 0, 7)).setObjects(*(("LMP-MIB", "lmpTeLinkOperStatus"), ) )
if mibBuilder.loadTexts: lmpTeLinkNotDegraded.setDescription("This notification is generated when a lmpTeLinkOperStatus\nobject for a TE link leaves the degraded state.  This\nnotification should not be sent unless\nlmpTeLinkNotificationsEnabled is true(1).")
lmpDataLinkVerificationFailure = NotificationType((1, 3, 6, 1, 2, 1, 10, 227, 0, 8)).setObjects(*(("LMP-MIB", "lmpDataLinkActiveOperStatus"), ("LMP-MIB", "lmpDataLinkPassiveOperStatus"), ) )
if mibBuilder.loadTexts: lmpDataLinkVerificationFailure.setDescription("This notification is generated when a data-bearing\nlink verification fails.  This notification should not be sent\nunless lmpDataLinkNotificationsEnabled is true(1).  For a given\ndata link, this notification can occur no more than once per\nverification interval (lmpGlobalLinkVerificationInterval).")

# Groups

lmpNodeGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 10, 227, 2, 2, 1)).setObjects(*(("LMP-MIB", "lmpNbrRowStatus"), ("LMP-MIB", "lmpNbrAdminStatus"), ("LMP-MIB", "lmpOperStatus"), ("LMP-MIB", "lmpNbrOperStatus"), ("LMP-MIB", "lmpUnprotectedNotificationsEnabled"), ("LMP-MIB", "lmpAdminStatus"), ("LMP-MIB", "lmpNbrStorageType"), ("LMP-MIB", "lmpNotificationMaxRate"), ) )
if mibBuilder.loadTexts: lmpNodeGroup.setDescription("Collection of objects that represent LMP node\nconfiguration.")
lmpControlChannelGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 10, 227, 2, 2, 2)).setObjects(*(("LMP-MIB", "lmpCcOperStatus"), ("LMP-MIB", "lmpNbrOperStatus"), ("LMP-MIB", "lmpCcUpDownNotificationsEnabled"), ("LMP-MIB", "lmpNbrRetransmitDelta"), ("LMP-MIB", "lmpCcHelloDeadIntervalDefaultMax"), ("LMP-MIB", "lmpCcRowStatus"), ("LMP-MIB", "lmpCcNbrNodeId"), ("LMP-MIB", "lmpCcSetupRole"), ("LMP-MIB", "lmpCcHelloIntervalDefaultMax"), ("LMP-MIB", "lmpCcRemoteIpAddr"), ("LMP-MIB", "lmpNbrRowStatus"), ("LMP-MIB", "lmpCcHelloDeadIntervalDefaultMin"), ("LMP-MIB", "lmpCcHelloDeadIntervalDefault"), ("LMP-MIB", "lmpCcHelloIntervalMax"), ("LMP-MIB", "lmpCcHelloIntervalMin"), ("LMP-MIB", "lmpNbrRetryLimit"), ("LMP-MIB", "lmpCcHelloIntervalDefaultMin"), ("LMP-MIB", "lmpCcAuthentication"), ("LMP-MIB", "lmpNbrAdminStatus"), ("LMP-MIB", "lmpCcHelloDeadInterval"), ("LMP-MIB", "lmpCcHelloInterval"), ("LMP-MIB", "lmpCcHelloIntervalNegotiated"), ("LMP-MIB", "lmpCcHelloDeadIntervalMax"), ("LMP-MIB", "lmpNbrRetransmitInterval"), ("LMP-MIB", "lmpCcStorageType"), ("LMP-MIB", "lmpCcRemoteId"), ("LMP-MIB", "lmpCcHelloDeadIntervalNegotiated"), ("LMP-MIB", "lmpCcRemoteAddressType"), ("LMP-MIB", "lmpNbrStorageType"), ("LMP-MIB", "lmpCcHelloIntervalDefault"), ("LMP-MIB", "lmpCcHelloDeadIntervalMin"), ) )
if mibBuilder.loadTexts: lmpControlChannelGroup.setDescription("Objects that can be used to configure LMP interface.")
lmpCcIsInterfaceGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 10, 227, 2, 2, 3)).setObjects(*(("LMP-MIB", "lmpCcIsIf"), ) )
if mibBuilder.loadTexts: lmpCcIsInterfaceGroup.setDescription("Objects that can be used to configure control channels\nthat are interfaces.")
lmpCcIsNotInterfaceGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 10, 227, 2, 2, 4)).setObjects(*(("LMP-MIB", "lmpCcAdminStatus"), ("LMP-MIB", "lmpCcIsIf"), ("LMP-MIB", "lmpCcUnderlyingIfIndex"), ("LMP-MIB", "lmpCcLastChange"), ) )
if mibBuilder.loadTexts: lmpCcIsNotInterfaceGroup.setDescription("Objects that can be used to configure control channels\nthat are not interfaces.")
lmpLinkPropertyCorrelationGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 10, 227, 2, 2, 5)).setObjects(*(("LMP-MIB", "lmpLinkPropertyNotificationsEnabled"), ) )
if mibBuilder.loadTexts: lmpLinkPropertyCorrelationGroup.setDescription("Collection of objects used to configure the link\nproperty correlation procedure.")
lmpLinkVerificationGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 10, 227, 2, 2, 6)).setObjects(*(("LMP-MIB", "lmpLinkVerifyRowStatus"), ("LMP-MIB", "lmpLinkVerifyTransportMechanism"), ("LMP-MIB", "lmpLinkVerifyInterval"), ("LMP-MIB", "lmpLinkVerifyTransmissionRate"), ("LMP-MIB", "lmpLinkVerifyAllLinks"), ("LMP-MIB", "lmpDataLinkNotificationsEnabled"), ("LMP-MIB", "lmpLinkVerifyWavelength"), ("LMP-MIB", "lmpGlobalLinkVerificationInterval"), ("LMP-MIB", "lmpLinkVerifyDeadInterval"), ("LMP-MIB", "lmpLinkVerifyStorageType"), ) )
if mibBuilder.loadTexts: lmpLinkVerificationGroup.setDescription("Collection of objects that represent the link\nverification procedure configuration.")
lmpPerfGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 10, 227, 2, 2, 7)).setObjects(*(("LMP-MIB", "lmpCcInErrors"), ("LMP-MIB", "lmpDataLinkPassiveTestSuccess"), ("LMP-MIB", "lmpTeEndVerifyRetransmit"), ("LMP-MIB", "lmpCcChannelStatusAckSent"), ("LMP-MIB", "lmpCcLinkSummaryRetransmit"), ("LMP-MIB", "lmpTeLinkSummarySent"), ("LMP-MIB", "lmpCcBeginVerifySent"), ("LMP-MIB", "lmpCcChannelStatusReqReceived"), ("LMP-MIB", "lmpTeChannelStatusRetransmit"), ("LMP-MIB", "lmpCcChannelStatusAckReceived"), ("LMP-MIB", "lmpTeBeginVerifyRetransmit"), ("LMP-MIB", "lmpCcTestStatusFailureReceived"), ("LMP-MIB", "lmpCcConfigAckSent"), ("LMP-MIB", "lmpTeLinkSummaryAckSent"), ("LMP-MIB", "lmpTeCounterDiscontinuityTime"), ("LMP-MIB", "lmpTeChannelStatusReqSent"), ("LMP-MIB", "lmpCcChannelStatusReqSent"), ("LMP-MIB", "lmpCcTestStatusFailureSent"), ("LMP-MIB", "lmpTeChannelStatusSent"), ("LMP-MIB", "lmpTeLinkSummaryReceived"), ("LMP-MIB", "lmpCcTestStatusAckSent"), ("LMP-MIB", "lmpCcTestStatusFailureRetransmit"), ("LMP-MIB", "lmpCcOutDiscards"), ("LMP-MIB", "lmpCcTestStatusSuccessRetransmit"), ("LMP-MIB", "lmpCcConfigNackReceived"), ("LMP-MIB", "lmpCcBeginVerifyAckReceived"), ("LMP-MIB", "lmpCcLinkSummaryNackReceived"), ("LMP-MIB", "lmpTeBeginVerifyAckSent"), ("LMP-MIB", "lmpCcEndVerifySent"), ("LMP-MIB", "lmpCcConfigReceived"), ("LMP-MIB", "lmpCcBeginVerifyAckSent"), ("LMP-MIB", "lmpTeLinkSummaryNackSent"), ("LMP-MIB", "lmpDataLinkDiscontinuityTime"), ("LMP-MIB", "lmpCcEndVerifyAckReceived"), ("LMP-MIB", "lmpCcChannelStatusRetransmit"), ("LMP-MIB", "lmpTeEndVerifyAckReceived"), ("LMP-MIB", "lmpDataLinkActiveTestSuccess"), ("LMP-MIB", "lmpTeChannelStatusReqReceived"), ("LMP-MIB", "lmpCcChannelStatusRspReceived"), ("LMP-MIB", "lmpDataLinkActiveTestFailure"), ("LMP-MIB", "lmpTeTestStatusAckSent"), ("LMP-MIB", "lmpTeTestStatusFailureSent"), ("LMP-MIB", "lmpTeTestStatusFailureRetransmit"), ("LMP-MIB", "lmpCcInOctets"), ("LMP-MIB", "lmpTeBeginVerifyNackReceived"), ("LMP-MIB", "lmpTeChannelStatusReqRetransmit"), ("LMP-MIB", "lmpCcHelloSent"), ("LMP-MIB", "lmpCcChannelStatusSent"), ("LMP-MIB", "lmpTeBeginVerifyAckReceived"), ("LMP-MIB", "lmpCcHelloReceived"), ("LMP-MIB", "lmpTeLinkSummaryRetransmit"), ("LMP-MIB", "lmpCcInDiscards"), ("LMP-MIB", "lmpCcLinkSummarySent"), ("LMP-MIB", "lmpTeChannelStatusAckReceived"), ("LMP-MIB", "lmpCcLinkSummaryNackSent"), ("LMP-MIB", "lmpCcBeginVerifyReceived"), ("LMP-MIB", "lmpCcTestStatusSuccessSent"), ("LMP-MIB", "lmpCcChannelStatusRspSent"), ("LMP-MIB", "lmpCcLinkSummaryAckReceived"), ("LMP-MIB", "lmpTeLinkSummaryAckReceived"), ("LMP-MIB", "lmpTeTestStatusSuccessReceived"), ("LMP-MIB", "lmpCcConfigSent"), ("LMP-MIB", "lmpCcCounterDiscontinuityTime"), ("LMP-MIB", "lmpCcTestStatusSuccessReceived"), ("LMP-MIB", "lmpCcTestStatusAckReceived"), ("LMP-MIB", "lmpTeChannelStatusReceived"), ("LMP-MIB", "lmpTeLinkSummaryNackReceived"), ("LMP-MIB", "lmpCcEndVerifyReceived"), ("LMP-MIB", "lmpCcLinkSummaryReceived"), ("LMP-MIB", "lmpTeEndVerifyReceived"), ("LMP-MIB", "lmpCcChannelStatusReceived"), ("LMP-MIB", "lmpDataLinkTestSent"), ("LMP-MIB", "lmpTeTestStatusSuccessRetransmit"), ("LMP-MIB", "lmpCcOutOctets"), ("LMP-MIB", "lmpCcConfigNackSent"), ("LMP-MIB", "lmpDataLinkTestReceived"), ("LMP-MIB", "lmpCcBeginVerifyNackReceived"), ("LMP-MIB", "lmpTeOutOctets"), ("LMP-MIB", "lmpTeInOctets"), ("LMP-MIB", "lmpTeChannelStatusRspReceived"), ("LMP-MIB", "lmpCcBeginVerifyNackSent"), ("LMP-MIB", "lmpTeChannelStatusAckSent"), ("LMP-MIB", "lmpCcOutErrors"), ("LMP-MIB", "lmpDataLinkPassiveTestFailure"), ("LMP-MIB", "lmpCcEndVerifyAckSent"), ("LMP-MIB", "lmpCcBeginVerifyRetransmit"), ("LMP-MIB", "lmpTeTestStatusFailureReceived"), ("LMP-MIB", "lmpTeEndVerifySent"), ("LMP-MIB", "lmpTeBeginVerifyNackSent"), ("LMP-MIB", "lmpTeEndVerifyAckSent"), ("LMP-MIB", "lmpTeChannelStatusRspSent"), ("LMP-MIB", "lmpTeTestStatusAckReceived"), ("LMP-MIB", "lmpCcEndVerifyRetransmit"), ("LMP-MIB", "lmpTeBeginVerifyReceived"), ("LMP-MIB", "lmpCcChannelStatusReqRetransmit"), ("LMP-MIB", "lmpCcConfigRetransmit"), ("LMP-MIB", "lmpTeTestStatusSuccessSent"), ("LMP-MIB", "lmpTeBeginVerifySent"), ("LMP-MIB", "lmpCcLinkSummaryAckSent"), ("LMP-MIB", "lmpCcConfigAckReceived"), ) )
if mibBuilder.loadTexts: lmpPerfGroup.setDescription("Collection of objects used to provide performance\ninformation about LMP interfaces and data-bearing links.")
lmpTeLinkGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 10, 227, 2, 2, 8)).setObjects(*(("LMP-MIB", "lmpTeLinkNotificationsEnabled"), ("LMP-MIB", "lmpTeLinkFaultManagement"), ("LMP-MIB", "lmpTeLinkDwdm"), ("LMP-MIB", "lmpTeLinkVerification"), ("LMP-MIB", "lmpTeLinkNbrRemoteNodeId"), ("LMP-MIB", "lmpTeLinkStorageType"), ("LMP-MIB", "lmpTeLinkRowStatus"), ("LMP-MIB", "lmpTeLinkOperStatus"), ) )
if mibBuilder.loadTexts: lmpTeLinkGroup.setDescription("Objects that can be used to configure TE links.")
lmpDataLinkGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 10, 227, 2, 2, 9)).setObjects(*(("LMP-MIB", "lmpDataLinkType"), ("LMP-MIB", "lmpDataLinkActiveOperStatus"), ("LMP-MIB", "lmpDataLinkRemoteIfId"), ("LMP-MIB", "lmpDataLinkRowStatus"), ("LMP-MIB", "lmpDataLinkIpAddr"), ("LMP-MIB", "lmpDataLinkPassiveOperStatus"), ("LMP-MIB", "lmpDataLinkStorageType"), ("LMP-MIB", "lmpDataLinkEncodingType"), ("LMP-MIB", "lmpDataLinkRemoteIpAddress"), ("LMP-MIB", "lmpDataLinkAddressType"), ) )
if mibBuilder.loadTexts: lmpDataLinkGroup.setDescription("Collection of objects that represent data-bearing link\nconfiguration.")
lmpNotificationGroup = NotificationGroup((1, 3, 6, 1, 2, 1, 10, 227, 2, 2, 10)).setObjects(*(("LMP-MIB", "lmpTeLinkNotDegraded"), ("LMP-MIB", "lmpUnprotected"), ("LMP-MIB", "lmpTeLinkPropertyMismatch"), ("LMP-MIB", "lmpDataLinkVerificationFailure"), ("LMP-MIB", "lmpDataLinkPropertyMismatch"), ("LMP-MIB", "lmpControlChannelDown"), ("LMP-MIB", "lmpControlChannelUp"), ("LMP-MIB", "lmpTeLinkDegraded"), ) )
if mibBuilder.loadTexts: lmpNotificationGroup.setDescription("Set of notifications defined in this module.")

# Compliances

lmpModuleFullCompliance = ModuleCompliance((1, 3, 6, 1, 2, 1, 10, 227, 2, 1, 1)).setObjects(*(("LMP-MIB", "lmpCcIsInterfaceGroup"), ("LMP-MIB", "lmpCcIsNotInterfaceGroup"), ("LMP-MIB", "lmpLinkVerificationGroup"), ("LMP-MIB", "lmpDataLinkGroup"), ("LMP-MIB", "lmpNotificationGroup"), ("LMP-MIB", "lmpControlChannelGroup"), ("LMP-MIB", "lmpPerfGroup"), ("LMP-MIB", "lmpNodeGroup"), ("LMP-MIB", "lmpLinkPropertyCorrelationGroup"), ("LMP-MIB", "lmpTeLinkGroup"), ) )
if mibBuilder.loadTexts: lmpModuleFullCompliance.setDescription("Compliance statement for agents that support the\nconfiguration and monitoring of LMP MIB.")
lmpModuleReadOnlyCompliance = ModuleCompliance((1, 3, 6, 1, 2, 1, 10, 227, 2, 1, 2)).setObjects(*(("LMP-MIB", "lmpCcIsInterfaceGroup"), ("LMP-MIB", "lmpCcIsNotInterfaceGroup"), ("LMP-MIB", "lmpLinkVerificationGroup"), ("LMP-MIB", "lmpDataLinkGroup"), ("LMP-MIB", "lmpNotificationGroup"), ("LMP-MIB", "lmpControlChannelGroup"), ("LMP-MIB", "lmpPerfGroup"), ("LMP-MIB", "lmpNodeGroup"), ("LMP-MIB", "lmpLinkPropertyCorrelationGroup"), ("LMP-MIB", "lmpTeLinkGroup"), ) )
if mibBuilder.loadTexts: lmpModuleReadOnlyCompliance.setDescription("Compliance statement for agents that support the\nmonitoring of the LMP MIB.")

# Exports

# Module identity
mibBuilder.exportSymbols("LMP-MIB", PYSNMP_MODULE_ID=lmpMIB)

# Types
mibBuilder.exportSymbols("LMP-MIB", LmpInterval=LmpInterval, LmpNodeId=LmpNodeId, LmpRetransmitInterval=LmpRetransmitInterval)

# Objects
mibBuilder.exportSymbols("LMP-MIB", lmpMIB=lmpMIB, lmpNotifications=lmpNotifications, lmpObjects=lmpObjects, lmpAdminStatus=lmpAdminStatus, lmpOperStatus=lmpOperStatus, lmpNbrTable=lmpNbrTable, lmpNbrEntry=lmpNbrEntry, lmpNbrNodeId=lmpNbrNodeId, lmpNbrRetransmitInterval=lmpNbrRetransmitInterval, lmpNbrRetryLimit=lmpNbrRetryLimit, lmpNbrRetransmitDelta=lmpNbrRetransmitDelta, lmpNbrAdminStatus=lmpNbrAdminStatus, lmpNbrOperStatus=lmpNbrOperStatus, lmpNbrRowStatus=lmpNbrRowStatus, lmpNbrStorageType=lmpNbrStorageType, lmpCcHelloIntervalDefault=lmpCcHelloIntervalDefault, lmpCcHelloIntervalDefaultMin=lmpCcHelloIntervalDefaultMin, lmpCcHelloIntervalDefaultMax=lmpCcHelloIntervalDefaultMax, lmpCcHelloDeadIntervalDefault=lmpCcHelloDeadIntervalDefault, lmpCcHelloDeadIntervalDefaultMin=lmpCcHelloDeadIntervalDefaultMin, lmpCcHelloDeadIntervalDefaultMax=lmpCcHelloDeadIntervalDefaultMax, lmpControlChannelTable=lmpControlChannelTable, lmpControlChannelEntry=lmpControlChannelEntry, lmpCcId=lmpCcId, lmpCcUnderlyingIfIndex=lmpCcUnderlyingIfIndex, lmpCcIsIf=lmpCcIsIf, lmpCcNbrNodeId=lmpCcNbrNodeId, lmpCcRemoteId=lmpCcRemoteId, lmpCcRemoteAddressType=lmpCcRemoteAddressType, lmpCcRemoteIpAddr=lmpCcRemoteIpAddr, lmpCcSetupRole=lmpCcSetupRole, lmpCcAuthentication=lmpCcAuthentication, lmpCcHelloInterval=lmpCcHelloInterval, lmpCcHelloIntervalMin=lmpCcHelloIntervalMin, lmpCcHelloIntervalMax=lmpCcHelloIntervalMax, lmpCcHelloIntervalNegotiated=lmpCcHelloIntervalNegotiated, lmpCcHelloDeadInterval=lmpCcHelloDeadInterval, lmpCcHelloDeadIntervalMin=lmpCcHelloDeadIntervalMin, lmpCcHelloDeadIntervalMax=lmpCcHelloDeadIntervalMax, lmpCcHelloDeadIntervalNegotiated=lmpCcHelloDeadIntervalNegotiated, lmpCcLastChange=lmpCcLastChange, lmpCcAdminStatus=lmpCcAdminStatus, lmpCcOperStatus=lmpCcOperStatus, lmpCcRowStatus=lmpCcRowStatus, lmpCcStorageType=lmpCcStorageType, lmpControlChannelPerfTable=lmpControlChannelPerfTable, lmpControlChannelPerfEntry=lmpControlChannelPerfEntry, lmpCcInOctets=lmpCcInOctets, lmpCcInDiscards=lmpCcInDiscards, lmpCcInErrors=lmpCcInErrors, lmpCcOutOctets=lmpCcOutOctets, lmpCcOutDiscards=lmpCcOutDiscards, lmpCcOutErrors=lmpCcOutErrors, lmpCcConfigReceived=lmpCcConfigReceived, lmpCcConfigSent=lmpCcConfigSent, lmpCcConfigRetransmit=lmpCcConfigRetransmit, lmpCcConfigAckReceived=lmpCcConfigAckReceived, lmpCcConfigAckSent=lmpCcConfigAckSent, lmpCcConfigNackReceived=lmpCcConfigNackReceived, lmpCcConfigNackSent=lmpCcConfigNackSent, lmpCcHelloReceived=lmpCcHelloReceived, lmpCcHelloSent=lmpCcHelloSent, lmpCcBeginVerifyReceived=lmpCcBeginVerifyReceived, lmpCcBeginVerifySent=lmpCcBeginVerifySent, lmpCcBeginVerifyRetransmit=lmpCcBeginVerifyRetransmit, lmpCcBeginVerifyAckReceived=lmpCcBeginVerifyAckReceived, lmpCcBeginVerifyAckSent=lmpCcBeginVerifyAckSent, lmpCcBeginVerifyNackReceived=lmpCcBeginVerifyNackReceived, lmpCcBeginVerifyNackSent=lmpCcBeginVerifyNackSent, lmpCcEndVerifyReceived=lmpCcEndVerifyReceived, lmpCcEndVerifySent=lmpCcEndVerifySent, lmpCcEndVerifyRetransmit=lmpCcEndVerifyRetransmit, lmpCcEndVerifyAckReceived=lmpCcEndVerifyAckReceived, lmpCcEndVerifyAckSent=lmpCcEndVerifyAckSent, lmpCcTestStatusSuccessReceived=lmpCcTestStatusSuccessReceived, lmpCcTestStatusSuccessSent=lmpCcTestStatusSuccessSent, lmpCcTestStatusSuccessRetransmit=lmpCcTestStatusSuccessRetransmit, lmpCcTestStatusFailureReceived=lmpCcTestStatusFailureReceived, lmpCcTestStatusFailureSent=lmpCcTestStatusFailureSent, lmpCcTestStatusFailureRetransmit=lmpCcTestStatusFailureRetransmit, lmpCcTestStatusAckReceived=lmpCcTestStatusAckReceived, lmpCcTestStatusAckSent=lmpCcTestStatusAckSent, lmpCcLinkSummaryReceived=lmpCcLinkSummaryReceived, lmpCcLinkSummarySent=lmpCcLinkSummarySent, lmpCcLinkSummaryRetransmit=lmpCcLinkSummaryRetransmit, lmpCcLinkSummaryAckReceived=lmpCcLinkSummaryAckReceived, lmpCcLinkSummaryAckSent=lmpCcLinkSummaryAckSent, lmpCcLinkSummaryNackReceived=lmpCcLinkSummaryNackReceived, lmpCcLinkSummaryNackSent=lmpCcLinkSummaryNackSent, lmpCcChannelStatusReceived=lmpCcChannelStatusReceived, lmpCcChannelStatusSent=lmpCcChannelStatusSent, lmpCcChannelStatusRetransmit=lmpCcChannelStatusRetransmit, lmpCcChannelStatusAckReceived=lmpCcChannelStatusAckReceived, lmpCcChannelStatusAckSent=lmpCcChannelStatusAckSent, lmpCcChannelStatusReqReceived=lmpCcChannelStatusReqReceived, lmpCcChannelStatusReqSent=lmpCcChannelStatusReqSent, lmpCcChannelStatusReqRetransmit=lmpCcChannelStatusReqRetransmit, lmpCcChannelStatusRspReceived=lmpCcChannelStatusRspReceived, lmpCcChannelStatusRspSent=lmpCcChannelStatusRspSent, lmpCcCounterDiscontinuityTime=lmpCcCounterDiscontinuityTime, lmpTeLinkTable=lmpTeLinkTable, lmpTeLinkEntry=lmpTeLinkEntry, lmpTeLinkNbrRemoteNodeId=lmpTeLinkNbrRemoteNodeId, lmpTeLinkVerification=lmpTeLinkVerification, lmpTeLinkFaultManagement=lmpTeLinkFaultManagement, lmpTeLinkDwdm=lmpTeLinkDwdm, lmpTeLinkOperStatus=lmpTeLinkOperStatus, lmpTeLinkRowStatus=lmpTeLinkRowStatus, lmpTeLinkStorageType=lmpTeLinkStorageType, lmpGlobalLinkVerificationInterval=lmpGlobalLinkVerificationInterval, lmpLinkVerificationTable=lmpLinkVerificationTable, lmpLinkVerificationEntry=lmpLinkVerificationEntry, lmpLinkVerifyInterval=lmpLinkVerifyInterval, lmpLinkVerifyDeadInterval=lmpLinkVerifyDeadInterval, lmpLinkVerifyTransportMechanism=lmpLinkVerifyTransportMechanism, lmpLinkVerifyAllLinks=lmpLinkVerifyAllLinks, lmpLinkVerifyTransmissionRate=lmpLinkVerifyTransmissionRate, lmpLinkVerifyWavelength=lmpLinkVerifyWavelength, lmpLinkVerifyRowStatus=lmpLinkVerifyRowStatus, lmpLinkVerifyStorageType=lmpLinkVerifyStorageType, lmpTeLinkPerfTable=lmpTeLinkPerfTable, lmpTeLinkPerfEntry=lmpTeLinkPerfEntry, lmpTeInOctets=lmpTeInOctets, lmpTeOutOctets=lmpTeOutOctets, lmpTeBeginVerifyReceived=lmpTeBeginVerifyReceived, lmpTeBeginVerifySent=lmpTeBeginVerifySent)
mibBuilder.exportSymbols("LMP-MIB", lmpTeBeginVerifyRetransmit=lmpTeBeginVerifyRetransmit, lmpTeBeginVerifyAckReceived=lmpTeBeginVerifyAckReceived, lmpTeBeginVerifyAckSent=lmpTeBeginVerifyAckSent, lmpTeBeginVerifyNackReceived=lmpTeBeginVerifyNackReceived, lmpTeBeginVerifyNackSent=lmpTeBeginVerifyNackSent, lmpTeEndVerifyReceived=lmpTeEndVerifyReceived, lmpTeEndVerifySent=lmpTeEndVerifySent, lmpTeEndVerifyRetransmit=lmpTeEndVerifyRetransmit, lmpTeEndVerifyAckReceived=lmpTeEndVerifyAckReceived, lmpTeEndVerifyAckSent=lmpTeEndVerifyAckSent, lmpTeTestStatusSuccessReceived=lmpTeTestStatusSuccessReceived, lmpTeTestStatusSuccessSent=lmpTeTestStatusSuccessSent, lmpTeTestStatusSuccessRetransmit=lmpTeTestStatusSuccessRetransmit, lmpTeTestStatusFailureReceived=lmpTeTestStatusFailureReceived, lmpTeTestStatusFailureSent=lmpTeTestStatusFailureSent, lmpTeTestStatusFailureRetransmit=lmpTeTestStatusFailureRetransmit, lmpTeTestStatusAckReceived=lmpTeTestStatusAckReceived, lmpTeTestStatusAckSent=lmpTeTestStatusAckSent, lmpTeLinkSummaryReceived=lmpTeLinkSummaryReceived, lmpTeLinkSummarySent=lmpTeLinkSummarySent, lmpTeLinkSummaryRetransmit=lmpTeLinkSummaryRetransmit, lmpTeLinkSummaryAckReceived=lmpTeLinkSummaryAckReceived, lmpTeLinkSummaryAckSent=lmpTeLinkSummaryAckSent, lmpTeLinkSummaryNackReceived=lmpTeLinkSummaryNackReceived, lmpTeLinkSummaryNackSent=lmpTeLinkSummaryNackSent, lmpTeChannelStatusReceived=lmpTeChannelStatusReceived, lmpTeChannelStatusSent=lmpTeChannelStatusSent, lmpTeChannelStatusRetransmit=lmpTeChannelStatusRetransmit, lmpTeChannelStatusAckReceived=lmpTeChannelStatusAckReceived, lmpTeChannelStatusAckSent=lmpTeChannelStatusAckSent, lmpTeChannelStatusReqReceived=lmpTeChannelStatusReqReceived, lmpTeChannelStatusReqSent=lmpTeChannelStatusReqSent, lmpTeChannelStatusReqRetransmit=lmpTeChannelStatusReqRetransmit, lmpTeChannelStatusRspReceived=lmpTeChannelStatusRspReceived, lmpTeChannelStatusRspSent=lmpTeChannelStatusRspSent, lmpTeCounterDiscontinuityTime=lmpTeCounterDiscontinuityTime, lmpDataLinkTable=lmpDataLinkTable, lmpDataLinkEntry=lmpDataLinkEntry, lmpDataLinkType=lmpDataLinkType, lmpDataLinkAddressType=lmpDataLinkAddressType, lmpDataLinkIpAddr=lmpDataLinkIpAddr, lmpDataLinkRemoteIpAddress=lmpDataLinkRemoteIpAddress, lmpDataLinkRemoteIfId=lmpDataLinkRemoteIfId, lmpDataLinkEncodingType=lmpDataLinkEncodingType, lmpDataLinkActiveOperStatus=lmpDataLinkActiveOperStatus, lmpDataLinkPassiveOperStatus=lmpDataLinkPassiveOperStatus, lmpDataLinkRowStatus=lmpDataLinkRowStatus, lmpDataLinkStorageType=lmpDataLinkStorageType, lmpDataLinkPerfTable=lmpDataLinkPerfTable, lmpDataLinkPerfEntry=lmpDataLinkPerfEntry, lmpDataLinkTestReceived=lmpDataLinkTestReceived, lmpDataLinkTestSent=lmpDataLinkTestSent, lmpDataLinkActiveTestSuccess=lmpDataLinkActiveTestSuccess, lmpDataLinkActiveTestFailure=lmpDataLinkActiveTestFailure, lmpDataLinkPassiveTestSuccess=lmpDataLinkPassiveTestSuccess, lmpDataLinkPassiveTestFailure=lmpDataLinkPassiveTestFailure, lmpDataLinkDiscontinuityTime=lmpDataLinkDiscontinuityTime, lmpNotificationMaxRate=lmpNotificationMaxRate, lmpLinkPropertyNotificationsEnabled=lmpLinkPropertyNotificationsEnabled, lmpUnprotectedNotificationsEnabled=lmpUnprotectedNotificationsEnabled, lmpCcUpDownNotificationsEnabled=lmpCcUpDownNotificationsEnabled, lmpTeLinkNotificationsEnabled=lmpTeLinkNotificationsEnabled, lmpDataLinkNotificationsEnabled=lmpDataLinkNotificationsEnabled, lmpConformance=lmpConformance, lmpCompliances=lmpCompliances, lmpGroups=lmpGroups)

# Notifications
mibBuilder.exportSymbols("LMP-MIB", lmpTeLinkPropertyMismatch=lmpTeLinkPropertyMismatch, lmpDataLinkPropertyMismatch=lmpDataLinkPropertyMismatch, lmpUnprotected=lmpUnprotected, lmpControlChannelUp=lmpControlChannelUp, lmpControlChannelDown=lmpControlChannelDown, lmpTeLinkDegraded=lmpTeLinkDegraded, lmpTeLinkNotDegraded=lmpTeLinkNotDegraded, lmpDataLinkVerificationFailure=lmpDataLinkVerificationFailure)

# Groups
mibBuilder.exportSymbols("LMP-MIB", lmpNodeGroup=lmpNodeGroup, lmpControlChannelGroup=lmpControlChannelGroup, lmpCcIsInterfaceGroup=lmpCcIsInterfaceGroup, lmpCcIsNotInterfaceGroup=lmpCcIsNotInterfaceGroup, lmpLinkPropertyCorrelationGroup=lmpLinkPropertyCorrelationGroup, lmpLinkVerificationGroup=lmpLinkVerificationGroup, lmpPerfGroup=lmpPerfGroup, lmpTeLinkGroup=lmpTeLinkGroup, lmpDataLinkGroup=lmpDataLinkGroup, lmpNotificationGroup=lmpNotificationGroup)

# Compliances
mibBuilder.exportSymbols("LMP-MIB", lmpModuleFullCompliance=lmpModuleFullCompliance, lmpModuleReadOnlyCompliance=lmpModuleReadOnlyCompliance)
