# Copyright 2013 The Chromium Authors. All rights reserved.
# Use of this source code is governed by a BSD-style license that can be
# found in the LICENSE file.

{
  'variables': {
    'chromium_code': 1,

    'linux_link_kerberos%': 0,
    'use_tracing_cache_backend%': 0,
    'conditions': [
      ['chromeos==1 or embedded==1 or OS=="android" or OS=="ios"', {
        # Disable Kerberos on ChromeOS, Android and iOS, at least for now.
        # It needs configuration (krb5.conf and so on).
        'use_kerberos%': 0,
      }, {  # chromeos == 0 and embedded==0 and OS!="android" and OS!="ios"
        'use_kerberos%': 1,
      }],
      ['OS=="android" and target_arch != "ia32"', {
        # The way the cache uses mmap() is inefficient on some Android devices.
        # If this flag is set, we hackily avoid using mmap() in the disk cache.
        # We are pretty confident that mmap-ing the index would not hurt any
        # existing x86 android devices, but we cannot be so sure about the
        # variety of ARM devices. So enable it for x86 only for now.
        'posix_avoid_mmap%': 1,
      }, {
        'posix_avoid_mmap%': 0,
      }],
      ['OS=="ios"', {
        # Websockets and socket stream are not used on iOS.
        'enable_websockets%': 0,
        # iOS does not use V8.
        'use_v8_in_net%': 0,
        'enable_built_in_dns%': 0,
      }, {
        'enable_websockets%': 1,
        'use_v8_in_net%': 1,
        'enable_built_in_dns%': 1,
      }],
    ],
  },
  'includes': [
    '../build/win_precompile.gypi',
  ],
  'targets': [
    {
      'target_name': 'net',
      'type': '<(component)',
      'variables': { 'enable_wexit_time_destructors': 1, },
      'dependencies': [
        '../base/base.gyp:base',
        '../base/base.gyp:base_i18n',
        '../base/third_party/dynamic_annotations/dynamic_annotations.gyp:dynamic_annotations',
        '../crypto/crypto.gyp:crypto',
        '../sdch/sdch.gyp:sdch',
        '../third_party/icu/icu.gyp:icui18n',
        '../third_party/icu/icu.gyp:icuuc',
        '../third_party/zlib/zlib.gyp:zlib',
        '../url/url.gyp:url_lib',
        'net_resources',
      ],
      'sources': [
        'android/cert_verify_result_android.cc',
        'android/cert_verify_result_android.h',
        'android/cert_verify_status_android_list.h',
        'android/gurl_utils.cc',
        'android/gurl_utils.h',
        'android/android_private_key.cc',
        'android/android_private_key.h',
        'android/keystore.cc',
        'android/keystore.h',
        'android/keystore_openssl.cc',
        'android/keystore_openssl.h',
        'android/net_jni_registrar.cc',
        'android/net_jni_registrar.h',
        'android/network_change_notifier_android.cc',
        'android/network_change_notifier_android.h',
        'android/network_change_notifier_delegate_android.cc',
        'android/network_change_notifier_delegate_android.h',
        'android/network_change_notifier_factory_android.cc',
        'android/network_change_notifier_factory_android.h',
        'android/network_library.cc',
        'android/network_library.h',
        'base/address_family.h',
        'base/address_list.cc',
        'base/address_list.h',
        'base/address_tracker_linux.cc',
        'base/address_tracker_linux.h',
        'base/auth.cc',
        'base/auth.h',
        'base/backoff_entry.cc',
        'base/backoff_entry.h',
        'base/bandwidth_metrics.cc',
        'base/bandwidth_metrics.h',
        'base/cache_type.h',
        'base/completion_callback.h',
        'base/connection_type_histograms.cc',
        'base/connection_type_histograms.h',
        'base/crypto_module.h',
        'base/crypto_module_nss.cc',
        'base/crypto_module_openssl.cc',
        'base/data_url.cc',
        'base/data_url.h',
        'base/directory_lister.cc',
        'base/directory_lister.h',
        'base/dns_reloader.cc',
        'base/dns_reloader.h',
        'base/dns_util.cc',
        'base/dns_util.h',
        'base/escape.cc',
        'base/escape.h',
        'base/expiring_cache.h',
        'base/file_stream.cc',
        'base/file_stream.h',
        'base/file_stream_context.cc',
        'base/file_stream_context.h',
        'base/file_stream_context_posix.cc',
        'base/file_stream_context_win.cc',
        'base/file_stream_metrics.cc',
        'base/file_stream_metrics.h',
        'base/file_stream_metrics_posix.cc',
        'base/file_stream_metrics_win.cc',
        'base/file_stream_net_log_parameters.cc',
        'base/file_stream_net_log_parameters.h',
        'base/file_stream_whence.h',
        'base/int128.cc',
        'base/int128.h',
        'base/hash_value.cc',
        'base/hash_value.h',
        'base/host_mapping_rules.cc',
        'base/host_mapping_rules.h',
        'base/host_port_pair.cc',
        'base/host_port_pair.h',
        'base/io_buffer.cc',
        'base/io_buffer.h',
        'base/iovec.h',
        'base/ip_endpoint.cc',
        'base/ip_endpoint.h',
        'base/ip_pattern.cc',
        'base/ip_pattern.h',
        'base/keygen_handler.cc',
        'base/keygen_handler.h',
        'base/keygen_handler_mac.cc',
        'base/keygen_handler_nss.cc',
        'base/keygen_handler_openssl.cc',
        'base/keygen_handler_win.cc',
        'base/linked_hash_map.h',
        'base/load_flags.h',
        'base/load_flags_list.h',
        'base/load_states.h',
        'base/load_states_list.h',
        'base/load_timing_info.cc',
        'base/load_timing_info.h',
        'base/mime_sniffer.cc',
        'base/mime_sniffer.h',
        'base/mime_util.cc',
        'base/mime_util.h',
        'base/net_error_list.h',
        'base/net_errors.cc',
        'base/net_errors.h',
        'base/net_errors_posix.cc',
        'base/net_errors_win.cc',
        'base/net_export.h',
        'base/net_log.cc',
        'base/net_log.h',
        'base/net_log_logger.cc',
        'base/net_log_logger.h',
        'base/net_log_event_type_list.h',
        'base/net_log_source_type_list.h',
        'base/net_module.cc',
        'base/net_module.h',
        'base/net_util.cc',
        'base/net_util.h',
        'base/net_util_posix.cc',
        'base/net_util_win.cc',
        'base/network_change_notifier.cc',
        'base/network_change_notifier.h',
        'base/network_change_notifier_factory.h',
        'base/network_change_notifier_linux.cc',
        'base/network_change_notifier_linux.h',
        'base/network_change_notifier_mac.cc',
        'base/network_change_notifier_mac.h',
        'base/network_change_notifier_win.cc',
        'base/network_change_notifier_win.h',
        'base/network_config_watcher_mac.cc',
        'base/network_config_watcher_mac.h',
        'base/network_delegate.cc',
        'base/network_delegate.h',
        'base/network_time_notifier.cc',
        'base/network_time_notifier.h',
        'base/nss_memio.c',
        'base/nss_memio.h',
        'base/openssl_private_key_store.h',
        'base/openssl_private_key_store_android.cc',
        'base/openssl_private_key_store_memory.cc',
        'base/platform_mime_util.h',
        # TODO(tc): gnome-vfs? xdgmime? /etc/mime.types?
        'base/platform_mime_util_linux.cc',
        'base/platform_mime_util_mac.mm',
        'base/platform_mime_util_win.cc',
        'base/prioritized_dispatcher.cc',
        'base/prioritized_dispatcher.h',
        'base/priority_queue.h',
        'base/rand_callback.h',
        'base/registry_controlled_domains/registry_controlled_domain.cc',
        'base/registry_controlled_domains/registry_controlled_domain.h',
        'base/request_priority.cc',
        'base/request_priority.h',
        'base/sdch_manager.cc',
        'base/sdch_manager.h',
        'base/static_cookie_policy.cc',
        'base/static_cookie_policy.h',
        'base/sys_addrinfo.h',
        'base/test_data_stream.cc',
        'base/test_data_stream.h',
        'base/upload_bytes_element_reader.cc',
        'base/upload_bytes_element_reader.h',
        'base/upload_data_stream.cc',
        'base/upload_data_stream.h',
        'base/upload_element.cc',
        'base/upload_element.h',
        'base/upload_element_reader.cc',
        'base/upload_element_reader.h',
        'base/upload_file_element_reader.cc',
        'base/upload_file_element_reader.h',
        'base/upload_progress.h',
        'base/url_util.cc',
        'base/url_util.h',
        'base/winsock_init.cc',
        'base/winsock_init.h',
        'base/winsock_util.cc',
        'base/winsock_util.h',
        'base/zap.cc',
        'base/zap.h',
        'cert/asn1_util.cc',
        'cert/asn1_util.h',
        'cert/cert_database.cc',
        'cert/cert_database.h',
        'cert/cert_database_android.cc',
        'cert/cert_database_ios.cc',
        'cert/cert_database_mac.cc',
        'cert/cert_database_nss.cc',
        'cert/cert_database_openssl.cc',
        'cert/cert_database_win.cc',
        'cert/cert_status_flags.cc',
        'cert/cert_status_flags.h',
        'cert/cert_trust_anchor_provider.h',
        'cert/cert_verifier.cc',
        'cert/cert_verifier.h',
        'cert/cert_verify_proc.cc',
        'cert/cert_verify_proc.h',
        'cert/cert_verify_proc_android.cc',
        'cert/cert_verify_proc_android.h',
        'cert/cert_verify_proc_mac.cc',
        'cert/cert_verify_proc_mac.h',
        'cert/cert_verify_proc_nss.cc',
        'cert/cert_verify_proc_nss.h',
        'cert/cert_verify_proc_openssl.cc',
        'cert/cert_verify_proc_openssl.h',
        'cert/cert_verify_proc_win.cc',
        'cert/cert_verify_proc_win.h',
        'cert/cert_verify_result.cc',
        'cert/cert_verify_result.h',
        'cert/crl_set.cc',
        'cert/crl_set.h',
        'cert/ct_known_logs.cc',
        'cert/ct_known_logs.h',
        'cert/ct_log_verifier.cc',
        'cert/ct_log_verifier.h',
        'cert/ct_log_verifier_nss.cc',
        'cert/ct_log_verifier_openssl.cc',
        'cert/ct_objects_extractor.h',
        'cert/ct_objects_extractor_nss.cc',
        'cert/ct_objects_extractor_openssl.cc',
        'cert/ct_serialization.cc',
        'cert/ct_serialization.h',
        'cert/ct_signed_certificate_timestamp_log_param.cc',
        'cert/ct_signed_certificate_timestamp_log_param.h',
        'cert/ct_verifier.h',
        'cert/ct_verify_result.cc',
        'cert/ct_verify_result.h',
        'cert/ev_root_ca_metadata.cc',
        'cert/ev_root_ca_metadata.h',
        'cert/jwk_serializer_nss.cc',
        'cert/jwk_serializer_openssl.cc',
        'cert/jwk_serializer.h',
        'cert/multi_log_ct_verifier.cc',
        'cert/multi_log_ct_verifier.h',
        'cert/multi_threaded_cert_verifier.cc',
        'cert/multi_threaded_cert_verifier.h',
        'cert/nss_cert_database.cc',
        'cert/nss_cert_database.h',
        'cert/nss_cert_database_chromeos.cc',
        'cert/nss_cert_database_chromeos.h',
        'cert/nss_profile_filter_chromeos.cc',
        'cert/nss_profile_filter_chromeos.h',
        'cert/pem_tokenizer.cc',
        'cert/pem_tokenizer.h',
        'cert/scoped_nss_types.h',
        'cert/sct_status_flags.h',
        'cert/signed_certificate_timestamp.cc',
        'cert/signed_certificate_timestamp.h',
        'cert/single_request_cert_verifier.cc',
        'cert/single_request_cert_verifier.h',
        'cert/test_root_certs.cc',
        'cert/test_root_certs.h',
        'cert/test_root_certs_android.cc',
        'cert/test_root_certs_mac.cc',
        'cert/test_root_certs_nss.cc',
        'cert/test_root_certs_openssl.cc',
        'cert/test_root_certs_win.cc',
        'cert/x509_cert_types.cc',
        'cert/x509_cert_types.h',
        'cert/x509_cert_types_mac.cc',
        'cert/x509_cert_types_win.cc',
        'cert/x509_certificate.cc',
        'cert/x509_certificate.h',
        'cert/x509_certificate_ios.cc',
        'cert/x509_certificate_mac.cc',
        'cert/x509_certificate_net_log_param.cc',
        'cert/x509_certificate_net_log_param.h',
        'cert/x509_certificate_nss.cc',
        'cert/x509_certificate_openssl.cc',
        'cert/x509_certificate_win.cc',
        'cert/x509_util.cc',
        'cert/x509_util.h',
        'cert/x509_util_android.cc',
        'cert/x509_util_android.h',
        'cert/x509_util_ios.cc',
        'cert/x509_util_ios.h',
        'cert/x509_util_mac.cc',
        'cert/x509_util_mac.h',
        'cert/x509_util_nss.cc',
        'cert/x509_util_nss.h',
        'cert/x509_util_openssl.cc',
        'cert/x509_util_openssl.h',
        'cookies/canonical_cookie.cc',
        'cookies/canonical_cookie.h',
        'cookies/cookie_constants.cc',
        'cookies/cookie_constants.h',
        'cookies/cookie_monster.cc',
        'cookies/cookie_monster.h',
        'cookies/cookie_options.h',
        'cookies/cookie_store.cc',
        'cookies/cookie_store.h',
        'cookies/cookie_util.cc',
        'cookies/cookie_util.h',
        'cookies/parsed_cookie.cc',
        'cookies/parsed_cookie.h',
        'disk_cache/blockfile/addr.cc',
        'disk_cache/blockfile/addr.h',
        'disk_cache/blockfile/backend_impl.cc',
        'disk_cache/blockfile/backend_impl.h',
        'disk_cache/blockfile/backend_impl_v3.cc',
        'disk_cache/blockfile/backend_impl_v3.h',
        'disk_cache/blockfile/backend_worker_v3.cc',
        'disk_cache/blockfile/backend_worker_v3.h',
        'disk_cache/blockfile/bitmap.cc',
        'disk_cache/blockfile/bitmap.h',
        'disk_cache/blockfile/block_bitmaps_v3.cc',
        'disk_cache/blockfile/block_bitmaps_v3.h',
        'disk_cache/blockfile/block_files.cc',
        'disk_cache/blockfile/block_files.h',
        'disk_cache/blockfile/disk_format.cc',
        'disk_cache/blockfile/disk_format.h',
        'disk_cache/blockfile/disk_format_base.h',
        'disk_cache/blockfile/disk_format_v3.h',
        'disk_cache/blockfile/entry_impl.cc',
        'disk_cache/blockfile/entry_impl.h',
        'disk_cache/blockfile/entry_impl_v3.cc',
        'disk_cache/blockfile/entry_impl_v3.h',
        'disk_cache/blockfile/errors.h',
        'disk_cache/blockfile/eviction.cc',
        'disk_cache/blockfile/eviction.h',
        'disk_cache/blockfile/eviction_v3.cc',
        'disk_cache/blockfile/eviction_v3.h',
        'disk_cache/blockfile/experiments.h',
        'disk_cache/blockfile/file.cc',
        'disk_cache/blockfile/file.h',
        'disk_cache/blockfile/file_block.h',
        'disk_cache/blockfile/file_ios.cc',
        'disk_cache/blockfile/file_lock.cc',
        'disk_cache/blockfile/file_lock.h',
        'disk_cache/blockfile/file_posix.cc',
        'disk_cache/blockfile/file_win.cc',
        'disk_cache/blockfile/histogram_macros.h',
        'disk_cache/blockfile/histogram_macros_v3.h',
        'disk_cache/blockfile/in_flight_backend_io.cc',
        'disk_cache/blockfile/in_flight_backend_io.h',
        'disk_cache/blockfile/in_flight_io.cc',
        'disk_cache/blockfile/in_flight_io.h',
        'disk_cache/blockfile/index_table_v3.cc',
        'disk_cache/blockfile/index_table_v3.h',
        'disk_cache/blockfile/mapped_file.cc',
        'disk_cache/blockfile/mapped_file.h',
        'disk_cache/blockfile/mapped_file_avoid_mmap_posix.cc',
        'disk_cache/blockfile/mapped_file_posix.cc',
        'disk_cache/blockfile/mapped_file_win.cc',
        'disk_cache/blockfile/rankings.cc',
        'disk_cache/blockfile/rankings.h',
        'disk_cache/blockfile/sparse_control.cc',
        'disk_cache/blockfile/sparse_control.h',
        'disk_cache/blockfile/stats.cc',
        'disk_cache/blockfile/stats.h',
        'disk_cache/blockfile/stats_histogram.cc',
        'disk_cache/blockfile/stats_histogram.h',
        'disk_cache/blockfile/storage_block-inl.h',
        'disk_cache/blockfile/storage_block.h',
        'disk_cache/blockfile/stress_support.h',
        'disk_cache/blockfile/trace.cc',
        'disk_cache/blockfile/trace.h',
        'disk_cache/cache_creator.cc',
        'disk_cache/cache_util.cc',
        'disk_cache/cache_util.h',
        'disk_cache/cache_util_posix.cc',
        'disk_cache/cache_util_win.cc',
        'disk_cache/disk_cache.h',
        'disk_cache/memory/mem_backend_impl.cc',
        'disk_cache/memory/mem_backend_impl.h',
        'disk_cache/memory/mem_entry_impl.cc',
        'disk_cache/memory/mem_entry_impl.h',
        'disk_cache/memory/mem_rankings.cc',
        'disk_cache/memory/mem_rankings.h',
        'disk_cache/net_log_parameters.cc',
        'disk_cache/net_log_parameters.h',
        'disk_cache/simple/simple_backend_impl.cc',
        'disk_cache/simple/simple_backend_impl.h',
        'disk_cache/simple/simple_backend_version.h',
        'disk_cache/simple/simple_entry_format.cc',
        'disk_cache/simple/simple_entry_format.h',
        'disk_cache/simple/simple_entry_format_history.h',
        'disk_cache/simple/simple_entry_impl.cc',
        'disk_cache/simple/simple_entry_impl.h',
        'disk_cache/simple/simple_entry_operation.cc',
        'disk_cache/simple/simple_entry_operation.h',
        'disk_cache/simple/simple_histogram_macros.h' ,
        'disk_cache/simple/simple_index.cc',
        'disk_cache/simple/simple_index.h',
        'disk_cache/simple/simple_index_delegate.h',
        'disk_cache/simple/simple_index_file.cc',
        'disk_cache/simple/simple_index_file.h',
        'disk_cache/simple/simple_index_file_posix.cc',
        'disk_cache/simple/simple_index_file_win.cc',
        'disk_cache/simple/simple_net_log_parameters.cc',
        'disk_cache/simple/simple_net_log_parameters.h',
        'disk_cache/simple/simple_synchronous_entry.cc',
        'disk_cache/simple/simple_synchronous_entry.h',
        'disk_cache/simple/simple_util.cc',
        'disk_cache/simple/simple_util.h',
        'disk_cache/simple/simple_version_upgrade.cc',
        'disk_cache/simple/simple_version_upgrade.h',
        'disk_cache/tracing/tracing_cache_backend.cc',
        'disk_cache/tracing/tracing_cache_backend.h',
        'dns/address_sorter.h',
        'dns/address_sorter_posix.cc',
        'dns/address_sorter_posix.h',
        'dns/address_sorter_win.cc',
        'dns/dns_client.cc',
        'dns/dns_client.h',
        'dns/dns_config_service.cc',
        'dns/dns_config_service.h',
        'dns/dns_config_service_posix.cc',
        'dns/dns_config_service_posix.h',
        'dns/dns_config_service_win.cc',
        'dns/dns_config_service_win.h',
        'dns/dns_config_watcher_mac.cc',
        'dns/dns_config_watcher_mac.h',
        'dns/dns_hosts.cc',
        'dns/dns_hosts.h',
        'dns/dns_protocol.h',
        'dns/dns_query.cc',
        'dns/dns_query.h',
        'dns/dns_response.cc',
        'dns/dns_response.h',
        'dns/dns_session.cc',
        'dns/dns_session.h',
        'dns/dns_socket_pool.cc',
        'dns/dns_socket_pool.h',
        'dns/dns_transaction.cc',
        'dns/dns_transaction.h',
        'dns/host_cache.cc',
        'dns/host_cache.h',
        'dns/host_resolver.cc',
        'dns/host_resolver.h',
        'dns/host_resolver_impl.cc',
        'dns/host_resolver_impl.h',
        'dns/host_resolver_proc.cc',
        'dns/host_resolver_proc.h',
        'dns/mapped_host_resolver.cc',
        'dns/mapped_host_resolver.h',
        'dns/mdns_cache.cc',
        'dns/mdns_cache.h',
        'dns/mdns_client.cc',
        'dns/mdns_client.h',
        'dns/mdns_client_impl.cc',
        'dns/mdns_client_impl.h',
        'dns/notify_watcher_mac.cc',
        'dns/notify_watcher_mac.h',
        'dns/record_parsed.cc',
        'dns/record_parsed.h',
        'dns/record_rdata.cc',
        'dns/record_rdata.h',
        'dns/serial_worker.cc',
        'dns/serial_worker.h',
        'dns/single_request_host_resolver.cc',
        'dns/single_request_host_resolver.h',
        'filter/filter.cc',
        'filter/filter.h',
        'filter/gzip_filter.cc',
        'filter/gzip_filter.h',
        'filter/gzip_header.cc',
        'filter/gzip_header.h',
        'filter/sdch_filter.cc',
        'filter/sdch_filter.h',
        'ftp/ftp_auth_cache.cc',
        'ftp/ftp_auth_cache.h',
        'ftp/ftp_ctrl_response_buffer.cc',
        'ftp/ftp_ctrl_response_buffer.h',
        'ftp/ftp_directory_listing_parser.cc',
        'ftp/ftp_directory_listing_parser.h',
        'ftp/ftp_directory_listing_parser_ls.cc',
        'ftp/ftp_directory_listing_parser_ls.h',
        'ftp/ftp_directory_listing_parser_netware.cc',
        'ftp/ftp_directory_listing_parser_netware.h',
        'ftp/ftp_directory_listing_parser_os2.cc',
        'ftp/ftp_directory_listing_parser_os2.h',
        'ftp/ftp_directory_listing_parser_vms.cc',
        'ftp/ftp_directory_listing_parser_vms.h',
        'ftp/ftp_directory_listing_parser_windows.cc',
        'ftp/ftp_directory_listing_parser_windows.h',
        'ftp/ftp_network_layer.cc',
        'ftp/ftp_network_layer.h',
        'ftp/ftp_network_session.cc',
        'ftp/ftp_network_session.h',
        'ftp/ftp_network_transaction.cc',
        'ftp/ftp_network_transaction.h',
        'ftp/ftp_request_info.h',
        'ftp/ftp_response_info.cc',
        'ftp/ftp_response_info.h',
        'ftp/ftp_server_type_histograms.cc',
        'ftp/ftp_server_type_histograms.h',
        'ftp/ftp_transaction.h',
        'ftp/ftp_transaction_factory.h',
        'ftp/ftp_util.cc',
        'ftp/ftp_util.h',
        'http/des.cc',
        'http/des.h',
        'http/disk_cache_based_quic_server_info.cc',
        'http/disk_cache_based_quic_server_info.h',
	'http/failing_http_transaction_factory.cc',
	'http/failing_http_transaction_factory.h',
        'http/http_atom_list.h',
        'http/http_auth.cc',
        'http/http_auth.h',
        'http/http_auth_cache.cc',
        'http/http_auth_cache.h',
        'http/http_auth_challenge_tokenizer.cc',
        'http/http_auth_challenge_tokenizer.h',
        'http/http_auth_controller.cc',
        'http/http_auth_controller.h',
        'http/http_auth_filter.cc',
        'http/http_auth_filter.h',
        'http/http_auth_filter_win.h',
        'http/http_auth_gssapi_posix.cc',
        'http/http_auth_gssapi_posix.h',
        'http/http_auth_handler.cc',
        'http/http_auth_handler.h',
        'http/http_auth_handler_basic.cc',
        'http/http_auth_handler_basic.h',
        'http/http_auth_handler_digest.cc',
        'http/http_auth_handler_digest.h',
        'http/http_auth_handler_factory.cc',
        'http/http_auth_handler_factory.h',
        'http/http_auth_handler_negotiate.cc',
        'http/http_auth_handler_negotiate.h',
        'http/http_auth_handler_ntlm.cc',
        'http/http_auth_handler_ntlm.h',
        'http/http_auth_handler_ntlm_portable.cc',
        'http/http_auth_handler_ntlm_win.cc',
        'http/http_auth_sspi_win.cc',
        'http/http_auth_sspi_win.h',
        'http/http_basic_state.cc',
        'http/http_basic_state.h',
        'http/http_basic_stream.cc',
        'http/http_basic_stream.h',
        'http/http_byte_range.cc',
        'http/http_byte_range.h',
        'http/http_cache.cc',
        'http/http_cache.h',
        'http/http_cache_transaction.cc',
        'http/http_cache_transaction.h',
        'http/http_content_disposition.cc',
        'http/http_content_disposition.h',
        'http/http_chunked_decoder.cc',
        'http/http_chunked_decoder.h',
        'http/http_log_util.cc',
        'http/http_log_util.h',
        'http/http_network_layer.cc',
        'http/http_network_layer.h',
        'http/http_network_session.cc',
        'http/http_network_session.h',
        'http/http_network_session_peer.cc',
        'http/http_network_session_peer.h',
        'http/http_network_transaction.cc',
        'http/http_network_transaction.h',
        'http/http_pipelined_connection.h',
        'http/http_pipelined_connection_impl.cc',
        'http/http_pipelined_connection_impl.h',
        'http/http_pipelined_host.cc',
        'http/http_pipelined_host.h',
        'http/http_pipelined_host_capability.h',
        'http/http_pipelined_host_forced.cc',
        'http/http_pipelined_host_forced.h',
        'http/http_pipelined_host_impl.cc',
        'http/http_pipelined_host_impl.h',
        'http/http_pipelined_host_pool.cc',
        'http/http_pipelined_host_pool.h',
        'http/http_pipelined_stream.cc',
        'http/http_pipelined_stream.h',
        'http/http_proxy_client_socket.cc',
        'http/http_proxy_client_socket.h',
        'http/http_proxy_client_socket_pool.cc',
        'http/http_proxy_client_socket_pool.h',
        'http/http_request_headers.cc',
        'http/http_request_headers.h',
        'http/http_request_info.cc',
        'http/http_request_info.h',
        'http/http_response_body_drainer.cc',
        'http/http_response_body_drainer.h',
        'http/http_response_headers.cc',
        'http/http_response_headers.h',
        'http/http_response_info.cc',
        'http/http_response_info.h',
        'http/http_security_headers.cc',
        'http/http_security_headers.h',
        'http/http_server_properties.cc',
        'http/http_server_properties.h',
        'http/http_server_properties_impl.cc',
        'http/http_server_properties_impl.h',
        'http/http_status_code.cc',
        'http/http_status_code.h',
        'http/http_stream.h',
        'http/http_stream_base.h',
        'http/http_stream_factory.cc',
        'http/http_stream_factory.h',
        'http/http_stream_factory_impl.cc',
        'http/http_stream_factory_impl.h',
        'http/http_stream_factory_impl_job.cc',
        'http/http_stream_factory_impl_job.h',
        'http/http_stream_factory_impl_request.cc',
        'http/http_stream_factory_impl_request.h',
        'http/http_stream_parser.cc',
        'http/http_stream_parser.h',
        'http/http_transaction.h',
        'http/http_transaction_factory.h',
        'http/http_util.cc',
        'http/http_util.h',
        'http/http_util_icu.cc',
        'http/http_vary_data.cc',
        'http/http_vary_data.h',
        'http/http_version.h',
        'http/md4.cc',
        'http/md4.h',
        'http/partial_data.cc',
        'http/partial_data.h',
        'http/proxy_client_socket.h',
        'http/proxy_client_socket.cc',
        'http/proxy_connect_redirect_http_stream.cc',
        'http/proxy_connect_redirect_http_stream.h',
        'http/transport_security_persister.cc',
        'http/transport_security_persister.h',
        'http/transport_security_state.cc',
        'http/transport_security_state.h',
        'http/transport_security_state_static.h',
        'http/url_security_manager.cc',
        'http/url_security_manager.h',
        'http/url_security_manager_posix.cc',
        'http/url_security_manager_win.cc',
        'ocsp/nss_ocsp.cc',
        'ocsp/nss_ocsp.h',
        'proxy/dhcp_proxy_script_adapter_fetcher_win.cc',
        'proxy/dhcp_proxy_script_adapter_fetcher_win.h',
        'proxy/dhcp_proxy_script_fetcher.cc',
        'proxy/dhcp_proxy_script_fetcher.h',
        'proxy/dhcp_proxy_script_fetcher_factory.cc',
        'proxy/dhcp_proxy_script_fetcher_factory.h',
        'proxy/dhcp_proxy_script_fetcher_win.cc',
        'proxy/dhcp_proxy_script_fetcher_win.h',
        'proxy/dhcpcsvc_init_win.cc',
        'proxy/dhcpcsvc_init_win.h',
        'proxy/multi_threaded_proxy_resolver.cc',
        'proxy/multi_threaded_proxy_resolver.h',
        'proxy/network_delegate_error_observer.cc',
        'proxy/network_delegate_error_observer.h',
        'proxy/polling_proxy_config_service.cc',
        'proxy/polling_proxy_config_service.h',
        'proxy/proxy_bypass_rules.cc',
        'proxy/proxy_bypass_rules.h',
        'proxy/proxy_config.cc',
        'proxy/proxy_config.h',
        'proxy/proxy_config_service.h',
        'proxy/proxy_config_service_android.cc',
        'proxy/proxy_config_service_android.h',
        'proxy/proxy_config_service_fixed.cc',
        'proxy/proxy_config_service_fixed.h',
        'proxy/proxy_config_service_ios.cc',
        'proxy/proxy_config_service_ios.h',
        'proxy/proxy_config_service_linux.cc',
        'proxy/proxy_config_service_linux.h',
        'proxy/proxy_config_service_mac.cc',
        'proxy/proxy_config_service_mac.h',
        'proxy/proxy_config_service_win.cc',
        'proxy/proxy_config_service_win.h',
        'proxy/proxy_config_source.cc',
        'proxy/proxy_config_source.h',
        'proxy/proxy_info.cc',
        'proxy/proxy_info.h',
        'proxy/proxy_list.cc',
        'proxy/proxy_list.h',
        'proxy/proxy_resolver.h',
        'proxy/proxy_resolver_error_observer.h',
        'proxy/proxy_resolver_mac.cc',
        'proxy/proxy_resolver_mac.h',
        'proxy/proxy_resolver_script.h',
        'proxy/proxy_resolver_script_data.cc',
        'proxy/proxy_resolver_script_data.h',
        'proxy/proxy_resolver_winhttp.cc',
        'proxy/proxy_resolver_winhttp.h',
        'proxy/proxy_retry_info.h',
        'proxy/proxy_script_decider.cc',
        'proxy/proxy_script_decider.h',
        'proxy/proxy_script_fetcher.h',
        'proxy/proxy_script_fetcher_impl.cc',
        'proxy/proxy_script_fetcher_impl.h',
        'proxy/proxy_server.cc',
        'proxy/proxy_server.h',
        'proxy/proxy_server_mac.cc',
        'proxy/proxy_service.cc',
        'proxy/proxy_service.h',
        'quic/congestion_control/available_channel_estimator.cc',
        'quic/congestion_control/available_channel_estimator.h',
        'quic/congestion_control/channel_estimator.cc',
        'quic/congestion_control/channel_estimator.h',
        'quic/congestion_control/cube_root.cc',
        'quic/congestion_control/cube_root.h',
        'quic/congestion_control/cubic.cc',
        'quic/congestion_control/cubic.h',
        'quic/congestion_control/fix_rate_receiver.cc',
        'quic/congestion_control/fix_rate_receiver.h',
        'quic/congestion_control/fix_rate_sender.cc',
        'quic/congestion_control/fix_rate_sender.h',
        'quic/congestion_control/hybrid_slow_start.cc',
        'quic/congestion_control/hybrid_slow_start.h',
        'quic/congestion_control/inter_arrival_bitrate_ramp_up.cc',
        'quic/congestion_control/inter_arrival_bitrate_ramp_up.h',
        'quic/congestion_control/inter_arrival_overuse_detector.cc',
        'quic/congestion_control/inter_arrival_overuse_detector.h',
        'quic/congestion_control/inter_arrival_probe.cc',
        'quic/congestion_control/inter_arrival_probe.h',
        'quic/congestion_control/inter_arrival_receiver.cc',
        'quic/congestion_control/inter_arrival_receiver.h',
        'quic/congestion_control/inter_arrival_sender.cc',
        'quic/congestion_control/inter_arrival_sender.h',
        'quic/congestion_control/inter_arrival_state_machine.cc',
        'quic/congestion_control/inter_arrival_state_machine.h',
        'quic/congestion_control/leaky_bucket.cc',
        'quic/congestion_control/leaky_bucket.h',
        'quic/congestion_control/loss_detection_interface.cc',
        'quic/congestion_control/loss_detection_interface.h',
        'quic/congestion_control/paced_sender.cc',
        'quic/congestion_control/paced_sender.h',
        'quic/congestion_control/pacing_sender.cc',
        'quic/congestion_control/pacing_sender.h',
        'quic/congestion_control/quic_max_sized_map.h',
        'quic/congestion_control/receive_algorithm_interface.cc',
        'quic/congestion_control/receive_algorithm_interface.h',
        'quic/congestion_control/rtt_stats.cc',
        'quic/congestion_control/rtt_stats.h',
        'quic/congestion_control/send_algorithm_interface.cc',
        'quic/congestion_control/send_algorithm_interface.h',
        'quic/congestion_control/tcp_cubic_sender.cc',
        'quic/congestion_control/tcp_cubic_sender.h',
        'quic/congestion_control/tcp_loss_algorithm.cc',
        'quic/congestion_control/tcp_loss_algorithm.h',
        'quic/congestion_control/tcp_receiver.cc',
        'quic/congestion_control/tcp_receiver.h',
        'quic/congestion_control/time_loss_algorithm.cc',
        'quic/congestion_control/time_loss_algorithm.h',
        'quic/crypto/aead_base_decrypter.h',
        'quic/crypto/aead_base_decrypter_nss.cc',
        'quic/crypto/aead_base_decrypter_openssl.cc',
        'quic/crypto/aead_base_encrypter.h',
        'quic/crypto/aead_base_encrypter_nss.cc',
        'quic/crypto/aead_base_encrypter_openssl.cc',
        'quic/crypto/aes_128_gcm_12_decrypter.h',
        'quic/crypto/aes_128_gcm_12_decrypter_nss.cc',
        'quic/crypto/aes_128_gcm_12_decrypter_openssl.cc',
        'quic/crypto/aes_128_gcm_12_encrypter.h',
        'quic/crypto/aes_128_gcm_12_encrypter_nss.cc',
        'quic/crypto/aes_128_gcm_12_encrypter_openssl.cc',
        'quic/crypto/cert_compressor.cc',
        'quic/crypto/cert_compressor.h',
        'quic/crypto/chacha20_poly1305_decrypter.h',
        'quic/crypto/chacha20_poly1305_decrypter_nss.cc',
        'quic/crypto/chacha20_poly1305_decrypter_openssl.cc',
        'quic/crypto/chacha20_poly1305_encrypter.h',
        'quic/crypto/chacha20_poly1305_encrypter_nss.cc',
        'quic/crypto/chacha20_poly1305_encrypter_openssl.cc',
        'quic/crypto/channel_id.cc',
        'quic/crypto/channel_id.h',
        'quic/crypto/channel_id_nss.cc',
        'quic/crypto/channel_id_openssl.cc',
        'quic/crypto/common_cert_set.cc',
        'quic/crypto/common_cert_set.h',
        'quic/crypto/crypto_framer.cc',
        'quic/crypto/crypto_framer.h',
        'quic/crypto/crypto_handshake.cc',
        'quic/crypto/crypto_handshake.h',
        'quic/crypto/crypto_handshake_message.cc',
        'quic/crypto/crypto_handshake_message.h',
        'quic/crypto/crypto_protocol.h',
        'quic/crypto/crypto_secret_boxer.cc',
        'quic/crypto/crypto_secret_boxer.h',
        'quic/crypto/crypto_server_config_protobuf.cc',
        'quic/crypto/crypto_server_config_protobuf.h',
        'quic/crypto/crypto_utils.cc',
        'quic/crypto/crypto_utils.h',
        'quic/crypto/curve25519_key_exchange.cc',
        'quic/crypto/curve25519_key_exchange.h',
        'quic/crypto/ephemeral_key_source.h',
        'quic/crypto/key_exchange.h',
        'quic/crypto/local_strike_register_client.cc',
        'quic/crypto/local_strike_register_client.h',
        'quic/crypto/null_decrypter.cc',
        'quic/crypto/null_decrypter.h',
        'quic/crypto/null_encrypter.cc',
        'quic/crypto/null_encrypter.h',
        'quic/crypto/p256_key_exchange.h',
        'quic/crypto/p256_key_exchange_nss.cc',
        'quic/crypto/p256_key_exchange_openssl.cc',
        'quic/crypto/proof_source.h',
        'quic/crypto/proof_source_chromium.cc',
        'quic/crypto/proof_source_chromium.h',
        'quic/crypto/proof_verifier.h',
        'quic/crypto/proof_verifier_chromium.cc',
        'quic/crypto/proof_verifier_chromium.h',
        'quic/crypto/quic_crypto_client_config.cc',
        'quic/crypto/quic_crypto_client_config.h',
        'quic/crypto/quic_crypto_server_config.cc',
        'quic/crypto/quic_crypto_server_config.h',
        'quic/crypto/quic_decrypter.cc',
        'quic/crypto/quic_decrypter.h',
        'quic/crypto/quic_encrypter.cc',
        'quic/crypto/quic_encrypter.h',
        'quic/crypto/quic_random.cc',
        'quic/crypto/quic_random.h',
        'quic/crypto/quic_server_info.cc',
        'quic/crypto/quic_server_info.h',
        'quic/crypto/scoped_evp_aead_ctx.cc',
        'quic/crypto/scoped_evp_aead_ctx.h',
        'quic/crypto/strike_register.cc',
        'quic/crypto/strike_register.h',
        'quic/crypto/strike_register_client.h',
        'quic/crypto/source_address_token.cc',
        'quic/crypto/source_address_token.h',
        'quic/iovector.cc',
        'quic/iovector.h',
        'quic/port_suggester.cc',
        'quic/port_suggester.h',
        'quic/quic_ack_notifier.cc',
        'quic/quic_ack_notifier.h',
        'quic/quic_ack_notifier_manager.cc',
        'quic/quic_ack_notifier_manager.h',
        'quic/quic_address_mismatch.cc',
        'quic/quic_address_mismatch.h',
        'quic/quic_alarm.cc',
        'quic/quic_alarm.h',
        'quic/quic_bandwidth.cc',
        'quic/quic_bandwidth.h',
        'quic/quic_blocked_writer_interface.h',
        'quic/quic_client_session.cc',
        'quic/quic_client_session.h',
        'quic/quic_client_session_base.cc',
        'quic/quic_client_session_base.h',
        'quic/quic_clock.cc',
        'quic/quic_clock.h',
        'quic/quic_config.cc',
        'quic/quic_config.h',
        'quic/quic_connection.cc',
        'quic/quic_connection.h',
        'quic/quic_connection_helper.cc',
        'quic/quic_connection_helper.h',
        'quic/quic_connection_logger.cc',
        'quic/quic_connection_logger.h',
        'quic/quic_connection_stats.cc',
        'quic/quic_connection_stats.h',
        'quic/quic_crypto_client_stream.cc',
        'quic/quic_crypto_client_stream.h',
        'quic/quic_crypto_client_stream_factory.h',
        'quic/quic_crypto_server_stream.cc',
        'quic/quic_crypto_server_stream.h',
        'quic/quic_crypto_stream.cc',
        'quic/quic_crypto_stream.h',
        'quic/quic_data_reader.cc',
        'quic/quic_data_reader.h',
        'quic/quic_data_stream.cc',
        'quic/quic_data_stream.h',
        'quic/quic_data_writer.cc',
        'quic/quic_data_writer.h',
        'quic/quic_default_packet_writer.cc',
        'quic/quic_default_packet_writer.h',
        'quic/quic_fec_group.cc',
        'quic/quic_fec_group.h',
        'quic/quic_framer.cc',
        'quic/quic_framer.h',
        'quic/quic_headers_stream.cc',
        'quic/quic_headers_stream.h',
        'quic/quic_http_stream.cc',
        'quic/quic_http_stream.h',
        'quic/quic_http_utils.cc',
        'quic/quic_http_utils.h',
        'quic/quic_packet_creator.cc',
        'quic/quic_packet_creator.h',
        'quic/quic_packet_generator.cc',
        'quic/quic_packet_generator.h',
        'quic/quic_packet_writer.h',
        'quic/quic_protocol.cc',
        'quic/quic_protocol.h',
        'quic/quic_received_packet_manager.cc',
        'quic/quic_received_packet_manager.h',
        'quic/quic_reliable_client_stream.cc',
        'quic/quic_reliable_client_stream.h',
        'quic/quic_sent_entropy_manager.cc',
        'quic/quic_sent_entropy_manager.h',
        'quic/quic_sent_packet_manager.cc',
        'quic/quic_sent_packet_manager.h',
        'quic/quic_session.cc',
        'quic/quic_session.h',
        'quic/quic_session_key.cc',
        'quic/quic_session_key.h',
        'quic/quic_socket_address_coder.cc',
        'quic/quic_socket_address_coder.h',
        'quic/quic_stream_factory.cc',
        'quic/quic_stream_factory.h',
        'quic/quic_stream_sequencer.cc',
        'quic/quic_stream_sequencer.h',
        'quic/quic_time.cc',
        'quic/quic_time.h',
        'quic/quic_unacked_packet_map.cc',
        'quic/quic_unacked_packet_map.h',
        'quic/quic_utils.cc',
        'quic/quic_utils.h',
        'quic/quic_utils_chromium.h',
        'quic/quic_write_blocked_list.cc',
        'quic/quic_write_blocked_list.h',
        'quic/reliable_quic_stream.cc',
        'quic/reliable_quic_stream.h',
        'quic/spdy_utils.cc',
        'quic/spdy_utils.h',
        'socket/buffered_write_stream_socket.cc',
        'socket/buffered_write_stream_socket.h',
        'socket/client_socket_factory.cc',
        'socket/client_socket_factory.h',
        'socket/client_socket_handle.cc',
        'socket/client_socket_handle.h',
        'socket/client_socket_pool.cc',
        'socket/client_socket_pool.h',
        'socket/client_socket_pool_base.cc',
        'socket/client_socket_pool_base.h',
        'socket/client_socket_pool_histograms.cc',
        'socket/client_socket_pool_histograms.h',
        'socket/client_socket_pool_manager.cc',
        'socket/client_socket_pool_manager.h',
        'socket/client_socket_pool_manager_impl.cc',
        'socket/client_socket_pool_manager_impl.h',
        'socket/next_proto.h',
        'socket/nss_ssl_util.cc',
        'socket/nss_ssl_util.h',
        'socket/server_socket.h',
        'socket/socket_descriptor.cc',
        'socket/socket_descriptor.h',
        'socket/socket_net_log_params.cc',
        'socket/socket_net_log_params.h',
        'socket/socket.h',
        'socket/socks5_client_socket.cc',
        'socket/socks5_client_socket.h',
        'socket/socks_client_socket.cc',
        'socket/socks_client_socket.h',
        'socket/socks_client_socket_pool.cc',
        'socket/socks_client_socket_pool.h',
        'socket/ssl_client_socket.cc',
        'socket/ssl_client_socket.h',
        'socket/ssl_client_socket_nss.cc',
        'socket/ssl_client_socket_nss.h',
        'socket/ssl_client_socket_openssl.cc',
        'socket/ssl_client_socket_openssl.h',
        'socket/ssl_client_socket_pool.cc',
        'socket/ssl_client_socket_pool.h',
        'socket/ssl_error_params.cc',
        'socket/ssl_error_params.h',
        'socket/ssl_server_socket.h',
        'socket/ssl_server_socket_nss.cc',
        'socket/ssl_server_socket_nss.h',
        'socket/ssl_server_socket_openssl.cc',
        'socket/ssl_session_cache_openssl.cc',
        'socket/ssl_session_cache_openssl.h',
        'socket/ssl_socket.h',
        'socket/stream_listen_socket.cc',
        'socket/stream_listen_socket.h',
        'socket/stream_socket.cc',
        'socket/stream_socket.h',
        'socket/tcp_client_socket.cc',
        'socket/tcp_client_socket.h',
        'socket/tcp_listen_socket.cc',
        'socket/tcp_listen_socket.h',
        'socket/tcp_server_socket.cc',
        'socket/tcp_server_socket.h',
        'socket/tcp_socket.cc',
        'socket/tcp_socket.h',
        'socket/tcp_socket_libevent.cc',
        'socket/tcp_socket_libevent.h',
        'socket/tcp_socket_win.cc',
        'socket/tcp_socket_win.h',
        'socket/transport_client_socket_pool.cc',
        'socket/transport_client_socket_pool.h',
        'socket/unix_domain_socket_posix.cc',
        'socket/unix_domain_socket_posix.h',
        'socket_stream/socket_stream.cc',
        'socket_stream/socket_stream.h',
        'socket_stream/socket_stream_job.cc',
        'socket_stream/socket_stream_job.h',
        'socket_stream/socket_stream_job_manager.cc',
        'socket_stream/socket_stream_job_manager.h',
        'socket_stream/socket_stream_metrics.cc',
        'socket_stream/socket_stream_metrics.h',
        'spdy/buffered_spdy_framer.cc',
        'spdy/buffered_spdy_framer.h',
        'spdy/hpack_constants.cc',
        'spdy/hpack_constants.h',
        'spdy/hpack_decoder.cc',
        'spdy/hpack_decoder.h',
        'spdy/hpack_encoder.cc',
        'spdy/hpack_encoder.h',
        'spdy/hpack_encoding_context.cc',
        'spdy/hpack_encoding_context.h',
        'spdy/hpack_entry.cc',
        'spdy/hpack_entry.h',
        'spdy/hpack_header_table.cc',
        'spdy/hpack_header_table.h',
        'spdy/hpack_huffman_table.cc',
        'spdy/hpack_huffman_table.h',
        'spdy/hpack_input_stream.cc',
        'spdy/hpack_input_stream.h',
        'spdy/hpack_output_stream.cc',
        'spdy/hpack_output_stream.h',
        'spdy/hpack_string_util.cc',
        'spdy/hpack_string_util.h',
        'spdy/spdy_bitmasks.h',
        'spdy/spdy_buffer.cc',
        'spdy/spdy_buffer.h',
        'spdy/spdy_buffer_producer.cc',
        'spdy/spdy_buffer_producer.h',
        'spdy/spdy_frame_builder.cc',
        'spdy/spdy_frame_builder.h',
        'spdy/spdy_frame_reader.cc',
        'spdy/spdy_frame_reader.h',
        'spdy/spdy_framer.cc',
        'spdy/spdy_framer.h',
        'spdy/spdy_header_block.cc',
        'spdy/spdy_header_block.h',
        'spdy/spdy_headers_block_parser.cc',
        'spdy/spdy_headers_block_parser.h',
        'spdy/spdy_http_stream.cc',
        'spdy/spdy_http_stream.h',
        'spdy/spdy_http_utils.cc',
        'spdy/spdy_http_utils.h',
        'spdy/spdy_pinnable_buffer_piece.cc',
        'spdy/spdy_pinnable_buffer_piece.h',
        'spdy/spdy_prefixed_buffer_reader.cc',
        'spdy/spdy_prefixed_buffer_reader.h',
        'spdy/spdy_priority_forest.h',
        'spdy/spdy_protocol.cc',
        'spdy/spdy_protocol.h',
        'spdy/spdy_proxy_client_socket.cc',
        'spdy/spdy_proxy_client_socket.h',
        'spdy/spdy_read_queue.cc',
        'spdy/spdy_read_queue.h',
        'spdy/spdy_session.cc',
        'spdy/spdy_session.h',
        'spdy/spdy_session_key.cc',
        'spdy/spdy_session_key.h',
        'spdy/spdy_session_pool.cc',
        'spdy/spdy_session_pool.h',
        'spdy/spdy_stream.cc',
        'spdy/spdy_stream.h',
        'spdy/spdy_websocket_stream.cc',
        'spdy/spdy_websocket_stream.h',
        'spdy/spdy_write_queue.cc',
        'spdy/spdy_write_queue.h',
        'spdy/write_blocked_list.h',
        'ssl/client_cert_store.h',
        'ssl/client_cert_store_chromeos.cc',
        'ssl/client_cert_store_chromeos.h',
        'ssl/client_cert_store_mac.cc',
        'ssl/client_cert_store_mac.h',
        'ssl/client_cert_store_nss.cc',
        'ssl/client_cert_store_nss.h',
        'ssl/client_cert_store_win.cc',
        'ssl/client_cert_store_win.h',
        'ssl/default_server_bound_cert_store.cc',
        'ssl/default_server_bound_cert_store.h',
        'ssl/openssl_client_key_store.cc',
        'ssl/openssl_client_key_store.h',
        'ssl/server_bound_cert_service.cc',
        'ssl/server_bound_cert_service.h',
        'ssl/server_bound_cert_store.cc',
        'ssl/server_bound_cert_store.h',
        'ssl/signed_certificate_timestamp_and_status.cc',
        'ssl/signed_certificate_timestamp_and_status.h',
        'ssl/ssl_cert_request_info.cc',
        'ssl/ssl_cert_request_info.h',
        'ssl/ssl_cipher_suite_names.cc',
        'ssl/ssl_cipher_suite_names.h',
        'ssl/ssl_client_auth_cache.cc',
        'ssl/ssl_client_auth_cache.h',
        'ssl/ssl_client_cert_type.h',
        'ssl/ssl_config.cc',
        'ssl/ssl_config.h',
        'ssl/ssl_config_service.cc',
        'ssl/ssl_config_service.h',
        'ssl/ssl_config_service_defaults.cc',
        'ssl/ssl_config_service_defaults.h',
        'ssl/ssl_info.cc',
        'ssl/ssl_info.h',
        'third_party/mozilla_security_manager/nsKeygenHandler.cpp',
        'third_party/mozilla_security_manager/nsKeygenHandler.h',
        'third_party/mozilla_security_manager/nsNSSCertificateDB.cpp',
        'third_party/mozilla_security_manager/nsNSSCertificateDB.h',
        'third_party/mozilla_security_manager/nsPKCS12Blob.cpp',
        'third_party/mozilla_security_manager/nsPKCS12Blob.h',
        'udp/datagram_client_socket.h',
        'udp/datagram_server_socket.h',
        'udp/datagram_socket.h',
        'udp/udp_client_socket.cc',
        'udp/udp_client_socket.h',
        'udp/udp_net_log_parameters.cc',
        'udp/udp_net_log_parameters.h',
        'udp/udp_server_socket.cc',
        'udp/udp_server_socket.h',
        'udp/udp_socket.h',
        'udp/udp_socket_libevent.cc',
        'udp/udp_socket_libevent.h',
        'udp/udp_socket_win.cc',
        'udp/udp_socket_win.h',
        'url_request/data_protocol_handler.cc',
        'url_request/data_protocol_handler.h',
        'url_request/file_protocol_handler.cc',
        'url_request/file_protocol_handler.h',
        'url_request/fraudulent_certificate_reporter.h',
        'url_request/ftp_protocol_handler.cc',
        'url_request/ftp_protocol_handler.h',
        'url_request/http_user_agent_settings.h',
        'url_request/protocol_intercept_job_factory.cc',
        'url_request/protocol_intercept_job_factory.h',
        'url_request/static_http_user_agent_settings.cc',
        'url_request/static_http_user_agent_settings.h',
        'url_request/url_fetcher.cc',
        'url_request/url_fetcher.h',
        'url_request/url_fetcher_core.cc',
        'url_request/url_fetcher_core.h',
        'url_request/url_fetcher_delegate.cc',
        'url_request/url_fetcher_delegate.h',
        'url_request/url_fetcher_factory.h',
        'url_request/url_fetcher_impl.cc',
        'url_request/url_fetcher_impl.h',
        'url_request/url_fetcher_response_writer.cc',
        'url_request/url_fetcher_response_writer.h',
        'url_request/url_range_request_job.cc',
        'url_request/url_range_request_job.h',
        'url_request/url_request.cc',
        'url_request/url_request.h',
        'url_request/url_request_about_job.cc',
        'url_request/url_request_about_job.h',
        'url_request/url_request_context.cc',
        'url_request/url_request_context.h',
        'url_request/url_request_context_builder.cc',
        'url_request/url_request_context_builder.h',
        'url_request/url_request_context_getter.cc',
        'url_request/url_request_context_getter.h',
        'url_request/url_request_context_storage.cc',
        'url_request/url_request_context_storage.h',
        'url_request/url_request_data_job.cc',
        'url_request/url_request_data_job.h',
        'url_request/url_request_error_job.cc',
        'url_request/url_request_error_job.h',
        'url_request/url_request_file_dir_job.cc',
        'url_request/url_request_file_dir_job.h',
        'url_request/url_request_file_job.cc',
        'url_request/url_request_file_job.h',
        'url_request/url_request_filter.cc',
        'url_request/url_request_filter.h',
        'url_request/url_request_ftp_job.cc',
        'url_request/url_request_ftp_job.h',
        'url_request/url_request_http_job.cc',
        'url_request/url_request_http_job.h',
        'url_request/url_request_job.cc',
        'url_request/url_request_job.h',
        'url_request/url_request_job_factory.cc',
        'url_request/url_request_job_factory.h',
        'url_request/url_request_job_factory_impl.cc',
        'url_request/url_request_job_factory_impl.h',
        'url_request/url_request_job_manager.cc',
        'url_request/url_request_job_manager.h',
        'url_request/url_request_netlog_params.cc',
        'url_request/url_request_netlog_params.h',
        'url_request/url_request_redirect_job.cc',
        'url_request/url_request_redirect_job.h',
        'url_request/url_request_simple_job.cc',
        'url_request/url_request_simple_job.h',
        'url_request/url_request_status.h',
        'url_request/url_request_test_job.cc',
        'url_request/url_request_test_job.h',
        'url_request/url_request_throttler_entry.cc',
        'url_request/url_request_throttler_entry.h',
        'url_request/url_request_throttler_entry_interface.h',
        'url_request/url_request_throttler_header_adapter.cc',
        'url_request/url_request_throttler_header_adapter.h',
        'url_request/url_request_throttler_header_interface.h',
        'url_request/url_request_throttler_manager.cc',
        'url_request/url_request_throttler_manager.h',
        'url_request/view_cache_helper.cc',
        'url_request/view_cache_helper.h',
        'url_request/websocket_handshake_userdata_key.cc',
        'url_request/websocket_handshake_userdata_key.h',
        'websockets/websocket_basic_handshake_stream.cc',
        'websockets/websocket_basic_handshake_stream.h',
        'websockets/websocket_basic_stream.cc',
        'websockets/websocket_basic_stream.h',
        'websockets/websocket_channel.cc',
        'websockets/websocket_channel.h',
        'websockets/websocket_deflate_predictor.h',
        'websockets/websocket_deflate_predictor_impl.cc',
        'websockets/websocket_deflate_predictor_impl.h',
        'websockets/websocket_deflate_stream.cc',
        'websockets/websocket_deflate_stream.h',
        'websockets/websocket_deflater.cc',
        'websockets/websocket_deflater.h',
        'websockets/websocket_errors.cc',
        'websockets/websocket_errors.h',
        'websockets/websocket_extension.cc',
        'websockets/websocket_extension.h',
        'websockets/websocket_extension_parser.cc',
        'websockets/websocket_extension_parser.h',
        'websockets/websocket_frame.cc',
        'websockets/websocket_frame.h',
        'websockets/websocket_frame_parser.cc',
        'websockets/websocket_frame_parser.h',
        'websockets/websocket_handshake_constants.cc',
        'websockets/websocket_handshake_constants.h',
        'websockets/websocket_handshake_handler.cc',
        'websockets/websocket_handshake_handler.h',
        'websockets/websocket_handshake_request_info.cc',
        'websockets/websocket_handshake_request_info.h',
        'websockets/websocket_handshake_response_info.cc',
        'websockets/websocket_handshake_response_info.h',
        'websockets/websocket_handshake_stream_base.h',
        'websockets/websocket_handshake_stream_create_helper.cc',
        'websockets/websocket_handshake_stream_create_helper.h',
        'websockets/websocket_inflater.cc',
        'websockets/websocket_inflater.h',
        'websockets/websocket_job.cc',
        'websockets/websocket_job.h',
        'websockets/websocket_mux.h',
        'websockets/websocket_net_log_params.cc',
        'websockets/websocket_net_log_params.h',
        'websockets/websocket_stream.cc',
        'websockets/websocket_stream.h',
        'websockets/websocket_throttle.cc',
        'websockets/websocket_throttle.h',
      ],
      'defines': [
        'NET_IMPLEMENTATION',
      ],
      'export_dependent_settings': [
        '../base/base.gyp:base',
      ],
      'conditions': [
        ['chromeos==1', {
          'sources!': [
             'base/network_change_notifier_linux.cc',
             'base/network_change_notifier_linux.h',
             'base/network_change_notifier_netlink_linux.cc',
             'base/network_change_notifier_netlink_linux.h',
             'proxy/proxy_config_service_linux.cc',
             'proxy/proxy_config_service_linux.h',
          ],
        }],
        ['use_kerberos==1', {
          'defines': [
            'USE_KERBEROS',
          ],
          'conditions': [
            ['OS=="openbsd"', {
              'include_dirs': [
                '/usr/include/kerberosV'
              ],
            }],
            ['linux_link_kerberos==1', {
              'link_settings': {
                'ldflags': [
                  '<!@(krb5-config --libs gssapi)',
                ],
              },
            }, { # linux_link_kerberos==0
              'defines': [
                'DLOPEN_KERBEROS',
              ],
            }],
          ],
        }, { # use_kerberos == 0
          'sources!': [
            'http/http_auth_gssapi_posix.cc',
            'http/http_auth_gssapi_posix.h',
            'http/http_auth_handler_negotiate.h',
            'http/http_auth_handler_negotiate.cc',
          ],
        }],
        ['posix_avoid_mmap==1', {
          'defines': [
            'POSIX_AVOID_MMAP',
          ],
          'direct_dependent_settings': {
            'defines': [
              'POSIX_AVOID_MMAP',
            ],
          },
          'sources!': [
            'disk_cache/blockfile/mapped_file_posix.cc',
          ],
        }, { # else
          'sources!': [
            'disk_cache/blockfile/mapped_file_avoid_mmap_posix.cc',
          ],
        }],
        ['disable_ftp_support==1', {
          'sources/': [
            ['exclude', '^ftp/'],
          ],
          'sources!': [
            'url_request/ftp_protocol_handler.cc',
            'url_request/ftp_protocol_handler.h',
            'url_request/url_request_ftp_job.cc',
            'url_request/url_request_ftp_job.h',
          ],
        }],
        ['enable_built_in_dns==1', {
          'defines': [
            'ENABLE_BUILT_IN_DNS',
          ]
        }, { # else
          'sources!': [
            'dns/address_sorter_posix.cc',
            'dns/address_sorter_posix.h',
            'dns/dns_client.cc',
          ],
        }],
        ['use_tracing_cache_backend==1', {
          'defines': [
            'USE_TRACING_CACHE_BACKEND'
          ],
         }],
        ['use_openssl==1', {
            'sources!': [
              'base/crypto_module_nss.cc',
              'base/keygen_handler_nss.cc',
              'base/nss_memio.c',
              'base/nss_memio.h',
              'cert/cert_database_nss.cc',
              'cert/cert_verify_proc_nss.cc',
              'cert/cert_verify_proc_nss.h',
              'cert/ct_log_verifier_nss.cc',
              'cert/ct_objects_extractor_nss.cc',
              'cert/jwk_serializer_nss.cc',
              'cert/nss_cert_database.cc',
              'cert/nss_cert_database.h',
              'cert/scoped_nss_types.h',
              'cert/test_root_certs_nss.cc',
              'cert/x509_certificate_nss.cc',
              'cert/x509_util_nss.cc',
              'cert/x509_util_nss.h',
              'ocsp/nss_ocsp.cc',
              'ocsp/nss_ocsp.h',
              'quic/crypto/aead_base_decrypter_nss.cc',
              'quic/crypto/aead_base_encrypter_nss.cc',
              'quic/crypto/aes_128_gcm_12_decrypter_nss.cc',
              'quic/crypto/aes_128_gcm_12_encrypter_nss.cc',
              'quic/crypto/chacha20_poly1305_decrypter_nss.cc',
              'quic/crypto/chacha20_poly1305_encrypter_nss.cc',
              'quic/crypto/channel_id_nss.cc',
              'quic/crypto/p256_key_exchange_nss.cc',
              'socket/nss_ssl_util.cc',
              'socket/nss_ssl_util.h',
              'socket/ssl_client_socket_nss.cc',
              'socket/ssl_client_socket_nss.h',
              'socket/ssl_server_socket_nss.cc',
              'socket/ssl_server_socket_nss.h',
              'third_party/mozilla_security_manager/nsKeygenHandler.cpp',
              'third_party/mozilla_security_manager/nsKeygenHandler.h',
              'third_party/mozilla_security_manager/nsNSSCertificateDB.cpp',
              'third_party/mozilla_security_manager/nsNSSCertificateDB.h',
              'third_party/mozilla_security_manager/nsPKCS12Blob.cpp',
              'third_party/mozilla_security_manager/nsPKCS12Blob.h',
            ],
            'dependencies': [
              '../third_party/openssl/openssl.gyp:openssl',
            ],
          },
          {  # else !use_openssl: remove the unneeded files
            'sources!': [
              'base/crypto_module_openssl.cc',
              'base/keygen_handler_openssl.cc',
              'cert/ct_log_verifier_openssl.cc',
              'cert/ct_objects_extractor_openssl.cc',
              'cert/jwk_serializer_openssl.cc',
              'cert/x509_util_openssl.cc',
              'cert/x509_util_openssl.h',
              'quic/crypto/aead_base_decrypter_openssl.cc',
              'quic/crypto/aead_base_encrypter_openssl.cc',
              'quic/crypto/aes_128_gcm_12_decrypter_openssl.cc',
              'quic/crypto/aes_128_gcm_12_encrypter_openssl.cc',
              'quic/crypto/chacha20_poly1305_decrypter_openssl.cc',
              'quic/crypto/chacha20_poly1305_encrypter_openssl.cc',
              'quic/crypto/channel_id_openssl.cc',
              'quic/crypto/p256_key_exchange_openssl.cc',
              'quic/crypto/scoped_evp_aead_ctx.cc',
              'quic/crypto/scoped_evp_aead_ctx.h',
              'socket/ssl_client_socket_openssl.cc',
              'socket/ssl_client_socket_openssl.h',
              'socket/ssl_server_socket_openssl.cc',
              'socket/ssl_session_cache_openssl.cc',
              'socket/ssl_session_cache_openssl.h',
            ],
          },
        ],
        [ 'use_openssl_certs == 0', {
            'sources!': [
              'base/openssl_private_key_store.h',
              'base/openssl_private_key_store_android.cc',
              'base/openssl_private_key_store_memory.cc',
              'cert/cert_database_openssl.cc',
              'cert/cert_verify_proc_openssl.cc',
              'cert/cert_verify_proc_openssl.h',
              'cert/test_root_certs_openssl.cc',
              'cert/x509_certificate_openssl.cc',
              'ssl/openssl_client_key_store.cc',
              'ssl/openssl_client_key_store.h',
            ],
        }],
        [ 'use_glib == 1', {
            'dependencies': [
              '../build/linux/system.gyp:gconf',
              '../build/linux/system.gyp:gio',
            ],
        }],
        [ 'desktop_linux == 1 or chromeos == 1', {
            'conditions': [
              ['use_openssl == 0', {
                 # use NSS
                'dependencies': [
                  '../build/linux/system.gyp:ssl',
                ],
              }],
              ['os_bsd==1', {
                'sources!': [
                  'base/network_change_notifier_linux.cc',
                  'base/network_change_notifier_netlink_linux.cc',
                  'proxy/proxy_config_service_linux.cc',
                ],
              },{
                'dependencies': [
                  '../build/linux/system.gyp:libresolv',
                ],
              }],
              ['OS=="solaris"', {
                'link_settings': {
                  'ldflags': [
                    '-R/usr/lib/mps',
                  ],
                },
              }],
            ],
          },
          {  # else: OS is not in the above list
            'sources!': [
              'base/crypto_module_nss.cc',
              'base/keygen_handler_nss.cc',
              'cert/cert_database_nss.cc',
              'cert/nss_cert_database.cc',
              'cert/nss_cert_database.h',
              'cert/test_root_certs_nss.cc',
              'cert/x509_certificate_nss.cc',
              'ocsp/nss_ocsp.cc',
              'ocsp/nss_ocsp.h',
              'third_party/mozilla_security_manager/nsKeygenHandler.cpp',
              'third_party/mozilla_security_manager/nsKeygenHandler.h',
              'third_party/mozilla_security_manager/nsNSSCertificateDB.cpp',
              'third_party/mozilla_security_manager/nsNSSCertificateDB.h',
              'third_party/mozilla_security_manager/nsPKCS12Blob.cpp',
              'third_party/mozilla_security_manager/nsPKCS12Blob.h',
            ],
          },
        ],
        [ 'toolkit_uses_gtk == 1', {
          'dependencies': [
            '../build/linux/system.gyp:gdk',
          ],
        }],
        [ 'use_nss != 1', {
            'sources!': [
              'cert/cert_verify_proc_nss.cc',
              'cert/cert_verify_proc_nss.h',
              'ssl/client_cert_store_nss.cc',
              'ssl/client_cert_store_nss.h',
            ],
        }],
        [ 'enable_websockets != 1', {
            'sources/': [
              ['exclude', '^socket_stream/'],
              ['exclude', '^websockets/'],
            ],
            'sources!': [
              'spdy/spdy_websocket_stream.cc',
              'spdy/spdy_websocket_stream.h',
            ],
        }],
        [ 'enable_mdns != 1', {
            'sources!' : [
              'dns/mdns_cache.cc',
              'dns/mdns_cache.h',
              'dns/mdns_client.cc',
              'dns/mdns_client.h',
              'dns/mdns_client_impl.cc',
              'dns/mdns_client_impl.h',
              'dns/record_parsed.cc',
              'dns/record_parsed.h',
              'dns/record_rdata.cc',
              'dns/record_rdata.h',
            ]
        }],
        [ 'OS == "win"', {
            'sources!': [
              'http/http_auth_handler_ntlm_portable.cc',
              'socket/tcp_socket_libevent.cc',
              'socket/tcp_socket_libevent.h',
              'udp/udp_socket_libevent.cc',
              'udp/udp_socket_libevent.h',
            ],
            'dependencies': [
              '../third_party/nss/nss.gyp:nspr',
              '../third_party/nss/nss.gyp:nss',
              'third_party/nss/ssl.gyp:libssl',
            ],
            # TODO(jschuh): crbug.com/167187 fix size_t to int truncations.
            'msvs_disabled_warnings': [4267, ],
          }, { # else: OS != "win"
            'sources!': [
              'base/winsock_init.cc',
              'base/winsock_init.h',
              'base/winsock_util.cc',
              'base/winsock_util.h',
              'proxy/proxy_resolver_winhttp.cc',
              'proxy/proxy_resolver_winhttp.h',
            ],
          },
        ],
        [ 'OS == "mac"', {
            'conditions': [
              [ 'use_openssl == 0', {
                'dependencies': [
                  # defaults to nss
                  '../third_party/nss/nss.gyp:nspr',
                  '../third_party/nss/nss.gyp:nss',
                  'third_party/nss/ssl.gyp:libssl',
                ],
              }],
            ],
            'link_settings': {
              'libraries': [
                '$(SDKROOT)/System/Library/Frameworks/Foundation.framework',
                '$(SDKROOT)/System/Library/Frameworks/Security.framework',
                '$(SDKROOT)/System/Library/Frameworks/SystemConfiguration.framework',
                '$(SDKROOT)/usr/lib/libresolv.dylib',
              ]
            },
          },
        ],
        [ 'OS == "ios"', {
            'dependencies': [
              '../third_party/nss/nss.gyp:nss',
              'third_party/nss/ssl.gyp:libssl',
            ],
            'sources!': [
              'disk_cache/blockfile/file_posix.cc',
            ],
            'link_settings': {
              'libraries': [
                '$(SDKROOT)/System/Library/Frameworks/CFNetwork.framework',
                '$(SDKROOT)/System/Library/Frameworks/MobileCoreServices.framework',
                '$(SDKROOT)/System/Library/Frameworks/Security.framework',
                '$(SDKROOT)/System/Library/Frameworks/SystemConfiguration.framework',
                '$(SDKROOT)/usr/lib/libresolv.dylib',
              ],
            },
          },
        ],
        ['OS=="android" and _toolset=="target" and android_webview_build == 0', {
          'dependencies': [
             'net_java',
          ],
        }],
        [ 'OS == "android"', {
            'dependencies': [
              '../third_party/openssl/openssl.gyp:openssl',
              'net_jni_headers',
            ],
            'sources!': [
              'base/openssl_private_key_store_memory.cc',
              'cert/cert_database_openssl.cc',
              'cert/cert_verify_proc_openssl.cc',
              'cert/test_root_certs_openssl.cc',
            ],
            # The net/android/keystore_openssl.cc source file needs to
            # access an OpenSSL-internal header.
            'include_dirs': [
              '../third_party/openssl',
            ],
          },
        ],
      ],
      'target_conditions': [
        # These source files are excluded by default platform rules, but they
        # are needed in specific cases on other platforms. Re-including them can
        # only be done in target_conditions as it is evaluated after the
        # platform rules.
        ['OS == "android"', {
          'sources/': [
            ['include', '^base/platform_mime_util_linux\\.cc$'],
            ['include', '^base/address_tracker_linux\\.cc$'],
            ['include', '^base/address_tracker_linux\\.h$'],
          ],
        }],
        ['OS == "ios"', {
          'sources/': [
            ['include', '^base/network_change_notifier_mac\\.cc$'],
            ['include', '^base/network_config_watcher_mac\\.cc$'],
            ['include', '^base/platform_mime_util_mac\\.mm$'],
            # The iOS implementation only partially uses NSS and thus does not
            # defines |use_nss|. In particular the |USE_NSS| preprocessor
            # definition is not used. The following files are needed though:
            ['include', '^cert/cert_verify_proc_nss\\.cc$'],
            ['include', '^cert/cert_verify_proc_nss\\.h$'],
            ['include', '^cert/test_root_certs_nss\\.cc$'],
            ['include', '^cert/x509_util_nss\\.cc$'],
            ['include', '^cert/x509_util_nss\\.h$'],
            ['include', '^proxy/proxy_resolver_mac\\.cc$'],
            ['include', '^proxy/proxy_server_mac\\.cc$'],
            ['include', '^ocsp/nss_ocsp\\.cc$'],
            ['include', '^ocsp/nss_ocsp\\.h$'],
          ],
        }],
      ],
    },
    {
      'target_name': 'net_unittests',
      'type': '<(gtest_target_type)',
      'dependencies': [
        '../base/base.gyp:base',
        '../base/base.gyp:base_i18n',
        '../base/third_party/dynamic_annotations/dynamic_annotations.gyp:dynamic_annotations',
        '../crypto/crypto.gyp:crypto',
        '../testing/gmock.gyp:gmock',
        '../testing/gtest.gyp:gtest',
        '../third_party/zlib/zlib.gyp:zlib',
        '../url/url.gyp:url_lib',
        'http_server',
        'net',
        'net_test_support'
      ],
      'sources': [
        'android/keystore_unittest.cc',
        'android/network_change_notifier_android_unittest.cc',
        'base/address_list_unittest.cc',
        'base/address_tracker_linux_unittest.cc',
        'base/backoff_entry_unittest.cc',
        'base/data_url_unittest.cc',
        'base/directory_lister_unittest.cc',
        'base/dns_util_unittest.cc',
        'base/escape_unittest.cc',
        'base/expiring_cache_unittest.cc',
        'base/file_stream_unittest.cc',
        'base/int128_unittest.cc',
        'base/host_mapping_rules_unittest.cc',
        'base/host_port_pair_unittest.cc',
        'base/ip_endpoint_unittest.cc',
        'base/ip_pattern_unittest.cc',
        'base/keygen_handler_unittest.cc',
        'base/mime_sniffer_unittest.cc',
        'base/mime_util_unittest.cc',
        'base/net_log_logger_unittest.cc',
        'base/net_log_unittest.cc',
        'base/net_log_unittest.h',
        'base/net_util_unittest.cc',
        'base/network_change_notifier_win_unittest.cc',
        'base/prioritized_dispatcher_unittest.cc',
        'base/priority_queue_unittest.cc',
        'base/registry_controlled_domains/registry_controlled_domain_unittest.cc',
        'base/sdch_manager_unittest.cc',
        'base/static_cookie_policy_unittest.cc',
        'base/test_completion_callback_unittest.cc',
        'base/upload_bytes_element_reader_unittest.cc',
        'base/upload_data_stream_unittest.cc',
        'base/upload_file_element_reader_unittest.cc',
        'base/url_util_unittest.cc',
        'cert/cert_verify_proc_unittest.cc',
        'cert/crl_set_unittest.cc',
        'cert/ct_log_verifier_unittest.cc',
        'cert/ct_objects_extractor_unittest.cc',
        'cert/ct_serialization_unittest.cc',
        'cert/ev_root_ca_metadata_unittest.cc',
        'cert/jwk_serializer_unittest.cc',
        'cert/multi_log_ct_verifier_unittest.cc',
        'cert/multi_threaded_cert_verifier_unittest.cc',
        'cert/nss_cert_database_unittest.cc',
        'cert/nss_cert_database_chromeos_unittest.cc',
        'cert/nss_profile_filter_chromeos_unittest.cc',
        'cert/pem_tokenizer_unittest.cc',
        'cert/signed_certificate_timestamp_unittest.cc',
        'cert/test_root_certs_unittest.cc',
        'cert/x509_certificate_unittest.cc',
        'cert/x509_cert_types_unittest.cc',
        'cert/x509_util_unittest.cc',
        'cert/x509_util_nss_unittest.cc',
        'cert/x509_util_openssl_unittest.cc',
        'cookies/canonical_cookie_unittest.cc',
        'cookies/cookie_constants_unittest.cc',
        'cookies/cookie_monster_unittest.cc',
        'cookies/cookie_store_unittest.h',
        'cookies/cookie_util_unittest.cc',
        'cookies/parsed_cookie_unittest.cc',
        'disk_cache/backend_unittest.cc',
        'disk_cache/blockfile/addr_unittest.cc',
        'disk_cache/blockfile/bitmap_unittest.cc',
        'disk_cache/blockfile/block_bitmaps_v3_unittest.cc',
        'disk_cache/blockfile/block_bitmaps_v3_unittest.cc',
        'disk_cache/blockfile/block_files_unittest.cc',
        'disk_cache/blockfile/index_table_v3_unittest.cc',
        'disk_cache/blockfile/mapped_file_unittest.cc',
        'disk_cache/blockfile/storage_block_unittest.cc',
        'disk_cache/cache_util_unittest.cc',
        'disk_cache/entry_unittest.cc',
        'disk_cache/simple/simple_index_file_unittest.cc',
        'disk_cache/simple/simple_index_unittest.cc',
        'disk_cache/simple/simple_test_util.cc',
        'disk_cache/simple/simple_test_util.h',
        'disk_cache/simple/simple_util_unittest.cc',
        'disk_cache/simple/simple_version_upgrade_unittest.cc',
        'dns/address_sorter_posix_unittest.cc',
        'dns/address_sorter_unittest.cc',
        'dns/dns_config_service_posix_unittest.cc',
        'dns/dns_config_service_unittest.cc',
        'dns/dns_config_service_win_unittest.cc',
        'dns/dns_hosts_unittest.cc',
        'dns/dns_query_unittest.cc',
        'dns/dns_response_unittest.cc',
        'dns/dns_session_unittest.cc',
        'dns/dns_transaction_unittest.cc',
        'dns/host_cache_unittest.cc',
        'dns/host_resolver_impl_unittest.cc',
        'dns/mapped_host_resolver_unittest.cc',
        'dns/mdns_cache_unittest.cc',
        'dns/mdns_client_unittest.cc',
        'dns/serial_worker_unittest.cc',
        'dns/record_parsed_unittest.cc',
        'dns/record_rdata_unittest.cc',
        'dns/single_request_host_resolver_unittest.cc',
        'filter/filter_unittest.cc',
        'filter/gzip_filter_unittest.cc',
        'filter/mock_filter_context.cc',
        'filter/mock_filter_context.h',
        'filter/sdch_filter_unittest.cc',
        'ftp/ftp_auth_cache_unittest.cc',
        'ftp/ftp_ctrl_response_buffer_unittest.cc',
        'ftp/ftp_directory_listing_parser_ls_unittest.cc',
        'ftp/ftp_directory_listing_parser_netware_unittest.cc',
        'ftp/ftp_directory_listing_parser_os2_unittest.cc',
        'ftp/ftp_directory_listing_parser_unittest.cc',
        'ftp/ftp_directory_listing_parser_unittest.h',
        'ftp/ftp_directory_listing_parser_vms_unittest.cc',
        'ftp/ftp_directory_listing_parser_windows_unittest.cc',
        'ftp/ftp_network_transaction_unittest.cc',
        'ftp/ftp_util_unittest.cc',
        'http/des_unittest.cc',
        'http/disk_cache_based_quic_server_info_unittest.cc',
        'http/http_auth_cache_unittest.cc',
        'http/http_auth_challenge_tokenizer_unittest.cc',
        'http/http_auth_controller_unittest.cc',
        'http/http_auth_filter_unittest.cc',
        'http/http_auth_gssapi_posix_unittest.cc',
        'http/http_auth_handler_basic_unittest.cc',
        'http/http_auth_handler_digest_unittest.cc',
        'http/http_auth_handler_factory_unittest.cc',
        'http/http_auth_handler_mock.cc',
        'http/http_auth_handler_mock.h',
        'http/http_auth_handler_negotiate_unittest.cc',
        'http/http_auth_handler_unittest.cc',
        'http/http_auth_sspi_win_unittest.cc',
        'http/http_auth_unittest.cc',
        'http/http_basic_state_unittest.cc',
        'http/http_byte_range_unittest.cc',
        'http/http_cache_unittest.cc',
        'http/http_chunked_decoder_unittest.cc',
        'http/http_content_disposition_unittest.cc',
        'http/http_log_util_unittest.cc',
        'http/http_network_layer_unittest.cc',
        'http/http_network_transaction_ssl_unittest.cc',
        'http/http_network_transaction_unittest.cc',
        'http/http_pipelined_connection_impl_unittest.cc',
        'http/http_pipelined_host_forced_unittest.cc',
        'http/http_pipelined_host_impl_unittest.cc',
        'http/http_pipelined_host_pool_unittest.cc',
        'http/http_pipelined_host_test_util.cc',
        'http/http_pipelined_host_test_util.h',
        'http/http_pipelined_network_transaction_unittest.cc',
        'http/http_proxy_client_socket_pool_unittest.cc',
        'http/http_request_headers_unittest.cc',
        'http/http_response_body_drainer_unittest.cc',
        'http/http_response_headers_unittest.cc',
        'http/http_security_headers_unittest.cc',
        'http/http_server_properties_impl_unittest.cc',
        'http/http_status_code_unittest.cc',
        'http/http_stream_factory_impl_request_unittest.cc',
        'http/http_stream_factory_impl_unittest.cc',
        'http/http_stream_parser_unittest.cc',
        'http/http_transaction_unittest.cc',
        'http/http_transaction_unittest.h',
        'http/http_util_unittest.cc',
        'http/http_vary_data_unittest.cc',
        'http/mock_allow_url_security_manager.cc',
        'http/mock_allow_url_security_manager.h',
        'http/mock_gssapi_library_posix.cc',
        'http/mock_gssapi_library_posix.h',
        'http/mock_http_cache.cc',
        'http/mock_http_cache.h',
        'http/mock_sspi_library_win.cc',
        'http/mock_sspi_library_win.h',
        'http/transport_security_persister_unittest.cc',
        'http/transport_security_state_unittest.cc',
        'http/url_security_manager_unittest.cc',
        'ocsp/nss_ocsp_unittest.cc',
        'proxy/dhcp_proxy_script_adapter_fetcher_win_unittest.cc',
        'proxy/dhcp_proxy_script_fetcher_factory_unittest.cc',
        'proxy/dhcp_proxy_script_fetcher_win_unittest.cc',
        'proxy/multi_threaded_proxy_resolver_unittest.cc',
        'proxy/network_delegate_error_observer_unittest.cc',
        'proxy/proxy_bypass_rules_unittest.cc',
        'proxy/proxy_config_service_android_unittest.cc',
        'proxy/proxy_config_service_linux_unittest.cc',
        'proxy/proxy_config_service_win_unittest.cc',
        'proxy/proxy_config_unittest.cc',
        'proxy/proxy_info_unittest.cc',
        'proxy/proxy_list_unittest.cc',
        'proxy/proxy_resolver_v8_tracing_unittest.cc',
        'proxy/proxy_resolver_v8_unittest.cc',
        'proxy/proxy_script_decider_unittest.cc',
        'proxy/proxy_script_fetcher_impl_unittest.cc',
        'proxy/proxy_server_unittest.cc',
        'proxy/proxy_service_unittest.cc',
        'quic/congestion_control/available_channel_estimator_test.cc',
        'quic/congestion_control/channel_estimator_test.cc',
        'quic/congestion_control/cube_root_test.cc',
        'quic/congestion_control/cubic_test.cc',
        'quic/congestion_control/fix_rate_test.cc',
        'quic/congestion_control/hybrid_slow_start_test.cc',
        'quic/congestion_control/inter_arrival_bitrate_ramp_up_test.cc',
        'quic/congestion_control/inter_arrival_overuse_detector_test.cc',
        'quic/congestion_control/inter_arrival_probe_test.cc',
        'quic/congestion_control/inter_arrival_receiver_test.cc',
        'quic/congestion_control/inter_arrival_state_machine_test.cc',
        'quic/congestion_control/inter_arrival_sender_test.cc',
        'quic/congestion_control/leaky_bucket_test.cc',
        'quic/congestion_control/paced_sender_test.cc',
        'quic/congestion_control/pacing_sender_test.cc',
        'quic/congestion_control/quic_max_sized_map_test.cc',
        'quic/congestion_control/tcp_cubic_sender_test.cc',
        'quic/congestion_control/tcp_loss_algorithm_test.cc',
        'quic/congestion_control/tcp_receiver_test.cc',
        'quic/congestion_control/time_loss_algorithm_test.cc',
        'quic/crypto/aes_128_gcm_12_decrypter_test.cc',
        'quic/crypto/aes_128_gcm_12_encrypter_test.cc',
        'quic/crypto/cert_compressor_test.cc',
        'quic/crypto/chacha20_poly1305_decrypter_test.cc',
        'quic/crypto/chacha20_poly1305_encrypter_test.cc',
        'quic/crypto/channel_id_test.cc',
        'quic/crypto/common_cert_set_test.cc',
        'quic/crypto/crypto_framer_test.cc',
        'quic/crypto/crypto_secret_boxer_test.cc',
        'quic/crypto/crypto_server_test.cc',
        'quic/crypto/crypto_utils_test.cc',
        'quic/crypto/curve25519_key_exchange_test.cc',
        'quic/crypto/local_strike_register_client_test.cc',
        'quic/crypto/null_decrypter_test.cc',
        'quic/crypto/null_encrypter_test.cc',
        'quic/crypto/p256_key_exchange_test.cc',
        'quic/crypto/proof_test.cc',
        'quic/crypto/quic_crypto_client_config_test.cc',
        'quic/crypto/quic_crypto_server_config_test.cc',
        'quic/crypto/quic_random_test.cc',
        'quic/crypto/strike_register_test.cc',
        'quic/iovector_test.cc',
        'quic/port_suggester_unittest.cc',
        'quic/test_tools/crypto_test_utils.cc',
        'quic/test_tools/crypto_test_utils.h',
        'quic/test_tools/crypto_test_utils_chromium.cc',
        'quic/test_tools/crypto_test_utils_nss.cc',
        'quic/test_tools/crypto_test_utils_openssl.cc',
        'quic/test_tools/delayed_verify_strike_register_client.cc',
        'quic/test_tools/delayed_verify_strike_register_client.h',
        'quic/test_tools/mock_clock.cc',
        'quic/test_tools/mock_clock.h',
        'quic/test_tools/mock_crypto_client_stream.cc',
        'quic/test_tools/mock_crypto_client_stream.h',
        'quic/test_tools/mock_crypto_client_stream_factory.cc',
        'quic/test_tools/mock_crypto_client_stream_factory.h',
        'quic/test_tools/mock_random.cc',
        'quic/test_tools/mock_random.h',
        'quic/test_tools/quic_client_session_peer.cc',
        'quic/test_tools/quic_client_session_peer.h',
        'quic/test_tools/quic_connection_peer.cc',
        'quic/test_tools/quic_connection_peer.h',
        'quic/test_tools/quic_data_stream_peer.cc',
        'quic/test_tools/quic_data_stream_peer.h',
        'quic/test_tools/quic_framer_peer.cc',
        'quic/test_tools/quic_framer_peer.h',
        'quic/test_tools/quic_packet_creator_peer.cc',
        'quic/test_tools/quic_packet_creator_peer.h',
        'quic/test_tools/quic_received_packet_manager_peer.cc',
        'quic/test_tools/quic_received_packet_manager_peer.h',
        'quic/test_tools/quic_sent_packet_manager_peer.cc',
        'quic/test_tools/quic_sent_packet_manager_peer.h',
        'quic/test_tools/quic_session_peer.cc',
        'quic/test_tools/quic_session_peer.h',
        'quic/test_tools/quic_test_packet_maker.cc',
        'quic/test_tools/quic_test_packet_maker.h',
        'quic/test_tools/quic_test_utils.cc',
        'quic/test_tools/quic_test_utils.h',
        'quic/test_tools/reliable_quic_stream_peer.cc',
        'quic/test_tools/reliable_quic_stream_peer.h',
        'quic/test_tools/simple_quic_framer.cc',
        'quic/test_tools/simple_quic_framer.h',
        'quic/test_tools/test_task_runner.cc',
        'quic/test_tools/test_task_runner.h',
        'quic/quic_ack_notifier_test.cc',
        'quic/quic_address_mismatch_test.cc',
        'quic/quic_alarm_test.cc',
        'quic/quic_bandwidth_test.cc',
        'quic/quic_client_session_test.cc',
        'quic/quic_clock_test.cc',
        'quic/quic_config_test.cc',
        'quic/quic_connection_helper_test.cc',
        'quic/quic_connection_test.cc',
        'quic/quic_crypto_client_stream_test.cc',
        'quic/quic_crypto_server_stream_test.cc',
        'quic/quic_crypto_stream_test.cc',
        'quic/quic_data_stream_test.cc',
        'quic/quic_data_writer_test.cc',
        'quic/quic_fec_group_test.cc',
        'quic/quic_framer_test.cc',
        'quic/quic_headers_stream_test.cc',
        'quic/quic_http_stream_test.cc',
        'quic/quic_http_utils_test.cc',
        'quic/quic_network_transaction_unittest.cc',
        'quic/quic_packet_creator_test.cc',
        'quic/quic_packet_generator_test.cc',
        'quic/quic_protocol_test.cc',
        'quic/quic_received_packet_manager_test.cc',
        'quic/quic_reliable_client_stream_test.cc',
        'quic/quic_sent_entropy_manager_test.cc',
        'quic/quic_sent_packet_manager_test.cc',
        'quic/quic_session_key_test.cc',
        'quic/quic_session_test.cc',
        'quic/quic_socket_address_coder_test.cc',
        'quic/quic_stream_factory_test.cc',
        'quic/quic_stream_sequencer_test.cc',
        'quic/quic_time_test.cc',
        'quic/quic_utils_chromium_test.cc',
        'quic/quic_utils_test.cc',
        'quic/quic_write_blocked_list_test.cc',
        'quic/reliable_quic_stream_test.cc',
        'server/http_server_response_info_unittest.cc',
        'server/http_server_unittest.cc',
        'socket/buffered_write_stream_socket_unittest.cc',
        'socket/client_socket_pool_base_unittest.cc',
        'socket/deterministic_socket_data_unittest.cc',
        'socket/mock_client_socket_pool_manager.cc',
        'socket/mock_client_socket_pool_manager.h',
        'socket/socks5_client_socket_unittest.cc',
        'socket/socks_client_socket_pool_unittest.cc',
        'socket/socks_client_socket_unittest.cc',
        'socket/ssl_client_socket_openssl_unittest.cc',
        'socket/ssl_client_socket_pool_unittest.cc',
        'socket/ssl_client_socket_unittest.cc',
        'socket/ssl_server_socket_unittest.cc',
        'socket/ssl_session_cache_openssl_unittest.cc',
        'socket/tcp_client_socket_unittest.cc',
        'socket/tcp_listen_socket_unittest.cc',
        'socket/tcp_listen_socket_unittest.h',
        'socket/tcp_server_socket_unittest.cc',
        'socket/tcp_socket_unittest.cc',
        'socket/transport_client_socket_pool_unittest.cc',
        'socket/transport_client_socket_unittest.cc',
        'socket/unix_domain_socket_posix_unittest.cc',
        'socket_stream/socket_stream_metrics_unittest.cc',
        'socket_stream/socket_stream_unittest.cc',
        'spdy/buffered_spdy_framer_unittest.cc',
        'spdy/hpack_decoder_test.cc',
        'spdy/hpack_encoder_test.cc',
        'spdy/hpack_encoding_context_test.cc',
        'spdy/hpack_entry_test.cc',
        'spdy/hpack_header_table_test.cc',
        'spdy/hpack_huffman_table_test.cc',
        'spdy/hpack_input_stream_test.cc',
        'spdy/hpack_output_stream_test.cc',
        'spdy/hpack_string_util_test.cc',
        'spdy/mock_spdy_framer_visitor.cc',
        'spdy/mock_spdy_framer_visitor.h',
        'spdy/spdy_buffer_unittest.cc',
        'spdy/spdy_frame_builder_test.cc',
        'spdy/spdy_frame_reader_test.cc',
        'spdy/spdy_framer_test.cc',
        'spdy/spdy_header_block_unittest.cc',
        'spdy/spdy_headers_block_parser_test.cc',
        'spdy/spdy_http_stream_unittest.cc',
        'spdy/spdy_http_utils_unittest.cc',
        'spdy/spdy_network_transaction_unittest.cc',
        'spdy/spdy_pinnable_buffer_piece_test.cc',
        'spdy/spdy_prefixed_buffer_reader_test.cc',
        'spdy/spdy_priority_forest_test.cc',
        'spdy/spdy_protocol_test.cc',
        'spdy/spdy_proxy_client_socket_unittest.cc',
        'spdy/spdy_read_queue_unittest.cc',
        'spdy/spdy_session_pool_unittest.cc',
        'spdy/spdy_session_test_util.cc',
        'spdy/spdy_session_test_util.h',
        'spdy/spdy_session_unittest.cc',
        'spdy/spdy_stream_test_util.cc',
        'spdy/spdy_stream_test_util.h',
        'spdy/spdy_stream_unittest.cc',
        'spdy/spdy_test_util_common.cc',
        'spdy/spdy_test_util_common.h',
        'spdy/spdy_test_utils.cc',
        'spdy/spdy_test_utils.h',
        'spdy/spdy_websocket_stream_unittest.cc',
        'spdy/spdy_websocket_test_util.cc',
        'spdy/spdy_websocket_test_util.h',
        'spdy/spdy_write_queue_unittest.cc',
        'spdy/write_blocked_list_test.cc',
        'ssl/client_cert_store_chromeos_unittest.cc',
        'ssl/client_cert_store_mac_unittest.cc',
        'ssl/client_cert_store_nss_unittest.cc',
        'ssl/client_cert_store_unittest-inl.h',
        'ssl/client_cert_store_win_unittest.cc',
        'ssl/default_server_bound_cert_store_unittest.cc',
        'ssl/openssl_client_key_store_unittest.cc',
        'ssl/server_bound_cert_service_unittest.cc',
        'ssl/ssl_cipher_suite_names_unittest.cc',
        'ssl/ssl_client_auth_cache_unittest.cc',
        'ssl/ssl_config_service_unittest.cc',
        'test/gtest_util.h',
        'test/embedded_test_server/embedded_test_server_unittest.cc',
        'test/embedded_test_server/http_request_unittest.cc',
        'test/embedded_test_server/http_response_unittest.cc',
        'test/python_utils_unittest.cc',
        'test/run_all_unittests.cc',
        'test/scoped_disable_exit_on_dfatal.cc',
        'test/scoped_disable_exit_on_dfatal.h',
        'test/scoped_mock_log.cc',
        'test/scoped_mock_log.h',
        'test/test_certificate_data.h',
        'tools/dump_cache/url_to_filename_encoder.cc',
        'tools/dump_cache/url_to_filename_encoder.h',
        'tools/dump_cache/url_to_filename_encoder_unittest.cc',
        'tools/dump_cache/url_utilities.h',
        'tools/dump_cache/url_utilities.cc',
        'tools/dump_cache/url_utilities_unittest.cc',
        'tools/tld_cleanup/tld_cleanup_util_unittest.cc',
        'udp/udp_socket_unittest.cc',
        'url_request/url_fetcher_impl_unittest.cc',
        'url_request/url_fetcher_response_writer_unittest.cc',
        'url_request/url_request_context_builder_unittest.cc',
        'url_request/url_request_filter_unittest.cc',
        'url_request/url_request_ftp_job_unittest.cc',
        'url_request/url_request_http_job_unittest.cc',
        'url_request/url_request_job_factory_impl_unittest.cc',
        'url_request/url_request_job_unittest.cc',
        'url_request/url_request_simple_job_unittest.cc',
        'url_request/url_request_throttler_simulation_unittest.cc',
        'url_request/url_request_throttler_test_support.cc',
        'url_request/url_request_throttler_test_support.h',
        'url_request/url_request_throttler_unittest.cc',
        'url_request/url_request_unittest.cc',
        'url_request/view_cache_helper_unittest.cc',
        'websockets/websocket_basic_stream_test.cc',
        'websockets/websocket_channel_test.cc',
        'websockets/websocket_deflate_predictor_impl_test.cc',
        'websockets/websocket_deflate_stream_test.cc',
        'websockets/websocket_deflater_test.cc',
        'websockets/websocket_errors_test.cc',
        'websockets/websocket_extension_parser_test.cc',
        'websockets/websocket_frame_parser_test.cc',
        'websockets/websocket_frame_test.cc',
        'websockets/websocket_handshake_handler_spdy_test.cc',
        'websockets/websocket_handshake_handler_test.cc',
        'websockets/websocket_handshake_stream_create_helper_test.cc',
        'websockets/websocket_inflater_test.cc',
        'websockets/websocket_job_test.cc',
        'websockets/websocket_net_log_params_test.cc',
        'websockets/websocket_stream_test.cc',
        'websockets/websocket_test_util.cc',
        'websockets/websocket_test_util.h',
        'websockets/websocket_throttle_test.cc',
      ],
      'conditions': [
        ['os_posix == 1 and OS != "mac" and OS != "ios" and OS != "android"', {
          'dependencies': [
            'balsa',
            'epoll_server',
            'flip_in_mem_edsm_server_base',
            'quic_base',
          ],
          'sources': [
            'quic/quic_end_to_end_unittest.cc',
            'tools/balsa/balsa_frame_test.cc',
            'tools/balsa/balsa_headers_test.cc',
            'tools/quic/end_to_end_test.cc',
            'tools/quic/quic_client_session_test.cc',
            'tools/quic/quic_dispatcher_test.cc',
            'tools/quic/quic_epoll_clock_test.cc',
            'tools/quic/quic_epoll_connection_helper_test.cc',
            'tools/quic/quic_in_memory_cache_test.cc',
            'tools/quic/quic_server_session_test.cc',
            'tools/quic/quic_server_test.cc',
            'tools/quic/quic_spdy_client_stream_test.cc',
            'tools/quic/quic_spdy_server_stream_test.cc',
            'tools/quic/quic_time_wait_list_manager_test.cc',
            'tools/quic/test_tools/http_message.cc',
            'tools/quic/test_tools/http_message.h',
            'tools/quic/test_tools/mock_epoll_server.cc',
            'tools/quic/test_tools/mock_epoll_server.h',
            'tools/quic/test_tools/mock_quic_dispatcher.cc',
            'tools/quic/test_tools/mock_quic_dispatcher.h',
            'tools/quic/test_tools/packet_dropping_test_writer.cc',
            'tools/quic/test_tools/packet_dropping_test_writer.h',
            'tools/quic/test_tools/quic_client_peer.cc',
            'tools/quic/test_tools/quic_client_peer.h',
            'tools/quic/test_tools/quic_dispatcher_peer.cc',
            'tools/quic/test_tools/quic_dispatcher_peer.h',
            'tools/quic/test_tools/quic_in_memory_cache_peer.h',
            'tools/quic/test_tools/quic_in_memory_cache_peer.cc',
            'tools/quic/test_tools/quic_server_peer.cc',
            'tools/quic/test_tools/quic_server_peer.h',
            'tools/quic/test_tools/quic_test_client.cc',
            'tools/quic/test_tools/quic_test_client.h',
            'tools/quic/test_tools/quic_test_utils.cc',
            'tools/quic/test_tools/quic_test_utils.h',
            'tools/quic/test_tools/server_thread.h',
            'tools/quic/test_tools/server_thread.cc',
          ],
        }],
        ['chromeos==1', {
          'sources!': [
            'base/network_change_notifier_linux_unittest.cc',
            'proxy/proxy_config_service_linux_unittest.cc',
          ],
        }],
        [ 'OS == "android"', {
          'sources!': [
            # See bug http://crbug.com/344533.
            'disk_cache/blockfile/index_table_v3_unittest.cc',
            # No res_ninit() et al on Android, so this doesn't make a lot of
            # sense.
            'dns/dns_config_service_posix_unittest.cc',
          ],
          'dependencies': [
            'net_javatests',
            'net_test_jni_headers',
          ],
        }],
        [ 'use_nss != 1', {
          'sources!': [
            'ssl/client_cert_store_nss_unittest.cc',
          ],
        }],
        [ 'use_openssl == 1', {
          # Avoid compiling/linking with the system library.
          'dependencies': [
            '../third_party/openssl/openssl.gyp:openssl',
          ],
        }, {  # use_openssl == 0
          'conditions': [
            [ 'desktop_linux == 1 or chromeos == 1', {
              'dependencies': [
                '../build/linux/system.gyp:ssl',
              ],
            }, {  # desktop_linux == 0 and chromeos == 0
              'sources!': [
                'cert/nss_cert_database_unittest.cc',
              ],
            }],
          ],
        }],
        [ 'toolkit_uses_gtk == 1', {
            'dependencies': [
              '../build/linux/system.gyp:gtk',
            ],
          },
        ],
        [ 'os_posix == 1 and OS != "mac" and OS != "android" and OS != "ios"', {
          'conditions': [
            # TODO(dmikurube): Kill linux_use_tcmalloc. http://crbug.com/345554
            ['(use_allocator!="none" and use_allocator!="see_use_tcmalloc") or (use_allocator=="see_use_tcmalloc" and linux_use_tcmalloc==1)', {
              'dependencies': [
                '../base/allocator/allocator.gyp:allocator',
              ],
            }],
          ],
        }],
        [ 'use_kerberos==1', {
          'defines': [
            'USE_KERBEROS',
          ],
        }, { # use_kerberos == 0
          'sources!': [
            'http/http_auth_gssapi_posix_unittest.cc',
            'http/http_auth_handler_negotiate_unittest.cc',
            'http/mock_gssapi_library_posix.cc',
            'http/mock_gssapi_library_posix.h',
          ],
        }],
        [ 'use_openssl == 1 or (desktop_linux == 0 and chromeos == 0 and OS != "ios")', {
          # Only include this test when on Posix and using NSS for
          # cert verification or on iOS (which also uses NSS for certs).
          'sources!': [
            'ocsp/nss_ocsp_unittest.cc',
          ],
        }],
        [ 'use_openssl==1', {
            # When building for OpenSSL, we need to exclude NSS specific tests
            # or functionality not supported by OpenSSL yet.
            # TODO(bulach): Add equivalent tests when the underlying
            #               functionality is ported to OpenSSL.
            'sources!': [
              'cert/ct_objects_extractor_unittest.cc',
              'cert/multi_log_ct_verifier_unittest.cc',
              'cert/nss_cert_database_unittest.cc',
              'cert/x509_util_nss_unittest.cc',
              'quic/test_tools/crypto_test_utils_nss.cc',
            ],
          }, {  # else !use_openssl: remove the unneeded files
            'sources!': [
              'cert/x509_util_openssl_unittest.cc',
              'quic/test_tools/crypto_test_utils_openssl.cc',
              'socket/ssl_client_socket_openssl_unittest.cc',
              'socket/ssl_session_cache_openssl_unittest.cc',
            ],
          },
        ],
        [ 'use_openssl_certs == 0', {
            'sources!': [
              'ssl/openssl_client_key_store_unittest.cc',
            ],
        }],
        [ 'enable_websockets != 1', {
            'sources/': [
              ['exclude', '^socket_stream/'],
              ['exclude', '^websockets/'],
              ['exclude', '^spdy/spdy_websocket_stream_unittest\\.cc$'],
            ],
        }],
        [ 'disable_ftp_support==1', {
            'sources/': [
              ['exclude', '^ftp/'],
            ],
            'sources!': [
              'url_request/url_request_ftp_job_unittest.cc',
            ],
          },
        ],
        [ 'enable_built_in_dns!=1', {
            'sources!': [
              'dns/address_sorter_posix_unittest.cc',
              'dns/address_sorter_unittest.cc',
            ],
          },
        ],
        [ 'use_v8_in_net==1', {
            'dependencies': [
              'net_with_v8',
            ],
          }, {  # else: !use_v8_in_net
            'sources!': [
              'proxy/proxy_resolver_v8_unittest.cc',
              'proxy/proxy_resolver_v8_tracing_unittest.cc',
            ],
          },
        ],

        [ 'enable_mdns != 1', {
            'sources!' : [
              'dns/mdns_cache_unittest.cc',
              'dns/mdns_client_unittest.cc',
              'dns/mdns_query_unittest.cc',
              'dns/record_parsed_unittest.cc',
              'dns/record_rdata_unittest.cc',
            ],
        }],
        [ 'OS == "win"', {
            'sources!': [
              'dns/dns_config_service_posix_unittest.cc',
              'http/http_auth_gssapi_posix_unittest.cc',
            ],
            'dependencies': [
              '../third_party/nss/nss.gyp:nspr',
              '../third_party/nss/nss.gyp:nss',
              'third_party/nss/ssl.gyp:libssl',
            ],
            'conditions': [
              [ 'icu_use_data_file_flag == 0', {
                # This is needed to trigger the dll copy step on windows.
                # TODO(mark): Specifying this here shouldn't be necessary.
                'dependencies': [
                  '../third_party/icu/icu.gyp:icudata',
                ],
              }],
            ],
            # TODO(jschuh): crbug.com/167187 fix size_t to int truncations.
            'msvs_disabled_warnings': [4267, ],
          },
        ],
        [ 'OS == "mac" and use_openssl == 0', {
            'dependencies': [
              '../third_party/nss/nss.gyp:nspr',
              '../third_party/nss/nss.gyp:nss',
              'third_party/nss/ssl.gyp:libssl',
            ],
          },
        ],
        [ 'OS == "ios"', {
            'dependencies': [
              '../third_party/nss/nss.gyp:nss',
            ],
            'actions': [
              {
                'action_name': 'copy_test_data',
                'variables': {
                  'test_data_files': [
                    'data/ssl/certificates/',
                    'data/test.html',
                    'data/url_request_unittest/',
                  ],
                  'test_data_prefix': 'net',
                },
                'includes': [ '../build/copy_test_data_ios.gypi' ],
              },
            ],
            'sources!': [
              # TODO(droger): The following tests are disabled because the
              # implementation is missing or incomplete.
              # KeygenHandler::GenKeyAndSignChallenge() is not ported to iOS.
              'base/keygen_handler_unittest.cc',
              'disk_cache/backend_unittest.cc',
              'disk_cache/blockfile/block_files_unittest.cc',
              # Need to read input data files.
              'filter/gzip_filter_unittest.cc',
              'socket/ssl_server_socket_unittest.cc',
              # Need TestServer.
              'proxy/proxy_script_fetcher_impl_unittest.cc',
              'socket/ssl_client_socket_unittest.cc',
              'url_request/url_fetcher_impl_unittest.cc',
              'url_request/url_request_context_builder_unittest.cc',
              # Needs GetAppOutput().
              'test/python_utils_unittest.cc',

              # The following tests are disabled because they don't apply to
              # iOS.
              # OS is not "linux" or "freebsd" or "openbsd".
              'socket/unix_domain_socket_posix_unittest.cc',

              # See bug http://crbug.com/344533.
              'disk_cache/blockfile/index_table_v3_unittest.cc',
            ],
        }],
        [ 'OS == "android"', {
            'dependencies': [
              '../third_party/openssl/openssl.gyp:openssl',
            ],
            'sources!': [
              'dns/dns_config_service_posix_unittest.cc',
            ],
          },
        ],
        ['OS == "android" and gtest_target_type == "shared_library"', {
          'dependencies': [
            '../testing/android/native_test.gyp:native_test_native_code',
          ]
        }],
      ],
      'target_conditions': [
        # These source files are excluded by default platform rules, but they
        # are needed in specific cases on other platforms. Re-including them can
        # only be done in target_conditions as it is evaluated after the
        # platform rules.
        ['OS == "android"', {
          'sources/': [
            ['include', '^base/address_tracker_linux_unittest\\.cc$'],
          ],
        }],
      ],
    },
    {
      'target_name': 'net_perftests',
      'type': 'executable',
      'dependencies': [
        '../base/base.gyp:base',
        '../base/base.gyp:base_i18n',
        '../base/base.gyp:test_support_perf',
        '../testing/gtest.gyp:gtest',
        '../url/url.gyp:url_lib',
        'net',
        'net_test_support',
      ],
      'sources': [
        'cookies/cookie_monster_perftest.cc',
        'disk_cache/blockfile/disk_cache_perftest.cc',
        'proxy/proxy_resolver_perftest.cc',
      ],
      'conditions': [
        [ 'use_v8_in_net==1', {
            'dependencies': [
              'net_with_v8',
            ],
          }, {  # else: !use_v8_in_net
            'sources!': [
              'proxy/proxy_resolver_perftest.cc',
            ],
          },
        ],
        [ 'OS == "win"', {
            'conditions': [
              [ 'icu_use_data_file_flag == 0', {
                # This is needed to trigger the dll copy step on windows.
                # TODO(mark): Specifying this here shouldn't be necessary.
                'dependencies': [
                  '../third_party/icu/icu.gyp:icudata',
                ],
              }],
            ],
            # TODO(jschuh): crbug.com/167187 fix size_t to int truncations.
            'msvs_disabled_warnings': [4267, ],
        }],
      ],
    },
    {
      'target_name': 'net_test_support',
      'type': 'static_library',
      'dependencies': [
        '../base/base.gyp:base',
        '../base/base.gyp:test_support_base',
        '../net/tools/tld_cleanup/tld_cleanup.gyp:tld_cleanup_util',
        '../testing/gtest.gyp:gtest',
        '../testing/gmock.gyp:gmock',
        '../url/url.gyp:url_lib',
        'net',
      ],
      'export_dependent_settings': [
        '../base/base.gyp:base',
        '../base/base.gyp:test_support_base',
        '../testing/gtest.gyp:gtest',
        '../testing/gmock.gyp:gmock',
      ],
      'sources': [
        'base/capturing_net_log.cc',
        'base/capturing_net_log.h',
        'base/load_timing_info_test_util.cc',
        'base/load_timing_info_test_util.h',
        'base/mock_file_stream.cc',
        'base/mock_file_stream.h',
        'base/test_completion_callback.cc',
        'base/test_completion_callback.h',
        'base/test_data_directory.cc',
        'base/test_data_directory.h',
        'cert/mock_cert_verifier.cc',
        'cert/mock_cert_verifier.h',
        'cookies/cookie_monster_store_test.cc',
        'cookies/cookie_monster_store_test.h',
        'cookies/cookie_store_test_callbacks.cc',
        'cookies/cookie_store_test_callbacks.h',
        'cookies/cookie_store_test_helpers.cc',
        'cookies/cookie_store_test_helpers.h',
        'disk_cache/disk_cache_test_base.cc',
        'disk_cache/disk_cache_test_base.h',
        'disk_cache/disk_cache_test_util.cc',
        'disk_cache/disk_cache_test_util.h',
        'dns/dns_test_util.cc',
        'dns/dns_test_util.h',
        'dns/mock_host_resolver.cc',
        'dns/mock_host_resolver.h',
        'dns/mock_mdns_socket_factory.cc',
        'dns/mock_mdns_socket_factory.h',
        'proxy/mock_proxy_resolver.cc',
        'proxy/mock_proxy_resolver.h',
        'proxy/mock_proxy_script_fetcher.cc',
        'proxy/mock_proxy_script_fetcher.h',
        'proxy/proxy_config_service_common_unittest.cc',
        'proxy/proxy_config_service_common_unittest.h',
        'socket/socket_test_util.cc',
        'socket/socket_test_util.h',
        'test/cert_test_util.cc',
        'test/cert_test_util.h',
        'test/ct_test_util.cc',
        'test/ct_test_util.h',
        'test/embedded_test_server/embedded_test_server.cc',
        'test/embedded_test_server/embedded_test_server.h',
        'test/embedded_test_server/http_connection.cc',
        'test/embedded_test_server/http_connection.h',
        'test/embedded_test_server/http_request.cc',
        'test/embedded_test_server/http_request.h',
        'test/embedded_test_server/http_response.cc',
        'test/embedded_test_server/http_response.h',
        'test/net_test_suite.cc',
        'test/net_test_suite.h',
        'test/python_utils.cc',
        'test/python_utils.h',
        'test/spawned_test_server/base_test_server.cc',
        'test/spawned_test_server/base_test_server.h',
        'test/spawned_test_server/local_test_server_posix.cc',
        'test/spawned_test_server/local_test_server_win.cc',
        'test/spawned_test_server/local_test_server.cc',
        'test/spawned_test_server/local_test_server.h',
        'test/spawned_test_server/remote_test_server.cc',
        'test/spawned_test_server/remote_test_server.h',
        'test/spawned_test_server/spawned_test_server.h',
        'test/spawned_test_server/spawner_communicator.cc',
        'test/spawned_test_server/spawner_communicator.h',
        'url_request/test_url_fetcher_factory.cc',
        'url_request/test_url_fetcher_factory.h',
        'url_request/url_request_test_util.cc',
        'url_request/url_request_test_util.h',
      ],
      'conditions': [
        ['OS != "ios"', {
          'dependencies': [
            '../third_party/protobuf/protobuf.gyp:py_proto',
          ],
        }],
        ['os_posix == 1 and OS != "mac" and OS != "android" and OS != "ios"', {
          'conditions': [
            ['use_openssl==1', {
              'dependencies': [
                '../third_party/openssl/openssl.gyp:openssl',
              ],
            }, {
              'dependencies': [
                '../build/linux/system.gyp:ssl',
              ],
            }],
          ],
        }],
        ['os_posix == 1 and OS != "mac" and OS != "android" and OS != "ios"', {
          'conditions': [
            # TODO(dmikurube): Kill linux_use_tcmalloc. http://crbug.com/345554
            ['(use_allocator!="none" and use_allocator!="see_use_tcmalloc") or (use_allocator=="see_use_tcmalloc" and linux_use_tcmalloc==1)', {
              'dependencies': [
                '../base/allocator/allocator.gyp:allocator',
              ],
            }],
          ],
        }],
        ['OS != "android"', {
          'sources!': [
            'test/spawned_test_server/remote_test_server.cc',
            'test/spawned_test_server/remote_test_server.h',
            'test/spawned_test_server/spawner_communicator.cc',
            'test/spawned_test_server/spawner_communicator.h',
          ],
        }],
        ['OS == "ios"', {
          'dependencies': [
            '../third_party/nss/nss.gyp:nss',
          ],
        }],
        [ 'use_v8_in_net==1', {
            'dependencies': [
              'net_with_v8',
            ],
          },
        ],
        [ 'enable_mdns != 1', {
            'sources!' : [
              'dns/mock_mdns_socket_factory.cc',
              'dns/mock_mdns_socket_factory.h'
            ]
        }],
      ],
      # TODO(jschuh): crbug.com/167187 fix size_t to int truncations.
      'msvs_disabled_warnings': [4267, ],
    },
    {
      'target_name': 'net_resources',
      'type': 'none',
      'variables': {
        'grit_out_dir': '<(SHARED_INTERMEDIATE_DIR)/net',
      },
      'actions': [
        {
          'action_name': 'net_resources',
          'variables': {
            'grit_grd_file': 'base/net_resources.grd',
          },
          'includes': [ '../build/grit_action.gypi' ],
        },
      ],
      'includes': [ '../build/grit_target.gypi' ],
    },
    {
      'target_name': 'http_server',
      'type': 'static_library',
      'variables': { 'enable_wexit_time_destructors': 1, },
      'dependencies': [
        '../base/base.gyp:base',
        'net',
      ],
      'sources': [
        'server/http_connection.cc',
        'server/http_connection.h',
        'server/http_server.cc',
        'server/http_server.h',
        'server/http_server_request_info.cc',
        'server/http_server_request_info.h',
        'server/http_server_response_info.cc',
        'server/http_server_response_info.h',
        'server/web_socket.cc',
        'server/web_socket.h',
      ],
      # TODO(jschuh): crbug.com/167187 fix size_t to int truncations.
      'msvs_disabled_warnings': [4267, ],
    },
    {
      'target_name': 'dump_cache',
      'type': 'executable',
      'dependencies': [
        '../base/base.gyp:base',
        'net',
        'net_test_support',
      ],
      'sources': [
        'tools/dump_cache/cache_dumper.cc',
        'tools/dump_cache/cache_dumper.h',
        'tools/dump_cache/dump_cache.cc',
        'tools/dump_cache/dump_files.cc',
        'tools/dump_cache/dump_files.h',
        'tools/dump_cache/simple_cache_dumper.cc',
        'tools/dump_cache/simple_cache_dumper.h',
        'tools/dump_cache/upgrade_win.cc',
        'tools/dump_cache/upgrade_win.h',
        'tools/dump_cache/url_to_filename_encoder.cc',
        'tools/dump_cache/url_to_filename_encoder.h',
        'tools/dump_cache/url_utilities.h',
        'tools/dump_cache/url_utilities.cc',
      ],
      # TODO(jschuh): crbug.com/167187 fix size_t to int truncations.
      'msvs_disabled_warnings': [4267, ],
    },
  ],
  'conditions': [
    ['use_v8_in_net == 1', {
      'targets': [
        {
          'target_name': 'net_with_v8',
          'type': '<(component)',
          'variables': { 'enable_wexit_time_destructors': 1, },
          'dependencies': [
            '../base/base.gyp:base',
            '../url/url.gyp:url_lib',
            '../v8/tools/gyp/v8.gyp:v8',
            'net'
          ],
          'defines': [
            'NET_IMPLEMENTATION',
          ],
          'sources': [
            'proxy/proxy_resolver_v8.cc',
            'proxy/proxy_resolver_v8.h',
            'proxy/proxy_resolver_v8_tracing.cc',
            'proxy/proxy_resolver_v8_tracing.h',
            'proxy/proxy_service_v8.cc',
            'proxy/proxy_service_v8.h',
          ],
          # TODO(jschuh): crbug.com/167187 fix size_t to int truncations.
          'msvs_disabled_warnings': [4267, ],
        },
      ],
    }],
    ['OS != "ios" and OS != "android"', {
      'targets': [
        # iOS doesn't have the concept of simple executables, these targets
        # can't be compiled on the platform.
        {
          'target_name': 'crash_cache',
          'type': 'executable',
          'dependencies': [
            '../base/base.gyp:base',
            'net',
            'net_test_support',
          ],
          'sources': [
            'tools/crash_cache/crash_cache.cc',
          ],
          # TODO(jschuh): crbug.com/167187 fix size_t to int truncations.
          'msvs_disabled_warnings': [4267, ],
        },
        {
          'target_name': 'crl_set_dump',
          'type': 'executable',
          'dependencies': [
            '../base/base.gyp:base',
            'net',
          ],
          'sources': [
            'tools/crl_set_dump/crl_set_dump.cc',
          ],
          # TODO(jschuh): crbug.com/167187 fix size_t to int truncations.
          'msvs_disabled_warnings': [4267, ],
        },
        {
          'target_name': 'dns_fuzz_stub',
          'type': 'executable',
          'dependencies': [
            '../base/base.gyp:base',
            'net',
          ],
          'sources': [
            'tools/dns_fuzz_stub/dns_fuzz_stub.cc',
          ],
          # TODO(jschuh): crbug.com/167187 fix size_t to int truncations.
          'msvs_disabled_warnings': [4267, ],
        },
        {
          'target_name': 'gdig',
          'type': 'executable',
          'dependencies': [
            '../base/base.gyp:base',
            'net',
          ],
          'sources': [
            'tools/gdig/file_net_log.cc',
            'tools/gdig/gdig.cc',
          ],
        },
        {
          'target_name': 'get_server_time',
          'type': 'executable',
          'dependencies': [
            '../base/base.gyp:base',
            '../base/base.gyp:base_i18n',
            '../url/url.gyp:url_lib',
            'net',
          ],
          'sources': [
            'tools/get_server_time/get_server_time.cc',
          ],
          # TODO(jschuh): crbug.com/167187 fix size_t to int truncations.
          'msvs_disabled_warnings': [4267, ],
        },
        {
          'target_name': 'net_watcher',
          'type': 'executable',
          'dependencies': [
            '../base/base.gyp:base',
            'net',
            'net_with_v8',
          ],
          'conditions': [
            [ 'use_glib == 1', {
                'dependencies': [
                  '../build/linux/system.gyp:gconf',
                  '../build/linux/system.gyp:gio',
                ],
              },
            ],
          ],
          'sources': [
            'tools/net_watcher/net_watcher.cc',
          ],
        },
        {
          'target_name': 'run_testserver',
          'type': 'executable',
          'dependencies': [
            '../base/base.gyp:base',
            '../base/base.gyp:test_support_base',
            '../testing/gtest.gyp:gtest',
            'net_test_support',
          ],
          'sources': [
            'tools/testserver/run_testserver.cc',
          ],
        },
        {
          'target_name': 'stress_cache',
          'type': 'executable',
          'dependencies': [
            '../base/base.gyp:base',
            'net',
            'net_test_support',
          ],
          'sources': [
            'disk_cache/blockfile/stress_cache.cc',
          ],
          # TODO(jschuh): crbug.com/167187 fix size_t to int truncations.
          'msvs_disabled_warnings': [4267, ],
        },
        {
          'target_name': 'tld_cleanup',
          'type': 'executable',
          'dependencies': [
            '../base/base.gyp:base',
            '../base/base.gyp:base_i18n',
            '../net/tools/tld_cleanup/tld_cleanup.gyp:tld_cleanup_util',
          ],
          'sources': [
            'tools/tld_cleanup/tld_cleanup.cc',
          ],
          # TODO(jschuh): crbug.com/167187 fix size_t to int truncations.
          'msvs_disabled_warnings': [4267, ],
        },
      ],
    }],
    ['os_posix == 1 and OS != "mac" and OS != "ios" and OS != "android"', {
      'targets': [
        {
          'target_name': 'balsa',
          'type': 'static_library',
          'dependencies': [
            '../base/base.gyp:base',
            'net',
          ],
          'sources': [
            'tools/balsa/balsa_enums.h',
            'tools/balsa/balsa_frame.cc',
            'tools/balsa/balsa_frame.h',
            'tools/balsa/balsa_headers.cc',
            'tools/balsa/balsa_headers.h',
            'tools/balsa/balsa_headers_token_utils.cc',
            'tools/balsa/balsa_headers_token_utils.h',
            'tools/balsa/balsa_visitor_interface.h',
            'tools/balsa/http_message_constants.cc',
            'tools/balsa/http_message_constants.h',
            'tools/balsa/noop_balsa_visitor.h',
            'tools/balsa/simple_buffer.cc',
            'tools/balsa/simple_buffer.h',
            'tools/balsa/split.cc',
            'tools/balsa/split.h',
            'tools/balsa/string_piece_utils.h',
          ],
        },
        {
          'target_name': 'epoll_server',
          'type': 'static_library',
          'dependencies': [
            '../base/base.gyp:base',
            'net',
          ],
          'sources': [
            'tools/epoll_server/epoll_server.cc',
            'tools/epoll_server/epoll_server.h',
          ],
        },
        {
          'target_name': 'flip_in_mem_edsm_server_base',
          'type': 'static_library',
          'cflags': [
            '-Wno-deprecated',
          ],
          'dependencies': [
            '../base/base.gyp:base',
            '../third_party/openssl/openssl.gyp:openssl',
            'balsa',
            'epoll_server',
            'net',
          ],
          'sources': [
            'tools/dump_cache/url_to_filename_encoder.cc',
            'tools/dump_cache/url_to_filename_encoder.h',
            'tools/dump_cache/url_utilities.h',
            'tools/dump_cache/url_utilities.cc',
            'tools/flip_server/acceptor_thread.h',
            'tools/flip_server/acceptor_thread.cc',
            'tools/flip_server/create_listener.cc',
            'tools/flip_server/create_listener.h',
            'tools/flip_server/constants.h',
            'tools/flip_server/flip_config.cc',
            'tools/flip_server/flip_config.h',
            'tools/flip_server/http_interface.cc',
            'tools/flip_server/http_interface.h',
            'tools/flip_server/loadtime_measurement.h',
            'tools/flip_server/mem_cache.h',
            'tools/flip_server/mem_cache.cc',
            'tools/flip_server/output_ordering.cc',
            'tools/flip_server/output_ordering.h',
            'tools/flip_server/ring_buffer.cc',
            'tools/flip_server/ring_buffer.h',
            'tools/flip_server/sm_connection.cc',
            'tools/flip_server/sm_connection.h',
            'tools/flip_server/sm_interface.h',
            'tools/flip_server/spdy_ssl.cc',
            'tools/flip_server/spdy_ssl.h',
            'tools/flip_server/spdy_interface.cc',
            'tools/flip_server/spdy_interface.h',
            'tools/flip_server/spdy_util.cc',
            'tools/flip_server/spdy_util.h',
            'tools/flip_server/streamer_interface.cc',
            'tools/flip_server/streamer_interface.h',
          ],
        },
        {
          'target_name': 'flip_in_mem_edsm_server_unittests',
          'type': 'executable',
          'dependencies': [
              '../testing/gtest.gyp:gtest',
              '../testing/gmock.gyp:gmock',
              '../third_party/openssl/openssl.gyp:openssl',
              'flip_in_mem_edsm_server_base',
              'net',
              'net_test_support',
          ],
          'sources': [
            'tools/flip_server/flip_test_utils.cc',
            'tools/flip_server/flip_test_utils.h',
            'tools/flip_server/http_interface_test.cc',
            'tools/flip_server/mem_cache_test.cc',
            'tools/flip_server/run_all_tests.cc',
            'tools/flip_server/spdy_interface_test.cc',
          ],
        },
        {
          'target_name': 'flip_in_mem_edsm_server',
          'type': 'executable',
          'cflags': [
            '-Wno-deprecated',
          ],
          'dependencies': [
            '../base/base.gyp:base',
            'flip_in_mem_edsm_server_base',
            'net',
          ],
          'sources': [
            'tools/flip_server/flip_in_mem_edsm_server.cc',
          ],
        },
        {
          'target_name': 'quic_base',
          'type': 'static_library',
          'dependencies': [
            '../base/base.gyp:base',
            '../base/third_party/dynamic_annotations/dynamic_annotations.gyp:dynamic_annotations',
            '../crypto/crypto.gyp:crypto',
            '../third_party/openssl/openssl.gyp:openssl',
            '../url/url.gyp:url_lib',
            'balsa',
            'epoll_server',
            'net',
          ],
          'sources': [
            'tools/quic/quic_client.cc',
            'tools/quic/quic_client.h',
            'tools/quic/quic_client_session.cc',
            'tools/quic/quic_client_session.h',
            'tools/quic/quic_default_packet_writer.cc',
            'tools/quic/quic_default_packet_writer.h',
            'tools/quic/quic_dispatcher.h',
            'tools/quic/quic_dispatcher.cc',
            'tools/quic/quic_epoll_clock.cc',
            'tools/quic/quic_epoll_clock.h',
            'tools/quic/quic_epoll_connection_helper.cc',
            'tools/quic/quic_epoll_connection_helper.h',
            'tools/quic/quic_in_memory_cache.cc',
            'tools/quic/quic_in_memory_cache.h',
            'tools/quic/quic_packet_writer_wrapper.cc',
            'tools/quic/quic_packet_writer_wrapper.h',
            'tools/quic/quic_server.cc',
            'tools/quic/quic_server.h',
            'tools/quic/quic_server_session.cc',
            'tools/quic/quic_server_session.h',
            'tools/quic/quic_socket_utils.cc',
            'tools/quic/quic_socket_utils.h',
            'tools/quic/quic_spdy_client_stream.cc',
            'tools/quic/quic_spdy_client_stream.h',
            'tools/quic/quic_spdy_server_stream.cc',
            'tools/quic/quic_spdy_server_stream.h',
            'tools/quic/quic_time_wait_list_manager.h',
            'tools/quic/quic_time_wait_list_manager.cc',
            'tools/quic/spdy_utils.cc',
            'tools/quic/spdy_utils.h',
          ],
        },
        {
          'target_name': 'quic_client',
          'type': 'executable',
          'dependencies': [
            '../base/base.gyp:base',
            '../third_party/openssl/openssl.gyp:openssl',
            'net',
            'quic_base',
          ],
          'sources': [
            'tools/quic/quic_client_bin.cc',
          ],
        },
        {
          'target_name': 'quic_server',
          'type': 'executable',
          'dependencies': [
            '../base/base.gyp:base',
            '../third_party/openssl/openssl.gyp:openssl',
            'net',
            'quic_base',
          ],
          'sources': [
            'tools/quic/quic_server_bin.cc',
          ],
        }
      ]
    }],
    ['OS=="android"', {
      'targets': [
        {
          'target_name': 'net_jni_headers',
          'type': 'none',
          'sources': [
            'android/java/src/org/chromium/net/AndroidCertVerifyResult.java',
            'android/java/src/org/chromium/net/AndroidKeyStore.java',
            'android/java/src/org/chromium/net/AndroidNetworkLibrary.java',
            'android/java/src/org/chromium/net/AndroidPrivateKey.java',
            'android/java/src/org/chromium/net/GURLUtils.java',
            'android/java/src/org/chromium/net/NetworkChangeNotifier.java',
            'android/java/src/org/chromium/net/ProxyChangeListener.java',
            'android/java/src/org/chromium/net/X509Util.java',
          ],
          'variables': {
            'jni_gen_package': 'net',
            'jni_generator_ptr_type': 'long',
          },
          'includes': [ '../build/jni_generator.gypi' ],
        },
        {
          'target_name': 'net_test_jni_headers',
          'type': 'none',
          'sources': [
            'android/javatests/src/org/chromium/net/AndroidKeyStoreTestUtil.java',
          ],
          'variables': {
            'jni_gen_package': 'net',
            'jni_generator_ptr_type': 'long',
          },
          'includes': [ '../build/jni_generator.gypi' ],
        },
        {
          'target_name': 'net_java',
          'type': 'none',
          'variables': {
            'java_in_dir': '../net/android/java',
          },
          'dependencies': [
            '../base/base.gyp:base',
            'cert_verify_status_android_java',
            'certificate_mime_types_java',
            'net_errors_java',
            'private_key_types_java',
            'remote_android_keystore_aidl',
          ],
          'includes': [ '../build/java.gypi' ],
        },
        {
          # Processes the interface files for communication with an Android KeyStore
          # running in a separate process.
          'target_name': 'remote_android_keystore_aidl',
          'type': 'none',
          'variables': {
            'aidl_interface_file': '../net/android/java/src/org/chromium/net/IRemoteAndroidKeyStoreInterface.aidl',
          },
          'sources': [
            '../net/android/java/src/org/chromium/net/IRemoteAndroidKeyStore.aidl',
            '../net/android/java/src/org/chromium/net/IRemoteAndroidKeyStoreCallbacks.aidl',
          ],
          'includes': [ '../build/java_aidl.gypi' ],
        },
        {
          'target_name': 'net_java_test_support',
          'type': 'none',
          'variables': {
            'java_in_dir': '../net/test/android/javatests',
          },
          'includes': [ '../build/java.gypi' ],
        },
        {
          'target_name': 'net_javatests',
          'type': 'none',
          'variables': {
            'java_in_dir': '../net/android/javatests',
          },
          'dependencies': [
            '../base/base.gyp:base',
            '../base/base.gyp:base_java_test_support',
            'net_java',
          ],
          'includes': [ '../build/java.gypi' ],
        },
        {
          'target_name': 'net_errors_java',
          'type': 'none',
          'sources': [
            'android/java/NetError.template',
          ],
          'variables': {
            'package_name': 'org/chromium/net',
            'template_deps': ['base/net_error_list.h'],
          },
          'includes': [ '../build/android/java_cpp_template.gypi' ],
        },
        {
          'target_name': 'certificate_mime_types_java',
          'type': 'none',
          'sources': [
            'android/java/CertificateMimeType.template',
          ],
          'variables': {
            'package_name': 'org/chromium/net',
            'template_deps': ['base/mime_util_certificate_type_list.h'],
          },
          'includes': [ '../build/android/java_cpp_template.gypi' ],
        },
        {
          'target_name': 'cert_verify_status_android_java',
          'type': 'none',
          'sources': [
            'android/java/CertVerifyStatusAndroid.template',
          ],
          'variables': {
            'package_name': 'org/chromium/net',
            'template_deps': ['android/cert_verify_status_android_list.h'],
          },
          'includes': [ '../build/android/java_cpp_template.gypi' ],
        },
        {
          'target_name': 'private_key_types_java',
          'type': 'none',
          'sources': [
            'android/java/PrivateKeyType.template',
          ],
          'variables': {
            'package_name': 'org/chromium/net',
            'template_deps': ['android/private_key_type_list.h'],
          },
          'includes': [ '../build/android/java_cpp_template.gypi' ],
        },
      ],
    }],
    # Special target to wrap a gtest_target_type==shared_library
    # net_unittests into an android apk for execution.
    # See base.gyp for TODO(jrg)s about this strategy.
    ['OS == "android" and gtest_target_type == "shared_library"', {
      'targets': [
        {
          'target_name': 'net_unittests_apk',
          'type': 'none',
          'dependencies': [
            'net_java',
            'net_javatests',
            'net_unittests',
          ],
          'variables': {
            'test_suite_name': 'net_unittests',
            'input_shlib_path': '<(SHARED_LIB_DIR)/<(SHARED_LIB_PREFIX)net_unittests<(SHARED_LIB_SUFFIX)',
          },
          'includes': [ '../build/apk_test.gypi' ],
        },
      ],
    }],
    ['OS == "android" or OS == "linux"', {
      'targets': [
        {
          'target_name': 'disk_cache_memory_test',
          'type': 'executable',
          'dependencies': [
            '../base/base.gyp:base',
            'net',
          ],
          'sources': [
            'tools/disk_cache_memory_test/disk_cache_memory_test.cc',
          ],
        },
      ],
    }],
    ['test_isolation_mode != "noop"', {
      'targets': [
        {
          'target_name': 'net_unittests_run',
          'type': 'none',
          'dependencies': [
            'net_unittests',
          ],
          'includes': [
            '../build/isolate.gypi',
            'net_unittests.isolate',
          ],
          'sources': [
            'net_unittests.isolate',
          ],
        },
      ],
    }],
    ['OS=="android"', {
      # TODO(mef): Consider moving all Cronet Android targets into separate
      # file. Also figure out what needs to be done for gn script.
      'targets': [
        {
          'target_name': 'cronet_jni_headers',
          'type': 'none',
          'sources': [
            'cronet/android/java/src/org/chromium/net/UrlRequest.java',
            'cronet/android/java/src/org/chromium/net/UrlRequestContext.java',
          ],
          'variables': {
            'jni_gen_package': 'cronet',
            'jni_generator_ptr_type': 'long',
          },
          'includes': [ '../build/jni_generator.gypi' ],
        },
        {
          'target_name': 'libcronet',
          'type': 'shared_library',
          'dependencies': [
            '../base/base.gyp:base',
            '../base/base.gyp:base_i18n',
            '../third_party/icu/icu.gyp:icui18n',
            '../third_party/icu/icu.gyp:icuuc',
            '../url/url.gyp:url_lib',
            'cronet_jni_headers',
            'net',
          ],
          'sources': [
            'cronet/android/org_chromium_net_UrlRequest.cc',
            'cronet/android/org_chromium_net_UrlRequest.h',
            'cronet/android/org_chromium_net_UrlRequestContext.cc',
            'cronet/android/org_chromium_net_UrlRequestContext.h',
            'cronet/android/url_request_context_peer.cc',
            'cronet/android/url_request_context_peer.h',
            'cronet/android/url_request_peer.cc',
            'cronet/android/url_request_peer.h',
          ],
          'cflags': [
            # TODO(mef): Figure out a good way to get version from chrome_version_info_posix.h.
            '-DCHROMIUM_VERSION=\\"TBD\\"',
            '-DLOGGING=1',
            '-fdata-sections',
            '-ffunction-sections',
            '-fno-rtti',
            '-fvisibility=hidden',
            '-fvisibility-inlines-hidden',
            '-Wno-sign-promo',
            '-Wno-missing-field-initializers',
          ],
          'ldflags': [
            '-llog',
            '-landroid',
            '-Wl,--gc-sections',
            '-Wl,--exclude-libs,ALL'
          ]
        },
        {
          'target_name': 'cronet',
          'type': 'none',
          'dependencies': [
            '../base/base.gyp:base',
            'libcronet',
          ],
          'variables': {
            'java_in_dir': 'cronet/android/java',
          },
          'includes': [ '../build/java.gypi' ],
        },
        {
          'target_name': 'cronet_package',
          'type': 'none',
          'dependencies': [
            'libcronet',
            'cronet',
          ],
          'variables': {
              'native_lib': 'libcronet.>(android_product_extension)',
              'java_lib': 'cronet.jar',
              'package_dir': '<(PRODUCT_DIR)/cronet',
          },
          'actions': [
            {
              'action_name': 'strip libcronet',
              'inputs': ['<(SHARED_LIB_DIR)/<(native_lib)'],
              'outputs': ['<(package_dir)/libs/<(android_app_abi)/<(native_lib)'],
              'action': [
                '<(android_strip)',
                '--strip-unneeded',
                '<@(_inputs)',
                '-o',
                '<@(_outputs)',
              ],
            },
          ],
          'copies': [
            {
              'destination': '<(package_dir)',
              'files': [
                '<(PRODUCT_DIR)/lib.java/<(java_lib)',
              ],
            },
          ],
        },
        {
          'target_name': 'cronet_sample_apk',
          'type': 'none',
          'dependencies': [
            'cronet',
          ],
          'variables': {
            'apk_name': 'CronetSample',
            'java_in_dir': 'cronet/android/sample',
            'resource_dir': 'cronet/android/sample/res',
            'native_lib_target': 'libcronet',
          },
          'includes': [ '../build/java_apk.gypi' ],
        },
        {
          # cronet_sample_apk creates a .jar as a side effect. Any java targets
          # that need that .jar in their classpath should depend on this target,
          # cronet_sample_apk_java. Dependents of cronet_sample_apk receive its
          # jar path in the variable 'apk_output_jar_path'. This target should
          # only be used by targets which instrument cronet_sample_apk.
          'target_name': 'cronet_sample_apk_java',
          'type': 'none',
          'dependencies': [
            'cronet_sample_apk',
          ],
          'includes': [ '../build/apk_fake_jar.gypi' ],
        },
        {
          'target_name': 'cronet_sample_test_apk',
          'type': 'none',
          'dependencies': [
            'cronet_sample_apk_java',
            '../base/base.gyp:base_java',
            '../base/base.gyp:base_javatests',
            '../base/base.gyp:base_java_test_support',
            # TODO(mef): Figure out why some tests are failing.
            #'../net/net.gyp:net_javatests',
            #'../net/net.gyp:net_java_test_support',
          ],
          'variables': {
            'apk_name': 'CronetSampleTest',
            'java_in_dir': 'cronet/android/sample/javatests',
            'resource_dir': 'cronet/android/sample/res',
            'is_test_apk': 1,
          },
          'includes': [ '../build/java_apk.gypi' ],
        },
      ],
    }],  # OS=="android"
  ],
}
