/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.gui;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.InputEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.UIManager;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jhotdraw.gui.fontchooser.DefaultFontChooserModel;
import org.jhotdraw.gui.fontchooser.FontChooserModel;
import org.jhotdraw.gui.fontchooser.FontCollectionNode;
import org.jhotdraw.gui.fontchooser.FontFaceNode;
import org.jhotdraw.gui.fontchooser.FontFamilyNode;
import org.jhotdraw.gui.plaf.FontChooserUI;
import org.jhotdraw.gui.plaf.palette.PaletteFontChooserUI;

public class JFontChooser
extends JComponent {
    private static final String uiClassID = "FontChooserUI";
    public static final String SELECTED_FONT_PROPERTY = "selectedFont";
    public static final String SELECTION_PATH_PROPERTY = "selectionPath";
    public static final String CANCEL_SELECTION = "CancelSelection";
    public static final String APPROVE_SELECTION = "ApproveSelection";
    public static final String MODEL_PROPERTY = "model";
    private TreePath selectionPath;
    private Font selectedFont;
    private FontChooserModel model;
    public static final int CANCEL_OPTION = 1;
    public static final int APPROVE_OPTION = 0;
    public static final int ERROR_OPTION = -1;
    private int returnValue = -1;
    private JDialog dialog = null;
    private static FutureTask<Font[]> future;
    private TreeModelListener modelHandler = new TreeModelListener(){

        @Override
        public void treeNodesChanged(TreeModelEvent treeModelEvent) {
            JFontChooser.this.updateSelectionPath(JFontChooser.this.getSelectedFont());
        }

        @Override
        public void treeNodesInserted(TreeModelEvent treeModelEvent) {
            JFontChooser.this.updateSelectionPath(JFontChooser.this.getSelectedFont());
        }

        @Override
        public void treeNodesRemoved(TreeModelEvent treeModelEvent) {
            JFontChooser.this.updateSelectionPath(JFontChooser.this.getSelectedFont());
        }

        @Override
        public void treeStructureChanged(TreeModelEvent treeModelEvent) {
            JFontChooser.this.updateSelectionPath(JFontChooser.this.getSelectedFont());
        }
    };

    public JFontChooser() {
        JFontChooser.loadAllFonts();
        this.model = new DefaultFontChooserModel.UIResource();
        this.model.addTreeModelListener(this.modelHandler);
        this.updateUI();
        this.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (propertyChangeEvent.getPropertyName() == "ancestor" && propertyChangeEvent.getNewValue() != null) {
                    Component component = (Component)propertyChangeEvent.getNewValue();
                    try {
                        ((DefaultFontChooserModel)JFontChooser.this.model).setFonts(JFontChooser.getAllFonts());
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                    JFontChooser.this.removePropertyChangeListener(this);
                }
            }
        });
    }

    @Override
    public void updateUI() {
        if (UIManager.get(this.getUIClassID()) != null) {
            this.setUI((FontChooserUI)UIManager.getUI(this));
        } else {
            this.setUI(PaletteFontChooserUI.createUI(this));
        }
    }

    @Override
    public FontChooserUI getUI() {
        return (FontChooserUI)this.ui;
    }

    public void setUI(FontChooserUI fontChooserUI) {
        super.setUI(fontChooserUI);
    }

    @Override
    public String getUIClassID() {
        return uiClassID;
    }

    public void approveSelection() {
        this.returnValue = 0;
        if (this.dialog != null) {
            this.dialog.setVisible(false);
        }
        this.fireActionPerformed(APPROVE_SELECTION);
    }

    public void cancelSelection() {
        this.returnValue = 1;
        if (this.dialog != null) {
            this.dialog.setVisible(false);
        }
        this.fireActionPerformed(CANCEL_SELECTION);
    }

    public void addActionListener(ActionListener actionListener) {
        this.listenerList.add(ActionListener.class, actionListener);
    }

    public void removeActionListener(ActionListener actionListener) {
        this.listenerList.remove(ActionListener.class, actionListener);
    }

    protected void fireActionPerformed(String string) {
        Object[] objectArray = this.listenerList.getListenerList();
        long l = EventQueue.getMostRecentEventTime();
        int n = 0;
        AWTEvent aWTEvent = EventQueue.getCurrentEvent();
        if (aWTEvent instanceof InputEvent) {
            n = ((InputEvent)aWTEvent).getModifiers();
        } else if (aWTEvent instanceof ActionEvent) {
            n = ((ActionEvent)aWTEvent).getModifiers();
        }
        ActionEvent actionEvent = null;
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != ActionListener.class) continue;
            if (actionEvent == null) {
                actionEvent = new ActionEvent(this, 1001, string, l, n);
            }
            ((ActionListener)objectArray[i + 1]).actionPerformed(actionEvent);
        }
    }

    public TreePath getSelectionPath() {
        return this.selectionPath;
    }

    public void setSelectionPath(TreePath treePath) {
        TreePath treePath2 = this.selectionPath;
        this.selectionPath = treePath;
        this.firePropertyChange(SELECTION_PATH_PROPERTY, treePath2, treePath);
        if (this.selectionPath != null && this.selectionPath.getPathCount() == 4) {
            this.setSelectedFont(((FontFaceNode)this.selectionPath.getLastPathComponent()).getFont());
        }
    }

    public static synchronized void loadAllFonts() {
        if (future == null) {
            future = new FutureTask<Font[]>(new Callable<Font[]>(){

                @Override
                public Font[] call() throws Exception {
                    long l = System.currentTimeMillis();
                    Font[] fontArray = GraphicsEnvironment.getLocalGraphicsEnvironment().getAllFonts();
                    long l2 = System.currentTimeMillis();
                    ArrayList<Font> arrayList = new ArrayList<Font>(fontArray.length);
                    for (Font font : fontArray) {
                        Font font2 = Font.decode(font.getFontName());
                        if (!font2.getFontName().equals(font.getFontName()) && !font2.getFontName().endsWith("-Derived")) continue;
                        arrayList.add(font);
                    }
                    return arrayList.toArray(new Font[arrayList.size()]);
                }
            });
            new Thread(future).start();
        }
    }

    public static synchronized Font[] getAllFonts() {
        JFontChooser.loadAllFonts();
        try {
            return (Font[])future.get().clone();
        }
        catch (InterruptedException interruptedException) {
            return new Font[0];
        }
        catch (ExecutionException executionException) {
            return new Font[0];
        }
    }

    public Font getSelectedFont() {
        return this.selectedFont;
    }

    public void setSelectedFont(Font font) {
        Font font2 = this.selectedFont;
        this.selectedFont = font;
        this.firePropertyChange(SELECTED_FONT_PROPERTY, font2, font);
        this.updateSelectionPath(font);
    }

    /*
     * WARNING - void declaration
     */
    protected void updateSelectionPath(Font font) {
        if (font == null || this.selectionPath == null || this.selectionPath.getPathCount() != 4 || !((FontFaceNode)this.selectionPath.getLastPathComponent()).getFont().getFontName().equals(font.getFontName())) {
            if (font == null) {
                this.setSelectionPath(null);
            } else {
                TreePath treePath = this.selectionPath;
                FontCollectionNode fontCollectionNode = treePath != null && treePath.getPathCount() > 1 ? (FontCollectionNode)treePath.getPathComponent(1) : null;
                FontFamilyNode fontFamilyNode = treePath != null && treePath.getPathCount() > 2 ? (FontFamilyNode)treePath.getPathComponent(2) : null;
                FontFaceNode fontFaceNode = treePath != null && treePath.getPathCount() > 3 ? (FontFaceNode)treePath.getPathComponent(3) : null;
                FontCollectionNode comparable = fontCollectionNode;
                FontFamilyNode comparable2 = fontFamilyNode;
                FontFaceNode comparable3 = null;
                if (comparable3 == null && comparable2 != null) {
                    for (FontFaceNode comparable4 : comparable2.faces()) {
                        if (!comparable4.getFont().getFontName().equals(font.getFontName())) continue;
                        comparable3 = comparable4;
                        break;
                    }
                }
                if (comparable3 == null && comparable != null) {
                    block1: for (FontFamilyNode fontFamilyNode2 : comparable.families()) {
                        for (FontFaceNode fontFaceNode2 : fontFamilyNode2.faces()) {
                            if (!fontFaceNode2.getFont().getFontName().equals(font.getFontName())) continue;
                            comparable2 = fontFamilyNode2;
                            comparable3 = fontFaceNode2;
                            continue block1;
                        }
                    }
                }
                if (comparable3 == null) {
                    void var10_14;
                    TreeNode treeNode = (TreeNode)this.getModel().getRoot();
                    boolean bl = false;
                    int n = treeNode.getChildCount();
                    block3: while (var10_14 < n) {
                        FontCollectionNode fontCollectionNode2 = (FontCollectionNode)treeNode.getChildAt((int)var10_14);
                        for (FontFamilyNode fontFamilyNode3 : fontCollectionNode2.families()) {
                            for (FontFaceNode fontFaceNode3 : fontFamilyNode3.faces()) {
                                if (!fontFaceNode3.getFont().getFontName().equals(font.getFontName())) continue;
                                comparable = fontCollectionNode2;
                                comparable2 = fontFamilyNode3;
                                comparable3 = fontFaceNode3;
                                break block3;
                            }
                        }
                        ++var10_14;
                    }
                }
                if (comparable3 != null) {
                    this.setSelectionPath(new TreePath(new Object[]{this.getModel().getRoot(), comparable, comparable2, comparable3}));
                } else {
                    this.setSelectionPath(null);
                }
            }
        }
    }

    public FontChooserModel getModel() {
        return this.model;
    }

    public void setModel(FontChooserModel fontChooserModel) {
        FontChooserModel fontChooserModel2 = this.model;
        if (fontChooserModel2 != null) {
            fontChooserModel2.removeTreeModelListener(this.modelHandler);
        }
        this.model = fontChooserModel;
        if (fontChooserModel != null) {
            fontChooserModel.addTreeModelListener(this.modelHandler);
        }
        this.firePropertyChange(MODEL_PROPERTY, fontChooserModel2, fontChooserModel);
        this.updateSelectionPath(this.selectedFont);
    }
}

