/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.standard;

import java.awt.Point;
import java.awt.Rectangle;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Iterator;
import java.util.List;
import org.jhotdraw.framework.Drawing;
import org.jhotdraw.framework.DrawingChangeEvent;
import org.jhotdraw.framework.DrawingChangeListener;
import org.jhotdraw.framework.Figure;
import org.jhotdraw.framework.FigureChangeEvent;
import org.jhotdraw.framework.FigureEnumeration;
import org.jhotdraw.framework.HandleEnumeration;
import org.jhotdraw.standard.CompositeFigure;
import org.jhotdraw.standard.HandleEnumerator;
import org.jhotdraw.standard.NullHandle;
import org.jhotdraw.standard.RelativeLocator;
import org.jhotdraw.util.CollectionsFactory;

public class StandardDrawing
extends CompositeFigure
implements Drawing {
    private transient List fListeners = CollectionsFactory.current().createList(2);
    private transient Thread fDrawingLockHolder = null;
    private String myTitle;
    private static final long serialVersionUID = -2602151437447962046L;
    private int drawingSerializedDataVersion = 1;

    public StandardDrawing() {
        this.init(new Rectangle(-500, -500, 2000, 2000));
    }

    public void addDrawingChangeListener(DrawingChangeListener drawingChangeListener) {
        if (this.fListeners == null) {
            this.fListeners = CollectionsFactory.current().createList(2);
        }
        this.fListeners.add(drawingChangeListener);
    }

    public void removeDrawingChangeListener(DrawingChangeListener drawingChangeListener) {
        this.fListeners.remove(drawingChangeListener);
    }

    public Iterator drawingChangeListeners() {
        return this.fListeners.iterator();
    }

    public synchronized Figure orphan(Figure figure) {
        Figure figure2 = super.orphan(figure);
        if (figure2.listener() != null) {
            Rectangle rectangle = this.invalidateRectangle(this.displayBox());
            figure2.listener().figureRequestRemove(new FigureChangeEvent(figure2, rectangle));
        }
        return figure2;
    }

    public synchronized Figure add(Figure figure) {
        Figure figure2 = super.add(figure);
        if (figure2.listener() != null) {
            Rectangle rectangle = this.invalidateRectangle(this.displayBox());
            figure2.listener().figureRequestUpdate(new FigureChangeEvent(figure, rectangle));
            return figure2;
        }
        return figure2;
    }

    public void figureInvalidated(FigureChangeEvent figureChangeEvent) {
        if (this.fListeners != null) {
            for (int i = 0; i < this.fListeners.size(); ++i) {
                DrawingChangeListener drawingChangeListener = (DrawingChangeListener)this.fListeners.get(i);
                drawingChangeListener.drawingInvalidated(new DrawingChangeEvent(this, figureChangeEvent.getInvalidatedRectangle()));
            }
        }
    }

    public void fireDrawingTitleChanged() {
        if (this.fListeners != null) {
            for (int i = 0; i < this.fListeners.size(); ++i) {
                DrawingChangeListener drawingChangeListener = (DrawingChangeListener)this.fListeners.get(i);
                drawingChangeListener.drawingTitleChanged(new DrawingChangeEvent(this, null));
            }
        }
    }

    public void figureRequestUpdate(FigureChangeEvent figureChangeEvent) {
        if (this.fListeners != null) {
            for (int i = 0; i < this.fListeners.size(); ++i) {
                DrawingChangeListener drawingChangeListener = (DrawingChangeListener)this.fListeners.get(i);
                drawingChangeListener.drawingRequestUpdate(new DrawingChangeEvent(this, null));
            }
        }
    }

    public HandleEnumeration handles() {
        List list = CollectionsFactory.current().createList();
        list.add(new NullHandle(this, RelativeLocator.northWest()));
        list.add(new NullHandle(this, RelativeLocator.northEast()));
        list.add(new NullHandle(this, RelativeLocator.southWest()));
        list.add(new NullHandle(this, RelativeLocator.southEast()));
        return new HandleEnumerator(list);
    }

    public Rectangle displayBox() {
        if (this.fFigures.size() > 0) {
            FigureEnumeration figureEnumeration = this.figures();
            Rectangle rectangle = figureEnumeration.nextFigure().displayBox();
            while (figureEnumeration.hasNextFigure()) {
                rectangle.add(figureEnumeration.nextFigure().displayBox());
            }
            return rectangle;
        }
        return new Rectangle(0, 0, 0, 0);
    }

    public void basicDisplayBox(Point point, Point point2) {
    }

    public synchronized void lock() {
        Thread thread = Thread.currentThread();
        if (this.fDrawingLockHolder == thread) {
            return;
        }
        while (this.fDrawingLockHolder != null) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        this.fDrawingLockHolder = thread;
    }

    public synchronized void unlock() {
        if (this.fDrawingLockHolder != null) {
            this.fDrawingLockHolder = null;
            this.notify();
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        objectInputStream.defaultReadObject();
        this.fListeners = CollectionsFactory.current().createList(2);
    }

    public String getTitle() {
        return this.myTitle;
    }

    public void setTitle(String string) {
        this.myTitle = string;
    }
}

