/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.jclasslib.io;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipFile;
import org.gjt.jclasslib.structures.ClassFile;
import org.gjt.jclasslib.structures.InvalidByteCodeException;

public class ClassFileReader {
    private ClassFileReader() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ClassFile readFromClassPath(String[] stringArray, String string, String string2) throws InvalidByteCodeException, IOException {
        String string3 = string.replace('.', File.separatorChar) + (string.length() == 0 ? "" : File.separator) + string2 + ".class";
        String string4 = string3.replace(File.separatorChar, '/');
        for (int i = 0; i < stringArray.length; ++i) {
            Object object;
            File file = new File(stringArray[i]);
            if (!file.exists()) continue;
            if (file.isDirectory()) {
                object = new File(file, string3);
                if (!((File)object).exists()) continue;
                return ClassFileReader.readFromFile((File)object);
            }
            if (!file.isFile()) continue;
            object = new JarFile(file);
            try {
                JarEntry jarEntry = ((JarFile)object).getJarEntry(string4);
                if (jarEntry == null) continue;
                ClassFile classFile = ClassFileReader.readFromInputStream(((JarFile)object).getInputStream(jarEntry));
                return classFile;
            }
            finally {
                ((ZipFile)object).close();
            }
        }
        return null;
    }

    public static ClassFile readFromFile(File file) throws InvalidByteCodeException, IOException {
        return ClassFileReader.readFromInputStream(new FileInputStream(file));
    }

    public static ClassFile readFromInputStream(InputStream inputStream) throws InvalidByteCodeException, IOException {
        DataInputStream dataInputStream = new DataInputStream(new BufferedInputStream(inputStream));
        ClassFile classFile = new ClassFile();
        classFile.read(dataInputStream);
        dataInputStream.close();
        return classFile;
    }

    public static void main(String[] stringArray) throws Exception {
        int n;
        File file = new File(stringArray[0]);
        ClassFile classFile = ClassFileReader.readFromFile(file);
        long l = System.currentTimeMillis();
        for (n = 0; n < 500; ++n) {
            classFile = ClassFileReader.readFromFile(file);
        }
        long l2 = System.currentTimeMillis();
        System.out.println("With attributes:");
        System.out.print(l2 - l);
        System.out.println(" ms");
        System.setProperty("jclasslib.io.skipAttributes", "true");
        l = System.currentTimeMillis();
        for (n = 0; n < 500; ++n) {
            classFile = ClassFileReader.readFromFile(file);
        }
        l2 = System.currentTimeMillis();
        System.out.println("Without attributes:");
        System.out.print(l2 - l);
        System.out.println(" ms");
    }
}

