// Code generated by protoc-gen-gogo.
// source: internal/protocol/sql.proto
// DO NOT EDIT!

/*
	Package protocol is a generated protocol buffer package.

	It is generated from these files:
		internal/protocol/sql.proto

	It has these top-level messages:
		Request
		RequestOpen
		RequestPrepare
		RequestExec
		RequestQuery
		RequestNext
		RequestColumnTypeScanType
		RequestColumnTypeDatabaseTypeName
		RequestRowsClose
		RequestStmtClose
		RequestBegin
		RequestCommit
		RequestRollback
		RequestClose
		RequestConnExec
		Response
		ResponseOpen
		ResponsePrepare
		ResponseExec
		ResponseQuery
		ResponseNext
		ResponseColumnTypeScanType
		ResponseColumnTypeDatabaseTypeName
		ResponseRowsClose
		ResponseStmtClose
		ResponseBegin
		ResponseCommit
		ResponseRollback
		ResponseClose
		ResponseSQLiteError
		Value
		ValueInt64
		ValueFloat64
		ValueBool
		ValueBytes
		ValueString
		ValueTime
		ValueNull
*/
package protocol

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"

import (
	context "golang.org/x/net/context"
	grpc "google.golang.org/grpc"
)

import io "io"

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion2 // please upgrade the proto package

// RequestCode is a numberic code identifying the SQL gRPC request to
// handle.
type RequestCode int32

const (
	RequestCode_OPEN                           RequestCode = 0
	RequestCode_PREPARE                        RequestCode = 1
	RequestCode_EXEC                           RequestCode = 2
	RequestCode_QUERY                          RequestCode = 3
	RequestCode_NEXT                           RequestCode = 4
	RequestCode_ROWS_CLOSE                     RequestCode = 5
	RequestCode_COLUMN_TYPE_SCAN_TYPE          RequestCode = 6
	RequestCode_COLUMN_TYPE_DATABASE_TYPE_NAME RequestCode = 7
	RequestCode_STMT_CLOSE                     RequestCode = 8
	RequestCode_BEGIN                          RequestCode = 9
	RequestCode_COMMIT                         RequestCode = 10
	RequestCode_ROLLBACK                       RequestCode = 11
	RequestCode_CLOSE                          RequestCode = 12
	RequestCode_CONN_EXEC                      RequestCode = 13
	// XXX error codes should be part of a separate ResponseCode enum.
	RequestCode_SQLITE_ERROR RequestCode = 14
)

var RequestCode_name = map[int32]string{
	0:  "OPEN",
	1:  "PREPARE",
	2:  "EXEC",
	3:  "QUERY",
	4:  "NEXT",
	5:  "ROWS_CLOSE",
	6:  "COLUMN_TYPE_SCAN_TYPE",
	7:  "COLUMN_TYPE_DATABASE_TYPE_NAME",
	8:  "STMT_CLOSE",
	9:  "BEGIN",
	10: "COMMIT",
	11: "ROLLBACK",
	12: "CLOSE",
	13: "CONN_EXEC",
	14: "SQLITE_ERROR",
}
var RequestCode_value = map[string]int32{
	"OPEN":                           0,
	"PREPARE":                        1,
	"EXEC":                           2,
	"QUERY":                          3,
	"NEXT":                           4,
	"ROWS_CLOSE":                     5,
	"COLUMN_TYPE_SCAN_TYPE":          6,
	"COLUMN_TYPE_DATABASE_TYPE_NAME": 7,
	"STMT_CLOSE":                     8,
	"BEGIN":                          9,
	"COMMIT":                         10,
	"ROLLBACK":                       11,
	"CLOSE":                          12,
	"CONN_EXEC":                      13,
	"SQLITE_ERROR":                   14,
}

func (x RequestCode) String() string {
	return proto.EnumName(RequestCode_name, int32(x))
}
func (RequestCode) EnumDescriptor() ([]byte, []int) { return fileDescriptorSql, []int{0} }

// ValueCode is a numberic code identifying the Go type of a value.
//
// It supports all types that should be handle by driver.Value in database/sql/driver.
type ValueCode int32

const (
	ValueCode_INT64   ValueCode = 0
	ValueCode_FLOAT64 ValueCode = 1
	ValueCode_BOOL    ValueCode = 2
	ValueCode_BYTES   ValueCode = 3
	ValueCode_STRING  ValueCode = 4
	ValueCode_TIME    ValueCode = 5
	ValueCode_NULL    ValueCode = 6
)

var ValueCode_name = map[int32]string{
	0: "INT64",
	1: "FLOAT64",
	2: "BOOL",
	3: "BYTES",
	4: "STRING",
	5: "TIME",
	6: "NULL",
}
var ValueCode_value = map[string]int32{
	"INT64":   0,
	"FLOAT64": 1,
	"BOOL":    2,
	"BYTES":   3,
	"STRING":  4,
	"TIME":    5,
	"NULL":    6,
}

func (x ValueCode) String() string {
	return proto.EnumName(ValueCode_name, int32(x))
}
func (ValueCode) EnumDescriptor() ([]byte, []int) { return fileDescriptorSql, []int{1} }

// A single request targeted to a certain SQL connection.
type Request struct {
	Code RequestCode `protobuf:"varint,1,opt,name=code,proto3,enum=protocol.RequestCode" json:"code,omitempty"`
	Data []byte      `protobuf:"bytes,2,opt,name=data,proto3" json:"data,omitempty"`
}

func (m *Request) Reset()                    { *m = Request{} }
func (m *Request) String() string            { return proto.CompactTextString(m) }
func (*Request) ProtoMessage()               {}
func (*Request) Descriptor() ([]byte, []int) { return fileDescriptorSql, []int{0} }

func (m *Request) GetCode() RequestCode {
	if m != nil {
		return m.Code
	}
	return RequestCode_OPEN
}

func (m *Request) GetData() []byte {
	if m != nil {
		return m.Data
	}
	return nil
}

type RequestOpen struct {
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (m *RequestOpen) Reset()                    { *m = RequestOpen{} }
func (m *RequestOpen) String() string            { return proto.CompactTextString(m) }
func (*RequestOpen) ProtoMessage()               {}
func (*RequestOpen) Descriptor() ([]byte, []int) { return fileDescriptorSql, []int{1} }

func (m *RequestOpen) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

type RequestPrepare struct {
	Query string `protobuf:"bytes,1,opt,name=query,proto3" json:"query,omitempty"`
}

func (m *RequestPrepare) Reset()                    { *m = RequestPrepare{} }
func (m *RequestPrepare) String() string            { return proto.CompactTextString(m) }
func (*RequestPrepare) ProtoMessage()               {}
func (*RequestPrepare) Descriptor() ([]byte, []int) { return fileDescriptorSql, []int{2} }

func (m *RequestPrepare) GetQuery() string {
	if m != nil {
		return m.Query
	}
	return ""
}

type RequestExec struct {
	Id   int64    `protobuf:"varint,1,opt,name=id,proto3" json:"id,omitempty"`
	Args []*Value `protobuf:"bytes,2,rep,name=args" json:"args,omitempty"`
}

func (m *RequestExec) Reset()                    { *m = RequestExec{} }
func (m *RequestExec) String() string            { return proto.CompactTextString(m) }
func (*RequestExec) ProtoMessage()               {}
func (*RequestExec) Descriptor() ([]byte, []int) { return fileDescriptorSql, []int{3} }

func (m *RequestExec) GetId() int64 {
	if m != nil {
		return m.Id
	}
	return 0
}

func (m *RequestExec) GetArgs() []*Value {
	if m != nil {
		return m.Args
	}
	return nil
}

type RequestQuery struct {
	Id   int64    `protobuf:"varint,1,opt,name=id,proto3" json:"id,omitempty"`
	Args []*Value `protobuf:"bytes,2,rep,name=args" json:"args,omitempty"`
}

func (m *RequestQuery) Reset()                    { *m = RequestQuery{} }
func (m *RequestQuery) String() string            { return proto.CompactTextString(m) }
func (*RequestQuery) ProtoMessage()               {}
func (*RequestQuery) Descriptor() ([]byte, []int) { return fileDescriptorSql, []int{4} }

func (m *RequestQuery) GetId() int64 {
	if m != nil {
		return m.Id
	}
	return 0
}

func (m *RequestQuery) GetArgs() []*Value {
	if m != nil {
		return m.Args
	}
	return nil
}

type RequestNext struct {
	Id  int64 `protobuf:"varint,1,opt,name=id,proto3" json:"id,omitempty"`
	Len int64 `protobuf:"varint,2,opt,name=len,proto3" json:"len,omitempty"`
}

func (m *RequestNext) Reset()                    { *m = RequestNext{} }
func (m *RequestNext) String() string            { return proto.CompactTextString(m) }
func (*RequestNext) ProtoMessage()               {}
func (*RequestNext) Descriptor() ([]byte, []int) { return fileDescriptorSql, []int{5} }

func (m *RequestNext) GetId() int64 {
	if m != nil {
		return m.Id
	}
	return 0
}

func (m *RequestNext) GetLen() int64 {
	if m != nil {
		return m.Len
	}
	return 0
}

type RequestColumnTypeScanType struct {
	Id     int64 `protobuf:"varint,1,opt,name=id,proto3" json:"id,omitempty"`
	Column int64 `protobuf:"varint,2,opt,name=column,proto3" json:"column,omitempty"`
}

func (m *RequestColumnTypeScanType) Reset()                    { *m = RequestColumnTypeScanType{} }
func (m *RequestColumnTypeScanType) String() string            { return proto.CompactTextString(m) }
func (*RequestColumnTypeScanType) ProtoMessage()               {}
func (*RequestColumnTypeScanType) Descriptor() ([]byte, []int) { return fileDescriptorSql, []int{6} }

func (m *RequestColumnTypeScanType) GetId() int64 {
	if m != nil {
		return m.Id
	}
	return 0
}

func (m *RequestColumnTypeScanType) GetColumn() int64 {
	if m != nil {
		return m.Column
	}
	return 0
}

type RequestColumnTypeDatabaseTypeName struct {
	Id     int64 `protobuf:"varint,1,opt,name=id,proto3" json:"id,omitempty"`
	Column int64 `protobuf:"varint,2,opt,name=column,proto3" json:"column,omitempty"`
}

func (m *RequestColumnTypeDatabaseTypeName) Reset()         { *m = RequestColumnTypeDatabaseTypeName{} }
func (m *RequestColumnTypeDatabaseTypeName) String() string { return proto.CompactTextString(m) }
func (*RequestColumnTypeDatabaseTypeName) ProtoMessage()    {}
func (*RequestColumnTypeDatabaseTypeName) Descriptor() ([]byte, []int) {
	return fileDescriptorSql, []int{7}
}

func (m *RequestColumnTypeDatabaseTypeName) GetId() int64 {
	if m != nil {
		return m.Id
	}
	return 0
}

func (m *RequestColumnTypeDatabaseTypeName) GetColumn() int64 {
	if m != nil {
		return m.Column
	}
	return 0
}

type RequestRowsClose struct {
	Id int64 `protobuf:"varint,1,opt,name=id,proto3" json:"id,omitempty"`
}

func (m *RequestRowsClose) Reset()                    { *m = RequestRowsClose{} }
func (m *RequestRowsClose) String() string            { return proto.CompactTextString(m) }
func (*RequestRowsClose) ProtoMessage()               {}
func (*RequestRowsClose) Descriptor() ([]byte, []int) { return fileDescriptorSql, []int{8} }

func (m *RequestRowsClose) GetId() int64 {
	if m != nil {
		return m.Id
	}
	return 0
}

type RequestStmtClose struct {
	Id int64 `protobuf:"varint,1,opt,name=id,proto3" json:"id,omitempty"`
}

func (m *RequestStmtClose) Reset()                    { *m = RequestStmtClose{} }
func (m *RequestStmtClose) String() string            { return proto.CompactTextString(m) }
func (*RequestStmtClose) ProtoMessage()               {}
func (*RequestStmtClose) Descriptor() ([]byte, []int) { return fileDescriptorSql, []int{9} }

func (m *RequestStmtClose) GetId() int64 {
	if m != nil {
		return m.Id
	}
	return 0
}

type RequestBegin struct {
}

func (m *RequestBegin) Reset()                    { *m = RequestBegin{} }
func (m *RequestBegin) String() string            { return proto.CompactTextString(m) }
func (*RequestBegin) ProtoMessage()               {}
func (*RequestBegin) Descriptor() ([]byte, []int) { return fileDescriptorSql, []int{10} }

type RequestCommit struct {
	Id int64 `protobuf:"varint,1,opt,name=id,proto3" json:"id,omitempty"`
}

func (m *RequestCommit) Reset()                    { *m = RequestCommit{} }
func (m *RequestCommit) String() string            { return proto.CompactTextString(m) }
func (*RequestCommit) ProtoMessage()               {}
func (*RequestCommit) Descriptor() ([]byte, []int) { return fileDescriptorSql, []int{11} }

func (m *RequestCommit) GetId() int64 {
	if m != nil {
		return m.Id
	}
	return 0
}

type RequestRollback struct {
	Id int64 `protobuf:"varint,1,opt,name=id,proto3" json:"id,omitempty"`
}

func (m *RequestRollback) Reset()                    { *m = RequestRollback{} }
func (m *RequestRollback) String() string            { return proto.CompactTextString(m) }
func (*RequestRollback) ProtoMessage()               {}
func (*RequestRollback) Descriptor() ([]byte, []int) { return fileDescriptorSql, []int{12} }

func (m *RequestRollback) GetId() int64 {
	if m != nil {
		return m.Id
	}
	return 0
}

type RequestClose struct {
}

func (m *RequestClose) Reset()                    { *m = RequestClose{} }
func (m *RequestClose) String() string            { return proto.CompactTextString(m) }
func (*RequestClose) ProtoMessage()               {}
func (*RequestClose) Descriptor() ([]byte, []int) { return fileDescriptorSql, []int{13} }

type RequestConnExec struct {
	Query string   `protobuf:"bytes,1,opt,name=query,proto3" json:"query,omitempty"`
	Args  []*Value `protobuf:"bytes,2,rep,name=args" json:"args,omitempty"`
}

func (m *RequestConnExec) Reset()                    { *m = RequestConnExec{} }
func (m *RequestConnExec) String() string            { return proto.CompactTextString(m) }
func (*RequestConnExec) ProtoMessage()               {}
func (*RequestConnExec) Descriptor() ([]byte, []int) { return fileDescriptorSql, []int{14} }

func (m *RequestConnExec) GetQuery() string {
	if m != nil {
		return m.Query
	}
	return ""
}

func (m *RequestConnExec) GetArgs() []*Value {
	if m != nil {
		return m.Args
	}
	return nil
}

// A single response to a request.
type Response struct {
	Code RequestCode `protobuf:"varint,1,opt,name=code,proto3,enum=protocol.RequestCode" json:"code,omitempty"`
	Data []byte      `protobuf:"bytes,2,opt,name=data,proto3" json:"data,omitempty"`
}

func (m *Response) Reset()                    { *m = Response{} }
func (m *Response) String() string            { return proto.CompactTextString(m) }
func (*Response) ProtoMessage()               {}
func (*Response) Descriptor() ([]byte, []int) { return fileDescriptorSql, []int{15} }

func (m *Response) GetCode() RequestCode {
	if m != nil {
		return m.Code
	}
	return RequestCode_OPEN
}

func (m *Response) GetData() []byte {
	if m != nil {
		return m.Data
	}
	return nil
}

type ResponseOpen struct {
}

func (m *ResponseOpen) Reset()                    { *m = ResponseOpen{} }
func (m *ResponseOpen) String() string            { return proto.CompactTextString(m) }
func (*ResponseOpen) ProtoMessage()               {}
func (*ResponseOpen) Descriptor() ([]byte, []int) { return fileDescriptorSql, []int{16} }

type ResponsePrepare struct {
	Id       int64 `protobuf:"varint,1,opt,name=id,proto3" json:"id,omitempty"`
	NumInput int64 `protobuf:"varint,2,opt,name=numInput,proto3" json:"numInput,omitempty"`
}

func (m *ResponsePrepare) Reset()                    { *m = ResponsePrepare{} }
func (m *ResponsePrepare) String() string            { return proto.CompactTextString(m) }
func (*ResponsePrepare) ProtoMessage()               {}
func (*ResponsePrepare) Descriptor() ([]byte, []int) { return fileDescriptorSql, []int{17} }

func (m *ResponsePrepare) GetId() int64 {
	if m != nil {
		return m.Id
	}
	return 0
}

func (m *ResponsePrepare) GetNumInput() int64 {
	if m != nil {
		return m.NumInput
	}
	return 0
}

type ResponseExec struct {
	LastInsertId int64 `protobuf:"varint,1,opt,name=LastInsertId,json=lastInsertId,proto3" json:"LastInsertId,omitempty"`
	RowsAffected int64 `protobuf:"varint,2,opt,name=RowsAffected,json=rowsAffected,proto3" json:"RowsAffected,omitempty"`
}

func (m *ResponseExec) Reset()                    { *m = ResponseExec{} }
func (m *ResponseExec) String() string            { return proto.CompactTextString(m) }
func (*ResponseExec) ProtoMessage()               {}
func (*ResponseExec) Descriptor() ([]byte, []int) { return fileDescriptorSql, []int{18} }

func (m *ResponseExec) GetLastInsertId() int64 {
	if m != nil {
		return m.LastInsertId
	}
	return 0
}

func (m *ResponseExec) GetRowsAffected() int64 {
	if m != nil {
		return m.RowsAffected
	}
	return 0
}

type ResponseQuery struct {
	Id      int64    `protobuf:"varint,1,opt,name=id,proto3" json:"id,omitempty"`
	Columns []string `protobuf:"bytes,2,rep,name=columns" json:"columns,omitempty"`
}

func (m *ResponseQuery) Reset()                    { *m = ResponseQuery{} }
func (m *ResponseQuery) String() string            { return proto.CompactTextString(m) }
func (*ResponseQuery) ProtoMessage()               {}
func (*ResponseQuery) Descriptor() ([]byte, []int) { return fileDescriptorSql, []int{19} }

func (m *ResponseQuery) GetId() int64 {
	if m != nil {
		return m.Id
	}
	return 0
}

func (m *ResponseQuery) GetColumns() []string {
	if m != nil {
		return m.Columns
	}
	return nil
}

type ResponseNext struct {
	Eof    bool     `protobuf:"varint,1,opt,name=eof,proto3" json:"eof,omitempty"`
	Values []*Value `protobuf:"bytes,2,rep,name=values" json:"values,omitempty"`
}

func (m *ResponseNext) Reset()                    { *m = ResponseNext{} }
func (m *ResponseNext) String() string            { return proto.CompactTextString(m) }
func (*ResponseNext) ProtoMessage()               {}
func (*ResponseNext) Descriptor() ([]byte, []int) { return fileDescriptorSql, []int{20} }

func (m *ResponseNext) GetEof() bool {
	if m != nil {
		return m.Eof
	}
	return false
}

func (m *ResponseNext) GetValues() []*Value {
	if m != nil {
		return m.Values
	}
	return nil
}

type ResponseColumnTypeScanType struct {
	Code ValueCode `protobuf:"varint,1,opt,name=code,proto3,enum=protocol.ValueCode" json:"code,omitempty"`
}

func (m *ResponseColumnTypeScanType) Reset()                    { *m = ResponseColumnTypeScanType{} }
func (m *ResponseColumnTypeScanType) String() string            { return proto.CompactTextString(m) }
func (*ResponseColumnTypeScanType) ProtoMessage()               {}
func (*ResponseColumnTypeScanType) Descriptor() ([]byte, []int) { return fileDescriptorSql, []int{21} }

func (m *ResponseColumnTypeScanType) GetCode() ValueCode {
	if m != nil {
		return m.Code
	}
	return ValueCode_INT64
}

type ResponseColumnTypeDatabaseTypeName struct {
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (m *ResponseColumnTypeDatabaseTypeName) Reset()         { *m = ResponseColumnTypeDatabaseTypeName{} }
func (m *ResponseColumnTypeDatabaseTypeName) String() string { return proto.CompactTextString(m) }
func (*ResponseColumnTypeDatabaseTypeName) ProtoMessage()    {}
func (*ResponseColumnTypeDatabaseTypeName) Descriptor() ([]byte, []int) {
	return fileDescriptorSql, []int{22}
}

func (m *ResponseColumnTypeDatabaseTypeName) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

type ResponseRowsClose struct {
}

func (m *ResponseRowsClose) Reset()                    { *m = ResponseRowsClose{} }
func (m *ResponseRowsClose) String() string            { return proto.CompactTextString(m) }
func (*ResponseRowsClose) ProtoMessage()               {}
func (*ResponseRowsClose) Descriptor() ([]byte, []int) { return fileDescriptorSql, []int{23} }

type ResponseStmtClose struct {
}

func (m *ResponseStmtClose) Reset()                    { *m = ResponseStmtClose{} }
func (m *ResponseStmtClose) String() string            { return proto.CompactTextString(m) }
func (*ResponseStmtClose) ProtoMessage()               {}
func (*ResponseStmtClose) Descriptor() ([]byte, []int) { return fileDescriptorSql, []int{24} }

type ResponseBegin struct {
	Id int64 `protobuf:"varint,1,opt,name=id,proto3" json:"id,omitempty"`
}

func (m *ResponseBegin) Reset()                    { *m = ResponseBegin{} }
func (m *ResponseBegin) String() string            { return proto.CompactTextString(m) }
func (*ResponseBegin) ProtoMessage()               {}
func (*ResponseBegin) Descriptor() ([]byte, []int) { return fileDescriptorSql, []int{25} }

func (m *ResponseBegin) GetId() int64 {
	if m != nil {
		return m.Id
	}
	return 0
}

type ResponseCommit struct {
}

func (m *ResponseCommit) Reset()                    { *m = ResponseCommit{} }
func (m *ResponseCommit) String() string            { return proto.CompactTextString(m) }
func (*ResponseCommit) ProtoMessage()               {}
func (*ResponseCommit) Descriptor() ([]byte, []int) { return fileDescriptorSql, []int{26} }

type ResponseRollback struct {
}

func (m *ResponseRollback) Reset()                    { *m = ResponseRollback{} }
func (m *ResponseRollback) String() string            { return proto.CompactTextString(m) }
func (*ResponseRollback) ProtoMessage()               {}
func (*ResponseRollback) Descriptor() ([]byte, []int) { return fileDescriptorSql, []int{27} }

type ResponseClose struct {
}

func (m *ResponseClose) Reset()                    { *m = ResponseClose{} }
func (m *ResponseClose) String() string            { return proto.CompactTextString(m) }
func (*ResponseClose) ProtoMessage()               {}
func (*ResponseClose) Descriptor() ([]byte, []int) { return fileDescriptorSql, []int{28} }

type ResponseSQLiteError struct {
	Code         int32  `protobuf:"varint,1,opt,name=code,proto3" json:"code,omitempty"`
	ExtendedCode int32  `protobuf:"varint,2,opt,name=extended_code,json=extendedCode,proto3" json:"extended_code,omitempty"`
	Err          string `protobuf:"bytes,3,opt,name=err,proto3" json:"err,omitempty"`
}

func (m *ResponseSQLiteError) Reset()                    { *m = ResponseSQLiteError{} }
func (m *ResponseSQLiteError) String() string            { return proto.CompactTextString(m) }
func (*ResponseSQLiteError) ProtoMessage()               {}
func (*ResponseSQLiteError) Descriptor() ([]byte, []int) { return fileDescriptorSql, []int{29} }

func (m *ResponseSQLiteError) GetCode() int32 {
	if m != nil {
		return m.Code
	}
	return 0
}

func (m *ResponseSQLiteError) GetExtendedCode() int32 {
	if m != nil {
		return m.ExtendedCode
	}
	return 0
}

func (m *ResponseSQLiteError) GetErr() string {
	if m != nil {
		return m.Err
	}
	return ""
}

// Value of a single statement argument or row column.
type Value struct {
	Code ValueCode `protobuf:"varint,1,opt,name=code,proto3,enum=protocol.ValueCode" json:"code,omitempty"`
	Data []byte    `protobuf:"bytes,2,opt,name=data,proto3" json:"data,omitempty"`
}

func (m *Value) Reset()                    { *m = Value{} }
func (m *Value) String() string            { return proto.CompactTextString(m) }
func (*Value) ProtoMessage()               {}
func (*Value) Descriptor() ([]byte, []int) { return fileDescriptorSql, []int{30} }

func (m *Value) GetCode() ValueCode {
	if m != nil {
		return m.Code
	}
	return ValueCode_INT64
}

func (m *Value) GetData() []byte {
	if m != nil {
		return m.Data
	}
	return nil
}

type ValueInt64 struct {
	Value int64 `protobuf:"varint,1,opt,name=value,proto3" json:"value,omitempty"`
}

func (m *ValueInt64) Reset()                    { *m = ValueInt64{} }
func (m *ValueInt64) String() string            { return proto.CompactTextString(m) }
func (*ValueInt64) ProtoMessage()               {}
func (*ValueInt64) Descriptor() ([]byte, []int) { return fileDescriptorSql, []int{31} }

func (m *ValueInt64) GetValue() int64 {
	if m != nil {
		return m.Value
	}
	return 0
}

type ValueFloat64 struct {
	Value float64 `protobuf:"fixed64,1,opt,name=value,proto3" json:"value,omitempty"`
}

func (m *ValueFloat64) Reset()                    { *m = ValueFloat64{} }
func (m *ValueFloat64) String() string            { return proto.CompactTextString(m) }
func (*ValueFloat64) ProtoMessage()               {}
func (*ValueFloat64) Descriptor() ([]byte, []int) { return fileDescriptorSql, []int{32} }

func (m *ValueFloat64) GetValue() float64 {
	if m != nil {
		return m.Value
	}
	return 0
}

type ValueBool struct {
	Value bool `protobuf:"varint,1,opt,name=value,proto3" json:"value,omitempty"`
}

func (m *ValueBool) Reset()                    { *m = ValueBool{} }
func (m *ValueBool) String() string            { return proto.CompactTextString(m) }
func (*ValueBool) ProtoMessage()               {}
func (*ValueBool) Descriptor() ([]byte, []int) { return fileDescriptorSql, []int{33} }

func (m *ValueBool) GetValue() bool {
	if m != nil {
		return m.Value
	}
	return false
}

type ValueBytes struct {
	Value []byte `protobuf:"bytes,1,opt,name=value,proto3" json:"value,omitempty"`
}

func (m *ValueBytes) Reset()                    { *m = ValueBytes{} }
func (m *ValueBytes) String() string            { return proto.CompactTextString(m) }
func (*ValueBytes) ProtoMessage()               {}
func (*ValueBytes) Descriptor() ([]byte, []int) { return fileDescriptorSql, []int{34} }

func (m *ValueBytes) GetValue() []byte {
	if m != nil {
		return m.Value
	}
	return nil
}

type ValueString struct {
	Value string `protobuf:"bytes,1,opt,name=value,proto3" json:"value,omitempty"`
}

func (m *ValueString) Reset()                    { *m = ValueString{} }
func (m *ValueString) String() string            { return proto.CompactTextString(m) }
func (*ValueString) ProtoMessage()               {}
func (*ValueString) Descriptor() ([]byte, []int) { return fileDescriptorSql, []int{35} }

func (m *ValueString) GetValue() string {
	if m != nil {
		return m.Value
	}
	return ""
}

type ValueTime struct {
	Value int64 `protobuf:"varint,1,opt,name=value,proto3" json:"value,omitempty"`
}

func (m *ValueTime) Reset()                    { *m = ValueTime{} }
func (m *ValueTime) String() string            { return proto.CompactTextString(m) }
func (*ValueTime) ProtoMessage()               {}
func (*ValueTime) Descriptor() ([]byte, []int) { return fileDescriptorSql, []int{36} }

func (m *ValueTime) GetValue() int64 {
	if m != nil {
		return m.Value
	}
	return 0
}

type ValueNull struct {
}

func (m *ValueNull) Reset()                    { *m = ValueNull{} }
func (m *ValueNull) String() string            { return proto.CompactTextString(m) }
func (*ValueNull) ProtoMessage()               {}
func (*ValueNull) Descriptor() ([]byte, []int) { return fileDescriptorSql, []int{37} }

func init() {
	proto.RegisterType((*Request)(nil), "protocol.Request")
	proto.RegisterType((*RequestOpen)(nil), "protocol.RequestOpen")
	proto.RegisterType((*RequestPrepare)(nil), "protocol.RequestPrepare")
	proto.RegisterType((*RequestExec)(nil), "protocol.RequestExec")
	proto.RegisterType((*RequestQuery)(nil), "protocol.RequestQuery")
	proto.RegisterType((*RequestNext)(nil), "protocol.RequestNext")
	proto.RegisterType((*RequestColumnTypeScanType)(nil), "protocol.RequestColumnTypeScanType")
	proto.RegisterType((*RequestColumnTypeDatabaseTypeName)(nil), "protocol.RequestColumnTypeDatabaseTypeName")
	proto.RegisterType((*RequestRowsClose)(nil), "protocol.RequestRowsClose")
	proto.RegisterType((*RequestStmtClose)(nil), "protocol.RequestStmtClose")
	proto.RegisterType((*RequestBegin)(nil), "protocol.RequestBegin")
	proto.RegisterType((*RequestCommit)(nil), "protocol.RequestCommit")
	proto.RegisterType((*RequestRollback)(nil), "protocol.RequestRollback")
	proto.RegisterType((*RequestClose)(nil), "protocol.RequestClose")
	proto.RegisterType((*RequestConnExec)(nil), "protocol.RequestConnExec")
	proto.RegisterType((*Response)(nil), "protocol.Response")
	proto.RegisterType((*ResponseOpen)(nil), "protocol.ResponseOpen")
	proto.RegisterType((*ResponsePrepare)(nil), "protocol.ResponsePrepare")
	proto.RegisterType((*ResponseExec)(nil), "protocol.ResponseExec")
	proto.RegisterType((*ResponseQuery)(nil), "protocol.ResponseQuery")
	proto.RegisterType((*ResponseNext)(nil), "protocol.ResponseNext")
	proto.RegisterType((*ResponseColumnTypeScanType)(nil), "protocol.ResponseColumnTypeScanType")
	proto.RegisterType((*ResponseColumnTypeDatabaseTypeName)(nil), "protocol.ResponseColumnTypeDatabaseTypeName")
	proto.RegisterType((*ResponseRowsClose)(nil), "protocol.ResponseRowsClose")
	proto.RegisterType((*ResponseStmtClose)(nil), "protocol.ResponseStmtClose")
	proto.RegisterType((*ResponseBegin)(nil), "protocol.ResponseBegin")
	proto.RegisterType((*ResponseCommit)(nil), "protocol.ResponseCommit")
	proto.RegisterType((*ResponseRollback)(nil), "protocol.ResponseRollback")
	proto.RegisterType((*ResponseClose)(nil), "protocol.ResponseClose")
	proto.RegisterType((*ResponseSQLiteError)(nil), "protocol.ResponseSQLiteError")
	proto.RegisterType((*Value)(nil), "protocol.Value")
	proto.RegisterType((*ValueInt64)(nil), "protocol.ValueInt64")
	proto.RegisterType((*ValueFloat64)(nil), "protocol.ValueFloat64")
	proto.RegisterType((*ValueBool)(nil), "protocol.ValueBool")
	proto.RegisterType((*ValueBytes)(nil), "protocol.ValueBytes")
	proto.RegisterType((*ValueString)(nil), "protocol.ValueString")
	proto.RegisterType((*ValueTime)(nil), "protocol.ValueTime")
	proto.RegisterType((*ValueNull)(nil), "protocol.ValueNull")
	proto.RegisterEnum("protocol.RequestCode", RequestCode_name, RequestCode_value)
	proto.RegisterEnum("protocol.ValueCode", ValueCode_name, ValueCode_value)
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// Client API for SQL service

type SQLClient interface {
	Conn(ctx context.Context, opts ...grpc.CallOption) (SQL_ConnClient, error)
}

type sQLClient struct {
	cc *grpc.ClientConn
}

func NewSQLClient(cc *grpc.ClientConn) SQLClient {
	return &sQLClient{cc}
}

func (c *sQLClient) Conn(ctx context.Context, opts ...grpc.CallOption) (SQL_ConnClient, error) {
	stream, err := grpc.NewClientStream(ctx, &_SQL_serviceDesc.Streams[0], c.cc, "/protocol.SQL/Conn", opts...)
	if err != nil {
		return nil, err
	}
	x := &sQLConnClient{stream}
	return x, nil
}

type SQL_ConnClient interface {
	Send(*Request) error
	Recv() (*Response, error)
	grpc.ClientStream
}

type sQLConnClient struct {
	grpc.ClientStream
}

func (x *sQLConnClient) Send(m *Request) error {
	return x.ClientStream.SendMsg(m)
}

func (x *sQLConnClient) Recv() (*Response, error) {
	m := new(Response)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

// Server API for SQL service

type SQLServer interface {
	Conn(SQL_ConnServer) error
}

func RegisterSQLServer(s *grpc.Server, srv SQLServer) {
	s.RegisterService(&_SQL_serviceDesc, srv)
}

func _SQL_Conn_Handler(srv interface{}, stream grpc.ServerStream) error {
	return srv.(SQLServer).Conn(&sQLConnServer{stream})
}

type SQL_ConnServer interface {
	Send(*Response) error
	Recv() (*Request, error)
	grpc.ServerStream
}

type sQLConnServer struct {
	grpc.ServerStream
}

func (x *sQLConnServer) Send(m *Response) error {
	return x.ServerStream.SendMsg(m)
}

func (x *sQLConnServer) Recv() (*Request, error) {
	m := new(Request)
	if err := x.ServerStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

var _SQL_serviceDesc = grpc.ServiceDesc{
	ServiceName: "protocol.SQL",
	HandlerType: (*SQLServer)(nil),
	Methods:     []grpc.MethodDesc{},
	Streams: []grpc.StreamDesc{
		{
			StreamName:    "Conn",
			Handler:       _SQL_Conn_Handler,
			ServerStreams: true,
			ClientStreams: true,
		},
	},
	Metadata: "internal/protocol/sql.proto",
}

func (m *Request) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Request) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Code != 0 {
		dAtA[i] = 0x8
		i++
		i = encodeVarintSql(dAtA, i, uint64(m.Code))
	}
	if len(m.Data) > 0 {
		dAtA[i] = 0x12
		i++
		i = encodeVarintSql(dAtA, i, uint64(len(m.Data)))
		i += copy(dAtA[i:], m.Data)
	}
	return i, nil
}

func (m *RequestOpen) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *RequestOpen) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Name) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintSql(dAtA, i, uint64(len(m.Name)))
		i += copy(dAtA[i:], m.Name)
	}
	return i, nil
}

func (m *RequestPrepare) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *RequestPrepare) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Query) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintSql(dAtA, i, uint64(len(m.Query)))
		i += copy(dAtA[i:], m.Query)
	}
	return i, nil
}

func (m *RequestExec) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *RequestExec) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Id != 0 {
		dAtA[i] = 0x8
		i++
		i = encodeVarintSql(dAtA, i, uint64(m.Id))
	}
	if len(m.Args) > 0 {
		for _, msg := range m.Args {
			dAtA[i] = 0x12
			i++
			i = encodeVarintSql(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	return i, nil
}

func (m *RequestQuery) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *RequestQuery) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Id != 0 {
		dAtA[i] = 0x8
		i++
		i = encodeVarintSql(dAtA, i, uint64(m.Id))
	}
	if len(m.Args) > 0 {
		for _, msg := range m.Args {
			dAtA[i] = 0x12
			i++
			i = encodeVarintSql(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	return i, nil
}

func (m *RequestNext) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *RequestNext) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Id != 0 {
		dAtA[i] = 0x8
		i++
		i = encodeVarintSql(dAtA, i, uint64(m.Id))
	}
	if m.Len != 0 {
		dAtA[i] = 0x10
		i++
		i = encodeVarintSql(dAtA, i, uint64(m.Len))
	}
	return i, nil
}

func (m *RequestColumnTypeScanType) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *RequestColumnTypeScanType) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Id != 0 {
		dAtA[i] = 0x8
		i++
		i = encodeVarintSql(dAtA, i, uint64(m.Id))
	}
	if m.Column != 0 {
		dAtA[i] = 0x10
		i++
		i = encodeVarintSql(dAtA, i, uint64(m.Column))
	}
	return i, nil
}

func (m *RequestColumnTypeDatabaseTypeName) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *RequestColumnTypeDatabaseTypeName) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Id != 0 {
		dAtA[i] = 0x8
		i++
		i = encodeVarintSql(dAtA, i, uint64(m.Id))
	}
	if m.Column != 0 {
		dAtA[i] = 0x10
		i++
		i = encodeVarintSql(dAtA, i, uint64(m.Column))
	}
	return i, nil
}

func (m *RequestRowsClose) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *RequestRowsClose) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Id != 0 {
		dAtA[i] = 0x8
		i++
		i = encodeVarintSql(dAtA, i, uint64(m.Id))
	}
	return i, nil
}

func (m *RequestStmtClose) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *RequestStmtClose) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Id != 0 {
		dAtA[i] = 0x8
		i++
		i = encodeVarintSql(dAtA, i, uint64(m.Id))
	}
	return i, nil
}

func (m *RequestBegin) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *RequestBegin) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	return i, nil
}

func (m *RequestCommit) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *RequestCommit) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Id != 0 {
		dAtA[i] = 0x8
		i++
		i = encodeVarintSql(dAtA, i, uint64(m.Id))
	}
	return i, nil
}

func (m *RequestRollback) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *RequestRollback) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Id != 0 {
		dAtA[i] = 0x8
		i++
		i = encodeVarintSql(dAtA, i, uint64(m.Id))
	}
	return i, nil
}

func (m *RequestClose) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *RequestClose) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	return i, nil
}

func (m *RequestConnExec) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *RequestConnExec) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Query) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintSql(dAtA, i, uint64(len(m.Query)))
		i += copy(dAtA[i:], m.Query)
	}
	if len(m.Args) > 0 {
		for _, msg := range m.Args {
			dAtA[i] = 0x12
			i++
			i = encodeVarintSql(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	return i, nil
}

func (m *Response) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Response) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Code != 0 {
		dAtA[i] = 0x8
		i++
		i = encodeVarintSql(dAtA, i, uint64(m.Code))
	}
	if len(m.Data) > 0 {
		dAtA[i] = 0x12
		i++
		i = encodeVarintSql(dAtA, i, uint64(len(m.Data)))
		i += copy(dAtA[i:], m.Data)
	}
	return i, nil
}

func (m *ResponseOpen) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ResponseOpen) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	return i, nil
}

func (m *ResponsePrepare) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ResponsePrepare) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Id != 0 {
		dAtA[i] = 0x8
		i++
		i = encodeVarintSql(dAtA, i, uint64(m.Id))
	}
	if m.NumInput != 0 {
		dAtA[i] = 0x10
		i++
		i = encodeVarintSql(dAtA, i, uint64(m.NumInput))
	}
	return i, nil
}

func (m *ResponseExec) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ResponseExec) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.LastInsertId != 0 {
		dAtA[i] = 0x8
		i++
		i = encodeVarintSql(dAtA, i, uint64(m.LastInsertId))
	}
	if m.RowsAffected != 0 {
		dAtA[i] = 0x10
		i++
		i = encodeVarintSql(dAtA, i, uint64(m.RowsAffected))
	}
	return i, nil
}

func (m *ResponseQuery) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ResponseQuery) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Id != 0 {
		dAtA[i] = 0x8
		i++
		i = encodeVarintSql(dAtA, i, uint64(m.Id))
	}
	if len(m.Columns) > 0 {
		for _, s := range m.Columns {
			dAtA[i] = 0x12
			i++
			l = len(s)
			for l >= 1<<7 {
				dAtA[i] = uint8(uint64(l)&0x7f | 0x80)
				l >>= 7
				i++
			}
			dAtA[i] = uint8(l)
			i++
			i += copy(dAtA[i:], s)
		}
	}
	return i, nil
}

func (m *ResponseNext) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ResponseNext) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Eof {
		dAtA[i] = 0x8
		i++
		if m.Eof {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	if len(m.Values) > 0 {
		for _, msg := range m.Values {
			dAtA[i] = 0x12
			i++
			i = encodeVarintSql(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	return i, nil
}

func (m *ResponseColumnTypeScanType) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ResponseColumnTypeScanType) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Code != 0 {
		dAtA[i] = 0x8
		i++
		i = encodeVarintSql(dAtA, i, uint64(m.Code))
	}
	return i, nil
}

func (m *ResponseColumnTypeDatabaseTypeName) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ResponseColumnTypeDatabaseTypeName) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Name) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintSql(dAtA, i, uint64(len(m.Name)))
		i += copy(dAtA[i:], m.Name)
	}
	return i, nil
}

func (m *ResponseRowsClose) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ResponseRowsClose) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	return i, nil
}

func (m *ResponseStmtClose) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ResponseStmtClose) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	return i, nil
}

func (m *ResponseBegin) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ResponseBegin) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Id != 0 {
		dAtA[i] = 0x8
		i++
		i = encodeVarintSql(dAtA, i, uint64(m.Id))
	}
	return i, nil
}

func (m *ResponseCommit) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ResponseCommit) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	return i, nil
}

func (m *ResponseRollback) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ResponseRollback) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	return i, nil
}

func (m *ResponseClose) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ResponseClose) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	return i, nil
}

func (m *ResponseSQLiteError) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ResponseSQLiteError) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Code != 0 {
		dAtA[i] = 0x8
		i++
		i = encodeVarintSql(dAtA, i, uint64(m.Code))
	}
	if m.ExtendedCode != 0 {
		dAtA[i] = 0x10
		i++
		i = encodeVarintSql(dAtA, i, uint64(m.ExtendedCode))
	}
	if len(m.Err) > 0 {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintSql(dAtA, i, uint64(len(m.Err)))
		i += copy(dAtA[i:], m.Err)
	}
	return i, nil
}

func (m *Value) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Value) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Code != 0 {
		dAtA[i] = 0x8
		i++
		i = encodeVarintSql(dAtA, i, uint64(m.Code))
	}
	if len(m.Data) > 0 {
		dAtA[i] = 0x12
		i++
		i = encodeVarintSql(dAtA, i, uint64(len(m.Data)))
		i += copy(dAtA[i:], m.Data)
	}
	return i, nil
}

func (m *ValueInt64) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ValueInt64) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Value != 0 {
		dAtA[i] = 0x8
		i++
		i = encodeVarintSql(dAtA, i, uint64(m.Value))
	}
	return i, nil
}

func (m *ValueFloat64) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ValueFloat64) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Value != 0 {
		dAtA[i] = 0x9
		i++
		i = encodeFixed64Sql(dAtA, i, uint64(math.Float64bits(float64(m.Value))))
	}
	return i, nil
}

func (m *ValueBool) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ValueBool) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Value {
		dAtA[i] = 0x8
		i++
		if m.Value {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	return i, nil
}

func (m *ValueBytes) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ValueBytes) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Value) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintSql(dAtA, i, uint64(len(m.Value)))
		i += copy(dAtA[i:], m.Value)
	}
	return i, nil
}

func (m *ValueString) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ValueString) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Value) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintSql(dAtA, i, uint64(len(m.Value)))
		i += copy(dAtA[i:], m.Value)
	}
	return i, nil
}

func (m *ValueTime) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ValueTime) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Value != 0 {
		dAtA[i] = 0x8
		i++
		i = encodeVarintSql(dAtA, i, uint64(m.Value))
	}
	return i, nil
}

func (m *ValueNull) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ValueNull) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	return i, nil
}

func encodeFixed64Sql(dAtA []byte, offset int, v uint64) int {
	dAtA[offset] = uint8(v)
	dAtA[offset+1] = uint8(v >> 8)
	dAtA[offset+2] = uint8(v >> 16)
	dAtA[offset+3] = uint8(v >> 24)
	dAtA[offset+4] = uint8(v >> 32)
	dAtA[offset+5] = uint8(v >> 40)
	dAtA[offset+6] = uint8(v >> 48)
	dAtA[offset+7] = uint8(v >> 56)
	return offset + 8
}
func encodeFixed32Sql(dAtA []byte, offset int, v uint32) int {
	dAtA[offset] = uint8(v)
	dAtA[offset+1] = uint8(v >> 8)
	dAtA[offset+2] = uint8(v >> 16)
	dAtA[offset+3] = uint8(v >> 24)
	return offset + 4
}
func encodeVarintSql(dAtA []byte, offset int, v uint64) int {
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return offset + 1
}
func (m *Request) Size() (n int) {
	var l int
	_ = l
	if m.Code != 0 {
		n += 1 + sovSql(uint64(m.Code))
	}
	l = len(m.Data)
	if l > 0 {
		n += 1 + l + sovSql(uint64(l))
	}
	return n
}

func (m *RequestOpen) Size() (n int) {
	var l int
	_ = l
	l = len(m.Name)
	if l > 0 {
		n += 1 + l + sovSql(uint64(l))
	}
	return n
}

func (m *RequestPrepare) Size() (n int) {
	var l int
	_ = l
	l = len(m.Query)
	if l > 0 {
		n += 1 + l + sovSql(uint64(l))
	}
	return n
}

func (m *RequestExec) Size() (n int) {
	var l int
	_ = l
	if m.Id != 0 {
		n += 1 + sovSql(uint64(m.Id))
	}
	if len(m.Args) > 0 {
		for _, e := range m.Args {
			l = e.Size()
			n += 1 + l + sovSql(uint64(l))
		}
	}
	return n
}

func (m *RequestQuery) Size() (n int) {
	var l int
	_ = l
	if m.Id != 0 {
		n += 1 + sovSql(uint64(m.Id))
	}
	if len(m.Args) > 0 {
		for _, e := range m.Args {
			l = e.Size()
			n += 1 + l + sovSql(uint64(l))
		}
	}
	return n
}

func (m *RequestNext) Size() (n int) {
	var l int
	_ = l
	if m.Id != 0 {
		n += 1 + sovSql(uint64(m.Id))
	}
	if m.Len != 0 {
		n += 1 + sovSql(uint64(m.Len))
	}
	return n
}

func (m *RequestColumnTypeScanType) Size() (n int) {
	var l int
	_ = l
	if m.Id != 0 {
		n += 1 + sovSql(uint64(m.Id))
	}
	if m.Column != 0 {
		n += 1 + sovSql(uint64(m.Column))
	}
	return n
}

func (m *RequestColumnTypeDatabaseTypeName) Size() (n int) {
	var l int
	_ = l
	if m.Id != 0 {
		n += 1 + sovSql(uint64(m.Id))
	}
	if m.Column != 0 {
		n += 1 + sovSql(uint64(m.Column))
	}
	return n
}

func (m *RequestRowsClose) Size() (n int) {
	var l int
	_ = l
	if m.Id != 0 {
		n += 1 + sovSql(uint64(m.Id))
	}
	return n
}

func (m *RequestStmtClose) Size() (n int) {
	var l int
	_ = l
	if m.Id != 0 {
		n += 1 + sovSql(uint64(m.Id))
	}
	return n
}

func (m *RequestBegin) Size() (n int) {
	var l int
	_ = l
	return n
}

func (m *RequestCommit) Size() (n int) {
	var l int
	_ = l
	if m.Id != 0 {
		n += 1 + sovSql(uint64(m.Id))
	}
	return n
}

func (m *RequestRollback) Size() (n int) {
	var l int
	_ = l
	if m.Id != 0 {
		n += 1 + sovSql(uint64(m.Id))
	}
	return n
}

func (m *RequestClose) Size() (n int) {
	var l int
	_ = l
	return n
}

func (m *RequestConnExec) Size() (n int) {
	var l int
	_ = l
	l = len(m.Query)
	if l > 0 {
		n += 1 + l + sovSql(uint64(l))
	}
	if len(m.Args) > 0 {
		for _, e := range m.Args {
			l = e.Size()
			n += 1 + l + sovSql(uint64(l))
		}
	}
	return n
}

func (m *Response) Size() (n int) {
	var l int
	_ = l
	if m.Code != 0 {
		n += 1 + sovSql(uint64(m.Code))
	}
	l = len(m.Data)
	if l > 0 {
		n += 1 + l + sovSql(uint64(l))
	}
	return n
}

func (m *ResponseOpen) Size() (n int) {
	var l int
	_ = l
	return n
}

func (m *ResponsePrepare) Size() (n int) {
	var l int
	_ = l
	if m.Id != 0 {
		n += 1 + sovSql(uint64(m.Id))
	}
	if m.NumInput != 0 {
		n += 1 + sovSql(uint64(m.NumInput))
	}
	return n
}

func (m *ResponseExec) Size() (n int) {
	var l int
	_ = l
	if m.LastInsertId != 0 {
		n += 1 + sovSql(uint64(m.LastInsertId))
	}
	if m.RowsAffected != 0 {
		n += 1 + sovSql(uint64(m.RowsAffected))
	}
	return n
}

func (m *ResponseQuery) Size() (n int) {
	var l int
	_ = l
	if m.Id != 0 {
		n += 1 + sovSql(uint64(m.Id))
	}
	if len(m.Columns) > 0 {
		for _, s := range m.Columns {
			l = len(s)
			n += 1 + l + sovSql(uint64(l))
		}
	}
	return n
}

func (m *ResponseNext) Size() (n int) {
	var l int
	_ = l
	if m.Eof {
		n += 2
	}
	if len(m.Values) > 0 {
		for _, e := range m.Values {
			l = e.Size()
			n += 1 + l + sovSql(uint64(l))
		}
	}
	return n
}

func (m *ResponseColumnTypeScanType) Size() (n int) {
	var l int
	_ = l
	if m.Code != 0 {
		n += 1 + sovSql(uint64(m.Code))
	}
	return n
}

func (m *ResponseColumnTypeDatabaseTypeName) Size() (n int) {
	var l int
	_ = l
	l = len(m.Name)
	if l > 0 {
		n += 1 + l + sovSql(uint64(l))
	}
	return n
}

func (m *ResponseRowsClose) Size() (n int) {
	var l int
	_ = l
	return n
}

func (m *ResponseStmtClose) Size() (n int) {
	var l int
	_ = l
	return n
}

func (m *ResponseBegin) Size() (n int) {
	var l int
	_ = l
	if m.Id != 0 {
		n += 1 + sovSql(uint64(m.Id))
	}
	return n
}

func (m *ResponseCommit) Size() (n int) {
	var l int
	_ = l
	return n
}

func (m *ResponseRollback) Size() (n int) {
	var l int
	_ = l
	return n
}

func (m *ResponseClose) Size() (n int) {
	var l int
	_ = l
	return n
}

func (m *ResponseSQLiteError) Size() (n int) {
	var l int
	_ = l
	if m.Code != 0 {
		n += 1 + sovSql(uint64(m.Code))
	}
	if m.ExtendedCode != 0 {
		n += 1 + sovSql(uint64(m.ExtendedCode))
	}
	l = len(m.Err)
	if l > 0 {
		n += 1 + l + sovSql(uint64(l))
	}
	return n
}

func (m *Value) Size() (n int) {
	var l int
	_ = l
	if m.Code != 0 {
		n += 1 + sovSql(uint64(m.Code))
	}
	l = len(m.Data)
	if l > 0 {
		n += 1 + l + sovSql(uint64(l))
	}
	return n
}

func (m *ValueInt64) Size() (n int) {
	var l int
	_ = l
	if m.Value != 0 {
		n += 1 + sovSql(uint64(m.Value))
	}
	return n
}

func (m *ValueFloat64) Size() (n int) {
	var l int
	_ = l
	if m.Value != 0 {
		n += 9
	}
	return n
}

func (m *ValueBool) Size() (n int) {
	var l int
	_ = l
	if m.Value {
		n += 2
	}
	return n
}

func (m *ValueBytes) Size() (n int) {
	var l int
	_ = l
	l = len(m.Value)
	if l > 0 {
		n += 1 + l + sovSql(uint64(l))
	}
	return n
}

func (m *ValueString) Size() (n int) {
	var l int
	_ = l
	l = len(m.Value)
	if l > 0 {
		n += 1 + l + sovSql(uint64(l))
	}
	return n
}

func (m *ValueTime) Size() (n int) {
	var l int
	_ = l
	if m.Value != 0 {
		n += 1 + sovSql(uint64(m.Value))
	}
	return n
}

func (m *ValueNull) Size() (n int) {
	var l int
	_ = l
	return n
}

func sovSql(x uint64) (n int) {
	for {
		n++
		x >>= 7
		if x == 0 {
			break
		}
	}
	return n
}
func sozSql(x uint64) (n int) {
	return sovSql(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (m *Request) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowSql
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Request: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Request: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Code", wireType)
			}
			m.Code = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSql
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Code |= (RequestCode(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Data", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSql
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthSql
			}
			postIndex := iNdEx + byteLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Data = append(m.Data[:0], dAtA[iNdEx:postIndex]...)
			if m.Data == nil {
				m.Data = []byte{}
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipSql(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthSql
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *RequestOpen) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowSql
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: RequestOpen: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: RequestOpen: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSql
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthSql
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Name = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipSql(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthSql
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *RequestPrepare) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowSql
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: RequestPrepare: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: RequestPrepare: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Query", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSql
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthSql
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Query = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipSql(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthSql
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *RequestExec) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowSql
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: RequestExec: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: RequestExec: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Id", wireType)
			}
			m.Id = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSql
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Id |= (int64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Args", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSql
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthSql
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Args = append(m.Args, &Value{})
			if err := m.Args[len(m.Args)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipSql(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthSql
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *RequestQuery) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowSql
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: RequestQuery: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: RequestQuery: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Id", wireType)
			}
			m.Id = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSql
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Id |= (int64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Args", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSql
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthSql
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Args = append(m.Args, &Value{})
			if err := m.Args[len(m.Args)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipSql(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthSql
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *RequestNext) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowSql
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: RequestNext: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: RequestNext: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Id", wireType)
			}
			m.Id = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSql
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Id |= (int64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Len", wireType)
			}
			m.Len = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSql
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Len |= (int64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipSql(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthSql
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *RequestColumnTypeScanType) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowSql
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: RequestColumnTypeScanType: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: RequestColumnTypeScanType: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Id", wireType)
			}
			m.Id = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSql
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Id |= (int64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Column", wireType)
			}
			m.Column = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSql
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Column |= (int64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipSql(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthSql
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *RequestColumnTypeDatabaseTypeName) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowSql
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: RequestColumnTypeDatabaseTypeName: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: RequestColumnTypeDatabaseTypeName: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Id", wireType)
			}
			m.Id = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSql
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Id |= (int64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Column", wireType)
			}
			m.Column = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSql
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Column |= (int64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipSql(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthSql
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *RequestRowsClose) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowSql
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: RequestRowsClose: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: RequestRowsClose: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Id", wireType)
			}
			m.Id = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSql
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Id |= (int64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipSql(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthSql
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *RequestStmtClose) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowSql
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: RequestStmtClose: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: RequestStmtClose: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Id", wireType)
			}
			m.Id = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSql
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Id |= (int64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipSql(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthSql
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *RequestBegin) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowSql
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: RequestBegin: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: RequestBegin: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		default:
			iNdEx = preIndex
			skippy, err := skipSql(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthSql
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *RequestCommit) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowSql
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: RequestCommit: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: RequestCommit: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Id", wireType)
			}
			m.Id = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSql
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Id |= (int64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipSql(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthSql
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *RequestRollback) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowSql
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: RequestRollback: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: RequestRollback: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Id", wireType)
			}
			m.Id = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSql
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Id |= (int64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipSql(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthSql
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *RequestClose) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowSql
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: RequestClose: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: RequestClose: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		default:
			iNdEx = preIndex
			skippy, err := skipSql(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthSql
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *RequestConnExec) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowSql
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: RequestConnExec: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: RequestConnExec: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Query", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSql
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthSql
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Query = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Args", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSql
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthSql
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Args = append(m.Args, &Value{})
			if err := m.Args[len(m.Args)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipSql(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthSql
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Response) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowSql
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Response: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Response: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Code", wireType)
			}
			m.Code = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSql
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Code |= (RequestCode(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Data", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSql
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthSql
			}
			postIndex := iNdEx + byteLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Data = append(m.Data[:0], dAtA[iNdEx:postIndex]...)
			if m.Data == nil {
				m.Data = []byte{}
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipSql(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthSql
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ResponseOpen) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowSql
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ResponseOpen: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ResponseOpen: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		default:
			iNdEx = preIndex
			skippy, err := skipSql(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthSql
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ResponsePrepare) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowSql
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ResponsePrepare: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ResponsePrepare: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Id", wireType)
			}
			m.Id = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSql
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Id |= (int64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field NumInput", wireType)
			}
			m.NumInput = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSql
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.NumInput |= (int64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipSql(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthSql
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ResponseExec) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowSql
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ResponseExec: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ResponseExec: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field LastInsertId", wireType)
			}
			m.LastInsertId = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSql
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.LastInsertId |= (int64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field RowsAffected", wireType)
			}
			m.RowsAffected = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSql
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.RowsAffected |= (int64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipSql(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthSql
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ResponseQuery) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowSql
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ResponseQuery: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ResponseQuery: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Id", wireType)
			}
			m.Id = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSql
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Id |= (int64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Columns", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSql
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthSql
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Columns = append(m.Columns, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipSql(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthSql
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ResponseNext) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowSql
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ResponseNext: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ResponseNext: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Eof", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSql
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Eof = bool(v != 0)
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Values", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSql
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthSql
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Values = append(m.Values, &Value{})
			if err := m.Values[len(m.Values)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipSql(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthSql
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ResponseColumnTypeScanType) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowSql
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ResponseColumnTypeScanType: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ResponseColumnTypeScanType: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Code", wireType)
			}
			m.Code = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSql
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Code |= (ValueCode(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipSql(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthSql
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ResponseColumnTypeDatabaseTypeName) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowSql
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ResponseColumnTypeDatabaseTypeName: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ResponseColumnTypeDatabaseTypeName: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSql
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthSql
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Name = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipSql(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthSql
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ResponseRowsClose) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowSql
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ResponseRowsClose: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ResponseRowsClose: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		default:
			iNdEx = preIndex
			skippy, err := skipSql(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthSql
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ResponseStmtClose) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowSql
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ResponseStmtClose: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ResponseStmtClose: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		default:
			iNdEx = preIndex
			skippy, err := skipSql(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthSql
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ResponseBegin) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowSql
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ResponseBegin: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ResponseBegin: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Id", wireType)
			}
			m.Id = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSql
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Id |= (int64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipSql(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthSql
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ResponseCommit) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowSql
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ResponseCommit: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ResponseCommit: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		default:
			iNdEx = preIndex
			skippy, err := skipSql(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthSql
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ResponseRollback) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowSql
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ResponseRollback: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ResponseRollback: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		default:
			iNdEx = preIndex
			skippy, err := skipSql(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthSql
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ResponseClose) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowSql
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ResponseClose: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ResponseClose: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		default:
			iNdEx = preIndex
			skippy, err := skipSql(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthSql
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ResponseSQLiteError) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowSql
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ResponseSQLiteError: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ResponseSQLiteError: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Code", wireType)
			}
			m.Code = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSql
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Code |= (int32(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ExtendedCode", wireType)
			}
			m.ExtendedCode = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSql
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.ExtendedCode |= (int32(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Err", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSql
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthSql
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Err = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipSql(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthSql
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Value) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowSql
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Value: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Value: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Code", wireType)
			}
			m.Code = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSql
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Code |= (ValueCode(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Data", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSql
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthSql
			}
			postIndex := iNdEx + byteLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Data = append(m.Data[:0], dAtA[iNdEx:postIndex]...)
			if m.Data == nil {
				m.Data = []byte{}
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipSql(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthSql
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ValueInt64) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowSql
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ValueInt64: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ValueInt64: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Value", wireType)
			}
			m.Value = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSql
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Value |= (int64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipSql(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthSql
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ValueFloat64) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowSql
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ValueFloat64: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ValueFloat64: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 1 {
				return fmt.Errorf("proto: wrong wireType = %d for field Value", wireType)
			}
			var v uint64
			if (iNdEx + 8) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += 8
			v = uint64(dAtA[iNdEx-8])
			v |= uint64(dAtA[iNdEx-7]) << 8
			v |= uint64(dAtA[iNdEx-6]) << 16
			v |= uint64(dAtA[iNdEx-5]) << 24
			v |= uint64(dAtA[iNdEx-4]) << 32
			v |= uint64(dAtA[iNdEx-3]) << 40
			v |= uint64(dAtA[iNdEx-2]) << 48
			v |= uint64(dAtA[iNdEx-1]) << 56
			m.Value = float64(math.Float64frombits(v))
		default:
			iNdEx = preIndex
			skippy, err := skipSql(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthSql
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ValueBool) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowSql
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ValueBool: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ValueBool: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Value", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSql
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Value = bool(v != 0)
		default:
			iNdEx = preIndex
			skippy, err := skipSql(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthSql
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ValueBytes) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowSql
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ValueBytes: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ValueBytes: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Value", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSql
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthSql
			}
			postIndex := iNdEx + byteLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Value = append(m.Value[:0], dAtA[iNdEx:postIndex]...)
			if m.Value == nil {
				m.Value = []byte{}
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipSql(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthSql
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ValueString) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowSql
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ValueString: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ValueString: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Value", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSql
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthSql
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Value = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipSql(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthSql
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ValueTime) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowSql
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ValueTime: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ValueTime: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Value", wireType)
			}
			m.Value = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSql
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Value |= (int64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipSql(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthSql
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ValueNull) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowSql
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ValueNull: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ValueNull: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		default:
			iNdEx = preIndex
			skippy, err := skipSql(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthSql
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipSql(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowSql
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowSql
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
			return iNdEx, nil
		case 1:
			iNdEx += 8
			return iNdEx, nil
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowSql
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			iNdEx += length
			if length < 0 {
				return 0, ErrInvalidLengthSql
			}
			return iNdEx, nil
		case 3:
			for {
				var innerWire uint64
				var start int = iNdEx
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return 0, ErrIntOverflowSql
					}
					if iNdEx >= l {
						return 0, io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					innerWire |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				innerWireType := int(innerWire & 0x7)
				if innerWireType == 4 {
					break
				}
				next, err := skipSql(dAtA[start:])
				if err != nil {
					return 0, err
				}
				iNdEx = start + next
			}
			return iNdEx, nil
		case 4:
			return iNdEx, nil
		case 5:
			iNdEx += 4
			return iNdEx, nil
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
	}
	panic("unreachable")
}

var (
	ErrInvalidLengthSql = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowSql   = fmt.Errorf("proto: integer overflow")
)

func init() { proto.RegisterFile("internal/protocol/sql.proto", fileDescriptorSql) }

var fileDescriptorSql = []byte{
	// 949 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x09, 0x6e, 0x88, 0x02, 0xff, 0xa4, 0x54, 0xdd, 0x72, 0xdb, 0x44,
	0x14, 0xae, 0xfc, 0x17, 0xfb, 0x58, 0x71, 0xb6, 0x1b, 0xca, 0xb8, 0x61, 0xc6, 0x24, 0x1b, 0x86,
	0x86, 0x5e, 0x24, 0x10, 0x3a, 0x9d, 0x72, 0xc1, 0x85, 0xa4, 0xa8, 0x45, 0x53, 0x59, 0xb2, 0x57,
	0x4a, 0x49, 0xae, 0x8c, 0x62, 0x6f, 0x32, 0x1e, 0x64, 0xc9, 0x91, 0x64, 0x48, 0xde, 0x84, 0x47,
	0xe2, 0x92, 0x47, 0x60, 0xc2, 0x23, 0xf0, 0x02, 0xcc, 0xae, 0x7e, 0xec, 0x44, 0x2e, 0x93, 0x81,
	0x2b, 0x9d, 0x73, 0xf4, 0xed, 0x77, 0xfe, 0xbe, 0x5d, 0xf8, 0x6c, 0x1a, 0x24, 0x2c, 0x0a, 0x3c,
	0xff, 0x68, 0x1e, 0x85, 0x49, 0x38, 0x0e, 0xfd, 0xa3, 0xf8, 0xda, 0x3f, 0x14, 0x0e, 0x6e, 0xe6,
	0x31, 0xf2, 0x03, 0x6c, 0x50, 0x76, 0xbd, 0x60, 0x71, 0x82, 0xbf, 0x82, 0xda, 0x38, 0x9c, 0xb0,
	0xae, 0xb4, 0x2b, 0x1d, 0x74, 0x8e, 0x9f, 0x1d, 0xe6, 0x98, 0xc3, 0x0c, 0xa0, 0x85, 0x13, 0x46,
	0x05, 0x04, 0x63, 0xa8, 0x4d, 0xbc, 0xc4, 0xeb, 0x56, 0x76, 0xa5, 0x03, 0x99, 0x0a, 0x9b, 0xec,
	0x41, 0x3b, 0x03, 0xda, 0x73, 0x16, 0x70, 0x48, 0xe0, 0xcd, 0x52, 0xb6, 0x16, 0x15, 0x36, 0xf9,
	0x12, 0x3a, 0x19, 0x64, 0x10, 0xb1, 0xb9, 0x17, 0x31, 0xfc, 0x09, 0xd4, 0xaf, 0x17, 0x2c, 0xba,
	0xcd, 0x60, 0xa9, 0x43, 0xd4, 0x82, 0x4a, 0xbf, 0x61, 0x63, 0xdc, 0x81, 0xca, 0x74, 0x22, 0x10,
	0x55, 0x5a, 0x99, 0x4e, 0xf0, 0x3e, 0xd4, 0xbc, 0xe8, 0x2a, 0xee, 0x56, 0x76, 0xab, 0x07, 0xed,
	0xe3, 0xad, 0x65, 0xa1, 0x1f, 0x3c, 0x7f, 0xc1, 0xa8, 0xf8, 0x49, 0x34, 0x90, 0x33, 0x8e, 0x21,
	0xe7, 0xfc, 0x6f, 0x24, 0x47, 0x45, 0x21, 0x16, 0xbb, 0x49, 0x4a, 0x1c, 0x08, 0xaa, 0x3e, 0x0b,
	0xc4, 0x14, 0xaa, 0x94, 0x9b, 0x44, 0x83, 0xe7, 0xc5, 0xb4, 0xfc, 0xc5, 0x2c, 0x70, 0x6f, 0xe7,
	0xcc, 0x19, 0x7b, 0xe2, 0x5b, 0x3a, 0xfe, 0x29, 0x34, 0xc6, 0x02, 0x95, 0x31, 0x64, 0x1e, 0x79,
	0x0f, 0x7b, 0x25, 0x92, 0x13, 0x2f, 0xf1, 0x2e, 0xbc, 0x98, 0x71, 0xdb, 0xf2, 0x66, 0x8f, 0x27,
	0x23, 0x80, 0x32, 0x32, 0x1a, 0xfe, 0x1a, 0x6b, 0x7e, 0x18, 0x97, 0xce, 0xae, 0x60, 0x9c, 0x64,
	0x96, 0xac, 0xc7, 0x74, 0x8a, 0x79, 0xaa, 0xec, 0x6a, 0x1a, 0x90, 0xcf, 0x61, 0xb3, 0x28, 0x72,
	0x36, 0x9b, 0x96, 0x86, 0x43, 0xf6, 0x60, 0xab, 0x48, 0xec, 0xfb, 0x17, 0xde, 0xf8, 0xe7, 0x7f,
	0xe1, 0x14, 0x39, 0x89, 0x59, 0x1c, 0xd1, 0xc2, 0x20, 0x10, 0xbb, 0x5f, 0x2b, 0x90, 0xc7, 0x2d,
	0xcf, 0x80, 0x26, 0x65, 0xf1, 0x3c, 0x0c, 0x62, 0xf6, 0x7f, 0xb5, 0x2d, 0x0a, 0x4d, 0xa9, 0xb8,
	0xb8, 0xc9, 0xf7, 0xbc, 0xd0, 0xd4, 0xcf, 0x95, 0xfc, 0x70, 0x1f, 0x3b, 0xd0, 0x0c, 0x16, 0x33,
	0x23, 0x98, 0x2f, 0x92, 0x6c, 0x23, 0x85, 0x4f, 0x3e, 0x2c, 0xe9, 0x44, 0x93, 0x04, 0x64, 0xd3,
	0x8b, 0x13, 0x23, 0x88, 0x59, 0x94, 0x18, 0x39, 0x8b, 0xec, 0xaf, 0xc4, 0x38, 0x86, 0x2f, 0x50,
	0xb9, 0xbc, 0x64, 0xe3, 0x84, 0x4d, 0x32, 0x4e, 0x39, 0x5a, 0x89, 0x91, 0xef, 0xf8, 0x4e, 0x52,
	0xde, 0xf5, 0xa2, 0xef, 0xc2, 0x46, 0x2a, 0x8b, 0x74, 0x74, 0x2d, 0x9a, 0xbb, 0xc4, 0x58, 0x96,
	0x24, 0xa4, 0x8e, 0xa0, 0xca, 0xc2, 0x4b, 0x71, 0xb4, 0x49, 0xb9, 0x89, 0x5f, 0x40, 0xe3, 0x17,
	0x3e, 0xdd, 0x8f, 0x4e, 0x3d, 0xfb, 0x4d, 0x74, 0xd8, 0xc9, 0xa9, 0xd6, 0x5c, 0x82, 0x17, 0xf7,
	0x36, 0xb1, 0xfd, 0x80, 0x64, 0xb9, 0x07, 0xf2, 0x06, 0x48, 0x99, 0xa6, 0x74, 0x0d, 0xd6, 0x3d,
	0x33, 0xdb, 0xf0, 0x34, 0x3f, 0x59, 0x68, 0x7e, 0x35, 0x58, 0x88, 0x3c, 0x15, 0x71, 0x1a, 0x14,
	0xaa, 0x2e, 0x29, 0x14, 0xf1, 0x17, 0x2b, 0x2f, 0x82, 0xcb, 0x9c, 0x60, 0x7e, 0x57, 0x72, 0xf2,
	0x54, 0xd7, 0x64, 0x6b, 0x49, 0x93, 0xf2, 0xfe, 0x04, 0xdb, 0x45, 0xb2, 0xa1, 0x39, 0x4d, 0x98,
	0x1e, 0x45, 0x61, 0xc4, 0x8b, 0x2d, 0x7a, 0xaf, 0x67, 0x72, 0xdb, 0x87, 0x4d, 0x76, 0x93, 0xb0,
	0x60, 0xc2, 0x26, 0x23, 0xf1, 0xb3, 0x22, 0x7e, 0xca, 0x79, 0x90, 0x4f, 0x44, 0x6c, 0x23, 0x8a,
	0xba, 0x55, 0xd1, 0x24, 0x37, 0xc9, 0x09, 0xd4, 0xc5, 0xc0, 0x1e, 0x3d, 0xcf, 0xb5, 0xba, 0x26,
	0x00, 0x02, 0x66, 0x04, 0xc9, 0xeb, 0x57, 0xfc, 0xae, 0x89, 0x15, 0x66, 0xfd, 0xa7, 0x0e, 0xf9,
	0x02, 0x64, 0x81, 0x79, 0xeb, 0x87, 0x5e, 0x09, 0x25, 0xe5, 0xa8, 0x3d, 0x68, 0x09, 0x94, 0x1a,
	0x86, 0xfe, 0x7d, 0x48, 0x33, 0x87, 0xe4, 0xc9, 0xd4, 0xdb, 0x84, 0xc5, 0xf7, 0x31, 0x72, 0x8e,
	0xd9, 0x87, 0xb6, 0xc0, 0x38, 0x49, 0x34, 0x0d, 0xae, 0xee, 0x83, 0x5a, 0x0f, 0x73, 0xb9, 0xd3,
	0x19, 0xfb, 0x48, 0xd1, 0xed, 0x0c, 0x62, 0x2d, 0x7c, 0xff, 0xe5, 0xdf, 0x52, 0xf1, 0x8c, 0x8b,
	0x69, 0x36, 0xa1, 0x66, 0x0f, 0x74, 0x0b, 0x3d, 0xc1, 0x6d, 0xd8, 0x18, 0x50, 0x7d, 0xa0, 0x50,
	0x1d, 0x49, 0x3c, 0xac, 0x9f, 0xe9, 0x1a, 0xaa, 0xe0, 0x16, 0xd4, 0x87, 0xa7, 0x3a, 0x3d, 0x47,
	0x55, 0x1e, 0xb4, 0xf4, 0x33, 0x17, 0xd5, 0x70, 0x07, 0x80, 0xda, 0x3f, 0x3a, 0x23, 0xcd, 0xb4,
	0x1d, 0x1d, 0xd5, 0xf1, 0x73, 0x78, 0xa6, 0xd9, 0xe6, 0x69, 0xdf, 0x1a, 0xb9, 0xe7, 0x03, 0x7d,
	0xe4, 0x68, 0x4a, 0x6a, 0xa1, 0x06, 0x26, 0xd0, 0x5b, 0xfd, 0x75, 0xa2, 0xb8, 0x8a, 0xaa, 0x38,
	0x7a, 0xea, 0x59, 0x4a, 0x5f, 0x47, 0x1b, 0x9c, 0xce, 0x71, 0xfb, 0x6e, 0x46, 0xd7, 0xe4, 0x39,
	0x55, 0xfd, 0x9d, 0x61, 0xa1, 0x16, 0x06, 0x68, 0x68, 0x76, 0xbf, 0x6f, 0xb8, 0x08, 0xb0, 0x0c,
	0x4d, 0x6a, 0x9b, 0xa6, 0xaa, 0x68, 0xef, 0x51, 0x9b, 0x83, 0x52, 0xbc, 0x8c, 0x37, 0xa1, 0xa5,
	0xd9, 0x96, 0x35, 0x12, 0x25, 0x6f, 0x62, 0x04, 0xb2, 0x33, 0x34, 0x0d, 0x57, 0x1f, 0xe9, 0x94,
	0xda, 0x14, 0x75, 0x5e, 0x9e, 0x65, 0x23, 0x10, 0x2d, 0xb7, 0xa0, 0x6e, 0x58, 0xee, 0xeb, 0x57,
	0x69, 0xcf, 0x6f, 0x4d, 0x5b, 0xe1, 0x8e, 0xe8, 0x59, 0xb5, 0x6d, 0x33, 0xed, 0x59, 0x3d, 0x77,
	0x75, 0x07, 0x55, 0x79, 0x7e, 0xc7, 0xa5, 0x86, 0xf5, 0x0e, 0xd5, 0x38, 0xc0, 0x35, 0xfa, 0xbc,
	0x5f, 0x3e, 0x89, 0x53, 0xd3, 0x44, 0x8d, 0xe3, 0x37, 0x50, 0x75, 0x86, 0x26, 0xfe, 0x06, 0x6a,
	0xfc, 0x99, 0xc6, 0x4f, 0x4b, 0xaf, 0xe9, 0x0e, 0x5e, 0x0d, 0xa5, 0xf7, 0xe0, 0x40, 0xfa, 0x5a,
	0x52, 0xd1, 0xef, 0x77, 0x3d, 0xe9, 0x8f, 0xbb, 0x9e, 0xf4, 0xe7, 0x5d, 0x4f, 0xfa, 0xed, 0xaf,
	0xde, 0x93, 0x8b, 0x86, 0x00, 0x7e, 0xfb, 0x4f, 0x00, 0x00, 0x00, 0xff, 0xff, 0x60, 0x73, 0x3e,
	0x48, 0xaf, 0x08, 0x00, 0x00,
}
