// Copyright 2012 The Go Authors. All rights reserved.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

#include "textflag.h"

// Called by C code generated by cmd/cgo.
// func crosscall2(fn func(a unsafe.Pointer, n int32, ctxt uintptr), a unsafe.Pointer, n int32, ctxt uintptr)
// Saves C callee-saved registers and calls fn with three arguments.
TEXT crosscall2(SB),NOSPLIT,$-4
	/* 
	 * We still need to save all callee save register as before, and then
	 *  push 3 args for fn (R1, R2, R3).
	 * Also note that at procedure entry in gc world, 4(R13) will be the
	 *  first arg, so we must push another dummy reg (R0) for 0(R13).
	 *  Additionally, runtime·load_g will clobber R0, so we need to save R0
	 *  nevertheless.
	 */
	SUB	$(8*9), R13 // Reserve space for the floating point registers.
	MOVM.WP	[R0, R1, R2, R3, R4, R5, R6, R7, R8, R9, g, R11, R12, R14], (R13)

	// Skip floating point registers on GOARM < 6.
	MOVB    runtime·goarm(SB), R11
	CMP $6, R11
	BLT skipfpsave
	MOVD	F8, (14*4+8*1)(R13)
	MOVD	F9, (14*4+8*2)(R13)
	MOVD	F10, (14*4+8*3)(R13)
	MOVD	F11, (14*4+8*4)(R13)
	MOVD	F12, (14*4+8*5)(R13)
	MOVD	F13, (14*4+8*6)(R13)
	MOVD	F14, (14*4+8*7)(R13)
	MOVD	F15, (14*4+8*8)(R13)

skipfpsave:
	BL	runtime·load_g(SB)
	MOVW	R15, R14 // R15 is PC.
	MOVW	0(R13), R15

	MOVB    runtime·goarm(SB), R11
	CMP $6, R11
	BLT skipfprest
	MOVD	(14*4+8*1)(R13), F8
	MOVD	(14*4+8*2)(R13), F9
	MOVD	(14*4+8*3)(R13), F10
	MOVD	(14*4+8*4)(R13), F11
	MOVD	(14*4+8*5)(R13), F12
	MOVD	(14*4+8*6)(R13), F13
	MOVD	(14*4+8*7)(R13), F14
	MOVD	(14*4+8*8)(R13), F15

skipfprest:
	MOVM.IAW	(R13), [R0, R1, R2, R3, R4, R5, R6, R7, R8, R9, g, R11, R12, R14]
	ADD	$(8*9), R13
	MOVW	R14, R15
