package web

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator 0.17.0.0
// Changes may cause incorrect behavior and will be lost if the code is
// regenerated.

import (
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"net/http"
)

// CertificateOrdersClient is the use these APIs to manage Azure Websites
// resources through the Azure Resource Manager. All task operations conform
// to the HTTP/1.1 protocol specification and each operation returns an
// x-ms-request-id header that can be used to obtain information about the
// request. You must make sure that requests made to these resources are
// secure. For more information, see <a
// href="https://msdn.microsoft.com/en-us/library/azure/dn790557.aspx">Authenticating
// Azure Resource Manager requests.</a>
type CertificateOrdersClient struct {
	ManagementClient
}

// NewCertificateOrdersClient creates an instance of the
// CertificateOrdersClient client.
func NewCertificateOrdersClient(subscriptionID string) CertificateOrdersClient {
	return NewCertificateOrdersClientWithBaseURI(DefaultBaseURI, subscriptionID)
}

// NewCertificateOrdersClientWithBaseURI creates an instance of the
// CertificateOrdersClient client.
func NewCertificateOrdersClientWithBaseURI(baseURI string, subscriptionID string) CertificateOrdersClient {
	return CertificateOrdersClient{NewWithBaseURI(baseURI, subscriptionID)}
}

// CreateOrUpdateCertificate sends the create or update certificate request.
//
// resourceGroupName is azure resource group name certificateOrderName is
// certificate name name is certificate name keyVaultCertificate is key Vault
// secret csm Id
func (client CertificateOrdersClient) CreateOrUpdateCertificate(resourceGroupName string, certificateOrderName string, name string, keyVaultCertificate CertificateOrderCertificate) (result CertificateOrderCertificate, err error) {
	req, err := client.CreateOrUpdateCertificatePreparer(resourceGroupName, certificateOrderName, name, keyVaultCertificate)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.CertificateOrdersClient", "CreateOrUpdateCertificate", nil, "Failure preparing request")
	}

	resp, err := client.CreateOrUpdateCertificateSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.CertificateOrdersClient", "CreateOrUpdateCertificate", resp, "Failure sending request")
	}

	result, err = client.CreateOrUpdateCertificateResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.CertificateOrdersClient", "CreateOrUpdateCertificate", resp, "Failure responding to request")
	}

	return
}

// CreateOrUpdateCertificatePreparer prepares the CreateOrUpdateCertificate request.
func (client CertificateOrdersClient) CreateOrUpdateCertificatePreparer(resourceGroupName string, certificateOrderName string, name string, keyVaultCertificate CertificateOrderCertificate) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"certificateOrderName": autorest.Encode("path", certificateOrderName),
		"name":                 autorest.Encode("path", name),
		"resourceGroupName":    autorest.Encode("path", resourceGroupName),
		"subscriptionId":       autorest.Encode("path", client.SubscriptionID),
	}

	queryParameters := map[string]interface{}{
		"api-version": client.APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsJSON(),
		autorest.AsPut(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CertificateRegistration/certificateOrders/{certificateOrderName}/certificates/{name}", pathParameters),
		autorest.WithJSON(keyVaultCertificate),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// CreateOrUpdateCertificateSender sends the CreateOrUpdateCertificate request. The method will close the
// http.Response Body if it receives an error.
func (client CertificateOrdersClient) CreateOrUpdateCertificateSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// CreateOrUpdateCertificateResponder handles the response to the CreateOrUpdateCertificate request. The method always
// closes the http.Response Body.
func (client CertificateOrdersClient) CreateOrUpdateCertificateResponder(resp *http.Response) (result CertificateOrderCertificate, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// CreateOrUpdateCertificateOrder sends the create or update certificate order
// request.
//
// resourceGroupName is azure resource group name name is certificate name
// certificateDistinguishedName is distinguished name to be used for
// purchasing certificate
func (client CertificateOrdersClient) CreateOrUpdateCertificateOrder(resourceGroupName string, name string, certificateDistinguishedName CertificateOrder) (result CertificateOrder, err error) {
	req, err := client.CreateOrUpdateCertificateOrderPreparer(resourceGroupName, name, certificateDistinguishedName)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.CertificateOrdersClient", "CreateOrUpdateCertificateOrder", nil, "Failure preparing request")
	}

	resp, err := client.CreateOrUpdateCertificateOrderSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.CertificateOrdersClient", "CreateOrUpdateCertificateOrder", resp, "Failure sending request")
	}

	result, err = client.CreateOrUpdateCertificateOrderResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.CertificateOrdersClient", "CreateOrUpdateCertificateOrder", resp, "Failure responding to request")
	}

	return
}

// CreateOrUpdateCertificateOrderPreparer prepares the CreateOrUpdateCertificateOrder request.
func (client CertificateOrdersClient) CreateOrUpdateCertificateOrderPreparer(resourceGroupName string, name string, certificateDistinguishedName CertificateOrder) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	queryParameters := map[string]interface{}{
		"api-version": client.APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsJSON(),
		autorest.AsPut(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CertificateRegistration/certificateOrders/{name}", pathParameters),
		autorest.WithJSON(certificateDistinguishedName),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// CreateOrUpdateCertificateOrderSender sends the CreateOrUpdateCertificateOrder request. The method will close the
// http.Response Body if it receives an error.
func (client CertificateOrdersClient) CreateOrUpdateCertificateOrderSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// CreateOrUpdateCertificateOrderResponder handles the response to the CreateOrUpdateCertificateOrder request. The method always
// closes the http.Response Body.
func (client CertificateOrdersClient) CreateOrUpdateCertificateOrderResponder(resp *http.Response) (result CertificateOrder, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// DeleteCertificate sends the delete certificate request.
//
// resourceGroupName is azure resource group name certificateOrderName is
// certificate name name is certificate name
func (client CertificateOrdersClient) DeleteCertificate(resourceGroupName string, certificateOrderName string, name string) (result SetObject, err error) {
	req, err := client.DeleteCertificatePreparer(resourceGroupName, certificateOrderName, name)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.CertificateOrdersClient", "DeleteCertificate", nil, "Failure preparing request")
	}

	resp, err := client.DeleteCertificateSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.CertificateOrdersClient", "DeleteCertificate", resp, "Failure sending request")
	}

	result, err = client.DeleteCertificateResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.CertificateOrdersClient", "DeleteCertificate", resp, "Failure responding to request")
	}

	return
}

// DeleteCertificatePreparer prepares the DeleteCertificate request.
func (client CertificateOrdersClient) DeleteCertificatePreparer(resourceGroupName string, certificateOrderName string, name string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"certificateOrderName": autorest.Encode("path", certificateOrderName),
		"name":                 autorest.Encode("path", name),
		"resourceGroupName":    autorest.Encode("path", resourceGroupName),
		"subscriptionId":       autorest.Encode("path", client.SubscriptionID),
	}

	queryParameters := map[string]interface{}{
		"api-version": client.APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsDelete(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CertificateRegistration/certificateOrders/{certificateOrderName}/certificates/{name}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// DeleteCertificateSender sends the DeleteCertificate request. The method will close the
// http.Response Body if it receives an error.
func (client CertificateOrdersClient) DeleteCertificateSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// DeleteCertificateResponder handles the response to the DeleteCertificate request. The method always
// closes the http.Response Body.
func (client CertificateOrdersClient) DeleteCertificateResponder(resp *http.Response) (result SetObject, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result.Value),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// DeleteCertificateOrder sends the delete certificate order request.
//
// resourceGroupName is azure resource group name name is certificate name
func (client CertificateOrdersClient) DeleteCertificateOrder(resourceGroupName string, name string) (result SetObject, err error) {
	req, err := client.DeleteCertificateOrderPreparer(resourceGroupName, name)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.CertificateOrdersClient", "DeleteCertificateOrder", nil, "Failure preparing request")
	}

	resp, err := client.DeleteCertificateOrderSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.CertificateOrdersClient", "DeleteCertificateOrder", resp, "Failure sending request")
	}

	result, err = client.DeleteCertificateOrderResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.CertificateOrdersClient", "DeleteCertificateOrder", resp, "Failure responding to request")
	}

	return
}

// DeleteCertificateOrderPreparer prepares the DeleteCertificateOrder request.
func (client CertificateOrdersClient) DeleteCertificateOrderPreparer(resourceGroupName string, name string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	queryParameters := map[string]interface{}{
		"api-version": client.APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsDelete(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CertificateRegistration/certificateOrders/{name}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// DeleteCertificateOrderSender sends the DeleteCertificateOrder request. The method will close the
// http.Response Body if it receives an error.
func (client CertificateOrdersClient) DeleteCertificateOrderSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// DeleteCertificateOrderResponder handles the response to the DeleteCertificateOrder request. The method always
// closes the http.Response Body.
func (client CertificateOrdersClient) DeleteCertificateOrderResponder(resp *http.Response) (result SetObject, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result.Value),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetCertificate sends the get certificate request.
//
// resourceGroupName is azure resource group name certificateOrderName is
// certificate name name is certificate name
func (client CertificateOrdersClient) GetCertificate(resourceGroupName string, certificateOrderName string, name string) (result CertificateOrderCertificate, err error) {
	req, err := client.GetCertificatePreparer(resourceGroupName, certificateOrderName, name)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.CertificateOrdersClient", "GetCertificate", nil, "Failure preparing request")
	}

	resp, err := client.GetCertificateSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.CertificateOrdersClient", "GetCertificate", resp, "Failure sending request")
	}

	result, err = client.GetCertificateResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.CertificateOrdersClient", "GetCertificate", resp, "Failure responding to request")
	}

	return
}

// GetCertificatePreparer prepares the GetCertificate request.
func (client CertificateOrdersClient) GetCertificatePreparer(resourceGroupName string, certificateOrderName string, name string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"certificateOrderName": autorest.Encode("path", certificateOrderName),
		"name":                 autorest.Encode("path", name),
		"resourceGroupName":    autorest.Encode("path", resourceGroupName),
		"subscriptionId":       autorest.Encode("path", client.SubscriptionID),
	}

	queryParameters := map[string]interface{}{
		"api-version": client.APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CertificateRegistration/certificateOrders/{certificateOrderName}/certificates/{name}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// GetCertificateSender sends the GetCertificate request. The method will close the
// http.Response Body if it receives an error.
func (client CertificateOrdersClient) GetCertificateSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// GetCertificateResponder handles the response to the GetCertificate request. The method always
// closes the http.Response Body.
func (client CertificateOrdersClient) GetCertificateResponder(resp *http.Response) (result CertificateOrderCertificate, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetCertificateOrder sends the get certificate order request.
//
// resourceGroupName is azure resource group name name is certificate name
func (client CertificateOrdersClient) GetCertificateOrder(resourceGroupName string, name string) (result CertificateOrder, err error) {
	req, err := client.GetCertificateOrderPreparer(resourceGroupName, name)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.CertificateOrdersClient", "GetCertificateOrder", nil, "Failure preparing request")
	}

	resp, err := client.GetCertificateOrderSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.CertificateOrdersClient", "GetCertificateOrder", resp, "Failure sending request")
	}

	result, err = client.GetCertificateOrderResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.CertificateOrdersClient", "GetCertificateOrder", resp, "Failure responding to request")
	}

	return
}

// GetCertificateOrderPreparer prepares the GetCertificateOrder request.
func (client CertificateOrdersClient) GetCertificateOrderPreparer(resourceGroupName string, name string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	queryParameters := map[string]interface{}{
		"api-version": client.APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CertificateRegistration/certificateOrders/{name}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// GetCertificateOrderSender sends the GetCertificateOrder request. The method will close the
// http.Response Body if it receives an error.
func (client CertificateOrdersClient) GetCertificateOrderSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// GetCertificateOrderResponder handles the response to the GetCertificateOrder request. The method always
// closes the http.Response Body.
func (client CertificateOrdersClient) GetCertificateOrderResponder(resp *http.Response) (result CertificateOrder, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetCertificateOrders sends the get certificate orders request.
//
// resourceGroupName is azure resource group name
func (client CertificateOrdersClient) GetCertificateOrders(resourceGroupName string) (result CertificateOrderCollection, err error) {
	req, err := client.GetCertificateOrdersPreparer(resourceGroupName)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.CertificateOrdersClient", "GetCertificateOrders", nil, "Failure preparing request")
	}

	resp, err := client.GetCertificateOrdersSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.CertificateOrdersClient", "GetCertificateOrders", resp, "Failure sending request")
	}

	result, err = client.GetCertificateOrdersResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.CertificateOrdersClient", "GetCertificateOrders", resp, "Failure responding to request")
	}

	return
}

// GetCertificateOrdersPreparer prepares the GetCertificateOrders request.
func (client CertificateOrdersClient) GetCertificateOrdersPreparer(resourceGroupName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	queryParameters := map[string]interface{}{
		"api-version": client.APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CertificateRegistration/certificateOrders", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// GetCertificateOrdersSender sends the GetCertificateOrders request. The method will close the
// http.Response Body if it receives an error.
func (client CertificateOrdersClient) GetCertificateOrdersSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// GetCertificateOrdersResponder handles the response to the GetCertificateOrders request. The method always
// closes the http.Response Body.
func (client CertificateOrdersClient) GetCertificateOrdersResponder(resp *http.Response) (result CertificateOrderCollection, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetCertificates sends the get certificates request.
//
// resourceGroupName is azure resource group name certificateOrderName is
// certificate name
func (client CertificateOrdersClient) GetCertificates(resourceGroupName string, certificateOrderName string) (result CertificateOrderCertificateCollection, err error) {
	req, err := client.GetCertificatesPreparer(resourceGroupName, certificateOrderName)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.CertificateOrdersClient", "GetCertificates", nil, "Failure preparing request")
	}

	resp, err := client.GetCertificatesSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.CertificateOrdersClient", "GetCertificates", resp, "Failure sending request")
	}

	result, err = client.GetCertificatesResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.CertificateOrdersClient", "GetCertificates", resp, "Failure responding to request")
	}

	return
}

// GetCertificatesPreparer prepares the GetCertificates request.
func (client CertificateOrdersClient) GetCertificatesPreparer(resourceGroupName string, certificateOrderName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"certificateOrderName": autorest.Encode("path", certificateOrderName),
		"resourceGroupName":    autorest.Encode("path", resourceGroupName),
		"subscriptionId":       autorest.Encode("path", client.SubscriptionID),
	}

	queryParameters := map[string]interface{}{
		"api-version": client.APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CertificateRegistration/certificateOrders/{certificateOrderName}/certificates", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// GetCertificatesSender sends the GetCertificates request. The method will close the
// http.Response Body if it receives an error.
func (client CertificateOrdersClient) GetCertificatesSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// GetCertificatesResponder handles the response to the GetCertificates request. The method always
// closes the http.Response Body.
func (client CertificateOrdersClient) GetCertificatesResponder(resp *http.Response) (result CertificateOrderCertificateCollection, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ReissueCertificateOrder sends the reissue certificate order request.
//
// resourceGroupName is azure resource group name name is certificate name
// reissueCertificateOrderRequest is reissue parameters
func (client CertificateOrdersClient) ReissueCertificateOrder(resourceGroupName string, name string, reissueCertificateOrderRequest ReissueCertificateOrderRequest) (result SetObject, err error) {
	req, err := client.ReissueCertificateOrderPreparer(resourceGroupName, name, reissueCertificateOrderRequest)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.CertificateOrdersClient", "ReissueCertificateOrder", nil, "Failure preparing request")
	}

	resp, err := client.ReissueCertificateOrderSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.CertificateOrdersClient", "ReissueCertificateOrder", resp, "Failure sending request")
	}

	result, err = client.ReissueCertificateOrderResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.CertificateOrdersClient", "ReissueCertificateOrder", resp, "Failure responding to request")
	}

	return
}

// ReissueCertificateOrderPreparer prepares the ReissueCertificateOrder request.
func (client CertificateOrdersClient) ReissueCertificateOrderPreparer(resourceGroupName string, name string, reissueCertificateOrderRequest ReissueCertificateOrderRequest) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	queryParameters := map[string]interface{}{
		"api-version": client.APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsJSON(),
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CertificateRegistration/certificateOrders/{name}/reissue", pathParameters),
		autorest.WithJSON(reissueCertificateOrderRequest),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// ReissueCertificateOrderSender sends the ReissueCertificateOrder request. The method will close the
// http.Response Body if it receives an error.
func (client CertificateOrdersClient) ReissueCertificateOrderSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// ReissueCertificateOrderResponder handles the response to the ReissueCertificateOrder request. The method always
// closes the http.Response Body.
func (client CertificateOrdersClient) ReissueCertificateOrderResponder(resp *http.Response) (result SetObject, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result.Value),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// RenewCertificateOrder sends the renew certificate order request.
//
// resourceGroupName is azure resource group name name is certificate name
// renewCertificateOrderRequest is renew parameters
func (client CertificateOrdersClient) RenewCertificateOrder(resourceGroupName string, name string, renewCertificateOrderRequest RenewCertificateOrderRequest) (result SetObject, err error) {
	req, err := client.RenewCertificateOrderPreparer(resourceGroupName, name, renewCertificateOrderRequest)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.CertificateOrdersClient", "RenewCertificateOrder", nil, "Failure preparing request")
	}

	resp, err := client.RenewCertificateOrderSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.CertificateOrdersClient", "RenewCertificateOrder", resp, "Failure sending request")
	}

	result, err = client.RenewCertificateOrderResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.CertificateOrdersClient", "RenewCertificateOrder", resp, "Failure responding to request")
	}

	return
}

// RenewCertificateOrderPreparer prepares the RenewCertificateOrder request.
func (client CertificateOrdersClient) RenewCertificateOrderPreparer(resourceGroupName string, name string, renewCertificateOrderRequest RenewCertificateOrderRequest) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	queryParameters := map[string]interface{}{
		"api-version": client.APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsJSON(),
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CertificateRegistration/certificateOrders/{name}/renew", pathParameters),
		autorest.WithJSON(renewCertificateOrderRequest),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// RenewCertificateOrderSender sends the RenewCertificateOrder request. The method will close the
// http.Response Body if it receives an error.
func (client CertificateOrdersClient) RenewCertificateOrderSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// RenewCertificateOrderResponder handles the response to the RenewCertificateOrder request. The method always
// closes the http.Response Body.
func (client CertificateOrdersClient) RenewCertificateOrderResponder(resp *http.Response) (result SetObject, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result.Value),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ResendCertificateEmail sends the resend certificate email request.
//
// resourceGroupName is azure resource group name name is certificate order
// name
func (client CertificateOrdersClient) ResendCertificateEmail(resourceGroupName string, name string) (result SetObject, err error) {
	req, err := client.ResendCertificateEmailPreparer(resourceGroupName, name)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.CertificateOrdersClient", "ResendCertificateEmail", nil, "Failure preparing request")
	}

	resp, err := client.ResendCertificateEmailSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.CertificateOrdersClient", "ResendCertificateEmail", resp, "Failure sending request")
	}

	result, err = client.ResendCertificateEmailResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.CertificateOrdersClient", "ResendCertificateEmail", resp, "Failure responding to request")
	}

	return
}

// ResendCertificateEmailPreparer prepares the ResendCertificateEmail request.
func (client CertificateOrdersClient) ResendCertificateEmailPreparer(resourceGroupName string, name string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	queryParameters := map[string]interface{}{
		"api-version": client.APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CertificateRegistration/certificateOrders/{name}/resendEmail", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// ResendCertificateEmailSender sends the ResendCertificateEmail request. The method will close the
// http.Response Body if it receives an error.
func (client CertificateOrdersClient) ResendCertificateEmailSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// ResendCertificateEmailResponder handles the response to the ResendCertificateEmail request. The method always
// closes the http.Response Body.
func (client CertificateOrdersClient) ResendCertificateEmailResponder(resp *http.Response) (result SetObject, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result.Value),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// RetrieveCertificateActions sends the retrieve certificate actions request.
//
// resourceGroupName is azure resource group name name is certificate order
// name
func (client CertificateOrdersClient) RetrieveCertificateActions(resourceGroupName string, name string) (result ListCertificateOrderAction, err error) {
	req, err := client.RetrieveCertificateActionsPreparer(resourceGroupName, name)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.CertificateOrdersClient", "RetrieveCertificateActions", nil, "Failure preparing request")
	}

	resp, err := client.RetrieveCertificateActionsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.CertificateOrdersClient", "RetrieveCertificateActions", resp, "Failure sending request")
	}

	result, err = client.RetrieveCertificateActionsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.CertificateOrdersClient", "RetrieveCertificateActions", resp, "Failure responding to request")
	}

	return
}

// RetrieveCertificateActionsPreparer prepares the RetrieveCertificateActions request.
func (client CertificateOrdersClient) RetrieveCertificateActionsPreparer(resourceGroupName string, name string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	queryParameters := map[string]interface{}{
		"api-version": client.APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CertificateRegistration/certificateOrders/{name}/retrieveCertificateActions", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// RetrieveCertificateActionsSender sends the RetrieveCertificateActions request. The method will close the
// http.Response Body if it receives an error.
func (client CertificateOrdersClient) RetrieveCertificateActionsSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// RetrieveCertificateActionsResponder handles the response to the RetrieveCertificateActions request. The method always
// closes the http.Response Body.
func (client CertificateOrdersClient) RetrieveCertificateActionsResponder(resp *http.Response) (result ListCertificateOrderAction, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result.Value),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// RetrieveCertificateEmailHistory sends the retrieve certificate email
// history request.
//
// resourceGroupName is azure resource group name name is certificate order
// name
func (client CertificateOrdersClient) RetrieveCertificateEmailHistory(resourceGroupName string, name string) (result ListCertificateEmail, err error) {
	req, err := client.RetrieveCertificateEmailHistoryPreparer(resourceGroupName, name)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.CertificateOrdersClient", "RetrieveCertificateEmailHistory", nil, "Failure preparing request")
	}

	resp, err := client.RetrieveCertificateEmailHistorySender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.CertificateOrdersClient", "RetrieveCertificateEmailHistory", resp, "Failure sending request")
	}

	result, err = client.RetrieveCertificateEmailHistoryResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.CertificateOrdersClient", "RetrieveCertificateEmailHistory", resp, "Failure responding to request")
	}

	return
}

// RetrieveCertificateEmailHistoryPreparer prepares the RetrieveCertificateEmailHistory request.
func (client CertificateOrdersClient) RetrieveCertificateEmailHistoryPreparer(resourceGroupName string, name string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	queryParameters := map[string]interface{}{
		"api-version": client.APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CertificateRegistration/certificateOrders/{name}/retrieveEmailHistory", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// RetrieveCertificateEmailHistorySender sends the RetrieveCertificateEmailHistory request. The method will close the
// http.Response Body if it receives an error.
func (client CertificateOrdersClient) RetrieveCertificateEmailHistorySender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// RetrieveCertificateEmailHistoryResponder handles the response to the RetrieveCertificateEmailHistory request. The method always
// closes the http.Response Body.
func (client CertificateOrdersClient) RetrieveCertificateEmailHistoryResponder(resp *http.Response) (result ListCertificateEmail, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result.Value),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// UpdateCertificate sends the update certificate request.
//
// resourceGroupName is azure resource group name certificateOrderName is
// certificate name name is certificate name keyVaultCertificate is key Vault
// secret csm Id
func (client CertificateOrdersClient) UpdateCertificate(resourceGroupName string, certificateOrderName string, name string, keyVaultCertificate CertificateOrderCertificate) (result CertificateOrderCertificate, err error) {
	req, err := client.UpdateCertificatePreparer(resourceGroupName, certificateOrderName, name, keyVaultCertificate)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.CertificateOrdersClient", "UpdateCertificate", nil, "Failure preparing request")
	}

	resp, err := client.UpdateCertificateSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.CertificateOrdersClient", "UpdateCertificate", resp, "Failure sending request")
	}

	result, err = client.UpdateCertificateResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.CertificateOrdersClient", "UpdateCertificate", resp, "Failure responding to request")
	}

	return
}

// UpdateCertificatePreparer prepares the UpdateCertificate request.
func (client CertificateOrdersClient) UpdateCertificatePreparer(resourceGroupName string, certificateOrderName string, name string, keyVaultCertificate CertificateOrderCertificate) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"certificateOrderName": autorest.Encode("path", certificateOrderName),
		"name":                 autorest.Encode("path", name),
		"resourceGroupName":    autorest.Encode("path", resourceGroupName),
		"subscriptionId":       autorest.Encode("path", client.SubscriptionID),
	}

	queryParameters := map[string]interface{}{
		"api-version": client.APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsJSON(),
		autorest.AsPatch(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CertificateRegistration/certificateOrders/{certificateOrderName}/certificates/{name}", pathParameters),
		autorest.WithJSON(keyVaultCertificate),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// UpdateCertificateSender sends the UpdateCertificate request. The method will close the
// http.Response Body if it receives an error.
func (client CertificateOrdersClient) UpdateCertificateSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// UpdateCertificateResponder handles the response to the UpdateCertificate request. The method always
// closes the http.Response Body.
func (client CertificateOrdersClient) UpdateCertificateResponder(resp *http.Response) (result CertificateOrderCertificate, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// UpdateCertificateOrder sends the update certificate order request.
//
// resourceGroupName is azure resource group name name is certificate name
// certificateDistinguishedName is distinguished name to be used for
// purchasing certificate
func (client CertificateOrdersClient) UpdateCertificateOrder(resourceGroupName string, name string, certificateDistinguishedName CertificateOrder) (result CertificateOrder, err error) {
	req, err := client.UpdateCertificateOrderPreparer(resourceGroupName, name, certificateDistinguishedName)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.CertificateOrdersClient", "UpdateCertificateOrder", nil, "Failure preparing request")
	}

	resp, err := client.UpdateCertificateOrderSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.CertificateOrdersClient", "UpdateCertificateOrder", resp, "Failure sending request")
	}

	result, err = client.UpdateCertificateOrderResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.CertificateOrdersClient", "UpdateCertificateOrder", resp, "Failure responding to request")
	}

	return
}

// UpdateCertificateOrderPreparer prepares the UpdateCertificateOrder request.
func (client CertificateOrdersClient) UpdateCertificateOrderPreparer(resourceGroupName string, name string, certificateDistinguishedName CertificateOrder) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	queryParameters := map[string]interface{}{
		"api-version": client.APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsJSON(),
		autorest.AsPatch(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CertificateRegistration/certificateOrders/{name}", pathParameters),
		autorest.WithJSON(certificateDistinguishedName),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// UpdateCertificateOrderSender sends the UpdateCertificateOrder request. The method will close the
// http.Response Body if it receives an error.
func (client CertificateOrdersClient) UpdateCertificateOrderSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// UpdateCertificateOrderResponder handles the response to the UpdateCertificateOrder request. The method always
// closes the http.Response Body.
func (client CertificateOrdersClient) UpdateCertificateOrderResponder(resp *http.Response) (result CertificateOrder, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// VerifyDomainOwnership sends the verify domain ownership request.
//
// resourceGroupName is azure resource group name name is certificate order
// name
func (client CertificateOrdersClient) VerifyDomainOwnership(resourceGroupName string, name string) (result SetObject, err error) {
	req, err := client.VerifyDomainOwnershipPreparer(resourceGroupName, name)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.CertificateOrdersClient", "VerifyDomainOwnership", nil, "Failure preparing request")
	}

	resp, err := client.VerifyDomainOwnershipSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.CertificateOrdersClient", "VerifyDomainOwnership", resp, "Failure sending request")
	}

	result, err = client.VerifyDomainOwnershipResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.CertificateOrdersClient", "VerifyDomainOwnership", resp, "Failure responding to request")
	}

	return
}

// VerifyDomainOwnershipPreparer prepares the VerifyDomainOwnership request.
func (client CertificateOrdersClient) VerifyDomainOwnershipPreparer(resourceGroupName string, name string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	queryParameters := map[string]interface{}{
		"api-version": client.APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CertificateRegistration/certificateOrders/{name}/verifyDomainOwnership", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// VerifyDomainOwnershipSender sends the VerifyDomainOwnership request. The method will close the
// http.Response Body if it receives an error.
func (client CertificateOrdersClient) VerifyDomainOwnershipSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// VerifyDomainOwnershipResponder handles the response to the VerifyDomainOwnership request. The method always
// closes the http.Response Body.
func (client CertificateOrdersClient) VerifyDomainOwnershipResponder(resp *http.Response) (result SetObject, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result.Value),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}
