// -*- c++ -*-
// Generated by gmmproc 2.46.1 -- DO NOT MODIFY!
#ifndef _GTKMM_TEXTTAGTABLE_H
#define _GTKMM_TEXTTAGTABLE_H


#include <glibmm/ustring.h>
#include <sigc++/sigc++.h>

/*
 * Copyright (C) 1998-2002 The gtkmm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include <glibmm/object.h>
#include <gtkmm/texttag.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _GtkTextTagTable GtkTextTagTable;
typedef struct _GtkTextTagTableClass GtkTextTagTableClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Gtk
{ class TextTagTable_Class; } // namespace Gtk
#endif //DOXYGEN_SHOULD_SKIP_THIS

namespace Gtk
{

class TextTag;

/** Typedefed as Gtk::TextBuffer::TagTable. A Collection of @link Gtk::TextTag Gtk::TextBuffer::Tags@endlink that can be used together.
 *
 * A tag table defines a set of @link Gtk::TextTag Gtk::TextBuffer::Tags@endlink that can be used together. Each buffer has one tag
 * table associated with it; only tags from that tag table can be used with the buffer. A single tag table can be shared between
 * multiple buffers, however.
 *
 * @ingroup TextView
 */

class TextTagTable : public Glib::Object
{
   
#ifndef DOXYGEN_SHOULD_SKIP_THIS

public:
  typedef TextTagTable CppObjectType;
  typedef TextTagTable_Class CppClassType;
  typedef GtkTextTagTable BaseObjectType;
  typedef GtkTextTagTableClass BaseClassType;

  // noncopyable
  TextTagTable(const TextTagTable&) = delete;
  TextTagTable& operator=(const TextTagTable&) = delete;

private:  friend class TextTagTable_Class;
  static CppClassType texttagtable_class_;

protected:
  explicit TextTagTable(const Glib::ConstructParams& construct_params);
  explicit TextTagTable(GtkTextTagTable* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:

  TextTagTable(TextTagTable&& src) noexcept;
  TextTagTable& operator=(TextTagTable&& src) noexcept;

  virtual ~TextTagTable() noexcept;

  /** Get the GType for this class, for use with the underlying GObject type system.
   */
  static GType get_type()      G_GNUC_CONST;

#ifndef DOXYGEN_SHOULD_SKIP_THIS


  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GObject.
  GtkTextTagTable*       gobj()       { return reinterpret_cast<GtkTextTagTable*>(gobject_); }

  ///Provides access to the underlying C GObject.
  const GtkTextTagTable* gobj() const { return reinterpret_cast<GtkTextTagTable*>(gobject_); }

  ///Provides access to the underlying C instance. The caller is responsible for unrefing it. Use when directly setting fields in structs.
  GtkTextTagTable* gobj_copy();

private:

protected:

  TextTagTable();

public:
  
  static Glib::RefPtr<TextTagTable> create();


  /** Add a tag to the table. The tag is assigned the highest priority
   * in the table.
   * 
   *  @a tag must not be in a tag table already, and may not have
   * the same name as an already-added tag.
   * 
   * @param tag A Gtk::TextTag.
   * @return <tt>true</tt> on success.
   */
  void add(const Glib::RefPtr<TextTag>& tag);
  
  /** Remove a tag from the table. If a Gtk::TextBuffer has @a table as its tag table,
   * the tag is removed from the buffer. The table’s reference to the tag is
   * removed, so the tag will end up destroyed if you don’t have a reference to
   * it.
   * 
   * @param tag A Gtk::TextTag.
   */
  void remove(const Glib::RefPtr<TextTag>& tag);
  
  /** Look up a named tag.
   * 
   * @param name Name of a tag.
   * @return The tag, or <tt>0</tt> if none by that name is in the table.
   */
  Glib::RefPtr<TextTag> lookup(const Glib::ustring& name);
  
  /** Look up a named tag.
   * 
   * @param name Name of a tag.
   * @return The tag, or <tt>0</tt> if none by that name is in the table.
   */
  Glib::RefPtr<const TextTag> lookup(const Glib::ustring& name) const;

  typedef sigc::slot<void, const Glib::RefPtr<TextTag>&> SlotForEach;
  void foreach(const SlotForEach& slot);
  

  /** Returns the size of the table (number of tags)
   * 
   * @return Number of tags in @a table.
   */
  int get_size() const;


  /**
   * @par Slot Prototype:
   * <tt>void on_my_%tag_changed(const Glib::RefPtr<TextTag>& tag, bool size_changed)</tt>
   *
   * @param tag The changed tag.
   * @param size_changed Whether the size has been changed.
   */

  Glib::SignalProxy2< void,const Glib::RefPtr<TextTag>&,bool > signal_tag_changed();


  /**
   * @par Slot Prototype:
   * <tt>void on_my_%tag_added(const Glib::RefPtr<TextTag>& tag)</tt>
   *
   * @param tag The added tag.
   */

  Glib::SignalProxy1< void,const Glib::RefPtr<TextTag>& > signal_tag_added();

  
  /**
   * @par Slot Prototype:
   * <tt>void on_my_%tag_removed(const Glib::RefPtr<TextTag>& tag)</tt>
   *
   * @param tag The removed tag.
   */

  Glib::SignalProxy1< void,const Glib::RefPtr<TextTag>& > signal_tag_removed();


public:

public:
  //C++ methods used to invoke GTK+ virtual functions:

protected:
  //GTK+ Virtual Functions (override these to change behaviour):

  //Default Signal Handlers::
  /// This is a default handler for the signal signal_tag_changed().
  virtual void on_tag_changed(const Glib::RefPtr<TextTag>& tag, bool size_changed);
  /// This is a default handler for the signal signal_tag_added().
  virtual void on_tag_added(const Glib::RefPtr<TextTag>& tag);
  /// This is a default handler for the signal signal_tag_removed().
  virtual void on_tag_removed(const Glib::RefPtr<TextTag>& tag);


};

} //namespace Gtk


namespace Glib
{
  /** A Glib::wrap() method for this object.
   * 
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Gtk::TextTagTable
   */
  Glib::RefPtr<Gtk::TextTagTable> wrap(GtkTextTagTable* object, bool take_copy = false);
}


#endif /* _GTKMM_TEXTTAGTABLE_H */

