#
# 
#
# Copyright (C) 1997-2013 by Dimitri van Heesch.
#
# Permission to use, copy, modify, and distribute this software and its
# documentation under the terms of the GNU General Public License is hereby 
# granted. No representations are made about the suitability of this software 
# for any purpose. It is provided "as is" without express or implied warranty.
# See the GNU General Public License for more details.
#
# Documents produced by Doxygen are derivative works derived from the
# input used in their production; they are not affected by this license.
#!
#! doxygen.t: This is a custom template for building Doxygen
#!
#$ IncludeTemplate("lib.t");

LEX        = /usr/bin/flex
YACC       = /opt/local/bin/bison
PYTHON     = /opt/local/bin/python
PERL       = %%PERL%%
INCBUFSIZE = $(PYTHON) increasebuffer.py

#${
sub GenerateDep {
    my($obj,$src,$dep) = @_;
    my(@objv,$srcv,$i,$s,$o,$d,$c);
    @objv = split(/\s+/,$obj);
    @srcv = split(/\s+/,$src);
    for $i ( 0..$#objv ) {
        $s = $srcv[$i];
        $o = $objv[$i];
        next if $s eq "";
        $text .= $o . ": " . $s;
	$text .= " ${linebreak}\n\t\t" . $dep if $dep ne "";
        if ( $moc_output{$s} ne "" ) {
            $text .= " ${linebreak}\n\t\t" . $moc_output{$s};
        }
        $d = &make_depend($s);
        $text .= " ${linebreak}\n\t\t" . $d if $d ne "";
	$text .= "\n";
    }
    chop $text;
}
sub GenerateLex {
    my($name,$caseOpt) = @_;
    $text = "\t\$(LEX) ";
    if ($caseOpt) {
        $text .= "-i ";
    }
    $text .= "-P".$name."YY -t ".$name.".l | \$(INCBUFSIZE) >".$name.".cpp";
}
#$} 

####################

#$ GenerateDep("scanner.cpp","scanner.l");
#$ GenerateLex("scanner",0);

#$ GenerateDep("code.cpp","code.l");
#$ GenerateLex("code",0);

#$ GenerateDep("pyscanner.cpp","pyscanner.l");
#$ GenerateLex("pyscanner",0);

#$ GenerateDep("pycode.cpp","pycode.l");
#$ GenerateLex("pycode",0);

#$ GenerateDep("fortranscanner.cpp","fortranscanner.l");
#$ GenerateLex("fortranscanner",1);

#$ GenerateDep("fortrancode.cpp","fortrancode.l");
#$ GenerateLex("fortrancode",1);

#$ GenerateDep("vhdlcode.cpp","vhdlcode.l");
#$ GenerateLex("vhdlcode",1);

#$ GenerateDep("tclscanner.cpp","tclscanner.l");
#$ GenerateLex("tclscanner",1);

#$ GenerateDep("pre.cpp","pre.l");
#$ GenerateLex("pre",0);

#$ GenerateDep("declinfo.cpp","declinfo.l");
#$ GenerateLex("declinfo",0);

#$ GenerateDep("defargs.cpp","defargs.l");
#$ GenerateLex("defargs",0);

#$ GenerateDep("doctokenizer.cpp","doctokenizer.l");
#$ GenerateLex("doctokenizer",0);

#$ GenerateDep("commentcnv.cpp","commentcnv.l");
#$ GenerateLex("commentcnv",0);

#$ GenerateDep("commentscan.cpp","commentscan.l");
#$ GenerateLex("commentscan",0);

#$ GenerateDep("constexp.cpp","constexp.l","ce_parse.h");
#$ GenerateLex("constexp",0);

#$ GenerateDep("ce_parse.cpp","constexp.y");
	$(YACC) -l -p constexpYY constexp.y -o ce_parse.cpp 

#$ GenerateDep("ce_parse.h","constexp.y");
	$(YACC) -l -d -p ce_parsexpYY constexp.y -o ce_parse.c 
	-rm ce_parse.c

#$ GenerateDep("vhdlscanner.cpp","vhdlscanner.l","vhdlparser.h");
#$ GenerateLex("vhdlscanner",1);

#$ GenerateDep("vhdlparser.cpp","vhdlparser.y");
	$(YACC) -l -p vhdlscannerYY vhdlparser.y -o vhdlparser.cpp 	

#$ GenerateDep("vhdlparser.h","vhdlparser.y");
	$(YACC) -l -d -p vhdlscannerYY vhdlparser.y -o vhdlparser.c 
	-rm vhdlparser.c	
	
#$ GenerateDep("layout.cpp","layout_default.xml.h");

TO_C_CMD=$(PYTHON) to_c_cmd.py < $< > $@

cite.cpp: doxygen.bst.h bib2xhtml.pl.h

ftvhelp.cpp: navtree.js.h resize.js.h navtree.css.h

htmlgen.cpp: header.html.h footer.html.h doxygen.css.h search_functions.php.h \
             search_opensearch.php.h search.css.h jquery_p1.js.h jquery_p2.js.h \
	     jquery_p3.js.h jquery_ui.js.h jquery_fx.js.h jquery_pt.js.h \
	     svgpan.js.h dynsections.js.h extsearch.js.h

layout.cpp: layout_default.xml.h

xmlgen.cpp: index.xsd.h compound.xsd.h

latexgen.cpp: doxygen.sty.h

searchindex.cpp: search.js.h

index.xsd.h: index.xsd
	$(TO_C_CMD)

compound.xsd.h: compound.xsd
	$(TO_C_CMD)

layout_default.xml.h: layout_default.xml
	$(TO_C_CMD)

header.html.h: header.html
	$(TO_C_CMD)

footer.html.h: footer.html
	$(TO_C_CMD)

search_functions.php.h: search_functions.php
	$(TO_C_CMD)

search_opensearch.php.h: search_opensearch.php
	$(TO_C_CMD)

search.js.h: search.js
	$(TO_C_CMD)

search.css.h: search.css
	$(TO_C_CMD)

extsearch.js.h: extsearch.js
	$(TO_C_CMD)

doxygen.css.h: doxygen.css
	$(TO_C_CMD)

doxygen.sty.h: doxygen.sty
	$(TO_C_CMD)


navtree.js.h: navtree.js
	$(TO_C_CMD)

resize.js.h: resize.js
	$(TO_C_CMD)

jquery_p1.js.h: jquery_p1.js
	$(TO_C_CMD)

jquery_p2.js.h: jquery_p2.js
	$(TO_C_CMD)

jquery_p3.js.h: jquery_p3.js
	$(TO_C_CMD)

jquery_ui.js.h: jquery_ui.js
	$(TO_C_CMD)

jquery_fx.js.h: jquery_fx.js
	$(TO_C_CMD)

jquery_pt.js.h: jquery_pt.js
	$(TO_C_CMD)

navtree.css.h: navtree.css
	$(TO_C_CMD)

svgpan.js.h: svgpan.js
	$(TO_C_CMD)

dynsections.js.h: dynsections.js
	$(TO_C_CMD)

doxygen.bst.h: doxygen.bst
	$(TO_C_CMD)

bib2xhtml.pl.h: bib2xhtml.pl
	$(TO_C_CMD)

version.cpp: ../configure
	$(PYTHON) version.py
