.TH XScreenSaver 1 "" "X Version 11"
.SH NAME
quasicrystal - aperiodic plane tilings.
.SH SYNOPSIS
.B quasicrystal
[\-display \fIhost:display.screen\fP]
[\-visual \fIvisual\fP]
[\-window]
[\-root]
[\-delay \fInumber\fP]
[\-speed \fInumber\fP]
[\-count \fInumber\fP]
[\-contrast \fIpercent\fP]
[\-no-wander]
[\-no-spin]
[\-asymmetric]
[\-fps]
.SH DESCRIPTION
A quasicrystal is a structure that is ordered but aperiodic.
Two-dimensional quasicrystals can be generated by adding a set of planes
where x is the sine of y. Different complex aperiodic plane tilings are
produced depending on the period, position, and rotation of the component
planes, and whether the rotation of the planes is evenly distributed around
the circle (the "symmetric" option, above) or random. See also the
"RD-Bomb", "CWaves" and "Penrose" screen savers.
.SH OPTIONS
.TP 8
.B \-visual \fIvisual\fP
Specify which visual to use.  Legal values are the name of a visual class,
or the id number (decimal or hex) of a specific visual.
.TP 8
.B \-window
Draw on a newly-created window.  This is the default.
.TP 8
.B \-root
Draw on the root window.
.TP 8
.B \-delay \fInumber\fP
Per-frame delay, in microseconds.  Default: 30000 (0.03 seconds.).
.TP 8
.B \-speed \fInumber\fP
Animation speed. 2 for twice as fast, 0.5 for half as fast.
.TP 8
.B \-contrast \fIcontrast\fP
Contrast. Sort of.  Default 30%.
.TP 8
.B \-count \fInumber\fP
How many planes to use. Default 17.
.TP 8
.B \-wander | \-no-wander
Whether the planes should displace horizontally and vertically.
.TP 8
.B \-spin | \-no-spin
Whether the planes should rotate.
.TP 8
.B \-asymmetric
Allow each plane to rotate freely instead of being constrained to an
even distribution around the circle.
.TP 8
.B \-fps | \-no-fps
Whether to show a frames-per-second display at the bottom of the screen.
.SH ENVIRONMENT
.PP
.TP 8
.B DISPLAY
to get the default host and display number.
.TP 8
.B XENVIRONMENT
to get the name of a resource file that overrides the global resources
stored in the RESOURCE_MANAGER property.
.SH SEE ALSO
.BR X (1),
.BR xscreensaver (1)
.SH COPYRIGHT
Copyright \(co 2013 by Jamie Zawinski.  Permission to use, copy, modify, 
distribute, and sell this software and its documentation for any purpose is 
hereby granted without fee, provided that the above copyright notice appear 
in all copies and that both that copyright notice and this permission notice
appear in supporting documentation.  No representations are made about the 
suitability of this software for any purpose.  It is provided "as is" without
express or implied warranty.
.SH AUTHOR
Jamie Zawinski.
