/***************************************************************
 *
 * Copyright (C) 2024, Pelican Project, Morgridge Institute for Research
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you
 * may not use this file except in compliance with the License.  You may
 * obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 ***************************************************************/
#pragma once

class AWSCredential {

  public:
	AWSCredential(const std::string &accessKeyID,
				  const std::string &secretAccessKey,
				  const std::string &securityToken)
		: m_access_key(accessKeyID), m_secret_key(secretAccessKey),
		  m_security_token(securityToken) {}

  private:
	const std::string m_access_key;
	const std::string m_secret_key;
	const std::string m_security_token;
};
