/* <<< Start of information >>>                                             */
/* This file is part of the xplot program, a plot program for               */
/* tabulated functions which works under X.                                 */
/*                                                                          */
/* Copyright (c) ICCE / Karel Kubat 1995. All rights reserved.              */
/*                                                                          */
/* This program is free software; you can redistribute it and/or modify it  */
/* under the terms of the GNU General Public License as published by the    */
/* Free Software Foundation; either version 2 of the License, or (at your   */
/* option) any later version.                                               */
/*                                                                          */
/* You may link this software with XForms (Copyright (C) by T.C. Zhao and   */
/* Mark Overmars) and distribute the resulting binary, under the            */
/* restrictions in clause 3 of the GPL, even though the resulting binary is */
/* not, as a whole, covered by the GPL. (You still need a separate license  */
/* to do so from the owner(s) of the copyright for XForms, however).  If a  */
/* derivative no longer requires XForms, you may use the unsupplemented GPL */
/* as its license by deleting this paragraph and therefore removing this    */
/* exemption for XForms.                                                    */
/*                                                                          */
/* This program is distributed in the hope that it will be useful,          */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of           */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the            */
/* GNU General Public License for more details.                             */
/*                                                                          */
/* You should have received a copy of the GNU General Public License        */
/* along with this program; if not, write to the Free Software              */
/* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA */
/* <<< End of information >>>                                               */

#include "xplot.h"

void dohelp (FL_OBJECT *ob, long d)
{
    static char
	*notloaded [] =
	{
	    "Sorry, help unavailable.",
	    "The help file was not found or could not",
	    "be loaded.",
	};
    register int
	i;
    
    /* deactivate help button */
    fl_deactivate_object (ob);

    /* load browser */
    if (fli_load_help_browser (help, help_browser, help_contents_browser,
			       help_index_browser, HELPFILE))
	for (i = 0; i < (sizeof (notloaded) / sizeof (char *)); i++)
	    fl_add_browser_line (help_browser, notloaded [i]);

    /* show the form */
    fl_show_form (help, FL_PLACE_SIZE | FL_PLACE_MOUSE, FL_FULLBORDER,
		  "XPlot Info");
}
