/*
 * This file is generated by gdbus-codegen, do not modify it.
 *
 * The license of this code is the same as for the D-Bus interface description
 * it was derived from. Note that it links to GLib, so must comply with the
 * LGPL linking clauses.
 */

#ifdef HAVE_CONFIG_H
#  include "config.h"
#endif

#include "xfdesktop-file-manager-proxy.h"

#include <string.h>
#ifdef G_OS_UNIX
#  include <gio/gunixfdlist.h>
#endif

typedef struct
{
  GDBusArgInfo parent_struct;
  gboolean use_gvariant;
} _ExtendedGDBusArgInfo;

typedef struct
{
  GDBusMethodInfo parent_struct;
  const gchar *signal_name;
  gboolean pass_fdlist;
} _ExtendedGDBusMethodInfo;

typedef struct
{
  GDBusSignalInfo parent_struct;
  const gchar *signal_name;
} _ExtendedGDBusSignalInfo;

typedef struct
{
  GDBusPropertyInfo parent_struct;
  const gchar *hyphen_name;
  guint use_gvariant : 1;
  guint emits_changed_signal : 1;
} _ExtendedGDBusPropertyInfo;

typedef struct
{
  GDBusInterfaceInfo parent_struct;
  const gchar *hyphen_name;
} _ExtendedGDBusInterfaceInfo;

typedef struct
{
  const _ExtendedGDBusPropertyInfo *info;
  guint prop_id;
  GValue orig_value; /* the value before the change */
} ChangedProperty;

static void
_changed_property_free (ChangedProperty *data)
{
  g_value_unset (&data->orig_value);
  g_free (data);
}

static gboolean
_g_strv_equal0 (gchar **a, gchar **b)
{
  gboolean ret = FALSE;
  guint n;
  if (a == NULL && b == NULL)
    {
      ret = TRUE;
      goto out;
    }
  if (a == NULL || b == NULL)
    goto out;
  if (g_strv_length (a) != g_strv_length (b))
    goto out;
  for (n = 0; a[n] != NULL; n++)
    if (g_strcmp0 (a[n], b[n]) != 0)
      goto out;
  ret = TRUE;
out:
  return ret;
}

static gboolean
_g_variant_equal0 (GVariant *a, GVariant *b)
{
  gboolean ret = FALSE;
  if (a == NULL && b == NULL)
    {
      ret = TRUE;
      goto out;
    }
  if (a == NULL || b == NULL)
    goto out;
  ret = g_variant_equal (a, b);
out:
  return ret;
}

G_GNUC_UNUSED static gboolean
_g_value_equal (const GValue *a, const GValue *b)
{
  gboolean ret = FALSE;
  g_assert (G_VALUE_TYPE (a) == G_VALUE_TYPE (b));
  switch (G_VALUE_TYPE (a))
    {
      case G_TYPE_BOOLEAN:
        ret = (g_value_get_boolean (a) == g_value_get_boolean (b));
        break;
      case G_TYPE_UCHAR:
        ret = (g_value_get_uchar (a) == g_value_get_uchar (b));
        break;
      case G_TYPE_INT:
        ret = (g_value_get_int (a) == g_value_get_int (b));
        break;
      case G_TYPE_UINT:
        ret = (g_value_get_uint (a) == g_value_get_uint (b));
        break;
      case G_TYPE_INT64:
        ret = (g_value_get_int64 (a) == g_value_get_int64 (b));
        break;
      case G_TYPE_UINT64:
        ret = (g_value_get_uint64 (a) == g_value_get_uint64 (b));
        break;
      case G_TYPE_DOUBLE:
        {
          /* Avoid -Wfloat-equal warnings by doing a direct bit compare */
          gdouble da = g_value_get_double (a);
          gdouble db = g_value_get_double (b);
          ret = memcmp (&da, &db, sizeof (gdouble)) == 0;
        }
        break;
      case G_TYPE_STRING:
        ret = (g_strcmp0 (g_value_get_string (a), g_value_get_string (b)) == 0);
        break;
      case G_TYPE_VARIANT:
        ret = _g_variant_equal0 (g_value_get_variant (a), g_value_get_variant (b));
        break;
      default:
        if (G_VALUE_TYPE (a) == G_TYPE_STRV)
          ret = _g_strv_equal0 (g_value_get_boxed (a), g_value_get_boxed (b));
        else
          g_critical ("_g_value_equal() does not handle type %s", g_type_name (G_VALUE_TYPE (a)));
        break;
    }
  return ret;
}

/* ------------------------------------------------------------------------
 * Code for interface org.xfce.FileManager
 * ------------------------------------------------------------------------
 */

/**
 * SECTION:XfdesktopFileManager
 * @title: XfdesktopFileManager
 * @short_description: Generated C code for the org.xfce.FileManager D-Bus interface
 *
 * This section contains code for working with the <link linkend="gdbus-interface-org-xfce-FileManager.top_of_page">org.xfce.FileManager</link> D-Bus interface in C.
 */

/* ---- Introspection data for org.xfce.FileManager ---- */

static const _ExtendedGDBusArgInfo _xfdesktop_file_manager_method_info_display_application_chooser_dialog_IN_ARG_uri =
{
  {
    -1,
    (gchar *) "uri",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xfdesktop_file_manager_method_info_display_application_chooser_dialog_IN_ARG_open =
{
  {
    -1,
    (gchar *) "open",
    (gchar *) "b",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xfdesktop_file_manager_method_info_display_application_chooser_dialog_IN_ARG_preselect_default_checkbox =
{
  {
    -1,
    (gchar *) "preselect_default_checkbox",
    (gchar *) "b",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xfdesktop_file_manager_method_info_display_application_chooser_dialog_IN_ARG_display =
{
  {
    -1,
    (gchar *) "display",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xfdesktop_file_manager_method_info_display_application_chooser_dialog_IN_ARG_startup_id =
{
  {
    -1,
    (gchar *) "startup_id",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _xfdesktop_file_manager_method_info_display_application_chooser_dialog_IN_ARG_pointers[] =
{
  &_xfdesktop_file_manager_method_info_display_application_chooser_dialog_IN_ARG_uri.parent_struct,
  &_xfdesktop_file_manager_method_info_display_application_chooser_dialog_IN_ARG_open.parent_struct,
  &_xfdesktop_file_manager_method_info_display_application_chooser_dialog_IN_ARG_preselect_default_checkbox.parent_struct,
  &_xfdesktop_file_manager_method_info_display_application_chooser_dialog_IN_ARG_display.parent_struct,
  &_xfdesktop_file_manager_method_info_display_application_chooser_dialog_IN_ARG_startup_id.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _xfdesktop_file_manager_method_info_display_application_chooser_dialog =
{
  {
    -1,
    (gchar *) "DisplayApplicationChooserDialog",
    (GDBusArgInfo **) &_xfdesktop_file_manager_method_info_display_application_chooser_dialog_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-display-application-chooser-dialog",
  FALSE
};

static const _ExtendedGDBusArgInfo _xfdesktop_file_manager_method_info_display_folder_IN_ARG_uri =
{
  {
    -1,
    (gchar *) "uri",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xfdesktop_file_manager_method_info_display_folder_IN_ARG_display =
{
  {
    -1,
    (gchar *) "display",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xfdesktop_file_manager_method_info_display_folder_IN_ARG_startup_id =
{
  {
    -1,
    (gchar *) "startup_id",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _xfdesktop_file_manager_method_info_display_folder_IN_ARG_pointers[] =
{
  &_xfdesktop_file_manager_method_info_display_folder_IN_ARG_uri.parent_struct,
  &_xfdesktop_file_manager_method_info_display_folder_IN_ARG_display.parent_struct,
  &_xfdesktop_file_manager_method_info_display_folder_IN_ARG_startup_id.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _xfdesktop_file_manager_method_info_display_folder =
{
  {
    -1,
    (gchar *) "DisplayFolder",
    (GDBusArgInfo **) &_xfdesktop_file_manager_method_info_display_folder_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-display-folder",
  FALSE
};

static const _ExtendedGDBusArgInfo _xfdesktop_file_manager_method_info_display_folder_and_select_IN_ARG_uri =
{
  {
    -1,
    (gchar *) "uri",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xfdesktop_file_manager_method_info_display_folder_and_select_IN_ARG_filename =
{
  {
    -1,
    (gchar *) "filename",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xfdesktop_file_manager_method_info_display_folder_and_select_IN_ARG_display =
{
  {
    -1,
    (gchar *) "display",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xfdesktop_file_manager_method_info_display_folder_and_select_IN_ARG_startup_id =
{
  {
    -1,
    (gchar *) "startup_id",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _xfdesktop_file_manager_method_info_display_folder_and_select_IN_ARG_pointers[] =
{
  &_xfdesktop_file_manager_method_info_display_folder_and_select_IN_ARG_uri.parent_struct,
  &_xfdesktop_file_manager_method_info_display_folder_and_select_IN_ARG_filename.parent_struct,
  &_xfdesktop_file_manager_method_info_display_folder_and_select_IN_ARG_display.parent_struct,
  &_xfdesktop_file_manager_method_info_display_folder_and_select_IN_ARG_startup_id.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _xfdesktop_file_manager_method_info_display_folder_and_select =
{
  {
    -1,
    (gchar *) "DisplayFolderAndSelect",
    (GDBusArgInfo **) &_xfdesktop_file_manager_method_info_display_folder_and_select_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-display-folder-and-select",
  FALSE
};

static const _ExtendedGDBusArgInfo _xfdesktop_file_manager_method_info_display_file_properties_IN_ARG_uri =
{
  {
    -1,
    (gchar *) "uri",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xfdesktop_file_manager_method_info_display_file_properties_IN_ARG_display =
{
  {
    -1,
    (gchar *) "display",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xfdesktop_file_manager_method_info_display_file_properties_IN_ARG_startup_id =
{
  {
    -1,
    (gchar *) "startup_id",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _xfdesktop_file_manager_method_info_display_file_properties_IN_ARG_pointers[] =
{
  &_xfdesktop_file_manager_method_info_display_file_properties_IN_ARG_uri.parent_struct,
  &_xfdesktop_file_manager_method_info_display_file_properties_IN_ARG_display.parent_struct,
  &_xfdesktop_file_manager_method_info_display_file_properties_IN_ARG_startup_id.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _xfdesktop_file_manager_method_info_display_file_properties =
{
  {
    -1,
    (gchar *) "DisplayFileProperties",
    (GDBusArgInfo **) &_xfdesktop_file_manager_method_info_display_file_properties_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-display-file-properties",
  FALSE
};

static const _ExtendedGDBusArgInfo _xfdesktop_file_manager_method_info_launch_IN_ARG_uri =
{
  {
    -1,
    (gchar *) "uri",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xfdesktop_file_manager_method_info_launch_IN_ARG_display =
{
  {
    -1,
    (gchar *) "display",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xfdesktop_file_manager_method_info_launch_IN_ARG_startup_id =
{
  {
    -1,
    (gchar *) "startup_id",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _xfdesktop_file_manager_method_info_launch_IN_ARG_pointers[] =
{
  &_xfdesktop_file_manager_method_info_launch_IN_ARG_uri.parent_struct,
  &_xfdesktop_file_manager_method_info_launch_IN_ARG_display.parent_struct,
  &_xfdesktop_file_manager_method_info_launch_IN_ARG_startup_id.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _xfdesktop_file_manager_method_info_launch =
{
  {
    -1,
    (gchar *) "Launch",
    (GDBusArgInfo **) &_xfdesktop_file_manager_method_info_launch_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-launch",
  FALSE
};

static const _ExtendedGDBusArgInfo _xfdesktop_file_manager_method_info_execute_IN_ARG_working_directory =
{
  {
    -1,
    (gchar *) "working_directory",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xfdesktop_file_manager_method_info_execute_IN_ARG_uri =
{
  {
    -1,
    (gchar *) "uri",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xfdesktop_file_manager_method_info_execute_IN_ARG_files =
{
  {
    -1,
    (gchar *) "files",
    (gchar *) "as",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xfdesktop_file_manager_method_info_execute_IN_ARG_display =
{
  {
    -1,
    (gchar *) "display",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xfdesktop_file_manager_method_info_execute_IN_ARG_startup_id =
{
  {
    -1,
    (gchar *) "startup_id",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _xfdesktop_file_manager_method_info_execute_IN_ARG_pointers[] =
{
  &_xfdesktop_file_manager_method_info_execute_IN_ARG_working_directory.parent_struct,
  &_xfdesktop_file_manager_method_info_execute_IN_ARG_uri.parent_struct,
  &_xfdesktop_file_manager_method_info_execute_IN_ARG_files.parent_struct,
  &_xfdesktop_file_manager_method_info_execute_IN_ARG_display.parent_struct,
  &_xfdesktop_file_manager_method_info_execute_IN_ARG_startup_id.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _xfdesktop_file_manager_method_info_execute =
{
  {
    -1,
    (gchar *) "Execute",
    (GDBusArgInfo **) &_xfdesktop_file_manager_method_info_execute_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-execute",
  FALSE
};

static const _ExtendedGDBusArgInfo _xfdesktop_file_manager_method_info_display_preferences_dialog_IN_ARG_display =
{
  {
    -1,
    (gchar *) "display",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xfdesktop_file_manager_method_info_display_preferences_dialog_IN_ARG_startup_id =
{
  {
    -1,
    (gchar *) "startup_id",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _xfdesktop_file_manager_method_info_display_preferences_dialog_IN_ARG_pointers[] =
{
  &_xfdesktop_file_manager_method_info_display_preferences_dialog_IN_ARG_display.parent_struct,
  &_xfdesktop_file_manager_method_info_display_preferences_dialog_IN_ARG_startup_id.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _xfdesktop_file_manager_method_info_display_preferences_dialog =
{
  {
    -1,
    (gchar *) "DisplayPreferencesDialog",
    (GDBusArgInfo **) &_xfdesktop_file_manager_method_info_display_preferences_dialog_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-display-preferences-dialog",
  FALSE
};

static const _ExtendedGDBusArgInfo _xfdesktop_file_manager_method_info_copy_to_IN_ARG_working_directory =
{
  {
    -1,
    (gchar *) "working_directory",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xfdesktop_file_manager_method_info_copy_to_IN_ARG_source_filenames =
{
  {
    -1,
    (gchar *) "source_filenames",
    (gchar *) "as",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xfdesktop_file_manager_method_info_copy_to_IN_ARG_target_filenames =
{
  {
    -1,
    (gchar *) "target_filenames",
    (gchar *) "as",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xfdesktop_file_manager_method_info_copy_to_IN_ARG_display =
{
  {
    -1,
    (gchar *) "display",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xfdesktop_file_manager_method_info_copy_to_IN_ARG_startup_id =
{
  {
    -1,
    (gchar *) "startup_id",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _xfdesktop_file_manager_method_info_copy_to_IN_ARG_pointers[] =
{
  &_xfdesktop_file_manager_method_info_copy_to_IN_ARG_working_directory.parent_struct,
  &_xfdesktop_file_manager_method_info_copy_to_IN_ARG_source_filenames.parent_struct,
  &_xfdesktop_file_manager_method_info_copy_to_IN_ARG_target_filenames.parent_struct,
  &_xfdesktop_file_manager_method_info_copy_to_IN_ARG_display.parent_struct,
  &_xfdesktop_file_manager_method_info_copy_to_IN_ARG_startup_id.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _xfdesktop_file_manager_method_info_copy_to =
{
  {
    -1,
    (gchar *) "CopyTo",
    (GDBusArgInfo **) &_xfdesktop_file_manager_method_info_copy_to_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-copy-to",
  FALSE
};

static const _ExtendedGDBusArgInfo _xfdesktop_file_manager_method_info_copy_into_IN_ARG_working_directory =
{
  {
    -1,
    (gchar *) "working_directory",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xfdesktop_file_manager_method_info_copy_into_IN_ARG_source_filenames =
{
  {
    -1,
    (gchar *) "source_filenames",
    (gchar *) "as",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xfdesktop_file_manager_method_info_copy_into_IN_ARG_target_filename =
{
  {
    -1,
    (gchar *) "target_filename",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xfdesktop_file_manager_method_info_copy_into_IN_ARG_display =
{
  {
    -1,
    (gchar *) "display",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xfdesktop_file_manager_method_info_copy_into_IN_ARG_startup_id =
{
  {
    -1,
    (gchar *) "startup_id",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _xfdesktop_file_manager_method_info_copy_into_IN_ARG_pointers[] =
{
  &_xfdesktop_file_manager_method_info_copy_into_IN_ARG_working_directory.parent_struct,
  &_xfdesktop_file_manager_method_info_copy_into_IN_ARG_source_filenames.parent_struct,
  &_xfdesktop_file_manager_method_info_copy_into_IN_ARG_target_filename.parent_struct,
  &_xfdesktop_file_manager_method_info_copy_into_IN_ARG_display.parent_struct,
  &_xfdesktop_file_manager_method_info_copy_into_IN_ARG_startup_id.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _xfdesktop_file_manager_method_info_copy_into =
{
  {
    -1,
    (gchar *) "CopyInto",
    (GDBusArgInfo **) &_xfdesktop_file_manager_method_info_copy_into_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-copy-into",
  FALSE
};

static const _ExtendedGDBusArgInfo _xfdesktop_file_manager_method_info_move_into_IN_ARG_working_directory =
{
  {
    -1,
    (gchar *) "working_directory",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xfdesktop_file_manager_method_info_move_into_IN_ARG_source_filenames =
{
  {
    -1,
    (gchar *) "source_filenames",
    (gchar *) "as",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xfdesktop_file_manager_method_info_move_into_IN_ARG_target_filename =
{
  {
    -1,
    (gchar *) "target_filename",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xfdesktop_file_manager_method_info_move_into_IN_ARG_display =
{
  {
    -1,
    (gchar *) "display",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xfdesktop_file_manager_method_info_move_into_IN_ARG_startup_id =
{
  {
    -1,
    (gchar *) "startup_id",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _xfdesktop_file_manager_method_info_move_into_IN_ARG_pointers[] =
{
  &_xfdesktop_file_manager_method_info_move_into_IN_ARG_working_directory.parent_struct,
  &_xfdesktop_file_manager_method_info_move_into_IN_ARG_source_filenames.parent_struct,
  &_xfdesktop_file_manager_method_info_move_into_IN_ARG_target_filename.parent_struct,
  &_xfdesktop_file_manager_method_info_move_into_IN_ARG_display.parent_struct,
  &_xfdesktop_file_manager_method_info_move_into_IN_ARG_startup_id.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _xfdesktop_file_manager_method_info_move_into =
{
  {
    -1,
    (gchar *) "MoveInto",
    (GDBusArgInfo **) &_xfdesktop_file_manager_method_info_move_into_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-move-into",
  FALSE
};

static const _ExtendedGDBusArgInfo _xfdesktop_file_manager_method_info_link_into_IN_ARG_working_directory =
{
  {
    -1,
    (gchar *) "working_directory",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xfdesktop_file_manager_method_info_link_into_IN_ARG_source_filenames =
{
  {
    -1,
    (gchar *) "source_filenames",
    (gchar *) "as",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xfdesktop_file_manager_method_info_link_into_IN_ARG_target_filename =
{
  {
    -1,
    (gchar *) "target_filename",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xfdesktop_file_manager_method_info_link_into_IN_ARG_display =
{
  {
    -1,
    (gchar *) "display",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xfdesktop_file_manager_method_info_link_into_IN_ARG_startup_id =
{
  {
    -1,
    (gchar *) "startup_id",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _xfdesktop_file_manager_method_info_link_into_IN_ARG_pointers[] =
{
  &_xfdesktop_file_manager_method_info_link_into_IN_ARG_working_directory.parent_struct,
  &_xfdesktop_file_manager_method_info_link_into_IN_ARG_source_filenames.parent_struct,
  &_xfdesktop_file_manager_method_info_link_into_IN_ARG_target_filename.parent_struct,
  &_xfdesktop_file_manager_method_info_link_into_IN_ARG_display.parent_struct,
  &_xfdesktop_file_manager_method_info_link_into_IN_ARG_startup_id.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _xfdesktop_file_manager_method_info_link_into =
{
  {
    -1,
    (gchar *) "LinkInto",
    (GDBusArgInfo **) &_xfdesktop_file_manager_method_info_link_into_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-link-into",
  FALSE
};

static const _ExtendedGDBusArgInfo _xfdesktop_file_manager_method_info_unlink_files_IN_ARG_working_directory =
{
  {
    -1,
    (gchar *) "working_directory",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xfdesktop_file_manager_method_info_unlink_files_IN_ARG_filenames =
{
  {
    -1,
    (gchar *) "filenames",
    (gchar *) "as",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xfdesktop_file_manager_method_info_unlink_files_IN_ARG_display =
{
  {
    -1,
    (gchar *) "display",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xfdesktop_file_manager_method_info_unlink_files_IN_ARG_startup_id =
{
  {
    -1,
    (gchar *) "startup_id",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _xfdesktop_file_manager_method_info_unlink_files_IN_ARG_pointers[] =
{
  &_xfdesktop_file_manager_method_info_unlink_files_IN_ARG_working_directory.parent_struct,
  &_xfdesktop_file_manager_method_info_unlink_files_IN_ARG_filenames.parent_struct,
  &_xfdesktop_file_manager_method_info_unlink_files_IN_ARG_display.parent_struct,
  &_xfdesktop_file_manager_method_info_unlink_files_IN_ARG_startup_id.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _xfdesktop_file_manager_method_info_unlink_files =
{
  {
    -1,
    (gchar *) "UnlinkFiles",
    (GDBusArgInfo **) &_xfdesktop_file_manager_method_info_unlink_files_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-unlink-files",
  FALSE
};

static const _ExtendedGDBusArgInfo _xfdesktop_file_manager_method_info_launch_files_IN_ARG_working_directory =
{
  {
    -1,
    (gchar *) "working_directory",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xfdesktop_file_manager_method_info_launch_files_IN_ARG_filenames =
{
  {
    -1,
    (gchar *) "filenames",
    (gchar *) "as",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xfdesktop_file_manager_method_info_launch_files_IN_ARG_display =
{
  {
    -1,
    (gchar *) "display",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xfdesktop_file_manager_method_info_launch_files_IN_ARG_startup_id =
{
  {
    -1,
    (gchar *) "startup_id",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _xfdesktop_file_manager_method_info_launch_files_IN_ARG_pointers[] =
{
  &_xfdesktop_file_manager_method_info_launch_files_IN_ARG_working_directory.parent_struct,
  &_xfdesktop_file_manager_method_info_launch_files_IN_ARG_filenames.parent_struct,
  &_xfdesktop_file_manager_method_info_launch_files_IN_ARG_display.parent_struct,
  &_xfdesktop_file_manager_method_info_launch_files_IN_ARG_startup_id.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _xfdesktop_file_manager_method_info_launch_files =
{
  {
    -1,
    (gchar *) "LaunchFiles",
    (GDBusArgInfo **) &_xfdesktop_file_manager_method_info_launch_files_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-launch-files",
  FALSE
};

static const _ExtendedGDBusArgInfo _xfdesktop_file_manager_method_info_rename_file_IN_ARG_filename =
{
  {
    -1,
    (gchar *) "filename",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xfdesktop_file_manager_method_info_rename_file_IN_ARG_display =
{
  {
    -1,
    (gchar *) "display",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xfdesktop_file_manager_method_info_rename_file_IN_ARG_startup_id =
{
  {
    -1,
    (gchar *) "startup_id",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _xfdesktop_file_manager_method_info_rename_file_IN_ARG_pointers[] =
{
  &_xfdesktop_file_manager_method_info_rename_file_IN_ARG_filename.parent_struct,
  &_xfdesktop_file_manager_method_info_rename_file_IN_ARG_display.parent_struct,
  &_xfdesktop_file_manager_method_info_rename_file_IN_ARG_startup_id.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _xfdesktop_file_manager_method_info_rename_file =
{
  {
    -1,
    (gchar *) "RenameFile",
    (GDBusArgInfo **) &_xfdesktop_file_manager_method_info_rename_file_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-rename-file",
  FALSE
};

static const _ExtendedGDBusArgInfo _xfdesktop_file_manager_method_info_create_file_IN_ARG_parent_directory =
{
  {
    -1,
    (gchar *) "parent_directory",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xfdesktop_file_manager_method_info_create_file_IN_ARG_content_type =
{
  {
    -1,
    (gchar *) "content_type",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xfdesktop_file_manager_method_info_create_file_IN_ARG_display =
{
  {
    -1,
    (gchar *) "display",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xfdesktop_file_manager_method_info_create_file_IN_ARG_startup_id =
{
  {
    -1,
    (gchar *) "startup_id",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _xfdesktop_file_manager_method_info_create_file_IN_ARG_pointers[] =
{
  &_xfdesktop_file_manager_method_info_create_file_IN_ARG_parent_directory.parent_struct,
  &_xfdesktop_file_manager_method_info_create_file_IN_ARG_content_type.parent_struct,
  &_xfdesktop_file_manager_method_info_create_file_IN_ARG_display.parent_struct,
  &_xfdesktop_file_manager_method_info_create_file_IN_ARG_startup_id.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _xfdesktop_file_manager_method_info_create_file =
{
  {
    -1,
    (gchar *) "CreateFile",
    (GDBusArgInfo **) &_xfdesktop_file_manager_method_info_create_file_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-create-file",
  FALSE
};

static const _ExtendedGDBusArgInfo _xfdesktop_file_manager_method_info_create_file_from_template_IN_ARG_parent_directory =
{
  {
    -1,
    (gchar *) "parent_directory",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xfdesktop_file_manager_method_info_create_file_from_template_IN_ARG_template_uri =
{
  {
    -1,
    (gchar *) "template_uri",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xfdesktop_file_manager_method_info_create_file_from_template_IN_ARG_display =
{
  {
    -1,
    (gchar *) "display",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xfdesktop_file_manager_method_info_create_file_from_template_IN_ARG_startup_id =
{
  {
    -1,
    (gchar *) "startup_id",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _xfdesktop_file_manager_method_info_create_file_from_template_IN_ARG_pointers[] =
{
  &_xfdesktop_file_manager_method_info_create_file_from_template_IN_ARG_parent_directory.parent_struct,
  &_xfdesktop_file_manager_method_info_create_file_from_template_IN_ARG_template_uri.parent_struct,
  &_xfdesktop_file_manager_method_info_create_file_from_template_IN_ARG_display.parent_struct,
  &_xfdesktop_file_manager_method_info_create_file_from_template_IN_ARG_startup_id.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _xfdesktop_file_manager_method_info_create_file_from_template =
{
  {
    -1,
    (gchar *) "CreateFileFromTemplate",
    (GDBusArgInfo **) &_xfdesktop_file_manager_method_info_create_file_from_template_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-create-file-from-template",
  FALSE
};

static const GDBusMethodInfo * const _xfdesktop_file_manager_method_info_pointers[] =
{
  &_xfdesktop_file_manager_method_info_display_application_chooser_dialog.parent_struct,
  &_xfdesktop_file_manager_method_info_display_folder.parent_struct,
  &_xfdesktop_file_manager_method_info_display_folder_and_select.parent_struct,
  &_xfdesktop_file_manager_method_info_display_file_properties.parent_struct,
  &_xfdesktop_file_manager_method_info_launch.parent_struct,
  &_xfdesktop_file_manager_method_info_execute.parent_struct,
  &_xfdesktop_file_manager_method_info_display_preferences_dialog.parent_struct,
  &_xfdesktop_file_manager_method_info_copy_to.parent_struct,
  &_xfdesktop_file_manager_method_info_copy_into.parent_struct,
  &_xfdesktop_file_manager_method_info_move_into.parent_struct,
  &_xfdesktop_file_manager_method_info_link_into.parent_struct,
  &_xfdesktop_file_manager_method_info_unlink_files.parent_struct,
  &_xfdesktop_file_manager_method_info_launch_files.parent_struct,
  &_xfdesktop_file_manager_method_info_rename_file.parent_struct,
  &_xfdesktop_file_manager_method_info_create_file.parent_struct,
  &_xfdesktop_file_manager_method_info_create_file_from_template.parent_struct,
  NULL
};

static const GDBusAnnotationInfo _xfdesktop_file_manager_annotation_info_0 =
{
  -1,
  (gchar *) "org.freedesktop.DBus.GLib.CSymbol",
  (gchar *) "thunar_dbus_service",
  NULL
};

static const GDBusAnnotationInfo * const _xfdesktop_file_manager_annotation_info_pointers[] =
{
  &_xfdesktop_file_manager_annotation_info_0,
  NULL
};

static const _ExtendedGDBusInterfaceInfo _xfdesktop_file_manager_interface_info =
{
  {
    -1,
    (gchar *) "org.xfce.FileManager",
    (GDBusMethodInfo **) &_xfdesktop_file_manager_method_info_pointers,
    NULL,
    NULL,
    (GDBusAnnotationInfo **) &_xfdesktop_file_manager_annotation_info_pointers
  },
  "file-manager",
};


/**
 * xfdesktop_file_manager_interface_info:
 *
 * Gets a machine-readable description of the <link linkend="gdbus-interface-org-xfce-FileManager.top_of_page">org.xfce.FileManager</link> D-Bus interface.
 *
 * Returns: (transfer none): A #GDBusInterfaceInfo. Do not free.
 */
GDBusInterfaceInfo *
xfdesktop_file_manager_interface_info (void)
{
  return (GDBusInterfaceInfo *) &_xfdesktop_file_manager_interface_info.parent_struct;
}

/**
 * xfdesktop_file_manager_override_properties:
 * @klass: The class structure for a #GObject derived class.
 * @property_id_begin: The property id to assign to the first overridden property.
 *
 * Overrides all #GObject properties in the #XfdesktopFileManager interface for a concrete class.
 * The properties are overridden in the order they are defined.
 *
 * Returns: The last property id.
 */
guint
xfdesktop_file_manager_override_properties (GObjectClass *klass G_GNUC_UNUSED, guint property_id_begin)
{
  return property_id_begin - 1;
}



/**
 * XfdesktopFileManager:
 *
 * Abstract interface type for the D-Bus interface <link linkend="gdbus-interface-org-xfce-FileManager.top_of_page">org.xfce.FileManager</link>.
 */

/**
 * XfdesktopFileManagerIface:
 * @parent_iface: The parent interface.
 * @handle_copy_into: Handler for the #XfdesktopFileManager::handle-copy-into signal.
 * @handle_copy_to: Handler for the #XfdesktopFileManager::handle-copy-to signal.
 * @handle_create_file: Handler for the #XfdesktopFileManager::handle-create-file signal.
 * @handle_create_file_from_template: Handler for the #XfdesktopFileManager::handle-create-file-from-template signal.
 * @handle_display_application_chooser_dialog: Handler for the #XfdesktopFileManager::handle-display-application-chooser-dialog signal.
 * @handle_display_file_properties: Handler for the #XfdesktopFileManager::handle-display-file-properties signal.
 * @handle_display_folder: Handler for the #XfdesktopFileManager::handle-display-folder signal.
 * @handle_display_folder_and_select: Handler for the #XfdesktopFileManager::handle-display-folder-and-select signal.
 * @handle_display_preferences_dialog: Handler for the #XfdesktopFileManager::handle-display-preferences-dialog signal.
 * @handle_execute: Handler for the #XfdesktopFileManager::handle-execute signal.
 * @handle_launch: Handler for the #XfdesktopFileManager::handle-launch signal.
 * @handle_launch_files: Handler for the #XfdesktopFileManager::handle-launch-files signal.
 * @handle_link_into: Handler for the #XfdesktopFileManager::handle-link-into signal.
 * @handle_move_into: Handler for the #XfdesktopFileManager::handle-move-into signal.
 * @handle_rename_file: Handler for the #XfdesktopFileManager::handle-rename-file signal.
 * @handle_unlink_files: Handler for the #XfdesktopFileManager::handle-unlink-files signal.
 *
 * Virtual table for the D-Bus interface <link linkend="gdbus-interface-org-xfce-FileManager.top_of_page">org.xfce.FileManager</link>.
 */

typedef XfdesktopFileManagerIface XfdesktopFileManagerInterface;
G_DEFINE_INTERFACE (XfdesktopFileManager, xfdesktop_file_manager, G_TYPE_OBJECT)

static void
xfdesktop_file_manager_default_init (XfdesktopFileManagerIface *iface)
{
  /* GObject signals for incoming D-Bus method calls: */
  /**
   * XfdesktopFileManager::handle-display-application-chooser-dialog:
   * @object: A #XfdesktopFileManager.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_uri: Argument passed by remote caller.
   * @arg_open: Argument passed by remote caller.
   * @arg_preselect_default_checkbox: Argument passed by remote caller.
   * @arg_display: Argument passed by remote caller.
   * @arg_startup_id: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-xfce-FileManager.DisplayApplicationChooserDialog">DisplayApplicationChooserDialog()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call xfdesktop_file_manager_complete_display_application_chooser_dialog() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-display-application-chooser-dialog",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (XfdesktopFileManagerIface, handle_display_application_chooser_dialog),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    6,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING, G_TYPE_BOOLEAN, G_TYPE_BOOLEAN, G_TYPE_STRING, G_TYPE_STRING);

  /**
   * XfdesktopFileManager::handle-display-folder:
   * @object: A #XfdesktopFileManager.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_uri: Argument passed by remote caller.
   * @arg_display: Argument passed by remote caller.
   * @arg_startup_id: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-xfce-FileManager.DisplayFolder">DisplayFolder()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call xfdesktop_file_manager_complete_display_folder() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-display-folder",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (XfdesktopFileManagerIface, handle_display_folder),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    4,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING);

  /**
   * XfdesktopFileManager::handle-display-folder-and-select:
   * @object: A #XfdesktopFileManager.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_uri: Argument passed by remote caller.
   * @arg_filename: Argument passed by remote caller.
   * @arg_display: Argument passed by remote caller.
   * @arg_startup_id: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-xfce-FileManager.DisplayFolderAndSelect">DisplayFolderAndSelect()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call xfdesktop_file_manager_complete_display_folder_and_select() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-display-folder-and-select",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (XfdesktopFileManagerIface, handle_display_folder_and_select),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    5,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING);

  /**
   * XfdesktopFileManager::handle-display-file-properties:
   * @object: A #XfdesktopFileManager.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_uri: Argument passed by remote caller.
   * @arg_display: Argument passed by remote caller.
   * @arg_startup_id: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-xfce-FileManager.DisplayFileProperties">DisplayFileProperties()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call xfdesktop_file_manager_complete_display_file_properties() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-display-file-properties",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (XfdesktopFileManagerIface, handle_display_file_properties),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    4,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING);

  /**
   * XfdesktopFileManager::handle-launch:
   * @object: A #XfdesktopFileManager.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_uri: Argument passed by remote caller.
   * @arg_display: Argument passed by remote caller.
   * @arg_startup_id: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-xfce-FileManager.Launch">Launch()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call xfdesktop_file_manager_complete_launch() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-launch",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (XfdesktopFileManagerIface, handle_launch),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    4,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING);

  /**
   * XfdesktopFileManager::handle-execute:
   * @object: A #XfdesktopFileManager.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_working_directory: Argument passed by remote caller.
   * @arg_uri: Argument passed by remote caller.
   * @arg_files: Argument passed by remote caller.
   * @arg_display: Argument passed by remote caller.
   * @arg_startup_id: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-xfce-FileManager.Execute">Execute()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call xfdesktop_file_manager_complete_execute() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-execute",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (XfdesktopFileManagerIface, handle_execute),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    6,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRV, G_TYPE_STRING, G_TYPE_STRING);

  /**
   * XfdesktopFileManager::handle-display-preferences-dialog:
   * @object: A #XfdesktopFileManager.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_display: Argument passed by remote caller.
   * @arg_startup_id: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-xfce-FileManager.DisplayPreferencesDialog">DisplayPreferencesDialog()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call xfdesktop_file_manager_complete_display_preferences_dialog() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-display-preferences-dialog",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (XfdesktopFileManagerIface, handle_display_preferences_dialog),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    3,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING, G_TYPE_STRING);

  /**
   * XfdesktopFileManager::handle-copy-to:
   * @object: A #XfdesktopFileManager.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_working_directory: Argument passed by remote caller.
   * @arg_source_filenames: Argument passed by remote caller.
   * @arg_target_filenames: Argument passed by remote caller.
   * @arg_display: Argument passed by remote caller.
   * @arg_startup_id: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-xfce-FileManager.CopyTo">CopyTo()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call xfdesktop_file_manager_complete_copy_to() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-copy-to",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (XfdesktopFileManagerIface, handle_copy_to),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    6,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING, G_TYPE_STRV, G_TYPE_STRV, G_TYPE_STRING, G_TYPE_STRING);

  /**
   * XfdesktopFileManager::handle-copy-into:
   * @object: A #XfdesktopFileManager.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_working_directory: Argument passed by remote caller.
   * @arg_source_filenames: Argument passed by remote caller.
   * @arg_target_filename: Argument passed by remote caller.
   * @arg_display: Argument passed by remote caller.
   * @arg_startup_id: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-xfce-FileManager.CopyInto">CopyInto()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call xfdesktop_file_manager_complete_copy_into() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-copy-into",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (XfdesktopFileManagerIface, handle_copy_into),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    6,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING, G_TYPE_STRV, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING);

  /**
   * XfdesktopFileManager::handle-move-into:
   * @object: A #XfdesktopFileManager.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_working_directory: Argument passed by remote caller.
   * @arg_source_filenames: Argument passed by remote caller.
   * @arg_target_filename: Argument passed by remote caller.
   * @arg_display: Argument passed by remote caller.
   * @arg_startup_id: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-xfce-FileManager.MoveInto">MoveInto()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call xfdesktop_file_manager_complete_move_into() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-move-into",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (XfdesktopFileManagerIface, handle_move_into),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    6,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING, G_TYPE_STRV, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING);

  /**
   * XfdesktopFileManager::handle-link-into:
   * @object: A #XfdesktopFileManager.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_working_directory: Argument passed by remote caller.
   * @arg_source_filenames: Argument passed by remote caller.
   * @arg_target_filename: Argument passed by remote caller.
   * @arg_display: Argument passed by remote caller.
   * @arg_startup_id: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-xfce-FileManager.LinkInto">LinkInto()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call xfdesktop_file_manager_complete_link_into() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-link-into",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (XfdesktopFileManagerIface, handle_link_into),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    6,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING, G_TYPE_STRV, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING);

  /**
   * XfdesktopFileManager::handle-unlink-files:
   * @object: A #XfdesktopFileManager.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_working_directory: Argument passed by remote caller.
   * @arg_filenames: Argument passed by remote caller.
   * @arg_display: Argument passed by remote caller.
   * @arg_startup_id: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-xfce-FileManager.UnlinkFiles">UnlinkFiles()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call xfdesktop_file_manager_complete_unlink_files() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-unlink-files",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (XfdesktopFileManagerIface, handle_unlink_files),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    5,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING, G_TYPE_STRV, G_TYPE_STRING, G_TYPE_STRING);

  /**
   * XfdesktopFileManager::handle-launch-files:
   * @object: A #XfdesktopFileManager.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_working_directory: Argument passed by remote caller.
   * @arg_filenames: Argument passed by remote caller.
   * @arg_display: Argument passed by remote caller.
   * @arg_startup_id: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-xfce-FileManager.LaunchFiles">LaunchFiles()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call xfdesktop_file_manager_complete_launch_files() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-launch-files",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (XfdesktopFileManagerIface, handle_launch_files),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    5,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING, G_TYPE_STRV, G_TYPE_STRING, G_TYPE_STRING);

  /**
   * XfdesktopFileManager::handle-rename-file:
   * @object: A #XfdesktopFileManager.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_filename: Argument passed by remote caller.
   * @arg_display: Argument passed by remote caller.
   * @arg_startup_id: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-xfce-FileManager.RenameFile">RenameFile()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call xfdesktop_file_manager_complete_rename_file() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-rename-file",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (XfdesktopFileManagerIface, handle_rename_file),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    4,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING);

  /**
   * XfdesktopFileManager::handle-create-file:
   * @object: A #XfdesktopFileManager.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_parent_directory: Argument passed by remote caller.
   * @arg_content_type: Argument passed by remote caller.
   * @arg_display: Argument passed by remote caller.
   * @arg_startup_id: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-xfce-FileManager.CreateFile">CreateFile()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call xfdesktop_file_manager_complete_create_file() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-create-file",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (XfdesktopFileManagerIface, handle_create_file),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    5,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING);

  /**
   * XfdesktopFileManager::handle-create-file-from-template:
   * @object: A #XfdesktopFileManager.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_parent_directory: Argument passed by remote caller.
   * @arg_template_uri: Argument passed by remote caller.
   * @arg_display: Argument passed by remote caller.
   * @arg_startup_id: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-xfce-FileManager.CreateFileFromTemplate">CreateFileFromTemplate()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call xfdesktop_file_manager_complete_create_file_from_template() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-create-file-from-template",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (XfdesktopFileManagerIface, handle_create_file_from_template),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    5,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING);

}

/**
 * xfdesktop_file_manager_call_display_application_chooser_dialog:
 * @proxy: A #XfdesktopFileManagerProxy.
 * @arg_uri: Argument to pass with the method invocation.
 * @arg_open: Argument to pass with the method invocation.
 * @arg_preselect_default_checkbox: Argument to pass with the method invocation.
 * @arg_display: Argument to pass with the method invocation.
 * @arg_startup_id: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-xfce-FileManager.DisplayApplicationChooserDialog">DisplayApplicationChooserDialog()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call xfdesktop_file_manager_call_display_application_chooser_dialog_finish() to get the result of the operation.
 *
 * See xfdesktop_file_manager_call_display_application_chooser_dialog_sync() for the synchronous, blocking version of this method.
 */
void
xfdesktop_file_manager_call_display_application_chooser_dialog (
    XfdesktopFileManager *proxy,
    const gchar *arg_uri,
    gboolean arg_open,
    gboolean arg_preselect_default_checkbox,
    const gchar *arg_display,
    const gchar *arg_startup_id,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "DisplayApplicationChooserDialog",
    g_variant_new ("(sbbss)",
                   arg_uri,
                   arg_open,
                   arg_preselect_default_checkbox,
                   arg_display,
                   arg_startup_id),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * xfdesktop_file_manager_call_display_application_chooser_dialog_finish:
 * @proxy: A #XfdesktopFileManagerProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to xfdesktop_file_manager_call_display_application_chooser_dialog().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with xfdesktop_file_manager_call_display_application_chooser_dialog().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xfdesktop_file_manager_call_display_application_chooser_dialog_finish (
    XfdesktopFileManager *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xfdesktop_file_manager_call_display_application_chooser_dialog_sync:
 * @proxy: A #XfdesktopFileManagerProxy.
 * @arg_uri: Argument to pass with the method invocation.
 * @arg_open: Argument to pass with the method invocation.
 * @arg_preselect_default_checkbox: Argument to pass with the method invocation.
 * @arg_display: Argument to pass with the method invocation.
 * @arg_startup_id: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-xfce-FileManager.DisplayApplicationChooserDialog">DisplayApplicationChooserDialog()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See xfdesktop_file_manager_call_display_application_chooser_dialog() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xfdesktop_file_manager_call_display_application_chooser_dialog_sync (
    XfdesktopFileManager *proxy,
    const gchar *arg_uri,
    gboolean arg_open,
    gboolean arg_preselect_default_checkbox,
    const gchar *arg_display,
    const gchar *arg_startup_id,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "DisplayApplicationChooserDialog",
    g_variant_new ("(sbbss)",
                   arg_uri,
                   arg_open,
                   arg_preselect_default_checkbox,
                   arg_display,
                   arg_startup_id),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xfdesktop_file_manager_call_display_folder:
 * @proxy: A #XfdesktopFileManagerProxy.
 * @arg_uri: Argument to pass with the method invocation.
 * @arg_display: Argument to pass with the method invocation.
 * @arg_startup_id: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-xfce-FileManager.DisplayFolder">DisplayFolder()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call xfdesktop_file_manager_call_display_folder_finish() to get the result of the operation.
 *
 * See xfdesktop_file_manager_call_display_folder_sync() for the synchronous, blocking version of this method.
 */
void
xfdesktop_file_manager_call_display_folder (
    XfdesktopFileManager *proxy,
    const gchar *arg_uri,
    const gchar *arg_display,
    const gchar *arg_startup_id,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "DisplayFolder",
    g_variant_new ("(sss)",
                   arg_uri,
                   arg_display,
                   arg_startup_id),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * xfdesktop_file_manager_call_display_folder_finish:
 * @proxy: A #XfdesktopFileManagerProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to xfdesktop_file_manager_call_display_folder().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with xfdesktop_file_manager_call_display_folder().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xfdesktop_file_manager_call_display_folder_finish (
    XfdesktopFileManager *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xfdesktop_file_manager_call_display_folder_sync:
 * @proxy: A #XfdesktopFileManagerProxy.
 * @arg_uri: Argument to pass with the method invocation.
 * @arg_display: Argument to pass with the method invocation.
 * @arg_startup_id: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-xfce-FileManager.DisplayFolder">DisplayFolder()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See xfdesktop_file_manager_call_display_folder() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xfdesktop_file_manager_call_display_folder_sync (
    XfdesktopFileManager *proxy,
    const gchar *arg_uri,
    const gchar *arg_display,
    const gchar *arg_startup_id,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "DisplayFolder",
    g_variant_new ("(sss)",
                   arg_uri,
                   arg_display,
                   arg_startup_id),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xfdesktop_file_manager_call_display_folder_and_select:
 * @proxy: A #XfdesktopFileManagerProxy.
 * @arg_uri: Argument to pass with the method invocation.
 * @arg_filename: Argument to pass with the method invocation.
 * @arg_display: Argument to pass with the method invocation.
 * @arg_startup_id: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-xfce-FileManager.DisplayFolderAndSelect">DisplayFolderAndSelect()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call xfdesktop_file_manager_call_display_folder_and_select_finish() to get the result of the operation.
 *
 * See xfdesktop_file_manager_call_display_folder_and_select_sync() for the synchronous, blocking version of this method.
 */
void
xfdesktop_file_manager_call_display_folder_and_select (
    XfdesktopFileManager *proxy,
    const gchar *arg_uri,
    const gchar *arg_filename,
    const gchar *arg_display,
    const gchar *arg_startup_id,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "DisplayFolderAndSelect",
    g_variant_new ("(ssss)",
                   arg_uri,
                   arg_filename,
                   arg_display,
                   arg_startup_id),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * xfdesktop_file_manager_call_display_folder_and_select_finish:
 * @proxy: A #XfdesktopFileManagerProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to xfdesktop_file_manager_call_display_folder_and_select().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with xfdesktop_file_manager_call_display_folder_and_select().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xfdesktop_file_manager_call_display_folder_and_select_finish (
    XfdesktopFileManager *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xfdesktop_file_manager_call_display_folder_and_select_sync:
 * @proxy: A #XfdesktopFileManagerProxy.
 * @arg_uri: Argument to pass with the method invocation.
 * @arg_filename: Argument to pass with the method invocation.
 * @arg_display: Argument to pass with the method invocation.
 * @arg_startup_id: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-xfce-FileManager.DisplayFolderAndSelect">DisplayFolderAndSelect()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See xfdesktop_file_manager_call_display_folder_and_select() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xfdesktop_file_manager_call_display_folder_and_select_sync (
    XfdesktopFileManager *proxy,
    const gchar *arg_uri,
    const gchar *arg_filename,
    const gchar *arg_display,
    const gchar *arg_startup_id,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "DisplayFolderAndSelect",
    g_variant_new ("(ssss)",
                   arg_uri,
                   arg_filename,
                   arg_display,
                   arg_startup_id),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xfdesktop_file_manager_call_display_file_properties:
 * @proxy: A #XfdesktopFileManagerProxy.
 * @arg_uri: Argument to pass with the method invocation.
 * @arg_display: Argument to pass with the method invocation.
 * @arg_startup_id: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-xfce-FileManager.DisplayFileProperties">DisplayFileProperties()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call xfdesktop_file_manager_call_display_file_properties_finish() to get the result of the operation.
 *
 * See xfdesktop_file_manager_call_display_file_properties_sync() for the synchronous, blocking version of this method.
 */
void
xfdesktop_file_manager_call_display_file_properties (
    XfdesktopFileManager *proxy,
    const gchar *arg_uri,
    const gchar *arg_display,
    const gchar *arg_startup_id,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "DisplayFileProperties",
    g_variant_new ("(sss)",
                   arg_uri,
                   arg_display,
                   arg_startup_id),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * xfdesktop_file_manager_call_display_file_properties_finish:
 * @proxy: A #XfdesktopFileManagerProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to xfdesktop_file_manager_call_display_file_properties().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with xfdesktop_file_manager_call_display_file_properties().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xfdesktop_file_manager_call_display_file_properties_finish (
    XfdesktopFileManager *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xfdesktop_file_manager_call_display_file_properties_sync:
 * @proxy: A #XfdesktopFileManagerProxy.
 * @arg_uri: Argument to pass with the method invocation.
 * @arg_display: Argument to pass with the method invocation.
 * @arg_startup_id: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-xfce-FileManager.DisplayFileProperties">DisplayFileProperties()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See xfdesktop_file_manager_call_display_file_properties() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xfdesktop_file_manager_call_display_file_properties_sync (
    XfdesktopFileManager *proxy,
    const gchar *arg_uri,
    const gchar *arg_display,
    const gchar *arg_startup_id,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "DisplayFileProperties",
    g_variant_new ("(sss)",
                   arg_uri,
                   arg_display,
                   arg_startup_id),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xfdesktop_file_manager_call_launch:
 * @proxy: A #XfdesktopFileManagerProxy.
 * @arg_uri: Argument to pass with the method invocation.
 * @arg_display: Argument to pass with the method invocation.
 * @arg_startup_id: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-xfce-FileManager.Launch">Launch()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call xfdesktop_file_manager_call_launch_finish() to get the result of the operation.
 *
 * See xfdesktop_file_manager_call_launch_sync() for the synchronous, blocking version of this method.
 */
void
xfdesktop_file_manager_call_launch (
    XfdesktopFileManager *proxy,
    const gchar *arg_uri,
    const gchar *arg_display,
    const gchar *arg_startup_id,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "Launch",
    g_variant_new ("(sss)",
                   arg_uri,
                   arg_display,
                   arg_startup_id),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * xfdesktop_file_manager_call_launch_finish:
 * @proxy: A #XfdesktopFileManagerProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to xfdesktop_file_manager_call_launch().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with xfdesktop_file_manager_call_launch().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xfdesktop_file_manager_call_launch_finish (
    XfdesktopFileManager *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xfdesktop_file_manager_call_launch_sync:
 * @proxy: A #XfdesktopFileManagerProxy.
 * @arg_uri: Argument to pass with the method invocation.
 * @arg_display: Argument to pass with the method invocation.
 * @arg_startup_id: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-xfce-FileManager.Launch">Launch()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See xfdesktop_file_manager_call_launch() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xfdesktop_file_manager_call_launch_sync (
    XfdesktopFileManager *proxy,
    const gchar *arg_uri,
    const gchar *arg_display,
    const gchar *arg_startup_id,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "Launch",
    g_variant_new ("(sss)",
                   arg_uri,
                   arg_display,
                   arg_startup_id),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xfdesktop_file_manager_call_execute:
 * @proxy: A #XfdesktopFileManagerProxy.
 * @arg_working_directory: Argument to pass with the method invocation.
 * @arg_uri: Argument to pass with the method invocation.
 * @arg_files: Argument to pass with the method invocation.
 * @arg_display: Argument to pass with the method invocation.
 * @arg_startup_id: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-xfce-FileManager.Execute">Execute()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call xfdesktop_file_manager_call_execute_finish() to get the result of the operation.
 *
 * See xfdesktop_file_manager_call_execute_sync() for the synchronous, blocking version of this method.
 */
void
xfdesktop_file_manager_call_execute (
    XfdesktopFileManager *proxy,
    const gchar *arg_working_directory,
    const gchar *arg_uri,
    const gchar *const *arg_files,
    const gchar *arg_display,
    const gchar *arg_startup_id,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "Execute",
    g_variant_new ("(ss^asss)",
                   arg_working_directory,
                   arg_uri,
                   arg_files,
                   arg_display,
                   arg_startup_id),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * xfdesktop_file_manager_call_execute_finish:
 * @proxy: A #XfdesktopFileManagerProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to xfdesktop_file_manager_call_execute().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with xfdesktop_file_manager_call_execute().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xfdesktop_file_manager_call_execute_finish (
    XfdesktopFileManager *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xfdesktop_file_manager_call_execute_sync:
 * @proxy: A #XfdesktopFileManagerProxy.
 * @arg_working_directory: Argument to pass with the method invocation.
 * @arg_uri: Argument to pass with the method invocation.
 * @arg_files: Argument to pass with the method invocation.
 * @arg_display: Argument to pass with the method invocation.
 * @arg_startup_id: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-xfce-FileManager.Execute">Execute()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See xfdesktop_file_manager_call_execute() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xfdesktop_file_manager_call_execute_sync (
    XfdesktopFileManager *proxy,
    const gchar *arg_working_directory,
    const gchar *arg_uri,
    const gchar *const *arg_files,
    const gchar *arg_display,
    const gchar *arg_startup_id,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "Execute",
    g_variant_new ("(ss^asss)",
                   arg_working_directory,
                   arg_uri,
                   arg_files,
                   arg_display,
                   arg_startup_id),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xfdesktop_file_manager_call_display_preferences_dialog:
 * @proxy: A #XfdesktopFileManagerProxy.
 * @arg_display: Argument to pass with the method invocation.
 * @arg_startup_id: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-xfce-FileManager.DisplayPreferencesDialog">DisplayPreferencesDialog()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call xfdesktop_file_manager_call_display_preferences_dialog_finish() to get the result of the operation.
 *
 * See xfdesktop_file_manager_call_display_preferences_dialog_sync() for the synchronous, blocking version of this method.
 */
void
xfdesktop_file_manager_call_display_preferences_dialog (
    XfdesktopFileManager *proxy,
    const gchar *arg_display,
    const gchar *arg_startup_id,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "DisplayPreferencesDialog",
    g_variant_new ("(ss)",
                   arg_display,
                   arg_startup_id),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * xfdesktop_file_manager_call_display_preferences_dialog_finish:
 * @proxy: A #XfdesktopFileManagerProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to xfdesktop_file_manager_call_display_preferences_dialog().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with xfdesktop_file_manager_call_display_preferences_dialog().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xfdesktop_file_manager_call_display_preferences_dialog_finish (
    XfdesktopFileManager *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xfdesktop_file_manager_call_display_preferences_dialog_sync:
 * @proxy: A #XfdesktopFileManagerProxy.
 * @arg_display: Argument to pass with the method invocation.
 * @arg_startup_id: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-xfce-FileManager.DisplayPreferencesDialog">DisplayPreferencesDialog()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See xfdesktop_file_manager_call_display_preferences_dialog() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xfdesktop_file_manager_call_display_preferences_dialog_sync (
    XfdesktopFileManager *proxy,
    const gchar *arg_display,
    const gchar *arg_startup_id,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "DisplayPreferencesDialog",
    g_variant_new ("(ss)",
                   arg_display,
                   arg_startup_id),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xfdesktop_file_manager_call_copy_to:
 * @proxy: A #XfdesktopFileManagerProxy.
 * @arg_working_directory: Argument to pass with the method invocation.
 * @arg_source_filenames: Argument to pass with the method invocation.
 * @arg_target_filenames: Argument to pass with the method invocation.
 * @arg_display: Argument to pass with the method invocation.
 * @arg_startup_id: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-xfce-FileManager.CopyTo">CopyTo()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call xfdesktop_file_manager_call_copy_to_finish() to get the result of the operation.
 *
 * See xfdesktop_file_manager_call_copy_to_sync() for the synchronous, blocking version of this method.
 */
void
xfdesktop_file_manager_call_copy_to (
    XfdesktopFileManager *proxy,
    const gchar *arg_working_directory,
    const gchar *const *arg_source_filenames,
    const gchar *const *arg_target_filenames,
    const gchar *arg_display,
    const gchar *arg_startup_id,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "CopyTo",
    g_variant_new ("(s^as^asss)",
                   arg_working_directory,
                   arg_source_filenames,
                   arg_target_filenames,
                   arg_display,
                   arg_startup_id),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * xfdesktop_file_manager_call_copy_to_finish:
 * @proxy: A #XfdesktopFileManagerProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to xfdesktop_file_manager_call_copy_to().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with xfdesktop_file_manager_call_copy_to().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xfdesktop_file_manager_call_copy_to_finish (
    XfdesktopFileManager *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xfdesktop_file_manager_call_copy_to_sync:
 * @proxy: A #XfdesktopFileManagerProxy.
 * @arg_working_directory: Argument to pass with the method invocation.
 * @arg_source_filenames: Argument to pass with the method invocation.
 * @arg_target_filenames: Argument to pass with the method invocation.
 * @arg_display: Argument to pass with the method invocation.
 * @arg_startup_id: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-xfce-FileManager.CopyTo">CopyTo()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See xfdesktop_file_manager_call_copy_to() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xfdesktop_file_manager_call_copy_to_sync (
    XfdesktopFileManager *proxy,
    const gchar *arg_working_directory,
    const gchar *const *arg_source_filenames,
    const gchar *const *arg_target_filenames,
    const gchar *arg_display,
    const gchar *arg_startup_id,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "CopyTo",
    g_variant_new ("(s^as^asss)",
                   arg_working_directory,
                   arg_source_filenames,
                   arg_target_filenames,
                   arg_display,
                   arg_startup_id),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xfdesktop_file_manager_call_copy_into:
 * @proxy: A #XfdesktopFileManagerProxy.
 * @arg_working_directory: Argument to pass with the method invocation.
 * @arg_source_filenames: Argument to pass with the method invocation.
 * @arg_target_filename: Argument to pass with the method invocation.
 * @arg_display: Argument to pass with the method invocation.
 * @arg_startup_id: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-xfce-FileManager.CopyInto">CopyInto()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call xfdesktop_file_manager_call_copy_into_finish() to get the result of the operation.
 *
 * See xfdesktop_file_manager_call_copy_into_sync() for the synchronous, blocking version of this method.
 */
void
xfdesktop_file_manager_call_copy_into (
    XfdesktopFileManager *proxy,
    const gchar *arg_working_directory,
    const gchar *const *arg_source_filenames,
    const gchar *arg_target_filename,
    const gchar *arg_display,
    const gchar *arg_startup_id,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "CopyInto",
    g_variant_new ("(s^assss)",
                   arg_working_directory,
                   arg_source_filenames,
                   arg_target_filename,
                   arg_display,
                   arg_startup_id),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * xfdesktop_file_manager_call_copy_into_finish:
 * @proxy: A #XfdesktopFileManagerProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to xfdesktop_file_manager_call_copy_into().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with xfdesktop_file_manager_call_copy_into().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xfdesktop_file_manager_call_copy_into_finish (
    XfdesktopFileManager *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xfdesktop_file_manager_call_copy_into_sync:
 * @proxy: A #XfdesktopFileManagerProxy.
 * @arg_working_directory: Argument to pass with the method invocation.
 * @arg_source_filenames: Argument to pass with the method invocation.
 * @arg_target_filename: Argument to pass with the method invocation.
 * @arg_display: Argument to pass with the method invocation.
 * @arg_startup_id: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-xfce-FileManager.CopyInto">CopyInto()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See xfdesktop_file_manager_call_copy_into() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xfdesktop_file_manager_call_copy_into_sync (
    XfdesktopFileManager *proxy,
    const gchar *arg_working_directory,
    const gchar *const *arg_source_filenames,
    const gchar *arg_target_filename,
    const gchar *arg_display,
    const gchar *arg_startup_id,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "CopyInto",
    g_variant_new ("(s^assss)",
                   arg_working_directory,
                   arg_source_filenames,
                   arg_target_filename,
                   arg_display,
                   arg_startup_id),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xfdesktop_file_manager_call_move_into:
 * @proxy: A #XfdesktopFileManagerProxy.
 * @arg_working_directory: Argument to pass with the method invocation.
 * @arg_source_filenames: Argument to pass with the method invocation.
 * @arg_target_filename: Argument to pass with the method invocation.
 * @arg_display: Argument to pass with the method invocation.
 * @arg_startup_id: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-xfce-FileManager.MoveInto">MoveInto()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call xfdesktop_file_manager_call_move_into_finish() to get the result of the operation.
 *
 * See xfdesktop_file_manager_call_move_into_sync() for the synchronous, blocking version of this method.
 */
void
xfdesktop_file_manager_call_move_into (
    XfdesktopFileManager *proxy,
    const gchar *arg_working_directory,
    const gchar *const *arg_source_filenames,
    const gchar *arg_target_filename,
    const gchar *arg_display,
    const gchar *arg_startup_id,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "MoveInto",
    g_variant_new ("(s^assss)",
                   arg_working_directory,
                   arg_source_filenames,
                   arg_target_filename,
                   arg_display,
                   arg_startup_id),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * xfdesktop_file_manager_call_move_into_finish:
 * @proxy: A #XfdesktopFileManagerProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to xfdesktop_file_manager_call_move_into().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with xfdesktop_file_manager_call_move_into().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xfdesktop_file_manager_call_move_into_finish (
    XfdesktopFileManager *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xfdesktop_file_manager_call_move_into_sync:
 * @proxy: A #XfdesktopFileManagerProxy.
 * @arg_working_directory: Argument to pass with the method invocation.
 * @arg_source_filenames: Argument to pass with the method invocation.
 * @arg_target_filename: Argument to pass with the method invocation.
 * @arg_display: Argument to pass with the method invocation.
 * @arg_startup_id: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-xfce-FileManager.MoveInto">MoveInto()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See xfdesktop_file_manager_call_move_into() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xfdesktop_file_manager_call_move_into_sync (
    XfdesktopFileManager *proxy,
    const gchar *arg_working_directory,
    const gchar *const *arg_source_filenames,
    const gchar *arg_target_filename,
    const gchar *arg_display,
    const gchar *arg_startup_id,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "MoveInto",
    g_variant_new ("(s^assss)",
                   arg_working_directory,
                   arg_source_filenames,
                   arg_target_filename,
                   arg_display,
                   arg_startup_id),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xfdesktop_file_manager_call_link_into:
 * @proxy: A #XfdesktopFileManagerProxy.
 * @arg_working_directory: Argument to pass with the method invocation.
 * @arg_source_filenames: Argument to pass with the method invocation.
 * @arg_target_filename: Argument to pass with the method invocation.
 * @arg_display: Argument to pass with the method invocation.
 * @arg_startup_id: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-xfce-FileManager.LinkInto">LinkInto()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call xfdesktop_file_manager_call_link_into_finish() to get the result of the operation.
 *
 * See xfdesktop_file_manager_call_link_into_sync() for the synchronous, blocking version of this method.
 */
void
xfdesktop_file_manager_call_link_into (
    XfdesktopFileManager *proxy,
    const gchar *arg_working_directory,
    const gchar *const *arg_source_filenames,
    const gchar *arg_target_filename,
    const gchar *arg_display,
    const gchar *arg_startup_id,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "LinkInto",
    g_variant_new ("(s^assss)",
                   arg_working_directory,
                   arg_source_filenames,
                   arg_target_filename,
                   arg_display,
                   arg_startup_id),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * xfdesktop_file_manager_call_link_into_finish:
 * @proxy: A #XfdesktopFileManagerProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to xfdesktop_file_manager_call_link_into().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with xfdesktop_file_manager_call_link_into().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xfdesktop_file_manager_call_link_into_finish (
    XfdesktopFileManager *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xfdesktop_file_manager_call_link_into_sync:
 * @proxy: A #XfdesktopFileManagerProxy.
 * @arg_working_directory: Argument to pass with the method invocation.
 * @arg_source_filenames: Argument to pass with the method invocation.
 * @arg_target_filename: Argument to pass with the method invocation.
 * @arg_display: Argument to pass with the method invocation.
 * @arg_startup_id: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-xfce-FileManager.LinkInto">LinkInto()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See xfdesktop_file_manager_call_link_into() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xfdesktop_file_manager_call_link_into_sync (
    XfdesktopFileManager *proxy,
    const gchar *arg_working_directory,
    const gchar *const *arg_source_filenames,
    const gchar *arg_target_filename,
    const gchar *arg_display,
    const gchar *arg_startup_id,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "LinkInto",
    g_variant_new ("(s^assss)",
                   arg_working_directory,
                   arg_source_filenames,
                   arg_target_filename,
                   arg_display,
                   arg_startup_id),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xfdesktop_file_manager_call_unlink_files:
 * @proxy: A #XfdesktopFileManagerProxy.
 * @arg_working_directory: Argument to pass with the method invocation.
 * @arg_filenames: Argument to pass with the method invocation.
 * @arg_display: Argument to pass with the method invocation.
 * @arg_startup_id: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-xfce-FileManager.UnlinkFiles">UnlinkFiles()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call xfdesktop_file_manager_call_unlink_files_finish() to get the result of the operation.
 *
 * See xfdesktop_file_manager_call_unlink_files_sync() for the synchronous, blocking version of this method.
 */
void
xfdesktop_file_manager_call_unlink_files (
    XfdesktopFileManager *proxy,
    const gchar *arg_working_directory,
    const gchar *const *arg_filenames,
    const gchar *arg_display,
    const gchar *arg_startup_id,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "UnlinkFiles",
    g_variant_new ("(s^asss)",
                   arg_working_directory,
                   arg_filenames,
                   arg_display,
                   arg_startup_id),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * xfdesktop_file_manager_call_unlink_files_finish:
 * @proxy: A #XfdesktopFileManagerProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to xfdesktop_file_manager_call_unlink_files().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with xfdesktop_file_manager_call_unlink_files().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xfdesktop_file_manager_call_unlink_files_finish (
    XfdesktopFileManager *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xfdesktop_file_manager_call_unlink_files_sync:
 * @proxy: A #XfdesktopFileManagerProxy.
 * @arg_working_directory: Argument to pass with the method invocation.
 * @arg_filenames: Argument to pass with the method invocation.
 * @arg_display: Argument to pass with the method invocation.
 * @arg_startup_id: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-xfce-FileManager.UnlinkFiles">UnlinkFiles()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See xfdesktop_file_manager_call_unlink_files() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xfdesktop_file_manager_call_unlink_files_sync (
    XfdesktopFileManager *proxy,
    const gchar *arg_working_directory,
    const gchar *const *arg_filenames,
    const gchar *arg_display,
    const gchar *arg_startup_id,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "UnlinkFiles",
    g_variant_new ("(s^asss)",
                   arg_working_directory,
                   arg_filenames,
                   arg_display,
                   arg_startup_id),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xfdesktop_file_manager_call_launch_files:
 * @proxy: A #XfdesktopFileManagerProxy.
 * @arg_working_directory: Argument to pass with the method invocation.
 * @arg_filenames: Argument to pass with the method invocation.
 * @arg_display: Argument to pass with the method invocation.
 * @arg_startup_id: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-xfce-FileManager.LaunchFiles">LaunchFiles()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call xfdesktop_file_manager_call_launch_files_finish() to get the result of the operation.
 *
 * See xfdesktop_file_manager_call_launch_files_sync() for the synchronous, blocking version of this method.
 */
void
xfdesktop_file_manager_call_launch_files (
    XfdesktopFileManager *proxy,
    const gchar *arg_working_directory,
    const gchar *const *arg_filenames,
    const gchar *arg_display,
    const gchar *arg_startup_id,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "LaunchFiles",
    g_variant_new ("(s^asss)",
                   arg_working_directory,
                   arg_filenames,
                   arg_display,
                   arg_startup_id),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * xfdesktop_file_manager_call_launch_files_finish:
 * @proxy: A #XfdesktopFileManagerProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to xfdesktop_file_manager_call_launch_files().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with xfdesktop_file_manager_call_launch_files().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xfdesktop_file_manager_call_launch_files_finish (
    XfdesktopFileManager *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xfdesktop_file_manager_call_launch_files_sync:
 * @proxy: A #XfdesktopFileManagerProxy.
 * @arg_working_directory: Argument to pass with the method invocation.
 * @arg_filenames: Argument to pass with the method invocation.
 * @arg_display: Argument to pass with the method invocation.
 * @arg_startup_id: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-xfce-FileManager.LaunchFiles">LaunchFiles()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See xfdesktop_file_manager_call_launch_files() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xfdesktop_file_manager_call_launch_files_sync (
    XfdesktopFileManager *proxy,
    const gchar *arg_working_directory,
    const gchar *const *arg_filenames,
    const gchar *arg_display,
    const gchar *arg_startup_id,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "LaunchFiles",
    g_variant_new ("(s^asss)",
                   arg_working_directory,
                   arg_filenames,
                   arg_display,
                   arg_startup_id),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xfdesktop_file_manager_call_rename_file:
 * @proxy: A #XfdesktopFileManagerProxy.
 * @arg_filename: Argument to pass with the method invocation.
 * @arg_display: Argument to pass with the method invocation.
 * @arg_startup_id: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-xfce-FileManager.RenameFile">RenameFile()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call xfdesktop_file_manager_call_rename_file_finish() to get the result of the operation.
 *
 * See xfdesktop_file_manager_call_rename_file_sync() for the synchronous, blocking version of this method.
 */
void
xfdesktop_file_manager_call_rename_file (
    XfdesktopFileManager *proxy,
    const gchar *arg_filename,
    const gchar *arg_display,
    const gchar *arg_startup_id,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "RenameFile",
    g_variant_new ("(sss)",
                   arg_filename,
                   arg_display,
                   arg_startup_id),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * xfdesktop_file_manager_call_rename_file_finish:
 * @proxy: A #XfdesktopFileManagerProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to xfdesktop_file_manager_call_rename_file().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with xfdesktop_file_manager_call_rename_file().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xfdesktop_file_manager_call_rename_file_finish (
    XfdesktopFileManager *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xfdesktop_file_manager_call_rename_file_sync:
 * @proxy: A #XfdesktopFileManagerProxy.
 * @arg_filename: Argument to pass with the method invocation.
 * @arg_display: Argument to pass with the method invocation.
 * @arg_startup_id: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-xfce-FileManager.RenameFile">RenameFile()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See xfdesktop_file_manager_call_rename_file() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xfdesktop_file_manager_call_rename_file_sync (
    XfdesktopFileManager *proxy,
    const gchar *arg_filename,
    const gchar *arg_display,
    const gchar *arg_startup_id,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "RenameFile",
    g_variant_new ("(sss)",
                   arg_filename,
                   arg_display,
                   arg_startup_id),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xfdesktop_file_manager_call_create_file:
 * @proxy: A #XfdesktopFileManagerProxy.
 * @arg_parent_directory: Argument to pass with the method invocation.
 * @arg_content_type: Argument to pass with the method invocation.
 * @arg_display: Argument to pass with the method invocation.
 * @arg_startup_id: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-xfce-FileManager.CreateFile">CreateFile()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call xfdesktop_file_manager_call_create_file_finish() to get the result of the operation.
 *
 * See xfdesktop_file_manager_call_create_file_sync() for the synchronous, blocking version of this method.
 */
void
xfdesktop_file_manager_call_create_file (
    XfdesktopFileManager *proxy,
    const gchar *arg_parent_directory,
    const gchar *arg_content_type,
    const gchar *arg_display,
    const gchar *arg_startup_id,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "CreateFile",
    g_variant_new ("(ssss)",
                   arg_parent_directory,
                   arg_content_type,
                   arg_display,
                   arg_startup_id),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * xfdesktop_file_manager_call_create_file_finish:
 * @proxy: A #XfdesktopFileManagerProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to xfdesktop_file_manager_call_create_file().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with xfdesktop_file_manager_call_create_file().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xfdesktop_file_manager_call_create_file_finish (
    XfdesktopFileManager *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xfdesktop_file_manager_call_create_file_sync:
 * @proxy: A #XfdesktopFileManagerProxy.
 * @arg_parent_directory: Argument to pass with the method invocation.
 * @arg_content_type: Argument to pass with the method invocation.
 * @arg_display: Argument to pass with the method invocation.
 * @arg_startup_id: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-xfce-FileManager.CreateFile">CreateFile()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See xfdesktop_file_manager_call_create_file() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xfdesktop_file_manager_call_create_file_sync (
    XfdesktopFileManager *proxy,
    const gchar *arg_parent_directory,
    const gchar *arg_content_type,
    const gchar *arg_display,
    const gchar *arg_startup_id,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "CreateFile",
    g_variant_new ("(ssss)",
                   arg_parent_directory,
                   arg_content_type,
                   arg_display,
                   arg_startup_id),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xfdesktop_file_manager_call_create_file_from_template:
 * @proxy: A #XfdesktopFileManagerProxy.
 * @arg_parent_directory: Argument to pass with the method invocation.
 * @arg_template_uri: Argument to pass with the method invocation.
 * @arg_display: Argument to pass with the method invocation.
 * @arg_startup_id: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-xfce-FileManager.CreateFileFromTemplate">CreateFileFromTemplate()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call xfdesktop_file_manager_call_create_file_from_template_finish() to get the result of the operation.
 *
 * See xfdesktop_file_manager_call_create_file_from_template_sync() for the synchronous, blocking version of this method.
 */
void
xfdesktop_file_manager_call_create_file_from_template (
    XfdesktopFileManager *proxy,
    const gchar *arg_parent_directory,
    const gchar *arg_template_uri,
    const gchar *arg_display,
    const gchar *arg_startup_id,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "CreateFileFromTemplate",
    g_variant_new ("(ssss)",
                   arg_parent_directory,
                   arg_template_uri,
                   arg_display,
                   arg_startup_id),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * xfdesktop_file_manager_call_create_file_from_template_finish:
 * @proxy: A #XfdesktopFileManagerProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to xfdesktop_file_manager_call_create_file_from_template().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with xfdesktop_file_manager_call_create_file_from_template().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xfdesktop_file_manager_call_create_file_from_template_finish (
    XfdesktopFileManager *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xfdesktop_file_manager_call_create_file_from_template_sync:
 * @proxy: A #XfdesktopFileManagerProxy.
 * @arg_parent_directory: Argument to pass with the method invocation.
 * @arg_template_uri: Argument to pass with the method invocation.
 * @arg_display: Argument to pass with the method invocation.
 * @arg_startup_id: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-xfce-FileManager.CreateFileFromTemplate">CreateFileFromTemplate()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See xfdesktop_file_manager_call_create_file_from_template() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xfdesktop_file_manager_call_create_file_from_template_sync (
    XfdesktopFileManager *proxy,
    const gchar *arg_parent_directory,
    const gchar *arg_template_uri,
    const gchar *arg_display,
    const gchar *arg_startup_id,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "CreateFileFromTemplate",
    g_variant_new ("(ssss)",
                   arg_parent_directory,
                   arg_template_uri,
                   arg_display,
                   arg_startup_id),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xfdesktop_file_manager_complete_display_application_chooser_dialog:
 * @object: A #XfdesktopFileManager.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-xfce-FileManager.DisplayApplicationChooserDialog">DisplayApplicationChooserDialog()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
xfdesktop_file_manager_complete_display_application_chooser_dialog (
    XfdesktopFileManager *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * xfdesktop_file_manager_complete_display_folder:
 * @object: A #XfdesktopFileManager.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-xfce-FileManager.DisplayFolder">DisplayFolder()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
xfdesktop_file_manager_complete_display_folder (
    XfdesktopFileManager *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * xfdesktop_file_manager_complete_display_folder_and_select:
 * @object: A #XfdesktopFileManager.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-xfce-FileManager.DisplayFolderAndSelect">DisplayFolderAndSelect()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
xfdesktop_file_manager_complete_display_folder_and_select (
    XfdesktopFileManager *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * xfdesktop_file_manager_complete_display_file_properties:
 * @object: A #XfdesktopFileManager.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-xfce-FileManager.DisplayFileProperties">DisplayFileProperties()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
xfdesktop_file_manager_complete_display_file_properties (
    XfdesktopFileManager *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * xfdesktop_file_manager_complete_launch:
 * @object: A #XfdesktopFileManager.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-xfce-FileManager.Launch">Launch()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
xfdesktop_file_manager_complete_launch (
    XfdesktopFileManager *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * xfdesktop_file_manager_complete_execute:
 * @object: A #XfdesktopFileManager.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-xfce-FileManager.Execute">Execute()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
xfdesktop_file_manager_complete_execute (
    XfdesktopFileManager *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * xfdesktop_file_manager_complete_display_preferences_dialog:
 * @object: A #XfdesktopFileManager.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-xfce-FileManager.DisplayPreferencesDialog">DisplayPreferencesDialog()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
xfdesktop_file_manager_complete_display_preferences_dialog (
    XfdesktopFileManager *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * xfdesktop_file_manager_complete_copy_to:
 * @object: A #XfdesktopFileManager.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-xfce-FileManager.CopyTo">CopyTo()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
xfdesktop_file_manager_complete_copy_to (
    XfdesktopFileManager *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * xfdesktop_file_manager_complete_copy_into:
 * @object: A #XfdesktopFileManager.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-xfce-FileManager.CopyInto">CopyInto()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
xfdesktop_file_manager_complete_copy_into (
    XfdesktopFileManager *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * xfdesktop_file_manager_complete_move_into:
 * @object: A #XfdesktopFileManager.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-xfce-FileManager.MoveInto">MoveInto()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
xfdesktop_file_manager_complete_move_into (
    XfdesktopFileManager *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * xfdesktop_file_manager_complete_link_into:
 * @object: A #XfdesktopFileManager.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-xfce-FileManager.LinkInto">LinkInto()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
xfdesktop_file_manager_complete_link_into (
    XfdesktopFileManager *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * xfdesktop_file_manager_complete_unlink_files:
 * @object: A #XfdesktopFileManager.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-xfce-FileManager.UnlinkFiles">UnlinkFiles()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
xfdesktop_file_manager_complete_unlink_files (
    XfdesktopFileManager *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * xfdesktop_file_manager_complete_launch_files:
 * @object: A #XfdesktopFileManager.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-xfce-FileManager.LaunchFiles">LaunchFiles()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
xfdesktop_file_manager_complete_launch_files (
    XfdesktopFileManager *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * xfdesktop_file_manager_complete_rename_file:
 * @object: A #XfdesktopFileManager.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-xfce-FileManager.RenameFile">RenameFile()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
xfdesktop_file_manager_complete_rename_file (
    XfdesktopFileManager *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * xfdesktop_file_manager_complete_create_file:
 * @object: A #XfdesktopFileManager.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-xfce-FileManager.CreateFile">CreateFile()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
xfdesktop_file_manager_complete_create_file (
    XfdesktopFileManager *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * xfdesktop_file_manager_complete_create_file_from_template:
 * @object: A #XfdesktopFileManager.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-xfce-FileManager.CreateFileFromTemplate">CreateFileFromTemplate()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
xfdesktop_file_manager_complete_create_file_from_template (
    XfdesktopFileManager *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/* ------------------------------------------------------------------------ */

/**
 * XfdesktopFileManagerProxy:
 *
 * The #XfdesktopFileManagerProxy structure contains only private data and should only be accessed using the provided API.
 */

/**
 * XfdesktopFileManagerProxyClass:
 * @parent_class: The parent class.
 *
 * Class structure for #XfdesktopFileManagerProxy.
 */

struct _XfdesktopFileManagerProxyPrivate
{
  GData *qdata;
};

static void xfdesktop_file_manager_proxy_iface_init (XfdesktopFileManagerIface *iface);

#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (XfdesktopFileManagerProxy, xfdesktop_file_manager_proxy, G_TYPE_DBUS_PROXY,
                         G_ADD_PRIVATE (XfdesktopFileManagerProxy)
                         G_IMPLEMENT_INTERFACE (XFDESKTOP_TYPE_FILE_MANAGER, xfdesktop_file_manager_proxy_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (XfdesktopFileManagerProxy, xfdesktop_file_manager_proxy, G_TYPE_DBUS_PROXY,
                         G_IMPLEMENT_INTERFACE (XFDESKTOP_TYPE_FILE_MANAGER, xfdesktop_file_manager_proxy_iface_init))

#endif
static void
xfdesktop_file_manager_proxy_finalize (GObject *object)
{
  XfdesktopFileManagerProxy *proxy = XFDESKTOP_FILE_MANAGER_PROXY (object);
  g_datalist_clear (&proxy->priv->qdata);
  G_OBJECT_CLASS (xfdesktop_file_manager_proxy_parent_class)->finalize (object);
}

static void
xfdesktop_file_manager_proxy_get_property (GObject      *object G_GNUC_UNUSED,
  guint         prop_id G_GNUC_UNUSED,
  GValue       *value G_GNUC_UNUSED,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
}

static void
xfdesktop_file_manager_proxy_set_property (GObject      *object G_GNUC_UNUSED,
  guint         prop_id G_GNUC_UNUSED,
  const GValue *value G_GNUC_UNUSED,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
}

static void
xfdesktop_file_manager_proxy_g_signal (GDBusProxy *proxy,
  const gchar *sender_name G_GNUC_UNUSED,
  const gchar *signal_name,
  GVariant *parameters)
{
  _ExtendedGDBusSignalInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  gsize n;
  guint signal_id;
  info = (_ExtendedGDBusSignalInfo *) g_dbus_interface_info_lookup_signal ((GDBusInterfaceInfo *) &_xfdesktop_file_manager_interface_info.parent_struct, signal_name);
  if (info == NULL)
    return;
  num_params = g_variant_n_children (parameters);
  paramv = g_new0 (GValue, num_params + 1);
  g_value_init (&paramv[0], XFDESKTOP_TYPE_FILE_MANAGER);
  g_value_set_object (&paramv[0], proxy);
  g_variant_iter_init (&iter, parameters);
  n = 1;
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.args[n - 1];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, XFDESKTOP_TYPE_FILE_MANAGER);
  g_signal_emitv (paramv, signal_id, 0, NULL);
  for (n = 0; n < num_params + 1; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static void
xfdesktop_file_manager_proxy_g_properties_changed (GDBusProxy *_proxy,
  GVariant *changed_properties,
  const gchar *const *invalidated_properties)
{
  XfdesktopFileManagerProxy *proxy = XFDESKTOP_FILE_MANAGER_PROXY (_proxy);
  guint n;
  const gchar *key;
  GVariantIter *iter;
  _ExtendedGDBusPropertyInfo *info;
  g_variant_get (changed_properties, "a{sv}", &iter);
  while (g_variant_iter_next (iter, "{&sv}", &key, NULL))
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_xfdesktop_file_manager_interface_info.parent_struct, key);
      g_datalist_remove_data (&proxy->priv->qdata, key);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
  g_variant_iter_free (iter);
  for (n = 0; invalidated_properties[n] != NULL; n++)
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_xfdesktop_file_manager_interface_info.parent_struct, invalidated_properties[n]);
      g_datalist_remove_data (&proxy->priv->qdata, invalidated_properties[n]);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
}

static void
xfdesktop_file_manager_proxy_init (XfdesktopFileManagerProxy *proxy)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  proxy->priv = xfdesktop_file_manager_proxy_get_instance_private (proxy);
#else
  proxy->priv = G_TYPE_INSTANCE_GET_PRIVATE (proxy, XFDESKTOP_TYPE_FILE_MANAGER_PROXY, XfdesktopFileManagerProxyPrivate);
#endif

  g_dbus_proxy_set_interface_info (G_DBUS_PROXY (proxy), xfdesktop_file_manager_interface_info ());
}

static void
xfdesktop_file_manager_proxy_class_init (XfdesktopFileManagerProxyClass *klass)
{
  GObjectClass *gobject_class;
  GDBusProxyClass *proxy_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize     = xfdesktop_file_manager_proxy_finalize;
  gobject_class->get_property = xfdesktop_file_manager_proxy_get_property;
  gobject_class->set_property = xfdesktop_file_manager_proxy_set_property;

  proxy_class = G_DBUS_PROXY_CLASS (klass);
  proxy_class->g_signal = xfdesktop_file_manager_proxy_g_signal;
  proxy_class->g_properties_changed = xfdesktop_file_manager_proxy_g_properties_changed;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (XfdesktopFileManagerProxyPrivate));
#endif
}

static void
xfdesktop_file_manager_proxy_iface_init (XfdesktopFileManagerIface *iface G_GNUC_UNUSED)
{
}

/**
 * xfdesktop_file_manager_proxy_new:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-xfce-FileManager.top_of_page">org.xfce.FileManager</link>. See g_dbus_proxy_new() for more details.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call xfdesktop_file_manager_proxy_new_finish() to get the result of the operation.
 *
 * See xfdesktop_file_manager_proxy_new_sync() for the synchronous, blocking version of this constructor.
 */
void
xfdesktop_file_manager_proxy_new (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (XFDESKTOP_TYPE_FILE_MANAGER_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.xfce.FileManager", NULL);
}

/**
 * xfdesktop_file_manager_proxy_new_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to xfdesktop_file_manager_proxy_new().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with xfdesktop_file_manager_proxy_new().
 *
 * Returns: (transfer full) (type XfdesktopFileManagerProxy): The constructed proxy object or %NULL if @error is set.
 */
XfdesktopFileManager *
xfdesktop_file_manager_proxy_new_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return XFDESKTOP_FILE_MANAGER (ret);
  else
    return NULL;
}

/**
 * xfdesktop_file_manager_proxy_new_sync:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Synchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-xfce-FileManager.top_of_page">org.xfce.FileManager</link>. See g_dbus_proxy_new_sync() for more details.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See xfdesktop_file_manager_proxy_new() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type XfdesktopFileManagerProxy): The constructed proxy object or %NULL if @error is set.
 */
XfdesktopFileManager *
xfdesktop_file_manager_proxy_new_sync (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (XFDESKTOP_TYPE_FILE_MANAGER_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.xfce.FileManager", NULL);
  if (ret != NULL)
    return XFDESKTOP_FILE_MANAGER (ret);
  else
    return NULL;
}


/**
 * xfdesktop_file_manager_proxy_new_for_bus:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Like xfdesktop_file_manager_proxy_new() but takes a #GBusType instead of a #GDBusConnection.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call xfdesktop_file_manager_proxy_new_for_bus_finish() to get the result of the operation.
 *
 * See xfdesktop_file_manager_proxy_new_for_bus_sync() for the synchronous, blocking version of this constructor.
 */
void
xfdesktop_file_manager_proxy_new_for_bus (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (XFDESKTOP_TYPE_FILE_MANAGER_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.xfce.FileManager", NULL);
}

/**
 * xfdesktop_file_manager_proxy_new_for_bus_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to xfdesktop_file_manager_proxy_new_for_bus().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with xfdesktop_file_manager_proxy_new_for_bus().
 *
 * Returns: (transfer full) (type XfdesktopFileManagerProxy): The constructed proxy object or %NULL if @error is set.
 */
XfdesktopFileManager *
xfdesktop_file_manager_proxy_new_for_bus_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return XFDESKTOP_FILE_MANAGER (ret);
  else
    return NULL;
}

/**
 * xfdesktop_file_manager_proxy_new_for_bus_sync:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Like xfdesktop_file_manager_proxy_new_sync() but takes a #GBusType instead of a #GDBusConnection.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See xfdesktop_file_manager_proxy_new_for_bus() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type XfdesktopFileManagerProxy): The constructed proxy object or %NULL if @error is set.
 */
XfdesktopFileManager *
xfdesktop_file_manager_proxy_new_for_bus_sync (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (XFDESKTOP_TYPE_FILE_MANAGER_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.xfce.FileManager", NULL);
  if (ret != NULL)
    return XFDESKTOP_FILE_MANAGER (ret);
  else
    return NULL;
}


/* ------------------------------------------------------------------------ */

/**
 * XfdesktopFileManagerSkeleton:
 *
 * The #XfdesktopFileManagerSkeleton structure contains only private data and should only be accessed using the provided API.
 */

/**
 * XfdesktopFileManagerSkeletonClass:
 * @parent_class: The parent class.
 *
 * Class structure for #XfdesktopFileManagerSkeleton.
 */

struct _XfdesktopFileManagerSkeletonPrivate
{
  GValue *properties;
  GList *changed_properties;
  GSource *changed_properties_idle_source;
  GMainContext *context;
  GMutex lock;
};

static void
_xfdesktop_file_manager_skeleton_handle_method_call (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name,
  const gchar *method_name,
  GVariant *parameters,
  GDBusMethodInvocation *invocation,
  gpointer user_data)
{
  XfdesktopFileManagerSkeleton *skeleton = XFDESKTOP_FILE_MANAGER_SKELETON (user_data);
  _ExtendedGDBusMethodInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  guint num_extra;
  gsize n;
  guint signal_id;
  GValue return_value = G_VALUE_INIT;
  info = (_ExtendedGDBusMethodInfo *) g_dbus_method_invocation_get_method_info (invocation);
  g_assert (info != NULL);
  num_params = g_variant_n_children (parameters);
  num_extra = info->pass_fdlist ? 3 : 2;  paramv = g_new0 (GValue, num_params + num_extra);
  n = 0;
  g_value_init (&paramv[n], XFDESKTOP_TYPE_FILE_MANAGER);
  g_value_set_object (&paramv[n++], skeleton);
  g_value_init (&paramv[n], G_TYPE_DBUS_METHOD_INVOCATION);
  g_value_set_object (&paramv[n++], invocation);
  if (info->pass_fdlist)
    {
#ifdef G_OS_UNIX
      g_value_init (&paramv[n], G_TYPE_UNIX_FD_LIST);
      g_value_set_object (&paramv[n++], g_dbus_message_get_unix_fd_list (g_dbus_method_invocation_get_message (invocation)));
#else
      g_assert_not_reached ();
#endif
    }
  g_variant_iter_init (&iter, parameters);
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.in_args[n - num_extra];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, XFDESKTOP_TYPE_FILE_MANAGER);
  g_value_init (&return_value, G_TYPE_BOOLEAN);
  g_signal_emitv (paramv, signal_id, 0, &return_value);
  if (!g_value_get_boolean (&return_value))
    g_dbus_method_invocation_return_error (invocation, G_DBUS_ERROR, G_DBUS_ERROR_UNKNOWN_METHOD, "Method %s is not implemented on interface %s", method_name, interface_name);
  g_value_unset (&return_value);
  for (n = 0; n < num_params + num_extra; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static GVariant *
_xfdesktop_file_manager_skeleton_handle_get_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GError **error,
  gpointer user_data)
{
  XfdesktopFileManagerSkeleton *skeleton = XFDESKTOP_FILE_MANAGER_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  GVariant *ret;
  ret = NULL;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_xfdesktop_file_manager_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      g_value_init (&value, pspec->value_type);
      g_object_get_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      ret = g_dbus_gvalue_to_gvariant (&value, G_VARIANT_TYPE (info->parent_struct.signature));
      g_value_unset (&value);
    }
  return ret;
}

static gboolean
_xfdesktop_file_manager_skeleton_handle_set_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GVariant *variant,
  GError **error,
  gpointer user_data)
{
  XfdesktopFileManagerSkeleton *skeleton = XFDESKTOP_FILE_MANAGER_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  gboolean ret;
  ret = FALSE;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_xfdesktop_file_manager_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      if (info->use_gvariant)
        g_value_set_variant (&value, variant);
      else
        g_dbus_gvariant_to_gvalue (variant, &value);
      g_object_set_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      g_value_unset (&value);
      ret = TRUE;
    }
  return ret;
}

static const GDBusInterfaceVTable _xfdesktop_file_manager_skeleton_vtable =
{
  _xfdesktop_file_manager_skeleton_handle_method_call,
  _xfdesktop_file_manager_skeleton_handle_get_property,
  _xfdesktop_file_manager_skeleton_handle_set_property,
  {NULL}
};

static GDBusInterfaceInfo *
xfdesktop_file_manager_skeleton_dbus_interface_get_info (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return xfdesktop_file_manager_interface_info ();
}

static GDBusInterfaceVTable *
xfdesktop_file_manager_skeleton_dbus_interface_get_vtable (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return (GDBusInterfaceVTable *) &_xfdesktop_file_manager_skeleton_vtable;
}

static GVariant *
xfdesktop_file_manager_skeleton_dbus_interface_get_properties (GDBusInterfaceSkeleton *_skeleton)
{
  XfdesktopFileManagerSkeleton *skeleton = XFDESKTOP_FILE_MANAGER_SKELETON (_skeleton);

  GVariantBuilder builder;
  guint n;
  g_variant_builder_init (&builder, G_VARIANT_TYPE ("a{sv}"));
  if (_xfdesktop_file_manager_interface_info.parent_struct.properties == NULL)
    goto out;
  for (n = 0; _xfdesktop_file_manager_interface_info.parent_struct.properties[n] != NULL; n++)
    {
      GDBusPropertyInfo *info = _xfdesktop_file_manager_interface_info.parent_struct.properties[n];
      if (info->flags & G_DBUS_PROPERTY_INFO_FLAGS_READABLE)
        {
          GVariant *value;
          value = _xfdesktop_file_manager_skeleton_handle_get_property (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)), NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.xfce.FileManager", info->name, NULL, skeleton);
          if (value != NULL)
            {
              g_variant_take_ref (value);
              g_variant_builder_add (&builder, "{sv}", info->name, value);
              g_variant_unref (value);
            }
        }
    }
out:
  return g_variant_builder_end (&builder);
}

static void
xfdesktop_file_manager_skeleton_dbus_interface_flush (GDBusInterfaceSkeleton *_skeleton G_GNUC_UNUSED)
{
}

static void xfdesktop_file_manager_skeleton_iface_init (XfdesktopFileManagerIface *iface);
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (XfdesktopFileManagerSkeleton, xfdesktop_file_manager_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_ADD_PRIVATE (XfdesktopFileManagerSkeleton)
                         G_IMPLEMENT_INTERFACE (XFDESKTOP_TYPE_FILE_MANAGER, xfdesktop_file_manager_skeleton_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (XfdesktopFileManagerSkeleton, xfdesktop_file_manager_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_IMPLEMENT_INTERFACE (XFDESKTOP_TYPE_FILE_MANAGER, xfdesktop_file_manager_skeleton_iface_init))

#endif
static void
xfdesktop_file_manager_skeleton_finalize (GObject *object)
{
  XfdesktopFileManagerSkeleton *skeleton = XFDESKTOP_FILE_MANAGER_SKELETON (object);
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    g_source_destroy (skeleton->priv->changed_properties_idle_source);
  g_main_context_unref (skeleton->priv->context);
  g_mutex_clear (&skeleton->priv->lock);
  G_OBJECT_CLASS (xfdesktop_file_manager_skeleton_parent_class)->finalize (object);
}

static void
xfdesktop_file_manager_skeleton_init (XfdesktopFileManagerSkeleton *skeleton)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  skeleton->priv = xfdesktop_file_manager_skeleton_get_instance_private (skeleton);
#else
  skeleton->priv = G_TYPE_INSTANCE_GET_PRIVATE (skeleton, XFDESKTOP_TYPE_FILE_MANAGER_SKELETON, XfdesktopFileManagerSkeletonPrivate);
#endif

  g_mutex_init (&skeleton->priv->lock);
  skeleton->priv->context = g_main_context_ref_thread_default ();
}

static void
xfdesktop_file_manager_skeleton_class_init (XfdesktopFileManagerSkeletonClass *klass)
{
  GObjectClass *gobject_class;
  GDBusInterfaceSkeletonClass *skeleton_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize = xfdesktop_file_manager_skeleton_finalize;

  skeleton_class = G_DBUS_INTERFACE_SKELETON_CLASS (klass);
  skeleton_class->get_info = xfdesktop_file_manager_skeleton_dbus_interface_get_info;
  skeleton_class->get_properties = xfdesktop_file_manager_skeleton_dbus_interface_get_properties;
  skeleton_class->flush = xfdesktop_file_manager_skeleton_dbus_interface_flush;
  skeleton_class->get_vtable = xfdesktop_file_manager_skeleton_dbus_interface_get_vtable;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (XfdesktopFileManagerSkeletonPrivate));
#endif
}

static void
xfdesktop_file_manager_skeleton_iface_init (XfdesktopFileManagerIface *iface G_GNUC_UNUSED)
{
}

/**
 * xfdesktop_file_manager_skeleton_new:
 *
 * Creates a skeleton object for the D-Bus interface <link linkend="gdbus-interface-org-xfce-FileManager.top_of_page">org.xfce.FileManager</link>.
 *
 * Returns: (transfer full) (type XfdesktopFileManagerSkeleton): The skeleton object.
 */
XfdesktopFileManager *
xfdesktop_file_manager_skeleton_new (void)
{
  return XFDESKTOP_FILE_MANAGER (g_object_new (XFDESKTOP_TYPE_FILE_MANAGER_SKELETON, NULL));
}

