/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.viewer;

import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.text.DateFormat;
import java.util.Date;
import java.util.Hashtable;
import java.util.Vector;
import java.util.zip.GZIPInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.jmol.api.JmolFileReaderInterface;
import org.jmol.api.JmolViewer;
import org.jmol.util.BinaryDocument;
import org.jmol.util.CompoundDocument;
import org.jmol.util.Logger;
import org.jmol.util.Parser;
import org.jmol.util.TextFormat;
import org.jmol.util.ZipUtil;
import org.jmol.viewer.JmolConstants;
import org.jmol.viewer.Viewer;

public class FileManager {
    protected Viewer viewer;
    private String loadScript;
    private String nameAsGiven = "zapped";
    private String fullPathName;
    private String fileName;
    private String inlineData;
    private URL appletDocumentBase = null;
    private URL appletCodeBase = null;
    private String appletProxy;
    private static final int URL_LOCAL = 3;
    private static final String[] urlPrefixes = new String[]{"http:", "https:", "ftp:", "file:"};
    private static final String[] urlPrefixPairs = new String[]{"http:", "http://", "www.", "http://www.", "https:", "https://", "ftp:", "ftp://", "file:", "file:///"};
    private static String[] scriptFilePrefixes = new String[]{"/*file*/\"", "FILE0=\"", "FILE1=\""};

    FileManager(Viewer viewer) {
        this.viewer = viewer;
        this.clear();
    }

    void clear() {
        this.setLoadScript("", false);
        this.nameAsGiven = "zapped";
        this.fileName = "zapped";
        this.fullPathName = "zapped";
    }

    String getLoadScript() {
        return this.loadScript;
    }

    private void setLoadScript(String string, boolean bl) {
        if (this.loadScript == null || !bl) {
            this.loadScript = "";
        }
        this.loadScript = this.loadScript + this.viewer.getLoadState();
        this.addLoadScript(string);
    }

    void addLoadScript(String string) {
        if (string == null) {
            return;
        }
        if (string.equals("-")) {
            this.loadScript = "";
            return;
        }
        this.loadScript = this.loadScript + "  " + string + ";\n";
    }

    void setFileInfo(String[] stringArray) {
        this.fullPathName = stringArray[0];
        this.fileName = stringArray[1];
        this.nameAsGiven = stringArray[2];
        this.inlineData = stringArray[3];
        this.loadScript = stringArray[4];
    }

    String[] getFileInfo() {
        return new String[]{this.fullPathName, this.fileName, this.nameAsGiven, this.inlineData, this.loadScript};
    }

    String getFullPathName() {
        return this.fullPathName != null ? this.fullPathName : this.nameAsGiven;
    }

    String getFileName() {
        return this.fileName != null ? this.fileName : this.nameAsGiven;
    }

    String getInlineData(int n) {
        return n < 0 ? this.inlineData : "";
    }

    String getAppletDocumentBase() {
        return this.appletDocumentBase == null ? "" : this.appletDocumentBase.toString();
    }

    void setAppletContext(URL uRL, URL uRL2, String string) {
        this.appletDocumentBase = uRL;
        this.appletCodeBase = uRL2;
        this.appletProxy = string;
        Logger.info("appletDocumentBase=" + this.appletDocumentBase + "\nappletCodeBase=" + this.appletCodeBase);
    }

    void setAppletProxy(String string) {
        this.appletProxy = string == null || string.length() == 0 ? null : string;
    }

    String getState(StringBuffer stringBuffer) {
        StringBuffer stringBuffer2 = new StringBuffer();
        if (stringBuffer != null) {
            stringBuffer.append("  _setFileState;\n");
            stringBuffer2.append("function _setFileState() {\n\n");
        }
        stringBuffer2.append(this.loadScript);
        if (this.viewer.getModelSetFileName().equals("zapped")) {
            stringBuffer2.append("  zap;\n");
        }
        if (stringBuffer != null) {
            stringBuffer2.append("\n}\n\n");
        }
        return stringBuffer2.toString();
    }

    String getFileTypeName(String string) {
        int n = string.indexOf("::");
        if (n >= 0) {
            return string.substring(0, n);
        }
        if (string.startsWith("=")) {
            return "pdb";
        }
        Object object = this.getUnzippedBufferedReaderOrErrorMessageFromName(string, true, false, true, true);
        if (object instanceof BufferedReader) {
            return this.viewer.getModelAdapter().getFileTypeName((BufferedReader)object);
        }
        if (object instanceof ZipInputStream) {
            String string2 = this.getZipDirectoryAsString(string);
            if (string2.indexOf("JmolManifest") >= 0) {
                return "Jmol";
            }
            return this.viewer.getModelAdapter().getFileTypeName(FileManager.getBufferedReaderForString(string2));
        }
        if (object instanceof String[]) {
            return ((String[])object)[0];
        }
        return null;
    }

    private static BufferedReader getBufferedReaderForString(String string) {
        return new BufferedReader(new StringReader(string));
    }

    private String getZipDirectoryAsString(String string) {
        return ZipUtil.getZipDirectoryAsStringAndClose((InputStream)this.getInputStreamOrErrorMessageFromName(string, false, false));
    }

    Object createAtomSetCollectionFromFile(String string, Hashtable hashtable, String string2, boolean bl) {
        int n;
        if (hashtable.get("atomDataOnly") == null) {
            this.setLoadScript(string2, bl);
        }
        this.nameAsGiven = (n = string.indexOf("::")) >= 0 ? string.substring(n + 2) : string;
        String string3 = n >= 0 ? string.substring(0, n) : null;
        Logger.info("\nFileManager.getAtomSetCollectionFromFile(" + this.nameAsGiven + ")" + (string.equals(this.nameAsGiven) ? "" : " //" + string));
        this.fullPathName = null;
        this.fileName = null;
        String[] stringArray = this.classifyName(this.nameAsGiven, true);
        if (stringArray.length == 1) {
            return stringArray[0];
        }
        this.fullPathName = stringArray[0];
        this.fileName = stringArray[1];
        hashtable.put("fullPathName", (string3 == null ? "" : string3 + "::") + this.fullPathName.replace('\\', '/'));
        if (this.viewer.getMessageStyleChime() && this.viewer.getDebugScript()) {
            this.viewer.scriptStatus("Requesting " + this.fullPathName);
        }
        FileReader fileReader = new FileReader(this.fullPathName, this.nameAsGiven, string3, null, hashtable);
        fileReader.run();
        return fileReader.atomSetCollection;
    }

    Object createAtomSetCollectionFromFiles(String[] stringArray, String string, boolean bl, Hashtable hashtable) {
        this.setLoadScript(string, bl);
        String[] stringArray2 = new String[stringArray.length];
        String[] stringArray3 = new String[stringArray.length];
        String[] stringArray4 = new String[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            int n = stringArray[i].indexOf("::");
            this.nameAsGiven = n >= 0 ? stringArray[i].substring(n + 2) : stringArray[i];
            String string2 = n >= 0 ? stringArray[i].substring(0, n) : null;
            String[] stringArray5 = this.classifyName(this.nameAsGiven, true);
            if (stringArray5.length == 1) {
                return stringArray5[0];
            }
            stringArray2[i] = stringArray5[0];
            stringArray[i] = stringArray5[0].replace('\\', '/');
            stringArray4[i] = string2;
            stringArray3[i] = this.nameAsGiven;
        }
        this.nameAsGiven = "file[]";
        this.fileName = "file[]";
        this.fullPathName = "file[]";
        this.inlineData = "";
        FilesReader filesReader = new FilesReader(stringArray2, stringArray3, stringArray4, null, hashtable);
        filesReader.run();
        return filesReader.atomSetCollection;
    }

    Object createAtomSetCollectionFromString(String string, Hashtable hashtable, boolean bl) {
        String string2 = bl ? "append" : "model";
        String string3 = "data \"" + string2 + " inline\"\n" + string + "end \"" + string2 + " inline\";";
        this.setLoadScript(string3, bl);
        Logger.info("FileManager.getAtomSetCollectionFromString()");
        if (!bl) {
            this.fileName = "string";
            this.fullPathName = "string";
            if (this.viewer.getPreserveState()) {
                this.inlineData = string;
            }
        }
        FileReader fileReader = new FileReader("string", "string", null, FileManager.getBufferedReaderForString(string), hashtable);
        fileReader.run();
        return fileReader.atomSetCollection;
    }

    Object createAtomSeCollectionFromStrings(String[] stringArray, Hashtable hashtable, boolean bl) {
        String string = "\"" + this.viewer.getDataSeparator() + "\"";
        String string2 = "\"" + (bl ? "append" : "model") + " inline\"";
        StringBuffer stringBuffer = new StringBuffer("set dataSeparator \"~~~next file~~~\";\ndata ");
        stringBuffer.append(string2);
        for (int i = 0; i < stringArray.length; ++i) {
            if (i > 0) {
                stringBuffer.append("~~~next file~~~");
            }
            stringBuffer.append(stringArray[i]);
        }
        stringBuffer.append("end ").append(string2).append(";set dataSeparator ").append(string);
        this.setLoadScript(stringBuffer.toString(), bl);
        Logger.info("FileManager.getAtomSetCollectionFromStrings(string[])");
        this.fileName = "string[]";
        this.fullPathName = "string[]";
        this.inlineData = "";
        String[] stringArray2 = new String[stringArray.length];
        DataReader[] dataReaderArray = new StringDataReader[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray2[i] = "string[" + i + "]";
            dataReaderArray[i] = new StringDataReader(stringArray[i]);
        }
        FilesReader filesReader = new FilesReader(stringArray2, stringArray2, null, dataReaderArray, null);
        filesReader.run();
        return filesReader.atomSetCollection;
    }

    Object createAtomSeCollectionFromArrayData(Vector vector, Hashtable hashtable, boolean bl) {
        Logger.info("FileManager.getAtomSetCollectionFromArrayData(Vector)");
        this.fileName = "String[]";
        this.fullPathName = "String[]";
        this.inlineData = "";
        int n = vector.size();
        String[] stringArray = new String[n];
        DataReader[] dataReaderArray = new DataReader[n];
        for (int i = 0; i < n; ++i) {
            stringArray[i] = "String[" + i + "]";
            Object e = vector.get(i);
            if (e instanceof String) {
                dataReaderArray[i] = new StringDataReader((String)vector.get(i));
                continue;
            }
            if (e instanceof String[]) {
                dataReaderArray[i] = new ArrayDataReader((String[])vector.get(i));
                continue;
            }
            if (!(e instanceof Vector)) continue;
            dataReaderArray[i] = new VectorDataReader((Vector)vector.get(i));
        }
        FilesReader filesReader = new FilesReader(stringArray, stringArray, null, dataReaderArray, null);
        filesReader.run();
        return filesReader.atomSetCollection;
    }

    Object createAtomSetCollectionFromDOM(Object object, Hashtable hashtable) {
        this.inlineData = "";
        this.fileName = "JSNode";
        this.fullPathName = "JSNode";
        DOMReader dOMReader = new DOMReader(object, hashtable);
        dOMReader.run();
        return dOMReader.atomSetCollection;
    }

    Object createAtomSetCollectionFromReader(String string, String string2, Reader reader, Hashtable hashtable) {
        this.fullPathName = string;
        this.fileName = string2;
        FileReader fileReader = new FileReader(string, string, null, new BufferedReader(reader), hashtable);
        fileReader.run();
        return fileReader.atomSetCollection;
    }

    BufferedInputStream getBufferedInputStream(String string) {
        Object object = this.getBufferedReaderOrErrorMessageFromName(string, new String[2], true, true);
        return object instanceof BufferedInputStream ? (BufferedInputStream)object : null;
    }

    Object getInputStreamOrErrorMessageFromName(String string, boolean bl, boolean bl2) {
        String string2 = null;
        int n = urlPrefixes.length;
        while (--n >= 0 && !string.startsWith(urlPrefixes[n])) {
        }
        boolean bl3 = n >= 0;
        boolean bl4 = this.appletDocumentBase != null;
        InputStream inputStream = null;
        try {
            if (bl4 || bl3) {
                if (bl4 && bl3 && this.appletProxy != null) {
                    string = this.appletProxy + "?url=" + URLEncoder.encode(string, "utf-8");
                }
                URL uRL = bl4 ? new URL(this.appletDocumentBase, string) : new URL(string);
                string = uRL.toString();
                if (bl) {
                    Logger.info("FileManager opening " + uRL.toString());
                }
                URLConnection uRLConnection = uRL.openConnection();
                inputStream = uRLConnection.getInputStream();
            } else {
                if (bl) {
                    Logger.info("FileManager opening " + string);
                }
                File file = new File(string);
                inputStream = new FileInputStream(file);
            }
            if (bl2) {
                inputStream.close();
                inputStream = null;
            }
            return inputStream;
        }
        catch (Exception exception) {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            string2 = "" + exception;
            return string2;
        }
    }

    String[] getFullPathNameOrError(String string) {
        String[] stringArray = this.classifyName(string, true);
        if (stringArray == null || stringArray[0] == null || stringArray.length < 2) {
            return new String[]{null, "cannot read file name: " + string};
        }
        String string2 = stringArray[0];
        String string3 = stringArray[0].replace('\\', '/');
        if (string2.indexOf("|") >= 0) {
            string2 = TextFormat.split(string2, "|")[0];
        }
        Object object = this.getInputStreamOrErrorMessageFromName(string2, false, true);
        return new String[]{string3, object instanceof String ? (String)object : null};
    }

    Object getBufferedReaderOrErrorMessageFromName(String string, String[] stringArray, boolean bl, boolean bl2) {
        String[] stringArray2 = this.classifyName(string, true);
        if (stringArray2 == null) {
            return "cannot read file name: " + string;
        }
        if (stringArray != null) {
            stringArray[0] = stringArray2[0].replace('\\', '/');
        }
        return this.getUnzippedBufferedReaderOrErrorMessageFromName(stringArray2[0], false, bl, false, bl2);
    }

    Object getUnzippedBufferedReaderOrErrorMessageFromName(String string, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        Object object;
        String[] stringArray;
        String[] stringArray2 = null;
        String[] stringArray3 = stringArray = bl4 ? this.viewer.getModelAdapter().specialLoad(string, "filesNeeded?") : null;
        if (stringArray != null) {
            if (bl3) {
                return stringArray;
            }
            if (stringArray[2] != null) {
                CharSequence charSequence;
                String string2 = stringArray[1];
                Hashtable<String, CharSequence> hashtable = new Hashtable<String, CharSequence>();
                if (stringArray.length == 3) {
                    charSequence = this.getObjectAsSections(stringArray[2], string2, hashtable);
                    hashtable.put("OUTPUT", charSequence);
                    stringArray = this.viewer.getModelAdapter().specialLoad(string, (String)hashtable.get(charSequence));
                    if (stringArray.length == 3) {
                        charSequence = this.getObjectAsSections(stringArray[2], string2, hashtable);
                        hashtable.put("OUTPUT", charSequence);
                        stringArray = this.viewer.getModelAdapter().specialLoad(stringArray[1], (String)hashtable.get(charSequence));
                    }
                }
                charSequence = new StringBuffer();
                ((StringBuffer)charSequence).append(hashtable.get(hashtable.get("OUTPUT")));
                for (int i = 2; i < stringArray.length; ++i) {
                    string = stringArray[i];
                    string = this.getObjectAsSections(string, string2, hashtable);
                    Logger.info("reading " + string);
                    String string3 = (String)hashtable.get(string);
                    ((StringBuffer)charSequence).append(string3);
                }
                return FileManager.getBufferedReaderForString(((StringBuffer)charSequence).toString());
            }
        }
        if (string.indexOf("|") >= 0) {
            stringArray2 = TextFormat.split(string, "|");
            string = stringArray2[0];
        }
        if ((object = this.getInputStreamOrErrorMessageFromName(string, true, false)) instanceof String) {
            return object;
        }
        try {
            BufferedInputStream bufferedInputStream;
            BufferedInputStream bufferedInputStream2 = bufferedInputStream = new BufferedInputStream((InputStream)object, 8192);
            if (CompoundDocument.isCompoundDocument(bufferedInputStream2)) {
                CompoundDocument compoundDocument = new CompoundDocument(bufferedInputStream);
                return FileManager.getBufferedReaderForString(compoundDocument.getAllData("Molecule").toString());
            }
            if (ZipUtil.isGzip(bufferedInputStream2)) {
                while (ZipUtil.isGzip(bufferedInputStream2 = new BufferedInputStream(new GZIPInputStream(bufferedInputStream2)))) {
                }
            } else if (ZipUtil.isZipFile(bufferedInputStream2)) {
                if (bl) {
                    return new ZipInputStream(bufferedInputStream);
                }
                if (bl2) {
                    return (InputStream)ZipUtil.getZipFileContents(bufferedInputStream2, stringArray2, 1, true);
                }
                String string4 = (String)ZipUtil.getZipFileContents(bufferedInputStream2, stringArray2, 1, false);
                ((InputStream)bufferedInputStream2).close();
                return FileManager.getBufferedReaderForString(string4);
            }
            if (bl2) {
                return bufferedInputStream2;
            }
            return new BufferedReader(new InputStreamReader(bufferedInputStream2));
        }
        catch (Exception exception) {
            return exception.getMessage();
        }
    }

    String[] getZipDirectory(String string, boolean bl) {
        return ZipUtil.getZipDirectoryAndClose((InputStream)this.getInputStreamOrErrorMessageFromName(string, false, false), bl);
    }

    private String getObjectAsSections(String string, String string2, Hashtable hashtable) {
        if (string == null) {
            return null;
        }
        String[] stringArray = null;
        boolean bl = false;
        String string3 = string.replace('\\', '/');
        if (string.indexOf(":asBinaryString") >= 0) {
            bl = true;
            string = string.substring(0, string.indexOf(":asBinaryString"));
        }
        StringBuffer stringBuffer = null;
        if (hashtable.containsKey(string3)) {
            return string3;
        }
        if (string.indexOf("#JMOL_MODEL ") >= 0) {
            hashtable.put(string3, string3 + "\n");
            return string3;
        }
        if (string.indexOf("|") >= 0) {
            stringArray = TextFormat.split(string, "|");
            string = stringArray[0];
        }
        BufferedInputStream bufferedInputStream = null;
        try {
            Object object = this.getInputStreamOrErrorMessageFromName(string, false, false);
            if (object instanceof String) {
                hashtable.put(string3, (String)object + "\n");
                return string3;
            }
            bufferedInputStream = new BufferedInputStream((InputStream)object, 8192);
            if (CompoundDocument.isCompoundDocument(bufferedInputStream)) {
                CompoundDocument compoundDocument = new CompoundDocument(bufferedInputStream);
                compoundDocument.getAllData(string.replace('\\', '/'), "Molecule", hashtable);
            } else if (ZipUtil.isZipFile(bufferedInputStream)) {
                ZipUtil.getAllData(bufferedInputStream, stringArray, string.replace('\\', '/'), "Molecule", hashtable);
            } else if (bl) {
                BinaryDocument binaryDocument = new BinaryDocument();
                binaryDocument.setStream(bufferedInputStream, false);
                stringBuffer = new StringBuffer();
                if (string2 != null) {
                    stringBuffer.append("BEGIN Directory Entry " + string3 + "\n");
                }
                try {
                    while (true) {
                        stringBuffer.append(Integer.toHexString(binaryDocument.readByte() & 0xFF)).append(' ');
                    }
                }
                catch (Exception exception) {
                    stringBuffer.append('\n');
                    if (string2 != null) {
                        stringBuffer.append("\nEND Directory Entry " + string3 + "\n");
                    }
                    hashtable.put(string3, stringBuffer.toString());
                }
            } else {
                String string4;
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(ZipUtil.isGzip(bufferedInputStream) ? new GZIPInputStream(bufferedInputStream) : bufferedInputStream));
                stringBuffer = new StringBuffer();
                if (string2 != null) {
                    stringBuffer.append("BEGIN Directory Entry " + string3 + "\n");
                }
                while ((string4 = bufferedReader.readLine()) != null) {
                    stringBuffer.append(string4);
                    stringBuffer.append('\n');
                }
                bufferedReader.close();
                if (string2 != null) {
                    stringBuffer.append("\nEND Directory Entry " + string3 + "\n");
                }
                hashtable.put(string3, stringBuffer.toString());
            }
        }
        catch (Exception exception) {
            hashtable.put(string3, exception.getMessage());
        }
        if (bufferedInputStream != null) {
            try {
                bufferedInputStream.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (!hashtable.containsKey(string3)) {
            hashtable.put(string3, "FILE NOT FOUND: " + string3 + "\n");
        }
        return string3;
    }

    Object getFileAsBytes(String string) {
        Object object;
        if (string == null) {
            return null;
        }
        String[] stringArray = null;
        if (string.indexOf("|") >= 0) {
            stringArray = TextFormat.split(string, "|");
            string = stringArray[0];
        }
        if ((object = this.getInputStreamOrErrorMessageFromName(string, false, false)) instanceof String) {
            return "Error:" + object;
        }
        try {
            BufferedInputStream bufferedInputStream;
            BufferedInputStream bufferedInputStream2 = bufferedInputStream = new BufferedInputStream((InputStream)object, 8192);
            byte[] byArray = ZipUtil.isZipFile(bufferedInputStream2) && stringArray != null && 1 < stringArray.length ? ZipUtil.getZipFileContentsAsBytes(bufferedInputStream2, stringArray, 1) : ZipUtil.getStreamAsBytes(bufferedInputStream);
            ((InputStream)bufferedInputStream2).close();
            return byArray;
        }
        catch (Exception exception) {
            return exception.getMessage();
        }
    }

    boolean getFileDataOrErrorAsString(String[] stringArray, int n, boolean bl) {
        stringArray[1] = "";
        String string = stringArray[0];
        if (string == null) {
            return false;
        }
        Object object = this.getBufferedReaderOrErrorMessageFromName(string, stringArray, false, bl);
        if (object instanceof String) {
            stringArray[1] = (String)object;
            return false;
        }
        try {
            BufferedReader bufferedReader = (BufferedReader)object;
            StringBuffer stringBuffer = new StringBuffer(8192);
            if (n == Integer.MAX_VALUE) {
                String string2;
                while ((string2 = bufferedReader.readLine()) != null) {
                    stringBuffer.append(string2).append('\n');
                }
            } else {
                String string3;
                int n2;
                for (int i = 0; i < n && (string3 = bufferedReader.readLine()) != null; i += n2 + 1) {
                    n2 = string3.length();
                    if (n - i < n2 + 1) {
                        string3 = string3.substring(0, n - i - 1);
                    }
                    stringBuffer.append(string3).append('\n');
                }
            }
            bufferedReader.close();
            stringArray[1] = stringBuffer.toString();
            return true;
        }
        catch (Exception exception) {
            stringArray[1] = exception.getMessage();
            return false;
        }
    }

    Object getFileAsImage(String string, Hashtable hashtable) {
        if (string == null) {
            return "";
        }
        String[] stringArray = this.classifyName(string, true);
        if (stringArray == null) {
            return "cannot read file name: " + string;
        }
        Image image = null;
        this.fullPathName = stringArray[0].replace('\\', '/');
        if (FileManager.urlTypeIndex(this.fullPathName) >= 0) {
            try {
                image = Toolkit.getDefaultToolkit().createImage(new URL(this.fullPathName));
            }
            catch (Exception exception) {
                return "bad URL: " + this.fullPathName;
            }
        } else {
            image = Toolkit.getDefaultToolkit().createImage(this.fullPathName);
        }
        try {
            MediaTracker mediaTracker = new MediaTracker(this.viewer.getDisplay());
            mediaTracker.addImage(image, 0);
            mediaTracker.waitForID(0);
        }
        catch (Exception exception) {
            return exception.getMessage() + " opening " + this.fullPathName;
        }
        if (image.getWidth(null) < 1) {
            return "invalid or missing image " + this.fullPathName;
        }
        hashtable.put("fullPathName", this.fullPathName);
        return image;
    }

    private static int urlTypeIndex(String string) {
        for (int i = 0; i < urlPrefixes.length; ++i) {
            if (!string.startsWith(urlPrefixes[i])) continue;
            return i;
        }
        return -1;
    }

    private String[] classifyName(String string, boolean bl) {
        String string2;
        int n;
        if (string == null) {
            return new String[]{null};
        }
        if (string.startsWith("?") && (string = this.viewer.dialogAsk("load", string.substring(1))) == null) {
            return new String[]{bl ? "#CANCELED#" : null};
        }
        File file = null;
        URL uRL = null;
        String[] stringArray = null;
        if (string.indexOf("=") == 0) {
            string = TextFormat.formatString(this.viewer.getLoadFormat(), "FILE", string.substring(1));
        }
        if (string.indexOf(":") < 0 && string.indexOf("/") != 0) {
            string = FileManager.addDirectory(this.viewer.getDefaultDirectory(), string);
        }
        if (this.appletDocumentBase != null) {
            try {
                if (string.indexOf(":\\") == 1 || string.indexOf(":/") == 1) {
                    string = "file:/" + string;
                }
                uRL = new URL(this.appletDocumentBase, string);
            }
            catch (MalformedURLException malformedURLException) {
                return new String[]{bl ? malformedURLException.getMessage() : null};
            }
        } else if (FileManager.urlTypeIndex(string) >= 0) {
            try {
                uRL = new URL(string);
            }
            catch (MalformedURLException malformedURLException) {
                return new String[]{bl ? malformedURLException.getMessage() : null};
            }
        } else {
            file = new File(string);
            stringArray = new String[]{file.getAbsolutePath(), file.getName(), "file:/" + file.getAbsolutePath().replace('\\', '/')};
        }
        if (uRL != null) {
            stringArray = new String[3];
            stringArray[0] = stringArray[2] = uRL.toString();
            stringArray[1] = stringArray[0].substring(stringArray[0].lastIndexOf(47) + 1);
        }
        if (bl && (file != null || FileManager.urlTypeIndex(stringArray[0]) == 3) && (n = (string2 = file == null ? TextFormat.trim(stringArray[0].substring(5), "/") : stringArray[0]).length() - stringArray[1].length() - 1) > 0) {
            string2 = string2.substring(0, n);
            FileManager.setLocalPath(this.viewer, string2, true);
        }
        return stringArray;
    }

    /*
     * Enabled aggressive block sorting
     */
    private static String addDirectory(String string, String string2) {
        String string3;
        if (string.length() == 0) {
            return string2;
        }
        int n = string2.length() > 0 ? (int)string2.charAt(0) : 32;
        String string4 = string.toLowerCase();
        if ((string4.endsWith(".zip") || string4.endsWith(".tar")) && n != 124 && n != 47) {
            string = string + "|";
        }
        StringBuffer stringBuffer = new StringBuffer().append(string);
        if (n != 47 && n != 47) {
            char c = string.charAt(string.length() - 1);
            n = c;
            if (c != '|' && n != 47) {
                string3 = "/";
                return stringBuffer.append(string3).append(string2).toString();
            }
        }
        string3 = "";
        return stringBuffer.append(string3).append(string2).toString();
    }

    String getDefaultDirectory(String string) {
        String[] stringArray = this.classifyName(string, true);
        if (stringArray == null) {
            return "";
        }
        string = FileManager.fixPath(stringArray[0]);
        return stringArray == null ? "" : string.substring(0, string.lastIndexOf("/"));
    }

    private static String fixPath(String string) {
        string = string.replace('\\', '/');
        int n = (string = TextFormat.simpleReplace(string, "/./", "/")).lastIndexOf("//") + 1;
        if (n < 1) {
            n = string.indexOf(":/") + 1;
        }
        if (n < 1) {
            n = string.indexOf("/");
        }
        String string2 = string.substring(0, n);
        string = string.substring(n);
        while ((n = string.lastIndexOf("/../")) >= 0) {
            int n2 = string.substring(0, n).lastIndexOf("/");
            if (n2 < 0) {
                return TextFormat.simpleReplace(string2 + string, "/../", "/");
            }
            string = string.substring(0, n2) + string.substring(n + 3);
        }
        if (string.length() == 0) {
            string = "/";
        }
        return string2 + string;
    }

    public String getFullPath(String string, boolean bl) {
        String[] stringArray = this.classifyName(string, false);
        return stringArray == null ? "" : (bl ? stringArray[2] : stringArray[0].replace('\\', '/'));
    }

    public static String getLocalUrl(File file) {
        int n;
        if (file.getName().startsWith("=")) {
            return file.getName();
        }
        String string = file.getAbsolutePath().replace('\\', '/');
        for (n = 0; n < urlPrefixPairs.length; ++n) {
            if (string.indexOf(urlPrefixPairs[n]) != 0) continue;
            return null;
        }
        for (n = 0; n < urlPrefixPairs.length; n += 2) {
            if (string.indexOf(urlPrefixPairs[n]) <= 0) continue;
            return urlPrefixPairs[n + 1] + TextFormat.trim(string.substring(string.indexOf(urlPrefixPairs[n]) + urlPrefixPairs[n].length()), "/");
        }
        return null;
    }

    public static File getLocalDirectory(JmolViewer jmolViewer, boolean bl) {
        File file;
        String string = (String)jmolViewer.getParameter(bl ? "currentLocalPath" : "defaultDirectoryLocal");
        if (string.length() == 0 && bl) {
            string = (String)jmolViewer.getParameter("defaultDirectoryLocal");
        }
        if (string.length() == 0) {
            return jmolViewer.isApplet() ? null : new File(System.getProperty("user.dir"));
        }
        if (jmolViewer.isApplet() && string.indexOf("file:/") == 0) {
            string = FileManager.getLocalPathForWritingFile(jmolViewer, string);
        }
        return (file = new File(string)).isDirectory() ? file : file.getParentFile();
    }

    public static void setLocalPath(JmolViewer jmolViewer, String string, boolean bl) {
        while (string.endsWith("/") || string.endsWith("\\")) {
            string = string.substring(0, string.length() - 1);
        }
        jmolViewer.setStringProperty("currentLocalPath", string);
        if (!bl) {
            jmolViewer.setStringProperty("defaultDirectoryLocal", string);
        }
    }

    public static String getLocalPathForWritingFile(JmolViewer jmolViewer, String string) {
        if (string.indexOf("file:/") == 0) {
            return string.substring(6);
        }
        if (string.indexOf("/") == 0 || string.indexOf(":") >= 0) {
            return string;
        }
        File file = FileManager.getLocalDirectory(jmolViewer, false);
        return file == null ? string : FileManager.fixPath(file.toString() + "/" + string);
    }

    public static String setScriptFileReferences(String string, String string2, String string3, String string4) {
        if (string2 != null) {
            string = FileManager.setScriptFileReferences(string, string2, true);
        }
        if (string3 != null) {
            string = FileManager.setScriptFileReferences(string, string3, false);
        }
        string = TextFormat.simpleReplace(string, "\u0001\"", "\"");
        if (string4 != null) {
            while (string4.endsWith("/")) {
                string4 = string4.substring(0, string4.length() - 1);
            }
            for (int i = 0; i < scriptFilePrefixes.length; ++i) {
                String string5 = scriptFilePrefixes[i];
                string = TextFormat.simpleReplace(string, string5 + ".", string5 + string4);
            }
        }
        return string;
    }

    private static String setScriptFileReferences(String string, String string2, boolean bl) {
        if (string2 == null) {
            return string;
        }
        boolean bl2 = string2.length() == 0;
        Vector vector = new Vector();
        FileManager.getFileReferences(string, vector, "");
        Vector<String> vector2 = new Vector<String>();
        Vector<String> vector3 = new Vector<String>();
        int n = vector.size();
        for (int i = 0; i < n; ++i) {
            String string3 = (String)vector.get(i);
            String string4 = string3;
            int n2 = FileManager.urlTypeIndex(string4);
            if (bl == (n2 < 0 || n2 == 3)) {
                int n3;
                int n4 = n3 = bl2 ? -1 : string4.indexOf("/" + string2 + "/");
                if (n3 >= 0) {
                    string4 = string4.substring(n3 + 1);
                } else {
                    n3 = string4.lastIndexOf("/");
                    if (n3 < 0 && !bl2) {
                        string4 = "/" + string4;
                    }
                    if (n3 < 0 || bl2) {
                        ++n3;
                    }
                    string4 = string2 + string4.substring(n3);
                }
            }
            Logger.info("FileManager substituting " + string3 + " --> " + string4);
            vector2.add("\"" + string3 + "\"");
            vector3.add("\u0001\"" + string4 + "\"");
        }
        return TextFormat.replaceStrings(string, vector2, vector3);
    }

    public static void getFileReferences(String string, Vector vector, String string2) {
        for (int i = 0; i < scriptFilePrefixes.length; ++i) {
            String string3 = scriptFilePrefixes[i];
            int n = -1;
            while ((n = string.indexOf(string3, n + 1)) >= 0) {
                vector.add(string2 + Parser.getNextQuotedString(string, n));
            }
        }
    }

    String createZipSet(String string, String string2, boolean bl) {
        String string3;
        Vector<Object> vector = new Vector<Object>();
        Vector vector2 = new Vector();
        FileManager.getFileReferences(string2, vector2, "");
        Vector<String> vector3 = new Vector<String>();
        int n = vector2.size();
        string = string.replace('\\', '/');
        String string4 = string.substring(string.lastIndexOf("/") + 1);
        if (string4.indexOf(".") >= 0) {
            string4 = string4.substring(0, string4.indexOf("."));
        }
        for (int i = 0; i < n; ++i) {
            boolean bl2;
            string3 = (String)vector2.get(i);
            int n2 = FileManager.urlTypeIndex(string3);
            boolean bl3 = bl2 = n2 < 0 || n2 == 3;
            if (bl2 || bl) {
                vector.add(string3);
                String string5 = "$SCRIPT_PATH$/" + string3.substring(string3.lastIndexOf("/") + 1);
                if (bl2 && string3.indexOf("|") < 0) {
                    vector.add(null);
                } else {
                    Object object = this.getFileAsBytes(string3);
                    if (!(object instanceof byte[])) {
                        return (String)object;
                    }
                    vector.add(object);
                }
                string3 = string5;
            }
            vector3.add(string3);
        }
        String string6 = string4 + ".spt";
        vector.add("JmolManifest.txt");
        string3 = "# Jmol Mmanifest Zip Format 1.0\n# Created " + DateFormat.getDateInstance().format(new Date()) + "\n" + "# JmolVersion " + Viewer.getJmolVersion() + "\n" + string6;
        vector.add(string3.getBytes());
        string2 = TextFormat.replaceQuotedStrings(string2, vector2, vector3);
        vector.add(string6);
        vector.add(string2.getBytes());
        Object object = this.viewer.getImageAs("JPEG", -1, -1, -1, null, null, JmolConstants.embedScript(string2));
        if (object instanceof byte[]) {
            vector.add(string4 + ".jpg");
            vector.add((byte[])object);
        }
        return FileManager.writeZipFile(string, vector, false, "OK JMOL");
    }

    private static String writeZipFile(String string, Vector vector, boolean bl, String string2) {
        byte[] byArray = new byte[1024];
        long l = 0L;
        long l2 = 0L;
        Logger.info("creating zip file " + string + "...");
        String string3 = null;
        try {
            ZipOutputStream zipOutputStream = new ZipOutputStream(new FileOutputStream(string));
            for (int i = 0; i < vector.size(); i += 2) {
                String string4 = (String)vector.get(i);
                if (string4.indexOf("file:/") == 0) {
                    string4 = string4.substring(6);
                }
                byte[] byArray2 = (byte[])vector.get(i + 1);
                String string5 = string4;
                if (!bl || string4.indexOf("|") >= 0) {
                    int n = Math.max(string4.lastIndexOf("|"), string4.lastIndexOf("/"));
                    string5 = string5.substring(n + 1);
                }
                Logger.info("...adding " + string4);
                zipOutputStream.putNextEntry(new ZipEntry(string5));
                if (byArray2 == null) {
                    int n;
                    FileInputStream fileInputStream = new FileInputStream(string4);
                    while ((n = fileInputStream.read(byArray)) > 0) {
                        zipOutputStream.write(byArray, 0, n);
                        l += (long)n;
                    }
                    fileInputStream.close();
                } else {
                    zipOutputStream.write(byArray2, 0, byArray2.length);
                    l += (long)byArray2.length;
                }
                zipOutputStream.closeEntry();
            }
            zipOutputStream.close();
            File file = new File(string);
            string3 = file.getAbsolutePath().replace('\\', '/');
            l2 = file.length();
        }
        catch (IOException iOException) {
            Logger.info(iOException.getMessage());
            return iOException.getMessage();
        }
        Logger.info(l + " bytes prior to compression");
        return string2 + " " + l2 + " " + string3;
    }

    class VectorDataReader
    extends DataReader {
        private Vector data;
        private int pt;
        private int len;
        int ptMark;

        VectorDataReader(Vector vector) {
            super(new StringReader(""));
            this.data = vector;
            this.len = vector.size();
        }

        public int read(char[] cArray) throws IOException {
            return this.readBuf(cArray);
        }

        public String readLine() {
            return this.pt < this.len ? (String)this.data.get(this.pt++) : null;
        }

        public void mark(long l) {
            this.ptMark = this.pt;
        }

        public void reset() {
            this.pt = this.ptMark;
        }
    }

    class StringDataReader
    extends DataReader {
        StringDataReader(String string) {
            super(new StringReader(string));
        }
    }

    class ArrayDataReader
    extends DataReader {
        private String[] data;
        private int pt;
        private int len;
        int ptMark;

        ArrayDataReader(String[] stringArray) {
            super(new StringReader(""));
            this.data = stringArray;
            this.len = stringArray.length;
        }

        public int read(char[] cArray) throws IOException {
            return this.readBuf(cArray);
        }

        public String readLine() {
            return this.pt < this.len ? this.data[this.pt++] : null;
        }

        public void mark(long l) {
            this.ptMark = this.pt;
        }

        public void reset() {
            this.pt = this.ptMark;
        }
    }

    abstract class DataReader
    extends BufferedReader {
        DataReader(Reader reader) {
            super(reader);
        }

        BufferedReader getBufferedReader() {
            return this;
        }

        protected int readBuf(char[] cArray) throws IOException {
            int n = 0;
            String string = this.readLine();
            if (string == null) {
                return 0;
            }
            int n2 = 0;
            int n3 = string == null ? -1 : string.length();
            for (int i = 0; i < cArray.length && n3 >= 0; ++i) {
                if (n2 >= n3) {
                    n2 = 0;
                    cArray[i] = 10;
                    string = this.readLine();
                    n3 = string == null ? -1 : string.length();
                } else {
                    cArray[i] = string.charAt(n2++);
                }
                ++n;
            }
            return n;
        }
    }

    private class FilesReader
    implements JmolFileReaderInterface {
        private String[] fullPathNamesIn;
        private String[] namesAsGivenIn;
        private String[] fileTypesIn;
        Object atomSetCollection;
        private DataReader[] stringReaders;
        private Hashtable[] htParamsSet;
        private Hashtable htParams;

        FilesReader(String[] stringArray, String[] stringArray2, String[] stringArray3, DataReader[] dataReaderArray, Hashtable hashtable) {
            this.fullPathNamesIn = stringArray;
            this.namesAsGivenIn = stringArray2;
            this.fileTypesIn = stringArray3;
            this.stringReaders = dataReaderArray;
            this.htParams = hashtable;
        }

        void run() {
            if (this.stringReaders != null) {
                this.atomSetCollection = FileManager.this.viewer.getModelAdapter().getAtomSetCollectionFromReaders(this, this.fullPathNamesIn, this.fileTypesIn, null);
                this.stringReaders = null;
            } else {
                this.htParamsSet = new Hashtable[this.fullPathNamesIn.length];
                for (int i = 0; i < this.htParamsSet.length; ++i) {
                    this.htParamsSet[i] = this.htParams;
                }
                this.atomSetCollection = FileManager.this.viewer.getModelAdapter().getAtomSetCollectionFromReaders(this, this.fullPathNamesIn, this.fileTypesIn, this.htParamsSet);
            }
            if (this.atomSetCollection instanceof String) {
                Logger.error("file ERROR: " + this.atomSetCollection);
            }
        }

        public Object getBufferedReader(int n) {
            Object object;
            if (this.stringReaders != null) {
                return this.stringReaders[n].getBufferedReader();
            }
            String string = this.fullPathNamesIn[n];
            String[] stringArray = null;
            Hashtable hashtable = this.htParamsSet[0];
            hashtable.remove("subFileList");
            if (string.indexOf("|") >= 0) {
                stringArray = TextFormat.split(string, "|");
                string = stringArray[0];
            }
            if ((object = FileManager.this.getUnzippedBufferedReaderOrErrorMessageFromName(string, true, false, false, true)) instanceof ZipInputStream) {
                if (stringArray != null) {
                    hashtable.put("subFileList", stringArray);
                }
                String[] stringArray2 = FileManager.this.getZipDirectory(string, true);
                BufferedInputStream bufferedInputStream = new BufferedInputStream((InputStream)FileManager.this.getInputStreamOrErrorMessageFromName(string, false, false), 8192);
                object = FileManager.this.viewer.getModelAdapter().getAtomSetCollectionOrBufferedReaderFromZip(bufferedInputStream, string, stringArray2, hashtable, true);
            }
            if (object instanceof BufferedReader) {
                return (BufferedReader)object;
            }
            return object == null ? "error opening:" + this.namesAsGivenIn[n] : (String)object;
        }
    }

    private class FileReader {
        private String fullPathNameIn;
        private String nameAsGivenIn;
        private String fileTypeIn;
        Object atomSetCollection;
        private BufferedReader reader;
        private Hashtable htParams;

        FileReader(String string, String string2, String string3, BufferedReader bufferedReader, Hashtable hashtable) {
            this.fullPathNameIn = string;
            this.nameAsGivenIn = string2;
            this.fileTypeIn = string3;
            this.reader = bufferedReader;
            this.htParams = hashtable;
        }

        void run() {
            String string = null;
            if (this.reader == null) {
                String string2 = this.fullPathNameIn;
                String[] stringArray = null;
                Object object = FileManager.this.getUnzippedBufferedReaderOrErrorMessageFromName(string2, true, false, false, true);
                if (string2.indexOf("|") >= 0) {
                    stringArray = TextFormat.split(string2, "|");
                    string2 = stringArray[0];
                }
                if (object instanceof BufferedReader) {
                    this.reader = (BufferedReader)object;
                } else if (object instanceof ZipInputStream) {
                    if (stringArray != null) {
                        this.htParams.put("subFileList", stringArray);
                    }
                    ZipInputStream zipInputStream = (ZipInputStream)object;
                    String[] stringArray2 = FileManager.this.getZipDirectory(string2, true);
                    this.atomSetCollection = FileManager.this.viewer.getModelAdapter().getAtomSetCollectionOrBufferedReaderFromZip(zipInputStream, string2, stringArray2, this.htParams, false);
                    try {
                        zipInputStream.close();
                    }
                    catch (Exception exception) {}
                } else {
                    String string3 = string = object == null ? "error opening:" + this.nameAsGivenIn : (String)object;
                }
            }
            if (this.reader != null) {
                this.atomSetCollection = FileManager.this.viewer.getModelAdapter().getAtomSetCollectionFromReader(this.fullPathNameIn, this.fileTypeIn, this.reader, this.htParams);
            }
            if (string != null) {
                if (!string.startsWith("NOTE:")) {
                    Logger.error("file ERROR: " + this.fullPathNameIn + "\n" + string);
                }
                this.atomSetCollection = string;
            }
        }
    }

    private class DOMReader {
        private Object aDOMNode;
        Object atomSetCollection;
        Hashtable htParams;

        DOMReader(Object object, Hashtable hashtable) {
            this.aDOMNode = object;
            this.htParams = hashtable;
        }

        void run() {
            this.atomSetCollection = FileManager.this.viewer.getModelAdapter().getAtomSetCollectionFromDOM(this.aDOMNode, this.htParams);
        }
    }
}

