/**
 * Intersection.java
 *
 * Created on Jul 10, 2006
 */
package maths;

/**
 * Cette classe implemente l'intersection de deux ensembles.
 *
 * @author Nicolae
 */
public class Intersection extends DefaultSet {

	private Set A;
	private Set B;
	
	/**
	 * Cache le constructor standard.
	 */
	private Intersection() {}
	
	
	/**
	 * Constructor qui initialise les deux ensembles.
	 *
	 * @param A ensemble.
	 * @param B ensemble.
	 */
	public Intersection(Set A, Set B) {
		this.A = A;
		this.B = B;
	}
	
	/* (non-Javadoc)
	 * @see maths.DefaultSet#contains(double, double)
	 */
	public boolean contains(double re, double im) {
		return A.contains(re, im) && B.contains(re, im); 
	}

}
