target= lagrange21 lagrange22
#if #TARGET(lagrange21)
\title{Interpolation de Lagrange I (4 points)}
#endif
#if #TARGET(lagrange22)
\title{Interpolation de Lagrange II (4 points)}
#endif

\author{Bernadette Perrin-Riou}
\email{bpr@math.u-psud.fr}
\precision{1000}
\text{S = 0,randint(50..80),randint(100..200),randint(300..400)}
\text{S=pari(0.1*[\S])}
text{S = 0,3.1,10.3,30.1}

\text{P = a*x^3 + b*x^2 + c*x + d}
\matrix{M = pari(M=matrix(4,4) ; 
  M[1,] = [\S[1],\S[1],\S[1],1] ;
  M[2,] = [(\S[2])^3, (\S[2])^2, \S[2],1] ; 
  M[3,] = [(\S[3])^3, (\S[3])^2, \S[3],1] ; 
  M[4,] = [(\S[4])^3, (\S[4])^2, \S[4],1] ;
  M)}

\text{V = 0,randint(4..20),randint(40..50),randint(60..90)}
text{V=0,30,60,90}

#if #TARGET(lagrange22) 
\real{S0= randitem(randint(10*\S[1]+10 .. 10*\S[2]-10) , randint(10*\S[2]+10 .. 10*\S[3]-10),randint(10*\S[3]+10 .. 10*\S[4]-10))/10}
#endif

\matrix{N = pari(floor(10000*[\M]^(-1)*[\V]~)~*0.0001)}
\function{f= (\N[1])*t^3 + (\N[2])*t^2 + (\N[3])*t + (\N[4]) }
\function{Psol=pari((\N[1])*x^3 + (\N[2])*x^2 + (\N[3])*x + (\N[4]))}
\text{condition=pari(([\M]*[a,b,c,d]~)~)}

\text{dessin=xrange -2,45
yrange -10,100
dvline \S[1],0,red
dvline \S[2],0,red
dvline \S[3],0,red
dvline \S[4],0,red
hline 0,0,blue
disk \S[1],\V[1],7,green
disk \S[2],\V[2],7,green
disk \S[3],\V[3],7,green
disk \S[4],\V[4],7,green
}
copy \S[1],\V[1],-1,-1,-1,-1,cross.gif

\text{Dessin=draw(200,200
\dessin
hline 0,0,blue)
}

\function{D1 = pari((\V[2]-\V[1])/(\S[2]-\S[1])*(x-\S[1]) + \V[1])}
\function{D2 = pari((\V[3]-\V[2])/(\S[3]-\S[2])*(x-\S[2]) + \V[2])}
\function{D3 = pari((\V[4]-\V[3])/(\S[4]-\S[3])*(x-\S[3]) + \V[3])}
\function{D1t=evalue(\D1,x=t)}
\function{D2t=evalue(\D2,x=t)}
\function{D3t=evalue(\D3,x=t)}

\text{dessin=\dessin
trange \S[1],\S[2]
plot red,t,\R1
trange \S[2],\S[3]
plot red,t,\R2
trange \S[3],\S[4]
plot red,t,\R3
trange \S[1],\S[2]
plot black,t,\D1t
trange \S[2],\S[3]
plot black,t,\D2t
trange \S[3],\S[4]
plot black,t,\D3t
}

\text{Dessin=draw(200,200
\dessin
hline 0,0,blue)
}

\text{style = <style type="text/css">
 .question {
  background-color: #FFFFAA;
  margin : 2% 5%;
  padding : 2%;
  text-align: center;}
  .reponse {background-color : #ffcc99;
          color : black;
          margin : 2% 5%;
          padding : 2%;}
 </style>}
 
 
\text{enonce=
Dans le tableau suivant, voici quelques valeurs donnant la vitesse
d'un vhicule en accleration en fonction du temps.}
\text{enonce2=On dsire interpoler ces points 
par une fonction continue, c'est--dire trouver une fonction \(f) donnant 
la vitesse en fonction du temps.
}


#if #TARGET(lagrange21)
\steps{r1,r2,r3
r4
r5,r6,r7,r8
r9
}

\statement{\style \enonce
<table align="center" border=1>
   <tr><th>Temps</th><td>\S[1]</td><td>\S[2]</td><td>\S[3]</td><td>\S[4]</td></tr>
   <tr><th>Vitesse</th><td>\V[1]</td><td>\V[2]</td><td>\V[3]</td><td>\V[4]</td></tr>
 </table>

 \enonce2
 <ol style="list-style: upper-alpha;"><li><dl>Interpolation par des segments de droite</dl>
\if{\step =1}{
On commence par relier les points par des segments. 
<div class="question">Donner les expressions
de la fonction d'interpolation dans les trois intervalles
</div>
<table align="center">
   <tr><td>\embed{reply1,15}</td> <td> sur l'intervalle [\S[1],\S[2]]</td></tr>
   <tr><td>\embed{reply2,15}</td> <td> sur l'intervalle [\S[2],\S[3]]</td></tr>
   <tr><td>\embed{reply3,15}</td> <td> sur l'intervalle [\S[3],\S[4]]</td></tr>
 </table>
}

\if{\step>=2}{
<li style=A><dl>Interpolation de Lagrange</dl>}
\if{\step=2}{
On prfrerait avoir une courbe plus <i>lisse</i>, c'est--dire par 
exemple drivable. Pour cela, on interpole les points  l'aide d'une
fonction polynme \(P) sur l'intervalle [0,\S[4]].
<div class="question">
De quel degr doit-on la prendre ? \embed{reply4,5}. 
</div>}
\if{\step=3}{
<div class="question">Ecrire le systme linaire que vrifient les coefficients
de \(P = \P). </div>
<ol><li>
Condition au premier point : 
\embed{reply5} = 0
</li>
<li>
Condition au deuxime point : 
\embed{reply6} = 0
</li>
<li>
Condition au troisime point : 
\embed{reply7} = 0
</li>
<li>
Condition au quatrime point : 
\embed{reply8} = 0
</li>
</ol>
}
\if{\step=4}{La matrice du systme est en effet \([\M]). 
<p>
<div class="question">Rsoudre le systme et donner le polynme solution : 
<p align="center">\embed{reply9}</p>
</div>
}
</ol>
<p align=center><img src=\Dessin></p>

}

\answer{}{\D1,y}{type=function}
\answer{}{\D2,y}{type=function}
\answer{}{\D3,y}{type=function}
\answer{}{3}
\answer{}{\condition[1],a,b,c,d}{type=equation}
\answer{}{\condition[2],a,b,c,d}{type=equation}
\answer{}{\condition[3],a,b,c,d}{type=equation}
\answer{}{\condition[4],a,b,c,d}{type=equation}
\answer{}{\Psol,x}{type=function}
\function{R1=evalue(\reply1,x=t)}
\function{R2=evalue(\reply2,x=t)}
\function{R3=evalue(\reply3,x=t)}
\function{Rep=evalue(\reply9,x=t)}
\text{Rep = wims(replace internal = by -( in \Rep))}
\text{dessin2=\dessin
trange \S[1],\S[2]
plot black,t,\D1t
trange \S[2],\S[3]
plot black,t,\D2t
trange \S[3],\S[4]
plot black,t,\D3t
trange \S[1],\S[4]
plot red,t,\Rep
plot green,t,\f
}

\text{Dessin=draw(200,200
\dessin2
hline 0,0,blue)
}
\feedback{1=1}{
<div class="reponse">Il est possible que la fonction trouve ne soit pas 
une approximation trs raliste du problme initial. Par exemple,
on s'attend  trouver une fonction croissante, ce qui n'est pas toujours le cas.
</div>
}

#endif

#if #TARGET(lagrange22)
  \real{Vlag= evalue(\Psol,x=\S0)}
  \real{Vlin= \S0 < \S[2] ? evalue(\D1,x=\S0):evalue(\D2,x=\S0)}
  \real{Vlin= \S0 > \S[3] ? evalue(\D3,x=\S0)}
\text{dessin2=\dessin
trange \S[1],\S[2]
plot black,t,\D1t
trange \S[2],\S[3]
plot black,t,\D2t
trange \S[3],\S[4]
plot black,t,\D3t
trange \S[1],\S[4]
plot red,t,\Rep
plot green,t,\f
}

\text{Dessin=draw(200,200
\dessin2
hline 0,0,blue
vline \S0,0,orange)
}
\statement{\style
\enonce
<p>
<table align="center" border=1>
   <tr><th>Temps</th><td>\S[1]</td><td>\S[2]</td><td>\S[3]</td><td>\S[4]</td></tr>
   <tr><th>Vitesse</th><td>\V[1]</td><td>\V[2]</td><td>\V[3]</td><td>\V[4]</td></tr>
 </table>
</p>

Donner la valeur de la vitesse en \(t = \S0)

 <ol style="list-style: upper-alpha;"><li>si on interpole par des segments de droite
 (interpolation linaire) : \embed{reply1,15}
 </li>
 <li>si on interpole par un polynme (interpolation polynomiale de Lagrange)
 \embed{reply2,15}
 </li>
 </ol>
 }
\answer{Interpolation linaire}{\Vlin}
\answer{Interpolation polynomiale}{\Vlag}

\feedback{1=1}{<center><img src=\Dessin></center>}
#endif
