# `<router-view>`

`<router-view>` — это функциональный компонент, отображающий соответствующее текущему пути представление. Компоненты, отображаемые на месте `<router-view>` могут сами содержать вложенные `<router-view>`, что позволяет организовать иерархию вложенных путей.


### Входные параметры

- **name**

  - тип: `string`

  - значение по умолчанию: `"default"`

  Если для `<router-view>` указывается имя, на его месте отобразится компонент, для которого в записи пути указано соответствующее имя в опции `components`. Для подробностей и примера см. [именованные представления](../essentials/named-views.md).


### Поведение

Все остальные входные параметры будут напрямую переданы отображаемому компоненту представления. Тем не менее, чаще всего данные уровня пути содержатся в параметрах пути (`$route.params`).

Поскольку мы имеем дело всего лишь с обыкновенным компонентом, можно использовать обёртки `<transition>` и `<keep-alive>`. Если вы используете оба, удостоверьтесь, что `<keep-alive>` располагается внутри:

``` html
<transition>
  <keep-alive>
    <router-view></router-view>
  </keep-alive>
</transition>
```
