/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2010 Oracle and/or its affiliates. All rights reserved.
 *
 * Oracle and Java are registered trademarks of Oracle and/or its affiliates.
 * Other names may be trademarks of their respective owners.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */
package org.graalvm.visualvm.lib.profiler.heapwalk.details.basic;

import org.graalvm.visualvm.lib.jfluid.heap.Heap;
import org.graalvm.visualvm.lib.jfluid.heap.Instance;
import org.graalvm.visualvm.lib.jfluid.heap.ObjectArrayInstance;
import org.graalvm.visualvm.lib.jfluid.heap.PrimitiveArrayInstance;
import org.graalvm.visualvm.lib.profiler.heapwalk.details.spi.DetailsProvider;
import org.graalvm.visualvm.lib.profiler.heapwalk.details.spi.DetailsUtils;
import org.openide.util.NbBundle;
import org.openide.util.lookup.ServiceProvider;

/**
 *
 * @author Jiri Sedlacek
 */
@NbBundle.Messages({
    "ArrayDetailsProvider_OneItemString=1 item",                                // NOI18N
    "ArrayDetailsProvider_ItemsNumberString={0} items"                          // NOI18N
})
@ServiceProvider(service=DetailsProvider.class)
public final class ArrayDetailsProvider extends DetailsProvider {
    
    public String getDetailsString(String className, Instance instance, Heap heap) {
        if (instance instanceof PrimitiveArrayInstance) {
            if ("char[]".equals(instance.getJavaClass().getName())) {           // NOI18N
                return DetailsUtils.getPrimitiveArrayString(
                        instance, 0, -1, null, "...");                          // NOI18N
            } else {
                return getItemsString(((PrimitiveArrayInstance)instance).getLength());
            }
        } else if (instance instanceof ObjectArrayInstance) {
            return getItemsString(((ObjectArrayInstance)instance).getLength());
        }
        return null;
    }
    
    public View getDetailsView(String className, Instance instance, Heap heap) {
        if (instance instanceof PrimitiveArrayInstance)
            return new ArrayValueView(className, instance, heap);
        else return null;
    }
    
    private static String getItemsString(int length) {
        return length == 1 ? Bundle.ArrayDetailsProvider_OneItemString() :
                             Bundle.ArrayDetailsProvider_ItemsNumberString(length);
    }
    
}
