/*
 * ===========================
 * VDK Visual Development Kit
 * Version 2.0.3
 * January 2003
 * ===========================
 *
 * Copyright (C) 1998, Mario Motta
 * Developed by Mario Motta <mmotta@guest.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 */
#include <vdk/vdkhlbutton.h>

#define PIXELATE 3.0
#define DARKENED 0.50
DEFINE_EVENT_LIST (VDKHLButton, VDKCustomButton);
/*
*/
VDKHLButton::VDKHLButton (
                  VDKForm  *owner, 
                  const char *pixfile, 
                  const char *label, 
                  unsigned int type,
                  GtkPositionType position):
    VDKCustomButton (owner, pixfile, label ,type,position) 
{
  normal_pix = new VDKPixbuf (this, pixfile);
  pixellated_pix = new VDKPixbuf (this, pixfile);
  darkened_pix = new VDKPixbuf (this, pixfile);
  GdkPixbuf* pixbuf = pixellated_pix->AsGdkPixbuf();
  gdk_pixbuf_saturate_and_pixelate(pixbuf,pixbuf,PIXELATE,FALSE);
  pixbuf = darkened_pix->AsGdkPixbuf();
  gdk_pixbuf_saturate_and_pixelate(pixbuf,pixbuf,DARKENED,FALSE);
}
/*
*/
VDKHLButton::VDKHLButton (
                   VDKForm *owner,
                   const char **pixdata,
                   const char *label,
                   unsigned int type,
                   GtkPositionType position):
    VDKCustomButton (owner, pixdata, label,type, position)
{
  normal_pix = new VDKPixbuf (this, pixdata);
  pixellated_pix = new VDKPixbuf (this, pixdata);
  darkened_pix = new VDKPixbuf (this, pixdata);
  GdkPixbuf* pixbuf = pixellated_pix->AsGdkPixbuf();
  gdk_pixbuf_saturate_and_pixelate(pixbuf,pixbuf,PIXELATE,FALSE);
  pixbuf = darkened_pix->AsGdkPixbuf();
  gdk_pixbuf_saturate_and_pixelate(pixbuf,pixbuf,DARKENED,FALSE);
}

/*
*/
void 
VDKHLButton::Setup (void)
{
  Relief = (GtkReliefStyle) 2;
  EventConnect("enter_notify_event",&VDKHLButton::OnEnter);
  EventConnect("leave_notify_event",&VDKHLButton ::OnLeave);
  EventConnect("button_release_event",&VDKHLButton ::OnClickRelease);
  EventConnect("button_press_event",&VDKHLButton ::OnClickPress);
}
/*
*/
bool 
VDKHLButton::OnClickRelease (VDKObject*,  GdkEvent* event)
{
  GdkEventButton* e = (GdkEventButton*) event;
  double w = GTK_WIDGET (WrappedWidget ())->allocation.width;
  double h = GTK_WIDGET (WrappedWidget ())->allocation.height;  
  VDKRect rect(0, 0, int (w), int (h) );
  VDKPoint p (int (e->x), int (e->y));
  if ( rect.Contains (p) )
    {
    VDKImage* image = Pixmap;
    image->SetImage (pixellated_pix);
    gtk_widget_queue_draw (image->WrappedWidget ());  
    SignalEmit (clicked_signal);
    SignalEmit ("clicked");
    }
  return false;
}
/*
*/
bool 
VDKHLButton::OnClickPress (VDKObject*,  GdkEvent* event)
{
  VDKImage* image = Pixmap;
  image->SetImage (darkened_pix);
  gtk_widget_queue_draw (image->WrappedWidget ());  
  return false;
}

/*
*/
bool 
VDKHLButton::OnEnter (VDKObject*,  GdkEvent*)
{
  VDKImage* image = Pixmap;
  image->SetImage (pixellated_pix);
  // Cursor = curHandPtr;
  gtk_widget_queue_draw (image->WrappedWidget ()); 
  SignalEmit (enter_signal); 
  SignalEmit ("enter"); 
  return true;
  }
/*
*/
bool 
VDKHLButton::OnLeave (VDKObject*,  GdkEvent*)
{
  VDKImage* image = Pixmap;
  image->SetImage (normal_pix);
  // Cursor = curDefault;
  gtk_widget_queue_draw (image->WrappedWidget ());  
  SignalEmit (leave_signal); 
  SignalEmit ("leave"); 
  return true;
}
