/*
 * Copyright (C) 2023, KylinSoft Co., Ltd.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see <http://www.gnu.org/licenses/>.
 *
**/
#ifndef HOSTNAMEDIALOG_H
#define HOSTNAMEDIALOG_H

#include <QObject>
#include <QWidget>
#include <QDialog>
#include <QLineEdit>
#include <QPushButton>
#include <QLabel>

#include "ukcccommon.h"
using namespace ukcc;

class HostNameDialog : public QDialog
{
    Q_OBJECT
public:
    HostNameDialog(QWidget *parent);
    ~HostNameDialog();

    void InitUi();

private:
    void initConnect();
    void setEdit();
    void setupComponent();
    void setHostname(QString hostname);
    bool isMatch(QString hostname);

private:

    QLineEdit *mHostNameEdit;
    QString mfirsthostname;
    QPushButton *mCancelBtn;
    QPushButton *mConfirmBtn;
    QLabel *mTipLabel;

};

#endif // HOSTNAMEDIALOG_H
